/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.ScrollPane;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ScrollMouseEvent
extends VisualTestImpl
implements MouseListener {
    private static final int BUTTONWIDTH = 100;
    private static final int BUTTONHEIGHT = 65;
    private static final int CENTERWIDTH = 40;
    private static final int CENTERHEIGHT = 20;
    private static final int NUMBEROFBUTTONS = 15;
    private static final String[] colornames = new String[]{"Purple", "Indigo", "Lightblue", "Green", "Yellow", "Orange", "Red"};
    private static final Color[] colors = new Color[]{new Color(128, 0, 128), new Color(0, 0, 128), new Color(96, 96, 255), Color.green, Color.yellow, Color.orange, Color.red};
    private List display;
    private GridBagLayout table;

    public ScrollMouseEvent() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        Panel center = new Panel(new FlowLayout());
        SizedScrollPane asneededpane = new SizedScrollPane(250, 150, Color.green);
        int saturation = 96;
        int brightness = 48;
        Panel asneeded = new Panel(new GridLayout(5, 3));
        for (int i = 0; i < 15; ++i) {
            PaneCanvas pc = new PaneCanvas("Canvas no." + i, 100, 65, saturation, saturation, brightness);
            pc.addMouseListener(this);
            asneeded.add(pc);
            saturation += 8;
            brightness += 6;
        }
        asneededpane.add(asneeded);
        center.add(asneededpane);
        this.add((Component)center, "Center");
        this.display = new List(3, false);
        this.display.add("your mouse events displayed here");
        this.add((Component)this.display, "South");
    }

    public void mouseEntered(MouseEvent evt) {
        this.displayEvent(evt, "mouseEntered");
    }

    public void mouseExited(MouseEvent evt) {
        this.displayEvent(evt, "mouseExited");
    }

    public void mousePressed(MouseEvent evt) {
        this.displayEvent(evt, "mousePressed");
    }

    public void mouseReleased(MouseEvent evt) {
        this.displayEvent(evt, "mouseReleased");
    }

    public void mouseClicked(MouseEvent evt) {
        this.displayEvent(evt, "mouseClicked");
    }

    public void displayEvent(MouseEvent evt, String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        PaneCanvas source = (PaneCanvas)evt.getSource();
        message = message + "(source=" + source.getName();
        int id = evt.getID();
        message = message + " event=" + id;
        message = id == 504 ? message + ":<Mouse entered>" : (id == 505 ? message + ":<Mouse exited>" : (id == 501 ? message + ":<Mouse pressed>" : (id == 502 ? message + ":<Mouse released>" : (id == 500 ? message + ":<Mouse clicked>" : (id == 503 ? message + ":<Mouse moved>" : (id == 506 ? message + ":<Mouse dragged>" : message + ":UNKNOWN ID"))))));
        message = message + " position=(" + evt.getX() + "," + evt.getY() + ") )";
        this.display.add(message, 0);
    }

    public void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "A test on detecting mouse events and refreshing the screen of the inner panel of a ScrollPane:\nThe screen shows a ScrollPane containing 5x3 custom mouse-listening components. Each of this components has a mouse listener attached and will react to mouse events by changing its layout and redrawing itself\nTEST THE THROWING AND CATCHING OF MOUSE EVENTS AND THE REDRAWING OF THE PANE\n..by clicking on one of the panels, the mouse events thrown will be forwarded to the display list on the bottom of the test. Check\n -> if the event source corresponds to the (name of the) panel clicked\n -> if the code for the event thrown corresponds to the actual mouse event.\n -> if the mouse positions (roughly) correspond to the actual position inside the component.\n\n..by regarding the reaction to the mouse events on the component itself :\n -> pressing or releasing the mouse should redraw the screen with the cursor arrow moved to the mouse position\n -> releasing the mouse inside the inner panel rectangle should change the color of the display drawings";
    }

    class PaneCanvas
    extends Component
    implements MouseListener {
        private int preferredWidth;
        private int preferredHeight;
        private Color backColor;
        private int buttonColor;
        private Rectangle colorButton;
        private Point lastclick;
        private String name;

        public PaneCanvas(String text, int width, int height, int red, int green, int blue) {
            this.name = text;
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.backColor = new Color(red, green, blue);
            this.colorButton = new Rectangle((width - 40) / 2, (height - 20) / 2, 40, 20);
            this.buttonColor = colors.length - 1;
            this.lastclick = new Point(width / 2, height / 2);
            this.addMouseListener(this);
        }

        public String getName() {
            return this.name;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            this.lastclick.setLocation(evt.getX(), evt.getY());
            this.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.colorButton.contains(evt.getPoint())) {
                this.buttonColor = this.buttonColor > 1 ? --this.buttonColor : colors.length - 1;
                this.lastclick.setLocation(evt.getX(), evt.getY());
                this.repaint();
            }
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            g.setColor(this.backColor);
            g.fillRect(2, 2, this.preferredWidth - 4, this.preferredHeight - 4);
            g.setColor(colors[this.buttonColor]);
            g.drawString(this.name + ": " + colornames[this.buttonColor], 5, 15);
            g.drawRect(this.colorButton.x, this.colorButton.y, this.colorButton.width, this.colorButton.height);
            g.drawRect(this.colorButton.x + 2, this.colorButton.y + 2, this.colorButton.width - 4, this.colorButton.height - 4);
            g.drawRect(this.colorButton.x + 5, this.colorButton.y + 5, this.colorButton.width - 10, this.colorButton.height - 10);
            g.drawLine(this.lastclick.x, this.lastclick.y, this.lastclick.x + 3, this.lastclick.y + 3);
            g.drawLine(this.lastclick.x, this.lastclick.y, this.lastclick.x + 3, this.lastclick.y - 3);
            g.drawLine(this.lastclick.x + 1, this.lastclick.y + 1, this.lastclick.x + 7, this.lastclick.y + 2);
            g.drawLine(this.lastclick.x + 1, this.lastclick.y - 1, this.lastclick.x + 7, this.lastclick.y - 2);
        }
    }

    class SizedScrollPane
    extends ScrollPane {
        private int preferredWidth;
        private int preferredHeight;

        public SizedScrollPane(int width, int height, Color back) {
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.setSize(width, height);
            this.setBackground(back);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
    }
}

