/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.ScrollPane;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ScrollActionEvent
extends VisualTestImpl
implements ActionListener {
    private List display;
    static final int NUMBEROFBUTTONS = 15;

    public ScrollActionEvent() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        Panel header = new Panel(new GridLayout(1, 3));
        Label lleft = new Label("SCROLLBARS_ALWAYS");
        lleft.setBackground(Color.red);
        header.add(lleft);
        Label lmid = new Label("SCROLLBARS_AS_NEEDED");
        lmid.setBackground(Color.green);
        header.add(lmid);
        Label lright = new Label("SCROLLBARS_NEVER");
        lright.setBackground(Color.blue);
        header.add(lright);
        this.add((Component)header, "North");
        Panel mid = new Panel(new GridLayout(1, 3));
        ScrollPane alwayspane = new ScrollPane(1);
        alwayspane.setBackground(Color.red);
        int saturation = 128;
        Panel always = new Panel(new GridLayout(5, 3));
        PaneButton[] alwaysbuttons = new PaneButton[15];
        for (int i = 0; i < 15; ++i) {
            alwaysbuttons[i] = new PaneButton("SCROLLBARS_ALWAYS", "Button no." + i, 70, 40, saturation += 8, 64, 64);
            alwaysbuttons[i].addActionListener(this);
            always.add(alwaysbuttons[i]);
        }
        alwayspane.add(always);
        mid.add(alwayspane);
        ScrollPane asneededpane = new ScrollPane(0);
        asneededpane.setBackground(Color.green);
        saturation = 128;
        Panel asneeded = new Panel(new GridLayout(5, 3));
        PaneButton[] asneededbuttons = new PaneButton[15];
        for (int i = 0; i < 15; ++i) {
            asneededbuttons[i] = new PaneButton("SCROLLBARS_AS_NEEDED", " Button no." + i, 70, 40, 64, saturation += 8, 64);
            asneededbuttons[i].addActionListener(this);
            asneeded.add(asneededbuttons[i]);
        }
        asneededpane.add(asneeded);
        mid.add(asneededpane);
        ScrollPane neverpane = new ScrollPane(2);
        neverpane.setBackground(Color.blue);
        saturation = 128;
        Panel never = new Panel(new GridLayout(5, 3));
        PaneButton[] neverbuttons = new PaneButton[15];
        for (int i = 0; i < 15; ++i) {
            neverbuttons[i] = new PaneButton("SCROLLBARS_NEVER", "Button no." + i, 70, 40, 64, 64, saturation += 8);
            neverbuttons[i].addActionListener(this);
            never.add(neverbuttons[i]);
        }
        neverpane.add(never);
        mid.add(neverpane);
        this.add((Component)mid, "Center");
        this.display = new List(3, false);
        this.display.add("your button events displayed here");
        this.add((Component)this.display, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        this.displayMessage("Pressed : " + source.getActionCommand());
    }

    public void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "Shows three ScrollPanes, each showing a table of 5 x 3 buttons. The left ScrollPane is defined with display policy ScrollPane.SCROLLBARS_ALWAYS, the middle one with ScrollPane.SCROLLBARS_AS_NEEDED and the right one with ScrollPane.SCROLLBARS_NEVER\n\nAll of the buttons of all of the ScrollPanes have an actionlistener added to them and pressing one of the buttons should display the button's name and its ScrollPane in the list below.\n\nTO TEST: make sure that the pressed button displayed in the events list is the actual button pressed, regardless of the offset of the scrollpanes";
    }

    class PaneButton
    extends Button {
        private int preferredWidth;
        private int preferredHeight;

        public PaneButton(String title, String text, int width, int height) {
            super(text);
            this.setActionCommand("<" + title + ">" + text);
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.setSize(width, height);
        }

        public PaneButton(String title, String text, int width, int height, int red, int green, int blue) {
            super(text);
            this.setBackground(new Color(red, green, blue));
            this.setActionCommand("<" + title + ">" + text);
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.setSize(width, height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
    }
}

