/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class PixelGrabberTest
extends VisualTestImpl
implements MouseListener {
    Image original;
    Image newImage;
    int currentColor;
    int w;
    int h;
    int[] pixels;
    int level = 10;
    PixelGrabber pg;

    public PixelGrabberTest() {
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        this.w = this.original.getWidth(null);
        this.h = this.original.getHeight(null);
        this.pg = new PixelGrabber(this.original, 0, 0, this.w, this.h, true);
        try {
            this.pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.w = this.pg.getWidth();
        this.h = this.pg.getHeight();
        this.pixels = (int[])this.pg.getPixels();
        this.newImage = this.createImage(new MemoryImageSource(this.w, this.h, this.pixels, 0, this.w));
        this.addMouseListener(this);
        this.setBackground(Color.black);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawImage(this.newImage, 0, 0, this.getWidth(), this.getHeight(), null);
        g.setColor(new Color(this.currentColor));
        g.fillRect(10, 10, 20, 20);
        g.setColor(Color.black);
        g.fillRect(10, 40, 20, 60);
        g.setColor(Color.white);
        g.drawRect(10, 10, 20, 20);
        g.drawRect(10, 40, 20, 20);
        g.drawRect(10, 60, 20, 20);
        g.drawRect(10, 80, 20, 20);
        FontMetrics fm = g.getFontMetrics();
        int oy = (20 - fm.getHeight()) / 2 + fm.getHeight();
        g.drawString("+", 10 + (20 - fm.stringWidth("+")) / 2, 40 + oy);
        g.drawString("" + this.level, 10 + (20 - fm.stringWidth("" + this.level)) / 2, 60 + oy);
        g.drawString("-", 10 + (20 - fm.stringWidth("-")) / 2, 80 + oy);
    }

    public String getHelpText() {
        return "PixelGrabber";
    }

    public void mouseClicked(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        boolean button = false;
        if (x > 10 && x < 30) {
            if (y > 40 && y < 60) {
                if (this.level < 255) {
                    ++this.level;
                }
                button = true;
            } else {
                if (y > 60 && y < 80) {
                    return;
                }
                if (y > 80 && y < 100) {
                    if (this.level > 1) {
                        --this.level;
                    }
                    button = true;
                }
            }
        }
        x = x * this.w / this.getWidth();
        y = y * this.h / this.getHeight();
        if (x >= 0 && x < this.w && y >= 0 && y < this.h || button) {
            if (!button) {
                this.currentColor = this.pixels[y * this.w + x];
            }
            int[] newPixels = (int[])this.pixels.clone();
            ColorModel model = this.pg.getColorModel();
            int r1 = model.getRed(this.currentColor);
            int g1 = model.getGreen(this.currentColor);
            int b1 = model.getBlue(this.currentColor);
            int f = this.level;
            for (int i = 0; i < newPixels.length; ++i) {
                int color = newPixels[i];
                int r2 = model.getRed(color);
                int g2 = model.getGreen(color);
                int b2 = model.getBlue(color);
                if (r1 - f >= r2 || r1 + f <= r2 || g1 - f >= g2 || g1 + f <= g2 || b1 - f >= b2 || b1 + f <= b2) continue;
                newPixels[i] = 0;
            }
            this.newImage = this.createImage(new MemoryImageSource(this.w, this.h, newPixels, 0, this.w));
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

