/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class DrawPoly
extends VisualTestImpl {
    public Panel getPanel(VisualTester vte) {
        this.vt = vte;
        return new Poly(this.getBounds().width, this.getBounds().height, new Color(200, 40, 70));
    }

    public String getHelpText() {
        return "You should see an acunia-red frame with a yellow hexagon, a green triangle and a white trapezium, slowly  moving downward. Edges of the polygons that cross the lower border of the frame should be clipped: only parts of these edges inside the frame remain visible";
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((Poly)p), "DrawPoly thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((Poly)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new DrawPoly();
    }

    class Poly
    extends Panel
    implements Runnable {
        Image backBuffer = null;
        Graphics g1 = null;
        int n1points = 6;
        int n2points = 3;
        int n3points = 4;
        int[] x1points = new int[this.n1points];
        int[] y1points = new int[this.n1points];
        int[] x2points = new int[this.n2points];
        int[] y2points = new int[this.n2points];
        int[] x3points = new int[this.n3points];
        int[] y3points = new int[this.n3points];
        int w1;
        int w2;
        int w3;
        int h1;
        int h2;
        int h3;
        int x1;
        int y1;
        int x2;
        int y2;
        int x3;
        int y3;
        Color bg;
        boolean stop = false;

        Poly(int width, int height, Color background) {
            this.setBackground(background);
            this.bg = background;
        }

        void initPoints(int xoffs, int yoffs) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            this.w2 = this.w3 = w / 2 - 1;
            this.w1 = this.w3;
            this.h1 = h;
            this.h2 = this.h3 = h / 2 - 1;
            this.x1 = xoffs;
            this.x2 = this.x3 = this.w1 + xoffs;
            this.y1 = this.y2 = yoffs;
            this.y3 = this.h2 + yoffs;
            if (this.y3 > h) {
                this.y3 -= h;
            }
            this.x1points[0] = this.x1 + 9 * this.w1 / 10;
            this.y1points[0] = this.y1 + 3 * this.h1 / 10;
            this.x1points[1] = this.x1 + 9 * this.w1 / 10;
            this.y1points[1] = this.y1 + 7 * this.h1 / 10;
            this.x1points[2] = this.x1 + 5 * this.w1 / 10;
            this.y1points[2] = this.y1 + 9 * this.h1 / 10;
            this.x1points[3] = this.x1 + 1 * this.w1 / 10;
            this.y1points[3] = this.y1 + 7 * this.h1 / 10;
            this.x1points[4] = this.x1 + 1 * this.w1 / 10;
            this.y1points[4] = this.y1 + 3 * this.h1 / 10;
            this.x1points[5] = this.x1 + 5 * this.w1 / 10;
            this.y1points[5] = this.y1 + this.h1 / 10;
            this.x2points[0] = this.x2 + 9 * this.w2 / 10;
            this.y2points[0] = this.y2;
            this.x2points[1] = this.x2 + this.w2 / 10;
            this.y2points[1] = this.y2 + 2 * this.h2 / 10;
            this.x2points[2] = this.x2 + 5 * this.w2 / 10;
            this.y2points[2] = this.y2 + 9 * this.h2 / 10;
            this.x3points[0] = this.x3 + 4 * this.w3 / 10;
            this.y3points[0] = this.y3;
            this.x3points[1] = this.x3 + 9 * this.w3 / 10;
            this.y3points[1] = this.y3 + 2 * this.h3 / 10;
            this.x3points[2] = this.x3 + 6 * this.w3 / 10;
            this.y3points[2] = this.y3 + 9 * this.h3 / 10;
            this.x3points[3] = this.x3 + this.w3 / 10;
            this.y3points[3] = this.y3 + 7 * this.h3 / 10;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            if (this.backBuffer == null || this.backBuffer.getWidth(null) != w || this.backBuffer.getHeight(null) != h) {
                this.backBuffer = this.createImage(w, h);
                if (this.backBuffer != null) {
                    this.g1 = this.backBuffer.getGraphics();
                }
            }
            if (this.backBuffer != null && this.g1 != null) {
                try {
                    this.g1.clearRect(0, 0, w, h);
                    this.g1.setColor(Color.yellow);
                    this.g1.drawPolygon(this.x1points, this.y1points, this.n1points);
                    this.g1.setColor(Color.green);
                    this.g1.drawPolygon(this.x2points, this.y2points, this.n2points);
                    this.g1.setColor(Color.white);
                    this.g1.drawPolygon(this.x3points, this.y3points, this.n3points);
                    g.drawImage(this.backBuffer, 0, 0, null);
                }
                catch (Exception e) {
                    System.out.println("caught unwanted exception " + e);
                    e.printStackTrace();
                }
            }
        }

        public void run() {
            int x = 0;
            int y = 0;
            while (!this.stop) {
                this.initPoints(x, y);
                this.repaint();
                try {
                    Thread.sleep(80L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++y <= this.getBounds().height) continue;
                y -= this.getBounds().height;
            }
        }
    }
}

