/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;

public class DrawLine
extends VisualTestImpl {
    MyButton but;
    MyPanel pan;

    public DrawLine() {
        this.setLayout(new GridLayout(2, 1));
        this.pan = new MyPanel(Color.blue, Color.yellow);
        this.add(this.pan);
        this.but = new MyButton("BUTTON");
        this.add(this.but);
    }

    public String getTitle() {
        return "DrawLine";
    }

    public String getHelpText() {
        return "A successful test looks like this: the upper half of the screen shows a blue panel and the lower half is a grey button; in both surfaces three identical lines are drawn: a red line extending from the top-left corner of the component to its bottom-right corner; a yellow line extending from the bottom-left corner to the top-right corner; an orange vertical line dividing the component in two equal parts; when pushing the button, the lines remain visible (with sun java they disappear).";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public String getLogInfo(Panel p, boolean b) {
        return "no logging info !";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new DrawLine();
    }

    class MyPanel
    extends Panel {
        public MyPanel(Color b, Color f) {
            this.setBackground(b);
            this.setForeground(f);
        }

        public void paint(Graphics g) {
            g.setColor(Color.red);
            g.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(Color.yellow);
            g.drawLine(this.getWidth() - 1, 0, 0, this.getHeight() - 1);
            g.setColor(Color.orange);
            g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
        }
    }

    class MyButton
    extends Button {
        public MyButton(String title) {
            super(title);
        }

        public void paint(Graphics g) {
            g.setColor(Color.red);
            g.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(Color.yellow);
            g.drawLine(this.getWidth() - 1, 0, 0, this.getHeight() - 1);
            g.setColor(Color.orange);
            g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
        }
    }
}

