/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class DrawImageClipped2
extends VisualTestImpl {
    private Image original;
    private Image faded;
    private int w;
    private int h;

    public DrawImageClipped2() {
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        this.faded = this.createImage(new FilteredImageSource(this.original.getSource(), new FadeFilter()));
        this.w = this.original.getWidth(null);
        this.h = this.original.getHeight(null);
        this.setBackground(Color.black);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.drawImage(this.original, 10, 10, null);
        g.drawRect(20, 20, this.w - 20, this.h - 20);
        g.drawRect(30, 30, this.w - 40, this.h - 40);
        int xspace = 10 * (this.w * 2) / (this.w - 20);
        int yspace = 10 * (this.h * 2) / (this.h - 20);
        g.drawImage(this.faded, 120, 80, 120 + this.w * 2, 80 + this.h * 2, 10, 10, this.w - 10, this.h - 10, null);
        g.setClip(120 + xspace, 80 + yspace, (this.w - xspace) * 2, (this.h - yspace) * 2);
        g.drawImage(this.original, 120, 80, 120 + this.w * 2, 80 + this.h * 2, 10, 10, this.w - 10, this.h - 10, null);
        g.setClip(0, 0, -1, -1);
        g.setColor(Color.white);
        g.drawRect(120, 80, this.w * 2, this.h * 2);
        g.drawRect(120 + xspace, 80 + yspace, (this.w - xspace) * 2, (this.h - yspace) * 2);
    }

    public String getHelpText() {
        return "";
    }

    public class FadeFilter
    extends RGBImageFilter {
        private boolean canFilterIndexColorModel = false;
        private ColorModel model = ColorModel.getRGBdefault();

        public int filterRGB(int x, int y, int rgb) {
            return rgb & 0xFFFFFF | 0xA0000000;
        }
    }
}

