/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Rectangle;

class PaintComponent
extends Component {
    static final Dimension DEFAULTSIZE = new Dimension(100, 55);
    static final Color[] LIGHTCOLORS = new Color[]{new Color(255, 92, 92), new Color(255, 192, 128), new Color(255, 255, 160), new Color(128, 255, 128), new Color(160, 160, 255), new Color(92, 92, 192), new Color(192, 96, 192)};
    static final Color[] DARKCOLORS = new Color[]{new Color(128, 32, 32), new Color(160, 92, 0), new Color(192, 192, 32), new Color(32, 128, 32), new Color(64, 64, 128), new Color(0, 0, 64), new Color(64, 0, 64)};
    static final Color[] MIDCOLORS = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, new Color(96, 96, 255), new Color(0, 0, 160), new Color(128, 0, 128)};
    static final Color[] CONTRASTCOLORS = new Color[]{Color.white, Color.black, Color.black, Color.black, Color.black, Color.white, Color.white};
    static final int COLORCOUNT = MIDCOLORS.length;
    protected int updateCount = 0;
    protected int paintCount = 0;
    protected String name;
    protected Rectangle frameRect;
    protected List displayList;

    public Dimension getPreferredSize() {
        return DEFAULTSIZE;
    }

    public Dimension getMinimumSize() {
        return DEFAULTSIZE;
    }

    public void paint(Graphics g) {
        this.displayList.add(this.name + " Received call to paint()");
        ++this.paintCount;
        if (this.paintArea(DARKCOLORS[(this.paintCount - 1) % COLORCOUNT], Color.white, g)) {
            this.displayList.add(this.name + " on paint() calculated sizes");
        }
        this.displayList.add(this.name + " paint() executed, total paints = " + this.paintCount);
    }

    public void update(Graphics g) {
        this.displayList.add(this.name + " Received call to update()");
        ++this.updateCount;
        if (this.paintArea(LIGHTCOLORS[(this.updateCount - 1) % COLORCOUNT], Color.black, g)) {
            this.displayList.add(this.name + " on update() calculated sizes");
        }
        this.displayList.add(this.name + " update() executed, total updates = " + this.updateCount);
    }

    protected boolean paintArea(Color background, Color foreground, Graphics g) {
        boolean calculated = false;
        if (this.frameRect.width <= 0) {
            this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
            calculated = true;
        }
        g.setColor(background);
        g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
        g.setColor(foreground);
        g.drawString(this.name, 10, 20);
        g.drawString("updates " + this.updateCount, 10, 35);
        g.drawString("paints = " + this.paintCount, 10, 50);
        return calculated;
    }

    public PaintComponent(String text, List displaylist) {
        this.name = text;
        this.displayList = displaylist;
        this.frameRect = new Rectangle();
    }
}

