/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Checkbox;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CheckboxTest
extends VisualTestImpl
implements ItemListener {
    static final Color BACKGROUND = new Color(128, 64, 160);
    private Checkbox[] options;
    private InnerMessagePanel messagePanel;

    public CheckboxTest() {
        int i;
        this.setBackground(BACKGROUND);
        this.setFont(new Font("courR17", 0, 17));
        CheckboxGroup group = new CheckboxGroup();
        this.options = new Checkbox[6];
        for (i = 0; i < 3; ++i) {
            this.options[i] = new Checkbox("option_" + (i + 1), true, group);
        }
        for (i = 3; i < 6; ++i) {
            this.options[i] = new Checkbox("option_" + (i + 1), true);
        }
        this.messagePanel = new InnerMessagePanel();
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(2, 3));
        for (int i2 = 0; i2 < 6; ++i2) {
            p.add(this.options[i2]);
            this.options[i2].addItemListener(this);
        }
        this.add((Component)p, "North");
        this.add((Component)this.messagePanel, "Center");
    }

    public void itemStateChanged(ItemEvent evt) {
        this.messagePanel.paintEvent(evt);
    }

    public String getHelpText() {
        return "A test for checkboxes and radio-buttons: check and uncheck the radio-buttons and checkboxes below.\nThe ItemEvent thrown by the checkbox will be analysed and displayed in the panel below.  Compare its output against that of Blackdown/Sun.\n";
    }

    class InnerMessagePanel
    extends Panel {
        private Rectangle bounds = new Rectangle(0, 0, 0, 0);
        private Rectangle inside = new Rectangle(0, 0, 0, 0);
        private String line1 = "Select one of the checkboxes";
        private String line2 = "  and see the result";
        private String line3 = "    HERE...";
        private String line4 = "           ...";

        public Dimension getMinimumSize() {
            return new Dimension(70, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(70, 50);
        }

        public void paintEvent(ItemEvent evt) {
            Object source = evt.getSource();
            this.line1 = source == null ? "evt.getSource() == NULL" : (source instanceof Checkbox ? "evt.getSource() = " + ((Checkbox)source).getLabel() : "evt.getSource() type = " + source.getClass().getName());
            source = evt.getItem();
            this.line2 = source == null ? "evt.getItem() == NULL" : (source instanceof Checkbox ? "evt.getItem() = " + ((Checkbox)source).getLabel() : " evt.getItem() of type = " + source.getClass().getName());
            ItemSelectable selectable = evt.getItemSelectable();
            Object[] selection = selectable.getSelectedObjects();
            if (selectable == null) {
                this.line3 = "evt.getItemSelectable() == NULL";
            } else if (selection == null) {
                this.line3 = "getItemSelectable():no selections";
            } else {
                this.line3 = "selections {";
                for (int i = 0; i < selection.length; ++i) {
                    this.line3 = this.line3 + " " + selection[i];
                }
                this.line3 = this.line3 + "}";
            }
            this.line4 = evt.getStateChange() == 1 ? "evt.getStateChange() = SELECTED (" + evt.getStateChange() + ")" : (evt.getStateChange() == 2 ? "evt.getStateChange() = DESELECTED (" + evt.getStateChange() + ")" : "(unknown state: evt.getStateChange() = " + evt.getStateChange() + ")");
            System.out.println(this.line1);
            System.out.println(this.line2);
            System.out.println(this.line3);
            System.out.println(this.line4);
            this.repaint();
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            int i;
            if (this.bounds.width == 0) {
                this.bounds.setBounds(1, 1, this.getSize().width - 2, this.getSize().height - 2);
                this.inside.setBounds(7, 7, this.getSize().width - 14, this.getSize().height - 14);
            }
            g.clearRect(1, 1, this.bounds.width, this.bounds.height);
            g.setColor(Color.white);
            g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
            g.drawString(this.line1, 10, 20);
            g.drawString(this.line2, 10, 40);
            g.drawString(this.line3, 10, 60);
            g.drawString(this.line4, 10, 80);
            int third = this.inside.width / 3;
            int x = 10;
            int y = this.inside.height - 35;
            g.drawString("Selected options :", 20, y);
            y += 18;
            for (i = 0; i < 3; ++i) {
                if (CheckboxTest.this.options[i].getState()) {
                    g.drawString(CheckboxTest.this.options[i].getLabel(), x, y);
                }
                x += third;
            }
            x = 10;
            y += 18;
            for (i = 3; i < 6; ++i) {
                if (CheckboxTest.this.options[i].getState()) {
                    g.drawString(CheckboxTest.this.options[i].getLabel(), x, y);
                }
                x += third;
            }
        }
    }
}

