/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.vm;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.vm.ClassOne;
import gnu.testlet.wonka.vm.ClassTwo;
import gnu.testlet.wonka.vm.ClassZero;
import gnu.testlet.wonka.vm.IhZero;
import gnu.testlet.wonka.vm.InitTestOne;
import gnu.testlet.wonka.vm.InitTestTwo;

public class testInheritance
implements Testlet {
    protected static TestHarness harness;

    private final void testStatic() {
        ClassTwo test1 = new ClassTwo();
        ClassTwo.classfield = 1;
        ClassTwo test2 = new ClassTwo(0.1f, 0.2f, 0.3f);
        harness.checkPoint("Static member access through different class instances");
        harness.check(ClassTwo.classfield++, 1);
        test2.zeroElement();
        harness.check(ClassTwo.classfield++, 2);
        test1.zeroElement();
        harness.check(ClassTwo.classfield++, 3);
        ClassTwo.nullElement();
        harness.check(ClassTwo.classfield++, 4);
        ClassTwo.nullElement();
        harness.check(ClassTwo.classfield++, 5);
        harness.check(ClassTwo.classfield, 6);
    }

    private final void testEvaluationOrder() {
        String s;
        harness.checkPoint("Evaluation order with static initialisers");
        harness.check(InitTestOne.a, 0);
        harness.check(InitTestTwo.a, 1);
        harness.checkPoint("Evaluation order with member update");
        String string = s = "0";
        s = "1";
        if (string.equals("1")) {
            harness.fail("s.equals(s='1') comparing s='0' first part with s=>'1' last part should fail");
        } else {
            harness.check(true, "s.equals(s='1') comparing s='0' first part with s=>'1' last part returned 'not equal'");
        }
        harness.check(s, "1", "inline assignment");
        s = "0";
        if ("0".equals(s)) {
            harness.check(true, "(s='0').equals(s) : found s='0' at comparison already");
        } else {
            harness.fail("(s='0').equals(s) : found s='1' at comparison");
        }
        harness.check(s, "0", "inline assignment");
        int x = 0;
        harness.check(x++, 0, "inline assignment post-increment");
        harness.check(++x, 2, "inline assignment pre-increment");
    }

    private final void testVariablesHiding() {
        ClassTwo test = new ClassTwo();
        harness.checkPoint("accessing superclass variables through super calls");
        harness.check(ClassTwo.getXS(), ClassZero.getDescription((float)10.0f), "static superclass member");
        harness.check(test.getX(), ClassZero.getDescription((float)0.0f), "instance superclass member");
        harness.check(test.getSuperXS(), ClassZero.getDescription((int)10), "static superclass member");
        harness.check(test.getSuperX(), ClassZero.getDescription((int)0), "instance superclass member");
        harness.checkPoint("accessing superclass variables through casting");
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), ClassZero.getDescription((float)10.0f), "static member");
        harness.check(ClassZero.getDescription((float)test.x), ClassZero.getDescription((float)0.0f), "instance member");
        harness.check(ClassZero.getDescription((int)ClassOne.xs), ClassZero.getDescription((int)10), "static superclass member");
        harness.check(ClassZero.getDescription((int)test.x), ClassZero.getDescription((int)0), "instance superclass member");
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), ClassZero.getDescription((boolean)true), "static superclass member");
        harness.check(ClassZero.getDescription((boolean)test.x), ClassZero.getDescription((boolean)false), "instance superclass member");
        harness.checkPoint("accessing interface variables through interface calls");
        harness.check(test.getIhZeroXS(), ClassZero.getDescription((ClassZero)new ClassZero()), "static interface member");
        harness.check(test.getIhZeroX(), ClassZero.getDescription((ClassZero)new ClassZero(true, 0.1f, 0.2f)), "instance interface member");
        harness.check(test.getIhOneXS(), ClassZero.getDescription((String)"ten"), "static interface member");
        harness.check(test.getIhOneX(), ClassZero.getDescription((String)"zero"), "instance interface member");
        harness.checkPoint("accessing interface variables through casting");
        harness.check(ClassZero.getDescription((ClassZero)IhZero.xs), ClassZero.getDescription((ClassZero)new ClassZero()), "static interface member");
        harness.check(ClassZero.getDescription((ClassZero)IhZero.x), ClassZero.getDescription((ClassZero)new ClassZero(true, 0.1f, 0.2f)), "instance interface member");
        harness.check(ClassZero.getDescription((String)"ten"), ClassZero.getDescription((String)"ten"), "static interface member");
        harness.check(ClassZero.getDescription((String)"zero"), ClassZero.getDescription((String)"zero"), "instance interface member");
    }

    private final void testMembersAccess() {
        ClassZero C0 = new ClassZero(true, 0.1f, 0.2f);
        ClassOne C1 = new ClassOne(1, 0.3f, 0.4f);
        ClassTwo C2 = new ClassTwo(1.0f, 0.5f, 0.6f);
        harness.checkPoint("construction: final members");
        C0.getClass();
        harness.check("C-0", (Object)"C-0");
        C0.getClass();
        new ClassZero();
        harness.check("C-0", (Object)"C-0");
        C1.getClass();
        harness.check("C-1", (Object)"C-1");
        C1.getClass();
        new ClassOne();
        harness.check("C-1", (Object)"C-1");
        C2.getClass();
        harness.check("C-2", (Object)"C-2");
        C2.getClass();
        new ClassTwo();
        harness.check("C-2", (Object)"C-2");
        harness.checkPoint("construction static members");
        harness.check(ClassZero.fullname, (Object)"C - Zero");
        harness.check(ClassZero.fullname, (Object)ClassZero.fullname);
        harness.check(ClassOne.fullname, (Object)"C - One");
        harness.check(ClassOne.fullname, (Object)ClassOne.fullname);
        harness.check(ClassTwo.fullname, (Object)"C - Two");
        harness.check(ClassTwo.fullname, (Object)ClassTwo.fullname);
        harness.checkPoint("construction instance members double defined");
        harness.check(C0.y, 0.1f);
        harness.check(C1.y, 0.3f);
        harness.check(C2.y, 0.5);
        harness.checkPoint("construction instance members once defined");
        harness.check(C0.z, 0.2f);
        harness.check(C1.z, 0.4f);
        harness.check(C2.z, 0.6f);
        ClassOne C1to0 = C1;
        ClassTwo C2to1 = C2;
        ClassTwo C2to0 = C2;
        harness.checkPoint("conversion through casting: final members");
        C1to0.getClass();
        harness.check("C-0", (Object)"C-0");
        C1to0.getClass();
        new ClassZero();
        harness.check("C-0", (Object)"C-0");
        C2to1.getClass();
        harness.check("C-1", (Object)"C-1");
        C2to1.getClass();
        new ClassOne();
        harness.check("C-1", (Object)"C-1");
        C2to0.getClass();
        harness.check("C-0", (Object)"C-0");
        C2to0.getClass();
        new ClassZero();
        harness.check("C-0", (Object)"C-0");
        harness.checkPoint("conversion through casting: static members");
        harness.check(ClassZero.fullname, (Object)"C - Zero");
        harness.check(ClassZero.fullname, (Object)ClassZero.fullname);
        harness.check(ClassOne.fullname, (Object)"C - One");
        harness.check(ClassOne.fullname, (Object)ClassOne.fullname);
        harness.check(ClassZero.fullname, (Object)"C - Zero");
        harness.check(ClassZero.fullname, (Object)ClassZero.fullname);
        harness.checkPoint("conversion through casting: instance members double defined");
        harness.check(C1to0.y, 0.0);
        harness.check(C1to0.y, new ClassZero().y);
        harness.check(C2to0.y, 0.0);
        harness.check(C2to0.y, new ClassZero().y);
        harness.check(C2to1.y, 1.0);
        harness.check(C2to1.y, new ClassOne().y);
        harness.checkPoint("conversion through casting: construction instance members once defined");
        harness.check(C1to0.z, 0.4f);
        harness.check(C2to0.z, 0.6f);
        harness.check(C2to1.z, 0.6f);
        C0 = C1;
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassOne");
        harness.checkPoint("conversion through (C1=>C0): final members");
        C0.getClass();
        harness.check("C-0", (Object)"C-0");
        C0.getClass();
        new ClassZero();
        harness.check("C-0", (Object)"C-0");
        harness.checkPoint("conversion through assignment(C1=>C0): static members");
        harness.check(ClassZero.fullname, (Object)"C - Zero");
        harness.check(ClassZero.fullname, (Object)ClassZero.fullname);
        harness.checkPoint("conversion through assignment(C1=>C0): instance members once defined");
        harness.check(C0.y, 0.0);
        harness.check(C0.y, new ClassZero().y);
        harness.checkPoint("conversion through assignment(C1=>C0): construction instance members once defined");
        harness.check(C0.z, 0.4f);
        C0 = C2;
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.checkPoint("conversion through assignment(C2=>C0): final members");
        C0.getClass();
        harness.check("C-0", (Object)"C-0");
        C0.getClass();
        new ClassZero();
        harness.check("C-0", (Object)"C-0");
        harness.checkPoint("conversion through assignment(C2=>C0): static members");
        harness.check(ClassZero.fullname, (Object)"C - Zero");
        harness.check(ClassZero.fullname, (Object)ClassZero.fullname);
        harness.checkPoint("conversion through assignment(C2=>C0): instance members once defined");
        harness.check(C0.y, 0.0);
        harness.check(C0.y, new ClassZero().y);
        harness.checkPoint("conversion through assignment(C2=>C0): construction instance members once defined");
        harness.check(C0.z, 0.6f);
        C1 = C2;
        harness.check(C1.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.checkPoint("conversion through assignment(C2=>C1): final members");
        C1.getClass();
        harness.check("C-1", (Object)"C-1");
        C1.getClass();
        new ClassOne();
        harness.check("C-1", (Object)"C-1");
        harness.checkPoint("conversion through assignment(C2=>C1): static members");
        harness.check(ClassOne.fullname, (Object)"C - One");
        harness.check(ClassOne.fullname, (Object)ClassOne.fullname);
        harness.checkPoint("conversion through assignment(C2=>C1): instance members once defined");
        harness.check(C1.y, 1.0);
        harness.check(C1.y, new ClassOne().y);
        harness.checkPoint("conversion through assignment(C2=>C1): construction instance members once defined");
        harness.check(C1.z, 0.6f);
    }

    private final void testMethodsAccess() {
        ClassTwo C2;
        ClassOne C1;
        ClassZero C0 = new ClassZero();
        ClassOne C1to0 = C1 = new ClassOne();
        ClassTwo C2to1 = C2 = new ClassTwo();
        ClassTwo C2to0 = C2;
        C0.reset();
        C1.reset();
        C2.reset();
        harness.checkPoint("class instance methods access by variable (float)");
        C0.setX(-11.9f);
        C1to0.setX(-11.9f);
        C2to0.setX(-11.9f);
        harness.check(ClassZero.getDescription((boolean)C0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((boolean)C1to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)-11));
        harness.check(ClassZero.getDescription((boolean)C2to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)-11.9f));
        C1.setX(11.8f);
        C2to1.setX(11.8f);
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)11));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)11.8f));
        C2.setX(-11.7f);
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)-11.7f));
        harness.checkPoint("class static methods access by variable (float)");
        ClassZero.setXS((float)12.5f);
        ClassZero.setXS((float)12.5f);
        ClassZero.setXS((float)12.5f);
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassOne.setXS((float)-12.6f);
        ClassOne.setXS((float)-12.6f);
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)-12));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)-12));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassTwo.setXS((float)12.7f);
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)12.7f));
        C0.reset();
        C1.reset();
        C2.reset();
        harness.checkPoint("class instance methods access by variable (int)");
        C0.setX(11);
        C1to0.setX(11);
        C2to0.setX(11);
        harness.check(ClassZero.getDescription((boolean)C0.x), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getDescription((boolean)C1to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)11));
        harness.check(ClassZero.getDescription((boolean)C2to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)11.0f));
        C1.setX(-12);
        C2to1.setX(-12);
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)-12));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)-12.0f));
        C2.setX(13);
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)13.0f));
        harness.checkPoint("class static methods access by variable (int)");
        ClassZero.setXS((int)-14);
        ClassZero.setXS((int)-14);
        ClassZero.setXS((int)-14);
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassOne.setXS((int)15);
        ClassOne.setXS((int)15);
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)15));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)15));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassTwo.setXS((int)-16);
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)-16.0f));
        C0.reset();
        C1.reset();
        C2.reset();
        harness.checkPoint("class instance methods access by variable (boolean)");
        C0.setX(true);
        C1to0.setX(true);
        C2to0.setX(true);
        harness.check(ClassZero.getDescription((boolean)C0.x), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getDescription((boolean)C1to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)1));
        harness.check(ClassZero.getDescription((boolean)C2to0.x), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)1.0f));
        C1.setX(false);
        C2to1.setX(false);
        harness.check(ClassZero.getDescription((int)C1.x), (Object)ClassZero.getDescription((int)-1));
        harness.check(ClassZero.getDescription((int)C2to1.x), (Object)ClassZero.getDescription((int)0));
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)(-1.0f)));
        C2.setX(true);
        harness.check(ClassZero.getDescription((float)C2.x), (Object)ClassZero.getDescription((float)1.0f));
        harness.checkPoint("class static methods access by variable (boolean)");
        ClassZero.setXS((boolean)false);
        ClassZero.setXS((boolean)false);
        ClassZero.setXS((boolean)false);
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((boolean)ClassZero.xs), (Object)ClassZero.getDescription((boolean)false));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassOne.setXS((boolean)true);
        ClassOne.setXS((boolean)true);
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)1));
        harness.check(ClassZero.getDescription((int)ClassOne.xs), (Object)ClassZero.getDescription((int)1));
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)10.0f));
        ClassTwo.setXS((boolean)false);
        harness.check(ClassZero.getDescription((float)ClassTwo.xs), (Object)ClassZero.getDescription((float)(-1.0f)));
        C0.reset();
        C1.reset();
        C2.reset();
        C0 = C1;
        harness.checkPoint("conversion through assignation(C1=>C0): Class and ToString");
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassOne");
        harness.check(C0.toString(), (Object)C1.toString());
        harness.check(C0.toString(), (Object)ClassOne.describeOne((ClassOne)C1));
        harness.checkPoint("conversion through assignation(C1=>C0): static members");
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)ClassZero.xs));
        new ClassZero();
        harness.check(ClassZero.getXS(), (Object)ClassZero.getXS());
        harness.checkPoint("conversion through assignation(C1=>C0): instance members");
        harness.check(C0.getX(), (Object)ClassZero.getDescription((int)0));
        harness.check(C0.getX(), (Object)ClassZero.getDescription((int)new ClassOne().x));
        harness.check(C0.getX(), (Object)new ClassOne().getX());
        C0 = C2;
        harness.checkPoint("conversion through assignation(C2=>C0): Class and ToString");
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.check(C0.toString(), (Object)C2.toString());
        harness.check(C0.toString(), (Object)ClassTwo.describeTwo((ClassTwo)C2));
        harness.checkPoint("conversion through assignation(C2=>C0): static members");
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)ClassZero.xs));
        new ClassZero();
        harness.check(ClassZero.getXS(), (Object)ClassZero.getXS());
        harness.checkPoint("conversion through assignation(C2=>C0): instance members");
        harness.check(C0.getX(), (Object)ClassZero.getDescription((float)0.0f));
        harness.check(C0.getX(), (Object)ClassZero.getDescription((float)new ClassTwo().x));
        harness.check(C0.getX(), (Object)new ClassTwo().getX());
        C1 = C2;
        harness.checkPoint("conversion through assignation(C2=>C1): Class and ToString");
        harness.check(C1.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.check(C1.toString(), (Object)C2.toString());
        harness.check(C1.toString(), (Object)ClassTwo.describeTwo((ClassTwo)C2));
        harness.checkPoint("conversion through assignation(C2=>C1): static members");
        harness.check(ClassOne.getXS(), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassOne.getXS(), (Object)ClassZero.getDescription((int)ClassOne.xs));
        new ClassOne();
        harness.check(ClassOne.getXS(), (Object)ClassOne.getXS());
        harness.checkPoint("conversion through assignation(C1=>C0): instance members");
        harness.check(C1.getX(), (Object)ClassZero.getDescription((float)0.0f));
        harness.check(C1.getX(), (Object)ClassZero.getDescription((float)new ClassTwo().x));
        harness.check(C1.getX(), (Object)new ClassTwo().getX());
        C0 = new ClassOne(7, 7.0f, 7.0f);
        harness.checkPoint("conversion through explicit construction(C1=>C0): Class and ToString");
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassOne");
        harness.check(C0.toString(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)10, (int)7, (float)7.0f, (float)7.0f));
        harness.check(C0.toString(), (Object)ClassOne.describeOne((ClassOne)new ClassOne(7, 7.0f, 7.0f)));
        harness.checkPoint("conversion through explicit construction(C1=>C0): static members");
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)ClassZero.xs));
        new ClassZero();
        harness.check(ClassZero.getXS(), (Object)ClassZero.getXS());
        harness.checkPoint("conversion through explicit construction(C1=>C0): instance members");
        harness.check(C0.getX(), (Object)ClassZero.getDescription((int)7));
        harness.check(C0.getX(), (Object)ClassZero.getDescription((int)new ClassOne((int)7, (float)0.0f, (float)0.0f).x));
        harness.check(C0.getX(), (Object)new ClassOne(7, 0.0f, 0.0f).getX());
        C0 = new ClassTwo(7.1f, 7.2f, 7.3f);
        harness.checkPoint("conversion through explicit construction(C2=>C0): Class and ToString");
        harness.check(C0.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.check(C0.toString(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)10.0f, (float)7.1f, (float)7.2f, (float)7.3f));
        harness.check(C0.toString(), (Object)ClassTwo.describeTwo((ClassTwo)new ClassTwo(7.1f, 7.2f, 7.3f)));
        harness.checkPoint("conversion through explicit construction(C2=>C0): static members");
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)true));
        harness.check(ClassZero.getXS(), (Object)ClassZero.getDescription((boolean)ClassZero.xs));
        new ClassZero();
        harness.check(ClassZero.getXS(), (Object)ClassZero.getXS());
        harness.checkPoint("conversion through explicit construction(C2=>C0): instance members");
        harness.check(C0.getX(), (Object)ClassZero.getDescription((float)7.1f));
        harness.check(C0.getX(), (Object)ClassZero.getDescription((float)new ClassTwo((float)7.1f, (float)0.0f, (float)0.0f).x));
        harness.check(C0.getX(), (Object)new ClassTwo(7.1f, 0.0f, 0.0f).getX());
        C1 = new ClassTwo(7.4f, 7.5f, 7.6f);
        harness.checkPoint("conversion through explicit construction(C2=>C1): Class and ToString");
        harness.check(C1.getClass().getName(), (Object)"gnu.testlet.wonka.vm.ClassTwo");
        harness.check(C1.toString(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)10.0f, (float)7.4f, (float)7.5f, (float)7.6f));
        harness.check(C1.toString(), (Object)ClassTwo.describeTwo((ClassTwo)new ClassTwo(7.4f, 7.5f, 7.6f)));
        harness.checkPoint("conversion through explicit construction(C2=>C1): static members");
        harness.check(ClassOne.getXS(), (Object)ClassZero.getDescription((int)10));
        harness.check(ClassOne.getXS(), (Object)ClassZero.getDescription((int)ClassOne.xs));
        new ClassOne();
        harness.check(ClassOne.getXS(), (Object)ClassOne.getXS());
        harness.checkPoint("conversion through explicit construction(C2=>C1): instance members");
        harness.check(C1.getX(), (Object)ClassZero.getDescription((float)7.4f));
        harness.check(C1.getX(), (Object)ClassZero.getDescription((float)new ClassTwo((float)7.4f, (float)0.0f, (float)0.0f).x));
        harness.check(C1.getX(), (Object)new ClassTwo(7.4f, 0.0f, 0.0f).getX());
    }

    private final void testMethodsParameters() {
        ClassTwo q2 = new ClassTwo();
        harness.checkPoint("member checking through explicit superclass functions");
        q2.importTwo(new ClassTwo(1.1f, 2.2f, 3.3f, 4.4f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.1f, (float)2.2f, (float)3.3f, (float)4.4f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)10, (int)0, (float)1.0f, (float)4.4f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)true, (boolean)false, (float)0.0f, (float)4.4f));
        q2.reset();
        harness.checkPoint("member checking through superclass functions, member setting with casted functions (ImportOne)");
        q2.importOne((ClassOne)new ClassTwo(1.2f, 2.3f, 3.4f, 4.5f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.2f, (float)0.0f, (float)2.0f, (float)4.5f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)10, (int)0, (float)1.0f, (float)4.5f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)true, (boolean)false, (float)0.0f, (float)4.5f));
        q2.importOne(new ClassOne(1, 2, 3.5f, 4.6f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.2f, (float)0.0f, (float)2.0f, (float)4.6f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)1, (int)2, (float)3.5f, (float)4.6f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)true, (boolean)false, (float)0.0f, (float)4.6f));
        q2.reset();
        harness.checkPoint("member checking through superclass functions, member setting with casted functions (ImportZero)");
        q2.importZero((ClassZero)new ClassTwo(1.4f, 2.5f, 3.6f, 4.7f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.4f, (float)0.0f, (float)2.0f, (float)4.7f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)10, (int)0, (float)1.0f, (float)4.7f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)true, (boolean)false, (float)0.0f, (float)4.7f));
        q2.importZero((ClassZero)new ClassOne(11, 12, 3.7f, 4.8f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.4f, (float)0.0f, (float)2.0f, (float)4.8f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)11, (int)0, (float)1.0f, (float)4.8f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)true, (boolean)false, (float)0.0f, (float)4.8f));
        q2.importZero(new ClassZero(false, true, 3.8f, 4.9f));
        harness.check(q2.describeTwo(), (Object)ClassZero.describe((String)ClassTwo.fullname, (float)1.4f, (float)0.0f, (float)2.0f, (float)4.9f));
        harness.check(q2.describeOne(), (Object)ClassZero.describe((String)ClassOne.fullname, (int)11, (int)0, (float)1.0f, (float)4.9f));
        harness.check(q2.describeZero(), (Object)ClassZero.describe((String)ClassZero.fullname, (boolean)false, (boolean)true, (float)3.8f, (float)4.9f));
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Class");
        this.testStatic();
        this.testEvaluationOrder();
        this.testVariablesHiding();
        this.testMembersAccess();
        this.testMethodsAccess();
        this.testMethodsParameters();
    }
}

