/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Timer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class AcuniaTimerTest
extends TimerTask
implements Testlet {
    private static int SET_THREAD = 20;
    private static int KILL_THREAD = 21;
    private static int CANCEL_TIMER = 30;
    private static int FIXED_RATE = 40;
    private static int RATE_STOP = 49;
    private static int FIXED_INTERVAL = 50;
    private static int INTERVAL_STOP = 59;
    private static int ONE_RUN = 60;
    private static int FAIL = -1;
    private static Thread timerthread;
    private static Timer theTimer;
    protected TestHarness th;
    private long previous;
    private int count;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Timer");
        this.test_Timer();
        this.test_cancel();
        this.test_schedule();
        this.test_scheduleAtFixedRate();
        this.test_basic();
        this.test_behaviour();
        theTimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_basic() {
        this.th.checkPoint("basic test");
        Timer timer = new Timer();
        AcuniaTimerTest acuniaTimerTest = this;
        synchronized (acuniaTimerTest) {
            timer.schedule((TimerTask)this, 200L, 100L);
            timer = null;
            try {
                this.wait();
                System.gc();
                timerthread.join(15000L);
                this.th.check(timerthread.isAlive() ^ true, "thread should be gone now");
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return;
        }
    }

    public void test_Timer() {
        this.th.checkPoint("Timer()");
        Timer timer = new Timer();
        timerthread = null;
        timer.schedule((TimerTask)new AcuniaTimerTest(SET_THREAD, this.th), 0L);
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.check(timerthread.isDaemon() ^ true, "timer has by default a non-daemon thread");
        this.th.checkPoint("Timer(boolean)");
        timer = new Timer(false);
        timerthread = null;
        timer.schedule((TimerTask)new AcuniaTimerTest(SET_THREAD, this.th), 0L);
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.check(timerthread.isDaemon() ^ true, "timer was set non-daemon");
        timer = new Timer(true);
        timerthread = null;
        timer.schedule((TimerTask)new AcuniaTimerTest(SET_THREAD, this.th), 0L);
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.check(timerthread.isDaemon(), "timer was set daemon");
        this.th.check(timerthread.getPriority(), 5, "checking priority of the timer");
    }

    public void test_cancel() {
        this.th.checkPoint("cancel()void");
        theTimer = new Timer();
        timerthread = null;
        theTimer.schedule((TimerTask)new AcuniaTimerTest(CANCEL_TIMER, this.th), 0L, 50L);
        while (timerthread == null) {
            Thread.yield();
        }
        Timer timer = new Timer();
        timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 250L, 50L);
        timer.cancel();
    }

    public void test_schedule() {
        this.th.checkPoint("schedule(java.util.TimerTask,long)void");
        timerthread = null;
        Timer killedTimer = new Timer();
        killedTimer.schedule((TimerTask)new AcuniaTimerTest(KILL_THREAD, this.th), 0L);
        while (timerthread == null) {
            Thread.yield();
        }
        Thread.yield();
        Timer timer = new Timer(true);
        Timer cancelledTimer = new Timer();
        AcuniaTimerTest cancelledTask = new AcuniaTimerTest(FAIL, this.th);
        cancelledTask.cancel();
        AcuniaTimerTest addedTask = new AcuniaTimerTest(FAIL, this.th);
        timer.schedule((TimerTask)addedTask, 10000000000L);
        try {
            cancelledTimer.schedule((TimerTask)addedTask, 50L);
            this.th.fail("should throw an IllegalStateException -- 0");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        cancelledTimer.cancel();
        try {
            cancelledTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L);
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L);
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)addedTask, 50L);
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)cancelledTask, 50L);
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), -1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), Long.MAX_VALUE);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        Timer runner = new Timer(true);
        timerthread = null;
        runner.schedule((TimerTask)new AcuniaTimerTest(ONE_RUN, this.th), 25L);
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.checkPoint("schedule(java.util.TimerTask,java.util.Date)void");
        try {
            cancelledTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date());
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date());
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)addedTask, new Date());
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)cancelledTask, new Date());
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(-1));
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        runner = new Timer(true);
        timerthread = null;
        runner.schedule((TimerTask)new AcuniaTimerTest(ONE_RUN, this.th), new Date(1L));
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.checkPoint("schedule(java.util.TimerTask,long,long)void");
        try {
            cancelledTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)addedTask, 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)cancelledTask, 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), -1, 50L);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), Long.MAX_VALUE, 50L);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), 10L, -50L);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        runner = new Timer(true);
        timerthread = null;
        runner.schedule((TimerTask)new AcuniaTimerTest(FIXED_INTERVAL, this.th, System.currentTimeMillis()), 0L, 50L);
        while (timerthread == null) {
            Thread.yield();
        }
        this.th.checkPoint("schedule(java.util.TimerTask,java.util.Date,long)void");
        try {
            cancelledTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)addedTask, new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)cancelledTask, new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(), -50L);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.schedule((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(-1), 50L);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        runner = new Timer(true);
        timerthread = null;
        runner.schedule((TimerTask)new AcuniaTimerTest(FIXED_INTERVAL, this.th, 0L), new Date(0L), 50L);
        while (timerthread == null) {
            Thread.yield();
        }
        timer.cancel();
    }

    public void test_scheduleAtFixedRate() {
        this.th.checkPoint("scheduleAtFixedRate(java.util.TimerTask,long,long)void");
        timerthread = null;
        Timer killedTimer = new Timer();
        killedTimer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(KILL_THREAD, this.th), 0L, 1L);
        while (timerthread == null) {
            Thread.yield();
        }
        Thread.yield();
        Timer timer = new Timer(true);
        Timer cancelledTimer = new Timer();
        AcuniaTimerTest cancelledTask = new AcuniaTimerTest(FAIL, this.th);
        cancelledTask.cancel();
        AcuniaTimerTest addedTask = new AcuniaTimerTest(FAIL, this.th);
        timer.scheduleAtFixedRate((TimerTask)addedTask, 10000000000L, 100000000L);
        try {
            cancelledTimer.scheduleAtFixedRate((TimerTask)addedTask, 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 0");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        cancelledTimer.cancel();
        try {
            cancelledTimer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)addedTask, 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)cancelledTask, 50L, 50L);
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), -1, 50L);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), Long.MAX_VALUE, 50L);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), 50L, (long)-1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.checkPoint("scheduleAtFixedRateAtFixedRate(java.util.TimerTask,java.util.Date,long)void");
        try {
            cancelledTimer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            killedTimer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)addedTask, new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)cancelledTask, new Date(), 50L);
            this.th.fail("should throw an IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(-1), 50L);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            timer.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FAIL, this.th), new Date(1L), (long)-1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        Timer runner = new Timer(true);
        timerthread = null;
        runner.scheduleAtFixedRate((TimerTask)new AcuniaTimerTest(FIXED_RATE, this.th, 1L), new Date(1L), 50L);
        while (timerthread == null) {
            Thread.yield();
        }
        timer.cancel();
    }

    public void test_behaviour() {
        this.th.checkPoint("()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.count == FAIL) {
            this.th.fail("TimerTask FAILED");
            throw new Error();
        }
        if (this.count == ONE_RUN) {
            boolean bl = false;
            if (this.scheduledExecutionTime() <= System.currentTimeMillis()) {
                bl = true;
            }
            this.th.check(bl, "ONE_RUN check");
            timerthread = Thread.currentThread();
            this.count = FAIL;
            return;
        }
        if (this.count == SET_THREAD) {
            timerthread = Thread.currentThread();
            return;
        }
        if (this.count == INTERVAL_STOP) {
            boolean bl = false;
            if (this.scheduledExecutionTime() >= this.previous + 1500L) {
                bl = true;
            }
            this.th.check(bl, "checking fixed interval");
            timerthread = Thread.currentThread();
            this.cancel();
            this.count = FAIL;
            return;
        }
        if (this.count >= FIXED_INTERVAL) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++this.count;
            return;
        }
        if (this.count == RATE_STOP) {
            this.th.check(this.scheduledExecutionTime(), this.previous, "checking fixed rate");
            timerthread = Thread.currentThread();
            this.cancel();
            this.count = FAIL;
            return;
        }
        if (this.count >= FIXED_RATE) {
            this.th.check(this.scheduledExecutionTime(), this.previous, "checking fixed rate");
            this.previous += 50L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.count;
            return;
        }
        if (this.count == KILL_THREAD) {
            timerthread = Thread.currentThread();
            throw new Error("this should kill the timerThread -- This is done intentially");
        }
        if (this.count == CANCEL_TIMER) {
            timerthread = Thread.currentThread();
            theTimer.cancel();
            this.count = FAIL;
            return;
        }
        boolean bl = false;
        if (this.scheduledExecutionTime() <= System.currentTimeMillis()) {
            bl = true;
        }
        this.th.check(bl);
        if (this.count++ < 5) return;
        this.th.check(this.cancel(), "stop the loop");
        this.th.check(this.cancel() ^ true, "already cancelled the loop");
        this.count = FAIL;
        AcuniaTimerTest acuniaTimerTest = this;
        synchronized (acuniaTimerTest) {
            timerthread = Thread.currentThread();
            this.notifyAll();
            return;
        }
    }

    public AcuniaTimerTest() {
    }

    private AcuniaTimerTest(int loop, TestHarness harness) {
        this.th = harness;
        this.count = loop;
    }

    private AcuniaTimerTest(int loop, TestHarness harness, long prev) {
        this.th = harness;
        this.count = loop;
        this.previous = prev;
    }

    private AcuniaTimerTest(TestHarness harness) {
        this.th = harness;
    }
}

