/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Stack;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.EmptyStackException;
import java.util.Stack;

public class SMStackTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Stack");
        this.test_empty();
        this.test_peek();
        this.test_pop();
        this.test_push();
        this.test_search();
    }

    public void test_empty() {
        this.th.checkPoint("empty()boolean");
        Stack<SMStackTest> s = new Stack<SMStackTest>();
        this.th.check(s.empty(), "a new stack is empty");
        s.push(this);
        this.th.check(s.empty() ^ true, "this stack is not empty");
        s.pop();
        this.th.check(s.empty(), "the stack is empty now");
    }

    public void test_peek() {
        this.th.checkPoint("peek()java.lang.Object");
        Stack<String> s = new Stack<String>();
        try {
            s.peek();
            this.th.fail("should throw EmptyStackException");
        }
        catch (EmptyStackException ee) {
            this.th.check(true);
        }
        s.add("a");
        s.add("b");
        s.add("c");
        this.th.check("c".equals(s.peek()), "top element is c, but got:" + s.peek());
        s.add(null);
        boolean bl = false;
        if (s.peek() == null) {
            bl = true;
        }
        this.th.check(bl, "top element is null");
    }

    public void test_pop() {
        this.th.checkPoint("pop()java.lang.Object");
        Stack<String> s = new Stack<String>();
        try {
            s.pop();
            this.th.fail("should throw EmptyStackException -- 1");
        }
        catch (EmptyStackException ee) {
            this.th.check(true);
        }
        s.add("a");
        s.add("b");
        s.add("c");
        this.th.check("c".equals(s.pop()), "popped element is c");
        this.th.check(s.contains("c") ^ true, "element should be removed -- 1");
        s.add(null);
        boolean bl = false;
        if (s.pop() == null) {
            bl = true;
        }
        this.th.check(bl, "popped element is null");
        this.th.check(s.contains("c") ^ true, "element should be removed -- 2");
        this.th.check("b".equals(s.pop()), "popped element is b");
        this.th.check(s.contains("b") ^ true, "element should be removed -- 3");
        this.th.check("a".equals(s.pop()), "popped element is a");
        this.th.check(s.contains("a") ^ true, "element should be removed -- 4");
        try {
            s.pop();
            this.th.fail("should throw EmptyStackException -- 2");
        }
        catch (EmptyStackException ee) {
            this.th.check(true);
        }
    }

    public void test_push() {
        this.th.checkPoint("push(java.lang.Object)java.lang.Object");
        Stack<String> s = new Stack<String>();
        this.th.check("c".equals(s.push("c")), "pushed element is c");
        this.th.check(s.contains("c"), "element should be added -- 1");
        this.th.check("b".equals(s.push("b")), "pushed element is b");
        this.th.check(s.contains("b"), "element should be added -- 2");
        this.th.check("a".equals(s.push("a")), "pushed element is a");
        this.th.check(s.contains("a"), "element should be added -- 3");
        boolean bl = false;
        if (s.push(null) == null) {
            bl = true;
        }
        this.th.check(bl, "null is allowed");
        boolean bl2 = false;
        if (s.lastElement() == null) {
            bl2 = true;
        }
        this.th.check(bl2, "added on the last place");
        this.th.check(s.toString().equals("[c, b, a, null]"), "got:" + s.toString());
    }

    public void test_search() {
        this.th.checkPoint("search(java.lang.Object)int");
        Stack<String> s = new Stack<String>();
        try {
            boolean bl = false;
            if (s.search("a") == -1) {
                bl = true;
            }
            this.th.check(bl, "empty stack should'n cause problems -- 1");
            boolean bl2 = false;
            if (s.search(null) == -1) {
                bl2 = true;
            }
            this.th.check(bl2, "empty stack should'n cause problems -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted Exception:" + e);
        }
        s.add("a");
        s.add("b");
        s.add("c");
        s.add("a");
        s.add("a");
        s.add(null);
        s.add(null);
        s.add("top");
        boolean bl = false;
        if (s.search("a") == 4) {
            bl = true;
        }
        this.th.check(bl, "checking position -- 1");
        boolean bl3 = false;
        if (s.search("b") == 7) {
            bl3 = true;
        }
        this.th.check(bl3, "checking position -- 2");
        boolean bl4 = false;
        if (s.search("c") == 6) {
            bl4 = true;
        }
        this.th.check(bl4, "checking position -- 3");
        boolean bl5 = false;
        if (s.search("top") == 1) {
            bl5 = true;
        }
        this.th.check(bl5, "checking position -- 4");
        boolean bl6 = false;
        if (s.search(null) == 2) {
            bl6 = true;
        }
        this.th.check(bl6, "checking position -- 5");
        boolean bl7 = false;
        if (s.search("ab") == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "checking position -- 6");
        s.pop();
        s.pop();
        s.pop();
        boolean bl8 = false;
        if (s.search("a") == 1) {
            bl8 = true;
        }
        this.th.check(bl8, "checking position -- 7");
        boolean bl9 = false;
        if (s.search(null) == -1) {
            bl9 = true;
        }
        this.th.check(bl9, "checking position -- 8");
    }
}

