/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.ResourceBundle;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class getBundle
implements Testlet {
    private static final String MISSING = "**missing**";

    private final String loadCheck(String bundle) {
        ResourceBundle rb;
        try {
            rb = ResourceBundle.getBundle(bundle);
        }
        catch (MissingResourceException ex) {
            return MISSING;
        }
        return rb.getString("class");
    }

    private final String loadCheck(String bundle, Locale locale) {
        ResourceBundle rb;
        try {
            rb = ResourceBundle.getBundle(bundle, locale);
        }
        catch (MissingResourceException ex) {
            return MISSING;
        }
        return rb.getString("class");
    }

    private final String c(String bundle) {
        return "gnu.testlet.wonka.util.ResourceBundle." + bundle;
    }

    public void test(TestHarness harness) {
        harness.setclass("java.util.ResourceBundle");
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.CANADA);
        harness.checkPoint("with locale of Canada");
        harness.check(this.loadCheck(this.c("Resource1")), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource1"), Locale.CANADA), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource1"), Locale.JAPAN), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource2"), Locale.CANADA), (Object)this.c("Resource2_en"));
        harness.check(this.loadCheck(this.c("Resource2"), Locale.JAPAN), (Object)this.c("Resource2_en"));
        harness.check(this.loadCheck(this.c("Resource3"), Locale.JAPAN), (Object)MISSING);
        Locale.setDefault(Locale.FRANCE);
        harness.checkPoint("with locale of France");
        harness.check(this.loadCheck(this.c("Resource1")), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource1"), Locale.CANADA), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource1"), Locale.JAPAN), (Object)this.c("Resource1"));
        harness.check(this.loadCheck(this.c("Resource2"), Locale.CANADA), (Object)this.c("Resource2_en"));
        harness.check(this.loadCheck(this.c("Resource2"), Locale.JAPAN), (Object)MISSING);
        harness.check(this.loadCheck(this.c("Resource3"), Locale.JAPAN), (Object)MISSING);
        Locale.setDefault(Locale.CANADA);
        Locale testLocale = new Locale("jp", "JA", "WIN_95");
        harness.checkPoint("book sample");
        harness.check(this.loadCheck(this.c("Resource4"), testLocale), (Object)this.c("Resource4_jp_JA_WIN_95"));
        harness.check(this.loadCheck(this.c("Resource5"), testLocale), (Object)this.c("Resource5_jp_JA_WIN"));
        harness.check(this.loadCheck(this.c("Resource6"), testLocale), (Object)this.c("Resource6_jp_JA"));
        harness.check(this.loadCheck(this.c("Resource7"), testLocale), (Object)this.c("Resource7_jp"));
        harness.check(this.loadCheck(this.c("Resource8"), testLocale), (Object)this.c("Resource8_en_CA"));
        harness.check(this.loadCheck(this.c("Resource9"), testLocale), (Object)this.c("Resource9_en_CA"));
        harness.check(this.loadCheck(this.c("Resource10"), testLocale), (Object)this.c("Resource10_en"));
        harness.checkPoint("null pointers");
        try {
            ResourceBundle.getBundle(null);
            harness.check(false);
        }
        catch (NullPointerException ex) {
            harness.check(true);
        }
        try {
            ResourceBundle.getBundle(this.c("Resource1"), null);
            harness.check(false);
        }
        catch (NullPointerException ex) {
            harness.check(true);
        }
        try {
            ResourceBundle.getBundle("no such resource", null);
            harness.check(false);
        }
        catch (NullPointerException ex) {
            harness.check(true);
        }
        try {
            ResourceBundle.getBundle(null, Locale.JAPAN);
            harness.check(false);
        }
        catch (NullPointerException ex) {
            harness.check(true);
        }
        Locale.setDefault(defaultLocale);
    }
}

