/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Observable;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.Observable.AcuniaObservable;
import java.util.Observable;
import java.util.Observer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaObservableTest
implements Testlet,
Observer {
    protected TestHarness th;
    public boolean updated;
    public Object arg;
    public Observable obs;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Observable");
        this.test_addObserver();
        this.test_countObservers();
        this.test_deleteObserver();
        this.test_deleteObservers();
        this.test_clearChanged();
        this.test_hasChanged();
        this.test_notifyObservers();
        this.test_setChanged();
    }

    public void clear() {
        this.updated = false;
        this.obs = null;
        this.arg = this;
    }

    public boolean verify(Observable o, Object ar) {
        boolean bl = false;
        if (this.updated && o == this.obs && ar == this.arg) {
            bl = true;
        }
        return bl;
    }

    public void update(Observable ob, Object ar) {
        this.updated = true;
        this.arg = ar;
        this.obs = ob;
    }

    public void test_addObserver() {
        this.th.checkPoint("addObserver(java.util.Observer)void");
        Observable o = new Observable();
        o.addObserver(this);
        o.addObserver(this);
        this.th.check(o.countObservers(), 1, "observer only added once ...");
        o.addObserver(new AcuniaObservableTest());
        this.th.check(o.countObservers(), 2, "observer added -- 1");
        o.addObserver(new AcuniaObservableTest());
        o.addObserver(new AcuniaObservableTest());
        this.th.check(o.countObservers(), 4, "observer added -- 2");
        try {
            o.addObserver(null);
            this.th.check(o.countObservers(), 4, "observer added -- 3");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_countObservers() {
        this.th.checkPoint("countObservers()int");
        Observable o = new Observable();
        this.th.check(o.countObservers(), 0, "no observers added");
        o.addObserver(this);
        o.addObserver(this);
        this.th.check(o.countObservers(), 1, "observer only added once ...");
        o.addObserver(new AcuniaObservableTest());
        this.th.check(o.countObservers(), 2, "observer added -- 1");
        o.addObserver(new AcuniaObservableTest());
        o.addObserver(new AcuniaObservableTest());
        this.th.check(o.countObservers(), 4, "observer added -- 2");
        o.deleteObserver(this);
        this.th.check(o.countObservers(), 3, "observer deleted -- 3");
        o.deleteObservers();
        this.th.check(o.countObservers(), 0, "all observers deleted -- 4");
        o.addObserver(this);
        this.th.check(o.countObservers(), 1, "one observer added -- 5");
        try {
            o.deleteObserver(null);
            this.th.check(o.countObservers(), 1, "one observer added -- 6");
        }
        catch (NullPointerException npe) {
            this.th.check(false);
        }
    }

    public void test_deleteObserver() {
        this.th.checkPoint("deleteObserver(java.util.Observer)void");
        Observable o = new Observable();
        o.addObserver(this);
        AcuniaObservableTest obs = new AcuniaObservableTest();
        o.addObserver(obs);
        o.deleteObserver(this);
        this.th.check(o.countObservers(), 1, "observer deleted -- 1");
        o.deleteObserver(this);
        this.th.check(o.countObservers(), 1, "observer already deleted -- 2");
        o.deleteObserver(obs);
        this.th.check(o.countObservers(), 0, "observer deleted -- 3");
        o.deleteObserver(obs);
        this.th.check(o.countObservers(), 0, "observer already deleted -- 4");
        o.addObserver(this);
        this.th.check(o.countObservers(), 1, "observer added -- 5");
        o.deleteObserver(this);
        this.th.check(o.countObservers(), 0, "observer deleted -- 6");
    }

    public void test_deleteObservers() {
        this.th.checkPoint("deleteObservers()void");
        Observable o = new Observable();
        o.addObserver(this);
        AcuniaObservableTest obs = new AcuniaObservableTest();
        o.addObserver(obs);
        o.deleteObservers();
        this.th.check(o.countObservers(), 0, "observers deleted -- 1");
        o.addObserver(this);
        this.th.check(o.countObservers(), 1, "observer added -- 5");
        o.deleteObservers();
        this.th.check(o.countObservers(), 0, "observer deleted -- 6");
    }

    public void test_hasChanged() {
        this.th.checkPoint("hasChanged()boolean");
        AcuniaObservable ao = new AcuniaObservable();
        this.th.check(ao.hasChanged() ^ true, "not changed -- 1");
        ao.setChanged();
        this.th.check(ao.hasChanged(), "changed -- 2");
        ao.setChanged();
        this.th.check(ao.hasChanged(), "changed -- 3");
        ao.clearChanged();
        this.th.check(ao.hasChanged() ^ true, "not changed -- 4");
        ao.clearChanged();
        this.th.check(ao.hasChanged() ^ true, "not changed -- 5");
        ao.setChanged();
        this.th.check(ao.hasChanged(), "changed -- 6");
        ao.clearChanged();
        this.th.check(ao.hasChanged() ^ true, "not changed -- 7");
    }

    public void test_clearChanged() {
        this.th.checkPoint("clearChanged()void");
    }

    public void test_setChanged() {
        this.th.checkPoint("setChanged()void");
    }

    public void test_notifyObservers() {
        this.th.checkPoint("notifyObservers()void");
        AcuniaObservable o = new AcuniaObservable();
        o.addObserver(this);
        AcuniaObservableTest obs = new AcuniaObservableTest();
        o.addObserver(obs);
        o.setChanged();
        try {
            o.notifyObservers();
        }
        catch (NullPointerException np) {
            this.th.fail("bad !");
        }
        this.clear();
        obs.clear();
        o.setChanged();
        o.notifyObservers();
        this.th.check(o.hasChanged() ^ true, "cleared by notifyObservers");
        this.th.check(this.verify(o, null), "update recieved -- 1");
        this.th.check(obs.verify(o, null), "update recieved -- 2");
        this.th.checkPoint("notifyObservers(java.lang.Object)void");
        this.clear();
        obs.clear();
        o.notifyObservers(null);
        this.th.check(this.verify(o, null) ^ true, "update recieved -- 3");
        this.th.check(obs.verify(o, null) ^ true, "update recieved -- 4");
        o.setChanged();
        this.clear();
        obs.clear();
        o.notifyObservers("a");
        this.th.check(o.hasChanged() ^ true, "cleared by notifyObservers");
        this.th.check(this.verify(o, "a"), "update recieved -- 5");
        this.th.check(obs.verify(o, "a"), "update recieved -- 6");
    }

    private final /* synthetic */ void this() {
        this.arg = this;
    }

    public AcuniaObservableTest() {
        this.this();
    }
}

