/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.LinkedList;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SMLinkedListTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.LinkedList");
        this.test_LinkedList();
        this.test_add();
        this.test_addAll();
        this.test_clear();
        this.test_remove();
        this.test_set();
        this.test_contains();
        this.test_indexOf();
        this.test_size();
        this.test_lastIndexOf();
        this.test_toArray();
        this.test_clone();
        this.test_iterator();
        this.test_getFirst();
        this.test_getLast();
        this.test_addFirst();
        this.test_addLast();
        this.test_removeFirst();
        this.test_removeLast();
        this.test_ListIterator();
    }

    protected LinkedList buildAL() {
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        return new LinkedList(v);
    }

    public void test_LinkedList() {
        this.th.checkPoint("LinkedList(java.util.Collection)");
        Vector<String> v = new Vector<String>();
        LinkedList al = new LinkedList(v);
        this.th.check(al.isEmpty(), "no elements added");
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        al = new LinkedList(v);
        this.th.check(v.equals(al), "check if everything is OK");
        try {
            new LinkedList(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_add() {
        this.th.checkPoint("add(int,java.lang.Object)void");
        LinkedList<String> al = new LinkedList<String>();
        try {
            al.add(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            al.add(1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        al.clear();
        al.add(0, "a");
        al.add(1, "c");
        al.add(2, "u");
        al.add(1, null);
        boolean bl = false;
        if ("a".equals(al.get(0)) && al.get(1) == null && "c".equals(al.get(2)) && "u".equals(al.get(3))) {
            bl = true;
        }
        this.th.check(bl, "checking add ...");
        this.th.checkPoint("add(java.lang.Object)boolean");
        al = new LinkedList();
        this.th.check(al.add("a"), "checking return value -- 1");
        this.th.check(al.add("c"), "checking return value -- 2");
        this.th.check(al.add("u"), "checking return value -- 3");
        this.th.check(al.add("n"), "checking return value -- 4");
        this.th.check(al.add("i"), "checking return value -- 5");
        this.th.check(al.add("a"), "checking return value -- 6");
        this.th.check(al.add(null), "checking return value -- 7");
        this.th.check(al.add("end"), "checking return value -- 8");
        boolean bl2 = false;
        if ("a".equals(al.get(0)) && al.get(6) == null && "c".equals(al.get(1)) && "u".equals(al.get(2))) {
            bl2 = true;
        }
        this.th.check(bl2, "checking add ... -- 1");
        boolean bl3 = false;
        if ("a".equals(al.get(5)) && "end".equals(al.get(7)) && "n".equals(al.get(3)) && "i".equals(al.get(4))) {
            bl3 = true;
        }
        this.th.check(bl3, "checking add ... -- 2");
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        LinkedList al = new LinkedList();
        try {
            al.addAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        LinkedList c = al;
        this.th.check(al.addAll(c) ^ true, "checking returnvalue -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        c = al;
        al = this.buildAL();
        this.th.check(al.addAll(c), "checking returnvalue -- 2");
        this.th.check(al.containsAll(c), "extra on containsAll -- 1");
        boolean bl = false;
        if (al.get(14) == "a" && al.get(15) == "b" && al.get(16) == "c") {
            bl = true;
        }
        this.th.check(bl, "checking added on right positions");
        this.th.checkPoint("addAll(int,java.util.Collection)boolean");
        c = al = new LinkedList();
        this.th.check(al.addAll(0, c) ^ true, "checking returnvalue -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        c = al;
        al = this.buildAL();
        try {
            al.addAll(-1, c);
            this.th.fail("should throw exception -- 1");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            al.addAll(15, c);
            this.th.fail("should throw exception -- 2");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            this.th.check(al.addAll(11, c), "checking returnvalue -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.fail("shouldn't throw exception -- 1");
        }
        this.th.check(al.containsAll(c), "extra on containsAll -- 1");
        boolean bl2 = false;
        if (al.get(11) == "a" && al.get(12) == "b" && al.get(13) == "c") {
            bl2 = true;
        }
        this.th.check(bl2, "checking added on right positions -- 1");
        this.th.check(al.addAll(1, c), "checking returnvalue -- 3");
        boolean bl3 = false;
        if (al.get(1) == "a" && al.get(2) == "b" && al.get(3) == "c") {
            bl3 = true;
        }
        this.th.check(bl3, "checking added on right positions -- 2");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        LinkedList al = new LinkedList();
        al.clear();
        al = this.buildAL();
        al.clear();
        boolean bl = false;
        if (al.size() == 0 && al.isEmpty()) {
            bl = true;
        }
        this.th.check(bl, "list is empty ...");
    }

    public void test_remove() {
        this.th.checkPoint("remove(int)java.lang.Object");
        LinkedList al = this.buildAL();
        try {
            al.remove(-1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.remove(14);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        this.th.check("a".equals(al.remove(5)), "checking returnvalue remove -- 1");
        boolean bl = false;
        if ("a".equals(al.get(0)) && al.get(5) == null && "c".equals(al.get(1)) && "u".equals(al.get(2))) {
            bl = true;
        }
        this.th.check(bl, "checking remove ... -- 1");
        boolean bl2 = false;
        if ("a".equals(al.get(6)) && "c".equals(al.get(7)) && "n".equals(al.get(3)) && "i".equals(al.get(4))) {
            bl2 = true;
        }
        this.th.check(bl2, "checking remove ... -- 2");
        boolean bl3 = false;
        if (al.size() == 13) {
            bl3 = true;
        }
        this.th.check(bl3, "checking new size -- 1");
        boolean bl4 = false;
        if (al.remove(5) == null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking returnvalue remove -- 2");
        boolean bl5 = false;
        if (al.size() == 12) {
            bl5 = true;
        }
        this.th.check(bl5, "checking new size -- 2");
        boolean bl6 = false;
        if (al.remove(11) == null) {
            bl6 = true;
        }
        this.th.check(bl6, "checking returnvalue remove -- 3");
        this.th.check("a".equals(al.remove(0)), "checking returnvalue remove -- 4");
        this.th.check("u".equals(al.remove(1)), "checking returnvalue remove -- 5");
        this.th.check("i".equals(al.remove(2)), "checking returnvalue remove -- 6");
        this.th.check("a".equals(al.remove(2)), "checking returnvalue remove -- 7");
        this.th.check("u".equals(al.remove(3)), "checking returnvalue remove -- 8");
        this.th.check("a".equals(al.remove(5)), "checking returnvalue remove -- 9");
        this.th.check("i".equals(al.remove(4)), "checking returnvalue remove -- 10");
        boolean bl7 = false;
        if ("c".equals(al.get(0)) && "c".equals(al.get(2)) && "n".equals(al.get(3)) && "n".equals(al.get(1))) {
            bl7 = true;
        }
        this.th.check(bl7, "checking remove ... -- 3");
        boolean bl8 = false;
        if (al.size() == 4) {
            bl8 = true;
        }
        this.th.check(bl8, "checking new size -- 3");
        al.remove(0);
        al.remove(0);
        al.remove(0);
        al.remove(0);
        boolean bl9 = false;
        if (al.size() == 0) {
            bl9 = true;
        }
        this.th.check(bl9, "checking new size -- 4");
        al = new LinkedList();
        try {
            al.remove(0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
    }

    public void test_set() {
        this.th.checkPoint("set(int,java.lang.Object)java.lang.Object");
        LinkedList al = new LinkedList();
        try {
            al.set(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.set(0, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        al = this.buildAL();
        try {
            al.set(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.set(14, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        this.th.check("a".equals(al.set(5, "b")), "checking returnvalue of set -- 1");
        this.th.check("a".equals(al.set(0, null)), "checking returnvalue of set -- 2");
        this.th.check("b".equals(al.get(5)), "checking effect of set -- 1");
        boolean bl = false;
        if (al.get(0) == null) {
            bl = true;
        }
        this.th.check(bl, "checking effect of set -- 2");
        this.th.check("b".equals(al.set(5, "a")), "checking returnvalue of set -- 3");
        boolean bl2 = false;
        if (al.set(0, null) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking returnvalue of set -- 4");
        this.th.check("a".equals(al.get(5)), "checking effect of set -- 3");
        boolean bl3 = false;
        if (al.get(0) == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking effect of set -- 4");
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        LinkedList al = new LinkedList();
        this.th.check(al.contains(null) ^ true, "checking empty List -- 1");
        this.th.check(al.contains(al) ^ true, "checking empty List -- 2");
        al = this.buildAL();
        this.th.check(al.contains(null), "check contains ... -- 1");
        this.th.check(al.contains("a"), "check contains ... -- 2");
        this.th.check(al.contains("c"), "check contains ... -- 3");
        this.th.check(al.contains(this) ^ true, "check contains ... -- 4");
        al.remove(6);
        this.th.check(al.contains(null), "check contains ... -- 5");
        al.remove(12);
        this.th.check(al.contains(null) ^ true, "check contains ... -- 6");
        this.th.check(al.contains("b") ^ true, "check contains ... -- 7");
        this.th.check(al.contains(al) ^ true, "check contains ... -- 8");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        LinkedList<String> al = new LinkedList<String>();
        this.th.check(al.isEmpty(), "checking returnvalue -- 1");
        al.add("A");
        this.th.check(al.isEmpty() ^ true, "checking returnvalue -- 2");
        al.remove(0);
        this.th.check(al.isEmpty(), "checking returnvalue -- 3");
    }

    public void test_indexOf() {
        this.th.checkPoint("indexOf(java.lang.Object)int");
        LinkedList al = new LinkedList();
        boolean bl = false;
        if (al.indexOf(null) == -1) {
            bl = true;
        }
        this.th.check(bl, "checks on empty list -- 1");
        boolean bl2 = false;
        if (al.indexOf(al) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "checks on empty list -- 2");
        Object o = new Object();
        al = this.buildAL();
        boolean bl3 = false;
        if (al.indexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, " doesn't contain -- 1");
        boolean bl4 = false;
        if (al.indexOf("a") == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 2");
        boolean bl5 = false;
        if (al.indexOf("Q") == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "doesn't contain -- 3");
        al.add(9, o);
        boolean bl6 = false;
        if (al.indexOf(o) == 9) {
            bl6 = true;
        }
        this.th.check(bl6, "contains -- 4");
        boolean bl7 = false;
        if (al.indexOf(new Object()) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "doesn't contain -- 5");
        boolean bl8 = false;
        if (al.indexOf(null) == 6) {
            bl8 = true;
        }
        this.th.check(bl8, "null was added to the Vector");
        al.remove(6);
        boolean bl9 = false;
        if (al.indexOf(null) == 13) {
            bl9 = true;
        }
        this.th.check(bl9, "null was added twice to the Vector");
        al.remove(13);
        boolean bl10 = false;
        if (al.indexOf(null) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "null was removed to the Vector");
        boolean bl11 = false;
        if (al.indexOf("c") == 1) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 6");
        boolean bl12 = false;
        if (al.indexOf("u") == 2) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 7");
        boolean bl13 = false;
        if (al.indexOf("n") == 3) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 8");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        LinkedList<String> al = new LinkedList<String>();
        boolean bl = false;
        if (al.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "check on size -- 1");
        al.addAll(this.buildAL());
        boolean bl2 = false;
        if (al.size() == 14) {
            bl2 = true;
        }
        this.th.check(bl2, "check on size -- 1");
        al.remove(5);
        boolean bl3 = false;
        if (al.size() == 13) {
            bl3 = true;
        }
        this.th.check(bl3, "check on size -- 1");
        al.add(4, "G");
        boolean bl4 = false;
        if (al.size() == 14) {
            bl4 = true;
        }
        this.th.check(bl4, "check on size -- 1");
    }

    public void test_lastIndexOf() {
        this.th.checkPoint("lastIndexOf(java.lang.Object)int");
        LinkedList al = new LinkedList();
        boolean bl = false;
        if (al.lastIndexOf(null) == -1) {
            bl = true;
        }
        this.th.check(bl, "checks on empty list -- 1");
        boolean bl2 = false;
        if (al.lastIndexOf(al) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "checks on empty list -- 2");
        Object o = new Object();
        al = this.buildAL();
        boolean bl3 = false;
        if (al.lastIndexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, " doesn't contain -- 1");
        boolean bl4 = false;
        if (al.lastIndexOf("a") == 12) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 2");
        boolean bl5 = false;
        if (al.lastIndexOf(o) == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "contains -- 3");
        al.add(9, o);
        boolean bl6 = false;
        if (al.lastIndexOf(o) == 9) {
            bl6 = true;
        }
        this.th.check(bl6, "contains -- 4");
        boolean bl7 = false;
        if (al.lastIndexOf(new Object()) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "doesn't contain -- 5");
        boolean bl8 = false;
        if (al.lastIndexOf(null) == 14) {
            bl8 = true;
        }
        this.th.check(bl8, "null was added to the Vector");
        al.remove(14);
        boolean bl9 = false;
        if (al.lastIndexOf(null) == 6) {
            bl9 = true;
        }
        this.th.check(bl9, "null was added twice to the Vector");
        al.remove(6);
        boolean bl10 = false;
        if (al.lastIndexOf(null) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "null was removed to the Vector");
        boolean bl11 = false;
        if (al.lastIndexOf("c") == 7) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 6, got " + al.lastIndexOf("c"));
        boolean bl12 = false;
        if (al.lastIndexOf("u") == 9) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 7, got " + al.lastIndexOf("u"));
        boolean bl13 = false;
        if (al.lastIndexOf("n") == 10) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 8, got " + al.lastIndexOf("n"));
    }

    public void test_toArray() {
        this.th.checkPoint("toArray()java.lang.Object[]");
        LinkedList v = new LinkedList();
        Object[] o = v.toArray();
        boolean bl = false;
        if (o.length == 0) {
            bl = true;
        }
        this.th.check(bl, "checking size Object array");
        v.add("a");
        v.add(null);
        v.add("b");
        o = v.toArray();
        boolean bl2 = false;
        if (o[0] == "a" && o[1] == null && o[2] == "b") {
            bl2 = true;
        }
        this.th.check(bl2, "checking elements -- 1");
        boolean bl3 = false;
        if (o.length == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking size Object array");
        this.th.checkPoint("toArray(java.lang.Object[])java.lang.Object[]");
        v = new LinkedList();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("a");
        v.add(null);
        v.add("b");
        String[] sa = new String[5];
        sa[3] = "deleteme";
        sa[4] = "leavemealone";
        boolean bl4 = false;
        if (v.toArray(sa) == sa) {
            bl4 = true;
        }
        this.th.check(bl4, "sa is large enough, no new array created");
        boolean bl5 = false;
        if (sa[0] == "a" && sa[1] == null && sa[2] == "b") {
            bl5 = true;
        }
        this.th.check(bl5, "checking elements -- 1" + sa[0] + ", " + sa[1] + ", " + sa[2]);
        boolean bl6 = false;
        if (sa.length == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "checking size Object array");
        boolean bl7 = false;
        if (sa[3] == null && sa[4] == "leavemealone") {
            bl7 = true;
        }
        this.th.check(bl7, "check other elements -- 1" + sa[3] + ", " + sa[4]);
        v = this.buildAL();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            v.toArray(new Class[5]);
            this.th.fail("should throw an ArrayStoreException");
        }
        catch (ArrayStoreException ae) {
            this.th.check(true);
        }
        v.add(null);
        sa = new String[15];
        String[] sar = v.toArray(sa);
        boolean bl8 = false;
        if (sar == sa) {
            bl8 = true;
        }
        this.th.check(bl8, "returned array is the same");
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        LinkedList<String> al = new LinkedList<String>();
        LinkedList cal = (LinkedList)al.clone();
        boolean bl = false;
        if (cal.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "checking size -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        al.add(null);
        cal = (LinkedList)al.clone();
        boolean bl2 = false;
        if (cal.size() == al.size()) {
            bl2 = true;
        }
        this.th.check(bl2, "checking size -- 2");
        boolean bl3 = false;
        if (al != cal) {
            bl3 = true;
        }
        this.th.check(bl3, "Objects are not the same");
        this.th.check(al.equals(cal), "cloned list is equal");
        al.add("a");
        boolean bl4 = false;
        if (cal.size() == 4) {
            bl4 = true;
        }
        this.th.check(bl4, "changes in one object doen't affect the other -- 2");
    }

    public void test_iterator() {
        this.th.checkPoint("modCount(protected)int");
        LinkedList al = this.buildAL();
        Iterator it = al.iterator();
        al.get(0);
        al.contains(null);
        al.isEmpty();
        al.indexOf(null);
        al.lastIndexOf(null);
        al.size();
        al.toArray();
        al.toArray(new String[10]);
        al.clone();
        try {
            it.next();
            this.th.check(true);
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.fail("should not throw a ConcurrentModificationException -- 2");
        }
        it = al.iterator();
        al.add("b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 3");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.add(3, "b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 4");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.addAll(this.buildAL());
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 5");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.addAll(2, this.buildAL());
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 6");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.set(2, this.buildAL());
        try {
            it.next();
            this.th.check(true);
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.fail("should NOT throw a ConcurrentModificationException -- 7");
        }
        it = al.iterator();
        al.remove(2);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 8");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 9");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
    }

    public void test_getFirst() {
        this.th.checkPoint("getFirst()java.lang.Object");
        LinkedList ll = new LinkedList();
        try {
            ll.getFirst();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
        ll = this.buildAL();
        this.th.check("a".equals(ll.getFirst()), "getFirst -- 1");
        ll.removeFirst();
        this.th.check("c".equals(ll.getFirst()), "getFirst -- 2");
        ll.addFirst("d");
        this.th.check("d".equals(ll.getFirst()), "getFirst -- 3");
    }

    public void test_getLast() {
        this.th.checkPoint("getLast()java.lang.Object");
        LinkedList ll = new LinkedList();
        try {
            ll.getLast();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
        ll = this.buildAL();
        boolean bl = false;
        if (ll.getLast() == null) {
            bl = true;
        }
        this.th.check(bl, "getLast -- 1");
        ll.removeLast();
        this.th.check("a".equals(ll.getLast()), "getLast -- 2");
        ll.addLast("d");
        this.th.check("d".equals(ll.getLast()), "getLast -- 3");
    }

    public void test_addFirst() {
        this.th.checkPoint("addFirst(java.lang.Object)void");
        LinkedList<String> ll = new LinkedList<String>();
        ll.addFirst("a");
        this.th.check("a".equals(ll.getLast()), "addFirst on empty List -- 1");
        this.th.check("a".equals(ll.getFirst()), "addFirst on empty List -- 1");
        ll.addFirst("c");
        this.th.check("a".equals(ll.getLast()), "addFirst on List -- 2");
        this.th.check("c".equals(ll.getFirst()), "addFirst on List -- 2");
        ll.addFirst(null);
        this.th.check("a".equals(ll.getLast()), "addFirst on List -- 3");
        boolean bl = false;
        if (ll.getFirst() == null) {
            bl = true;
        }
        this.th.check(bl, "addFirst on List -- 3");
        boolean bl2 = false;
        if (ll.get(0) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking order with get -- 1");
        this.th.check("c".equals(ll.get(1)), "checking order with get -- 2");
        this.th.check("a".equals(ll.get(2)), "checking order with get -- 3");
        boolean bl3 = false;
        if (ll.size() == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking size increment ...");
    }

    public void test_addLast() {
        this.th.checkPoint("addLast(java.lang.Object)void");
        LinkedList<String> ll = new LinkedList<String>();
        ll.addLast("a");
        this.th.check("a".equals(ll.getLast()), "addLast on empty List -- 1");
        this.th.check("a".equals(ll.getFirst()), "addLast on empty List -- 1");
        ll.addLast("c");
        this.th.check("c".equals(ll.getLast()), "addLast on List -- 2");
        this.th.check("a".equals(ll.getFirst()), "addLast on List -- 2");
        ll.addLast(null);
        this.th.check("a".equals(ll.getFirst()), "addLast on List -- 3");
        boolean bl = false;
        if (ll.getLast() == null) {
            bl = true;
        }
        this.th.check(bl, "addLast on List -- 3");
        boolean bl2 = false;
        if (ll.get(2) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking order with get -- 1");
        this.th.check("c".equals(ll.get(1)), "checking order with get -- 2");
        this.th.check("a".equals(ll.get(0)), "checking order with get -- 3");
        boolean bl3 = false;
        if (ll.size() == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking size increment ...");
    }

    public void test_removeFirst() {
        this.th.checkPoint("removeFirst()java.lang.Object");
        LinkedList ll = new LinkedList();
        try {
            ll.removeFirst();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
        ll = this.buildAL();
        this.th.check("a".equals(ll.removeFirst()), "removeFirst -- 1");
        this.th.check("c".equals(ll.removeFirst()), "removeFirst -- 2");
        this.th.check("u".equals(ll.getFirst()), "changing pointer to first ...");
        this.th.check("u".equals(ll.removeFirst()), "removeFirst -- 3");
        boolean bl = false;
        if (ll.size() == 11) {
            bl = true;
        }
        this.th.check(bl, "checking size decrement ...");
        this.th.check("n".equals(ll.removeFirst()), "removeFirst -- 4");
        this.th.check("i".equals(ll.removeFirst()), "removeFirst -- 5");
        this.th.check("a".equals(ll.removeFirst()), "removeFirst -- 6");
        boolean bl2 = false;
        if (ll.removeFirst() == null) {
            bl2 = true;
        }
        this.th.check(bl2, "removeFirst -- 7");
        ll.removeFirst();
        ll.removeFirst();
        ll.removeFirst();
        ll.removeFirst();
        ll.removeFirst();
        this.th.check("a".equals(ll.removeFirst()), "removeFirst -- 8");
        boolean bl3 = false;
        if (ll.getFirst() == null) {
            bl3 = true;
        }
        this.th.check(bl3, "removeFirst -- 8");
        boolean bl4 = false;
        if (ll.getLast() == null) {
            bl4 = true;
        }
        this.th.check(bl4, "removeFirst -- 9");
        boolean bl5 = false;
        if (ll.removeFirst() == null) {
            bl5 = true;
        }
        this.th.check(bl5, "removeFirst -- 10");
        try {
            ll.removeFirst();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
    }

    public void test_removeLast() {
        this.th.checkPoint("removeLast()java.lang.Object");
        LinkedList ll = new LinkedList();
        try {
            ll.removeLast();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
        ll = this.buildAL();
        boolean bl = false;
        if (ll.removeLast() == null) {
            bl = true;
        }
        this.th.check(bl, "removeLast -- 0");
        this.th.check("a".equals(ll.removeLast()), "removeLast -- 1");
        this.th.check("i".equals(ll.removeLast()), "removeLast -- 2");
        this.th.check("n".equals(ll.getLast()), "changing pointer to last ...");
        this.th.check("n".equals(ll.removeLast()), "removeLast -- 3");
        this.th.check("u".equals(ll.get(9)), "checking elements -- 3a");
        this.th.check("c".equals(ll.get(8)), "checking elements -- 3b");
        boolean bl2 = false;
        if (ll.size() == 10) {
            bl2 = true;
        }
        this.th.check(bl2, "checking size decrement ...");
        this.th.check("u".equals(ll.removeLast()), "removeLast -- 4");
        this.th.check("c".equals(ll.removeLast()), "removeLast -- 5");
        this.th.check("a".equals(ll.removeLast()), "removeLast -- 6");
        ll.removeLast();
        ll.removeLast();
        ll.removeLast();
        ll.removeLast();
        ll.removeLast();
        this.th.check("c".equals(ll.removeLast()), "removeLast -- 7");
        this.th.check("a".equals(ll.getLast()), "removeLast -- 8");
        this.th.check("a".equals(ll.getFirst()), "removeLast -- 9");
        this.th.check("a".equals(ll.removeLast()), "removeLast -- 10");
        try {
            ll.removeLast();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exception");
        }
    }

    public void test_ListIterator() {
        this.th.checkPoint("listIterator()java.util.ListIterator");
        LinkedList ll = new LinkedList();
        ListIterator<String> li = ll.listIterator();
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 1");
        }
        try {
            li.previous();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 2");
        }
        this.th.check(li.hasNext() ^ true, "no elements ... -- 1");
        this.th.check(li.hasPrevious() ^ true, "no elements ... -- 1");
        this.th.check(li.nextIndex(), 0, "nextIndex == 0 -- 1");
        this.th.check(li.previousIndex(), -1, "previousIndex == -1 -- 1");
        li.add("a");
        this.th.check(li.hasNext() ^ true, "no elements ... -- 2");
        this.th.check(li.hasPrevious(), "one element ... -- 2");
        this.th.check(li.nextIndex(), 1, "nextIndex == 1 -- 2");
        this.th.check(li.previousIndex(), 0, "previousIndex == 0 -- 2");
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 3");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 3");
        }
        this.th.check("a".equals(li.previous()), "checking previous element -- 1");
        li.add(null);
        boolean bl = false;
        if (ll.getFirst() == null) {
            bl = true;
        }
        this.th.check(bl, "checking if LinkedList got updated -- 1");
        this.th.check("a", ll.getLast(), "checking if LinkedList got updated -- 2");
        this.th.check(li.previousIndex(), 0, "previousIndex == 0 -- 3");
        boolean bl2 = false;
        if (li.previous() == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking previous element -- 2");
        boolean bl3 = false;
        if (li.next() == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking next element -- 1");
        li.add("b");
        this.th.check("a".equals(li.next()), "checking next element -- 2");
        li.add("c");
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 4");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 5");
        }
        this.th.check("c".equals(li.previous()), "checking previous element -- 3");
        li.set("new");
        this.th.check("new".equals(li.next()), "validating set");
        li.set("not");
        li.set("notOK");
        li.remove();
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 3");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 6");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 4");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 7");
        }
        try {
            li.next();
            this.th.fail("should throw a NoSuchElementException -- 4");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true, "caught exeption -- 8");
        }
        this.th.check("a", li.previous(), "checking on previous element");
        li.remove();
        try {
            li.set("not");
            this.th.fail("should throw a IllegalStateException -- 5");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 9");
        }
        this.th.check(ll.contains("not") ^ true, "set should not have been executed");
        try {
            li.remove();
            this.th.fail("should throw a IllegalStateException -- 6");
        }
        catch (IllegalStateException ise) {
            this.th.check(true, "caught exeption -- 10");
        }
    }
}

