/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.GregorianCalendar;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SMGregorianCalendarTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.GregorianCalendar");
        this.test_();
        this.test_behaviour();
    }

    public void test_() {
        this.th.checkPoint("()");
    }

    public void test_behaviour() {
        this.th.checkPoint("GregorianCalendar()");
        GregorianCalendar gc = new GregorianCalendar();
        gc.clear();
        gc.setTime(new Date(0L));
        this.th.check(gc.get(1), 1970, "check year");
        gc.clear(2);
        gc.set(6, 35);
        this.th.debug(gc.getTime().toString());
        gc = new GregorianCalendar(1970, 0, 1, 0, 0);
        gc.clear(2);
        gc.set(6, 35);
        gc.clear(2);
        this.th.check(gc.get(2), 1, "update Month");
        this.th.check(gc.get(6), 35, "update Month");
        this.th.debug(gc.getTime().toString());
        this.th.debug(gc.toString());
        this.th.check(gc.get(1), 1970, "check year");
        this.th.check(gc.get(13), 0, "check seconds");
        gc.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.th.debug(gc.getTime().toString());
        this.th.debug(new Date(0L).toString());
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        this.th.debug(new Date(0L).toString());
        this.th.debug(gc.getTime().toString() + ' ' + gc.getTimeZone().toString());
        gc = new GregorianCalendar(1970, 0, 1, 0, 0);
        gc.setLenient(true);
        gc.set(12, 12345678);
        this.th.debug(gc.getTime().toString());
        gc.add(12, 1200);
        this.th.debug(gc.getTime().toString());
        gc.add(2, 16);
        this.th.debug(gc.getTime().toString());
        gc = new GregorianCalendar(1970, 0, 1, 0, 0);
        this.th.debug("G.C is lenient " + gc.isLenient());
        this.th.debug(gc.getTime().toString());
        gc.setLenient(false);
        this.th.debug("G.C is lenient " + gc.isLenient());
        gc.add(1, 12349);
        this.th.debug(gc.getTime().toString());
        gc.setLenient(true);
        this.th.debug(gc.toString());
        gc = new GregorianCalendar(1970, 0, 1, 0, 0);
        this.th.debug(gc.getTime().toString());
        this.th.debug("" + gc.getTime().getTime());
        gc.set(2, 6);
        gc.setTime(new Date(Long.MAX_VALUE));
        this.th.debug(gc.getTime().toString());
        gc.setTime(new Date(Long.MIN_VALUE));
        this.th.debug(gc.getTime().toString());
        this.th.debug(gc.toString());
        this.th.debug(TimeZone.getDefault().getDisplayName(true, 1));
        this.th.debug(TimeZone.getTimeZone("PST").getDisplayName(true, 1));
        this.th.debug(TimeZone.getTimeZone("PRT").getDisplayName(true, 1));
        SimpleTimeZone stz = (SimpleTimeZone)TimeZone.getTimeZone("PST");
        stz.setEndRule(1, 28, 342113);
        stz = new SimpleTimeZone(-32400000, "MySTZ");
        this.th.debug("my TimeZone uses DST --> " + stz.useDaylightTime());
        stz.setEndRule(10, 28, 342113);
        this.th.debug("my TimeZone uses DST --> " + stz.useDaylightTime());
        stz.setStartRule(1, 28, 342113);
        this.th.debug("my TimeZone uses DST --> " + stz.useDaylightTime());
        this.th.debug(stz.toString());
        Locale loc = new Locale("acd", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("acd", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("aDd", "BFG", "adg");
        this.th.debug(loc.toString());
        loc = new Locale("be", "BEF_G", "a_f_g");
        this.th.debug(loc.toString());
        loc = new Locale("ac_d", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("a", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("yi", "BEFG", "adfg");
        this.th.debug(loc.toString());
        loc = new Locale("id", "BE_FG", "ad_fg");
        this.th.debug(loc.toString());
        this.th.debug(loc.getDisplayCountry());
        loc = new Locale("zh", "tw", "a_d_f_g");
        this.th.debug(loc.toString());
        this.th.debug("default Locale = " + Locale.getDefault());
        this.th.debug(Locale.getDefault().toString());
        this.th.debug(loc.getISO3Language());
        loc = new Locale("zoth", "cn", "a_d_f_g");
        this.th.debug(loc.toString());
        this.th.debug(loc.getDisplayCountry());
        this.th.debug(Locale.US.getDisplayCountry());
        this.th.debug(Locale.US.getDisplayLanguage());
        this.th.debug(Locale.getDefault().getDisplayName());
        this.th.debug(Locale.US.getDisplayName());
        ResourceBundle resb = ResourceBundle.getBundle("system");
        Enumeration<String> e = resb.getKeys();
        while (e.hasMoreElements()) {
            String o = e.nextElement();
            this.th.debug("key = " + o + ", value = " + resb.getObject(o) + '$');
        }
    }

    public GregorianCalendar cloneGC(GregorianCalendar gc) {
        GregorianCalendar cp = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), gc.get(11), gc.get(12), gc.get(13));
        cp.set(14, gc.get(14));
        return cp;
    }
}

