/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.AbstractMap;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.AbstractMap.SMExAbstractMap;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SMAbstractMapTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.AbstractMap");
        this.test_get();
        this.test_containsKey();
        this.test_containsValue();
        this.test_isEmpty();
        this.test_size();
        this.test_clear();
        this.test_put();
        this.test_putAll();
        this.test_remove();
        this.test_entrySet();
        this.test_keySet();
        this.test_values();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
    }

    protected SMExAbstractMap buildHT() {
        SMExAbstractMap t = new SMExAbstractMap();
        int i = 0;
        while (i < 15) {
            String s = "a" + i;
            t.put(s, s + " value");
            ++i;
        }
        return t;
    }

    public void test_get() {
        this.th.checkPoint("get(java.lang.Object)java.lang.Object");
        SMExAbstractMap ehm = this.buildHT();
        String s = "a1";
        Object o = ehm.get(s);
        this.th.check((s + " value").equals(o), "checking return value");
        o = ehm.get(null);
        boolean bl = false;
        if (o == null) {
            bl = true;
        }
        this.th.check(bl);
        o = ehm.get(s + " value");
        boolean bl2 = false;
        if (o == null) {
            bl2 = true;
        }
        this.th.check(bl2);
        ehm.put((Object)null, s);
        o = ehm.get(null);
        this.th.check(s.equals(o));
    }

    public void test_containsKey() {
        this.th.checkPoint("containsKey(java.lang.Object)boolean");
        SMExAbstractMap ehm = this.buildHT();
        this.th.check(ehm.containsKey(null) ^ true, "null not there");
        ehm.put((Object)null, "test");
        this.th.check(ehm.containsKey(null), "null is in there");
        this.th.check(ehm.containsKey("a1"), "object is in there");
        this.th.check(ehm.containsKey("a1 value") ^ true, "object is not in there -- 1");
        this.th.check(ehm.containsKey(this) ^ true, "object is not in there -- 2");
    }

    public void test_containsValue() {
        this.th.checkPoint("containsValue(java.lang.Object)boolean");
        SMExAbstractMap ehm = this.buildHT();
        this.th.check(ehm.containsValue(null) ^ true, "null not there");
        ehm.put((Object)null, (Object)null);
        this.th.check(ehm.containsValue(null), "null is in there");
        this.th.check(ehm.containsValue("a1") ^ true, "object is not in there -- 1");
        this.th.check(ehm.containsValue("a1 value"), "object is in there -- 1");
        this.th.check(ehm.containsValue(this) ^ true, "object is not in there -- 2");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        SMExAbstractMap ehm = new SMExAbstractMap();
        this.th.check(ehm.isEmpty(), "true");
        ehm = this.buildHT();
        this.th.check(ehm.isEmpty() ^ true, "false");
    }

    public void test_size() {
        this.th.checkPoint("()");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        SMExAbstractMap ehm = this.buildHT();
        ehm.clear();
        this.th.check(ehm.isEmpty(), "true");
    }

    public void test_put() {
        this.th.checkPoint("put(java.lang.Object,java.lang.Object)java.lang.Object");
        SMExAbstractMap ehm = this.buildHT();
        ehm.set_edit(false);
        try {
            ehm.put("a", "b");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_putAll() {
        this.th.checkPoint("putAll(java.util.Map)void");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        SMExAbstractMap ehm = new SMExAbstractMap();
        this.th.check(ehm.equals(ht), "true -- both empty");
        ht.put("a", "b");
        ht.put("c", "d");
        ht.put("e", "f");
        ehm.putAll(ht);
        this.th.check(ehm.equals(ht), "true -- 1");
        ht.put("a1", "f");
        ht.put("e", "b");
        ehm.putAll(ht);
        this.th.check(ehm.equals(ht), "true -- 2");
        ehm = this.buildHT();
        ehm.putAll(ht);
        boolean bl = false;
        if (ehm.size() == 18) {
            bl = true;
        }
        this.th.check(bl, "added three elements");
        this.th.check("f".equals(ehm.get("a1")), "overwritten old value");
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)java.lang.Object");
        SMExAbstractMap ehm = this.buildHT();
        ehm.remove("a1");
        this.th.check(ehm.containsKey("a1") ^ true, "key removed -- 1");
        this.th.check(ehm.containsValue("a1 value") ^ true, "value removed -- 1");
        ehm.remove("a0");
        this.th.check(ehm.containsKey("a0") ^ true, "key removed -- 2");
        this.th.check(ehm.containsValue("a0 value") ^ true, "value removed -- 2");
        int i = 2;
        while (i < 15) {
            ehm.remove("a" + i);
            ++i;
        }
        this.th.check(ehm.isEmpty());
    }

    public void test_entrySet() {
        this.th.checkPoint("()");
    }

    public void test_keySet() {
        this.th.checkPoint("keySet()java.util.Set");
        SMExAbstractMap ehm = this.buildHT();
        Set s = ehm.keySet();
        boolean bl = false;
        if (s.size() == 15) {
            bl = true;
        }
        this.th.check(bl);
        ehm.put((Object)null, "test");
        boolean bl2 = false;
        if (s.size() == 16) {
            bl2 = true;
        }
        this.th.check(bl2);
        this.th.check(s.contains("a1"), "does contain a1");
        this.th.check(s.contains(null), "does contain null");
        this.th.check(s.contains(this) ^ true, "does contain this");
        this.th.check(s.contains("test") ^ true, "does contain test");
        boolean bl3 = false;
        if (s == ehm.keySet()) {
            bl3 = true;
        }
        this.th.check(bl3, "same Set is returned");
        Iterator it = s.iterator();
        Vector v = ehm.getKeyV();
        int i = 0;
        while (i < 16) {
            Object o = it.next();
            boolean bl4 = false;
            if (v.indexOf(o) == 0) {
                bl4 = true;
            }
            this.th.check(bl4, "order is not respected");
            if (!v.remove(o)) {
                this.th.debug("didn't find " + o);
            }
            ++i;
        }
        it = s.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.th.check(s.isEmpty(), "everything is removed");
        s = ehm.keySet();
        this.th.check(s.isEmpty(), "new Set is also empty");
        ehm.put("a", "B");
        this.th.check(s.isEmpty() ^ true, "Set is updated by underlying actions");
    }

    public void test_values() {
        this.th.checkPoint("values()java.util.Collection");
        SMExAbstractMap ehm = this.buildHT();
        Collection s = ehm.values();
        boolean bl = false;
        if (s.size() == 15) {
            bl = true;
        }
        this.th.check(bl);
        ehm.put((Object)null, "test");
        ehm.put("a10", (Object)null);
        boolean bl2 = false;
        if (s.size() == 16) {
            bl2 = true;
        }
        this.th.check(bl2);
        this.th.check(s.contains("a1 value"), "does contain a1 value");
        this.th.check(s.contains(null), "does contain null");
        this.th.check(s.contains(this) ^ true, "does contain this");
        this.th.check(s.contains("test"), "does contain test");
        this.th.check(s.contains("a1") ^ true, "does not contain a1");
        boolean bl3 = false;
        if (s == ehm.values()) {
            bl3 = true;
        }
        this.th.check(bl3, "same Set is returned");
        Iterator it = s.iterator();
        Vector v = ehm.getValuesV();
        int i = 0;
        while (i < 16) {
            Object o = it.next();
            boolean bl4 = false;
            if (v.indexOf(o) == 0) {
                bl4 = true;
            }
            this.th.check(bl4, "order is not respected");
            if (!v.remove(o)) {
                this.th.debug("didn't find " + o);
            }
            ++i;
        }
        it = s.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.th.check(s.isEmpty(), "everything is removed");
        s = ehm.values();
        this.th.check(s.isEmpty(), "new Set is also empty");
        ehm.put("a", "B");
        this.th.check(s.isEmpty() ^ true, "Set is updated by underlying actions");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        SMExAbstractMap ehm = new SMExAbstractMap();
        this.th.check(ehm.equals(ht), "true -- both empty");
        ht.put("a", "b");
        ht.put("c", "d");
        ht.put("e", "f");
        ehm.put("a", "b");
        ehm.put("c", "d");
        ehm.put("e", "f");
        this.th.check(ehm.equals(ht), "true -- same key && values");
        ht.put("a", "f");
        this.th.check(ehm.equals(ht) ^ true, "false -- same key && diff values");
        ht.put("e", "b");
        this.th.check(ehm.equals(ht) ^ true, "false --  key with diff values");
        this.th.check(ehm.equals(ht.entrySet()) ^ true, "false --  no Map");
        this.th.check(ehm.equals(this) ^ true, "false -- Object is no Map");
        this.th.check(ehm.equals(null) ^ true, "false -- Object is null");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        SMExAbstractMap ehm = new SMExAbstractMap();
        boolean bl = false;
        if (ehm.hashCode() == 0) {
            bl = true;
        }
        this.th.check(bl, "hashCode of Empty Map is 0, got " + ehm.hashCode());
        int hash2 = 0;
        Iterator s = ehm.entrySet().iterator();
        while (s.hasNext()) {
            hash2 += s.next().hashCode();
        }
        this.th.check(ehm.hashCode(), hash2, "hashCode of Empty Map -- checking Algorithm");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        SMExAbstractMap ehm = new SMExAbstractMap();
        this.th.check("{}".equals(ehm.toString()), "checking empty Map");
        ehm.put("a", "b");
        this.th.check("{a=b}".equals(ehm.toString()), "checking Map with one element");
        ehm.put("c", "d");
        ehm.put("e", "f");
        this.th.check("{a=b, c=d, e=f}".equals(ehm.toString()), "checking Map with three elements");
    }
}

