/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.text.RuleBasedCollator;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.text.CollationElementIterator;
import java.text.ParseException;
import java.text.RuleBasedCollator;

public class AcuniaRuleBasedCollatorTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.text.RuleBasedCollator");
        this.test_();
        try {
            String str = " < a ; \u00e0 ; \u00e1 < x < b < c < ch < d < e < f < g < h < i < z ; z\u0316\u0314\u0315 < y ; y\u0300\u0301";
            RuleBasedCollator rbc = new RuleBasedCollator(str);
            rbc.setStrength(0);
            boolean bl = false;
            if (rbc.compare("ac", "x") < 0) {
                bl = true;
            }
            this.th.check(bl, "comparing - plain order -- 1");
            boolean bl2 = false;
            if (rbc.compare("a", "xd") < 0) {
                bl2 = true;
            }
            this.th.check(bl2, "comparing - plain order -- 2");
            boolean bl3 = false;
            if (rbc.compare("ae", "xd") < 0) {
                bl3 = true;
            }
            this.th.check(bl3, "comparing - plain order -- 3");
            this.th.check(rbc.compare("ae", "ae"), 0, "comparing - plain order -- 4");
            this.th.check(rbc.compare("a\u00e0", "\u00e0\u00e1"), 0, "comparing - plain order -- 5");
            boolean bl4 = false;
            if (rbc.compare("b", "xd") > 0) {
                bl4 = true;
            }
            this.th.check(bl4, "comparing - plain order -- 6");
            boolean bl5 = false;
            if (rbc.compare("ax", "\u00e0\u00e1") > 0) {
                bl5 = true;
            }
            this.th.check(bl5, "comparing - plain order -- 7");
            this.compareLT(rbc, "cd", "ch");
            this.compareLT(rbc, "ci", "ch");
            this.compareGT(rbc, "d", "ch");
            this.compareGT(rbc, "j", "\u00e0");
            this.compareGT(rbc, "y\u0301\u0300", "y\u0300\u0301");
            rbc.setStrength(1);
            this.compareLT(rbc, "a", "\u00e0");
            this.compareGT(rbc, "\u00e1", "\u00e0");
            this.th.check(rbc.compare("z\u0316\u0314\u0315", "z\u0314\u0315\u0316"), 0, "comparing - canonical ordering -- 1");
            this.th.check(rbc.compare("z\u0316\u0314\u0315", "z\u0316\u0315\u0314"), 0, "comparing - canonical ordering -- 2");
            this.th.check(rbc.compare("z\u0316\u0314\u0315", "z\u0315\u0314\u0316"), 0, "comparing - canonical ordering -- 3");
            this.th.check(rbc.compare("z\u0314\u0315\u0316", "z\u0316\u0315\u0314"), 0, "comparing - canonical ordering -- 4");
            this.th.check(rbc.compare("\u00e0", "a\u0300"), 0, "comparing - decomposition -- 1");
            str = "abcdefgacadxaech\u00e0\u00e1zz\u0316\u0315\u0314yy\u0300\u0301ay\u0301\u0300";
            CollationElementIterator cei = rbc.getCollationElementIterator(str);
            int order = cei.next();
            str = "< a < b ; x , y < f , z < g < h & b ; u ; l , m < e , v & b ; k , w < c < d";
            rbc = new RuleBasedCollator(str);
            this.compareLT(rbc, "c", "ch");
            this.compareLT(rbc, "ag", "ch");
            this.compareGT(rbc, "d", "ch");
            this.compareGT(rbc, "g", "d");
            this.compareGT(rbc, "e", "a");
            str = "abkwcdulmevxyfzgh";
            cei = rbc.getCollationElementIterator(str);
            order = cei.next();
            str = "< a < b < e & b < c < d & ad ; x < f < g";
            rbc = new RuleBasedCollator(str);
            this.compareLT(rbc, "x", "b");
            this.compareLT(rbc, "x", "ae");
            this.compareLT(rbc, "d", "e");
            this.compareLT(rbc, "e", "g");
            this.compareGT(rbc, "g", "c");
            this.compareGT(rbc, "ae", "x");
            this.compareGT(rbc, "x", "ad");
            this.compareGT(rbc, "e", "a");
            str = "abcdexfg";
            cei = rbc.getCollationElementIterator(str);
            order = cei.next();
            rbc.setStrength(0);
            this.th.check(rbc.compare("x", "ad"), 0, "comparing - combined pattern -- 1");
        }
        catch (ParseException pe) {
            this.th.debug(pe);
            pe.printStackTrace();
        }
    }

    private final void compareLT(RuleBasedCollator rbc, String one, String two) {
        int result = rbc.compare(one, two);
        boolean bl = false;
        if (result < 0) {
            bl = true;
        }
        this.th.check(bl, "comparing '" + one + "' with '" + two + "' " + result + " ?<? 0");
    }

    private final void compareGT(RuleBasedCollator rbc, String one, String two) {
        int result = rbc.compare(one, two);
        boolean bl = false;
        if (result > 0) {
            bl = true;
        }
        this.th.check(bl, "comparing '" + one + "' with '" + two + "' " + result + " ?>? 0");
    }

    public void test_() {
        this.th.checkPoint("()");
    }
}

