/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.URL;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.net.URL.MyURLStreamHandler;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        URL url;
        harness.checkPoint("Constructors");
        try {
            url = new URL("hithleksjf");
            harness.fail("Error in test_Basics  - 1  should have raised malformed URL exception here");
        }
        catch (MalformedURLException e) {
            harness.check(true);
        }
        try {
            url = new URL("http://////://");
            harness.check(true);
        }
        catch (MalformedURLException e) {
            harness.fail("Error in test_Basics  - 2  should not have raised malformed URL exception here");
        }
        try {
            url = new URL("http://sourceware.cygnus.com/index.html");
            harness.check(true);
        }
        catch (MalformedURLException e) {
            harness.fail("Error in test_Basics  - 3  should not have raised malformed URL exception here");
        }
        harness.checkPoint("get Methods");
        try {
            URL baseurl = new URL("http://sourceware.cygnus.com/");
            URL url2 = new URL(baseurl, "index.html");
            url2.hashCode();
            baseurl.hashCode();
            URL.setURLStreamHandlerFactory(null);
            URL.setURLStreamHandlerFactory(null);
            harness.check(url2.getProtocol(), (Object)"http");
            harness.check(url2.getPort(), -1);
            harness.check(url2.getHost(), (Object)"sourceware.cygnus.com");
            harness.check(url2.getFile(), (Object)"/index.html");
            harness.check(url2.equals(new URL("http://sourceware.cygnus.com/index.html")));
            boolean bl = false;
            if (url2.hashCode() != 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (MalformedURLException e) {
            harness.fail(" Error in test_Basics  - 9  exception should not be thrown here");
        }
        try {
            url = new URL("http", "sourceware.cygnus.com", "/index.html");
            harness.check(url.getProtocol(), (Object)"http");
            harness.check(url.getPort(), -1);
            harness.check(url.getHost(), (Object)"sourceware.cygnus.com");
            harness.check(url.getFile(), (Object)"/index.html");
            harness.check(url.equals(new URL("http://sourceware.cygnus.com/index.html")));
            URL url1 = new URL("http", "sourceware.cygnus.com", 80, "index.html");
            harness.check(url1.getPort(), 80);
        }
        catch (MalformedURLException e) {
            harness.fail(" Error in test_Basics  - 16  exception should not be thrown here");
        }
        try {
            url = new URL("http://sourceware.cygnus.com:80/mauve/testarea/index.html");
            harness.check(url.getProtocol(), (Object)"http");
            harness.check(url.getPort(), 80);
            harness.check(url.getHost(), (Object)"sourceware.cygnus.com");
            harness.check(url.getFile(), (Object)"/mauve/testarea/index.html");
        }
        catch (MalformedURLException e) {
            harness.fail(" Error in test_Basics  - 21  exception should not be thrown here");
        }
    }

    public void test_openConnection() {
        harness.checkPoint("openConnection");
        try {
            URL url = new URL("http://sourceware.cygnus.com/mauve/testarea/index.html");
            URLConnection conn = url.openConnection();
            harness.check(conn.getHeaderField(2), (Object)"Apache/1.3.9 (Unix)");
            String conttype = conn.getContentType();
            harness.check(conttype, (Object)"text/html");
            Object obj = url.getContent();
            harness.check(url.toExternalForm(), (Object)"http://sourceware.cygnus.com/mauve/testarea/index.html");
            harness.check(url.getRef(), null);
            URL url2 = new URL("http://www.hhp.com/index.html#help");
            harness.check(url2.getRef(), (Object)"help");
        }
        catch (Exception e) {
            harness.fail(" Error in test_openConnection  - 3  exception should not be thrown here");
            e.printStackTrace(System.out);
        }
    }

    public void test_openStream() {
        harness.checkPoint("openStream");
        try {
            URL url = new URL("http://sourceware.cygnus.com/mauve/testarea/index.html");
            InputStream conn = url.openStream();
            byte[] b = new byte[6];
            conn.read(b, 0, 6);
            String str = new String(b);
            harness.check(str, (Object)"<HTML>");
        }
        catch (Exception e) {
            harness.fail(" Error in test_openStream  - 2  exception should not be thrown here");
        }
    }

    public void test_sameFile() {
        harness.checkPoint("sameFile");
        try {
            URL url = new URL("http://sourceware.cygnus.com/mauve/testarea/index.html");
            URL url1 = new URL("http://sourceware.cygnus.com/mauve/testarea/index.html");
            harness.check(url.sameFile(url1));
            URL url2 = new URL("http://sourceware.cygnus.com:80/mauve/testarea/index.html");
            harness.check(url.sameFile(url2));
        }
        catch (Exception e) {
            harness.fail(" Error in test_sameFile  - 3  exception should not be thrown here");
        }
    }

    public void test_toString() {
        harness.checkPoint("toString");
        try {
            URL url = new URL("http://sourceware.cygnus.com/index.html");
            String str = url.toString();
            URL url1 = new URL("http://sourceware.cygnus.com:80/mauve/testarea/index.html");
            String str1 = url1.toString();
            URL url2 = new URL("http://205.180.83.71/");
            String str2 = url2.toString();
            harness.check(str, (Object)"http://sourceware.cygnus.com/index.html");
            harness.check(str1, (Object)"http://sourceware.cygnus.com:80/mauve/testarea/index.html");
            harness.check(str2, (Object)"http://205.180.83.71/");
            URL url3 = new URL("ftp", "sourceware.cygnus.com", 21, "/dir/dir1.lst");
            String str3 = url3.toString();
            harness.check(str3, (Object)"ftp://sourceware.cygnus.com:21/dir/dir1.lst");
        }
        catch (Exception e) {
            harness.fail(" Error in test_toString  - 5  exception should not be thrown here");
        }
    }

    public void test_URLStreamHandler() {
        harness.checkPoint("URLStreamHandler");
        try {
            URL url = new URL("http://sourceware.cygnus.com/index.html");
            MyURLStreamHandler sh = new MyURLStreamHandler();
            sh.invoke_setURL(url, "http", "sourceware.cygnus.com", 80, "/index.html", "#ref");
            harness.check(true);
            sh.invoke_parseURL(url, "http://sourceware.cygnus.com/index.html", 0, 20);
            harness.check(true);
        }
        catch (MalformedURLException e) {
            harness.fail(" Error in test_URLStreamHandler  - 1  exception should not be thrown here");
        }
    }

    public void test_cr601a() {
        String[][] s = new String[][]{{"file:////c:/pub/files/foobar.txt", "file://c:/pub/files/foobar.txt", "", "//c:/pub/files/foobar.txt"}, {"file:///c:/pub/files/foobar.txt", "file:/c:/pub/files/foobar.txt", "", "/c:/pub/files/foobar.txt"}, {"file://hpjavaux/c:/pub/files/foobar.txt", "file://hpjavaux/c:/pub/files/foobar.txt", "hpjavaux", "/c:/pub/files/foobar.txt"}, {"file://c:/pub/files/foobar.txt", "file://c/pub/files/foobar.txt", "c", "/pub/files/foobar.txt"}, {"file:/c:/pub/files/foobar.txt", "file:/c:/pub/files/foobar.txt", "", "/c:/pub/files/foobar.txt"}, {"file:c:/pub/files/foobar.txt", "file:/c:/pub/files/foobar.txt", "", "/c:/pub/files/foobar.txt"}, {"file:////hpjavant/bgee/foobar.txt", "file://hpjavant/bgee/foobar.txt", "", "//hpjavant/bgee/foobar.txt"}, {"file:///hpjavant/bgee/foobar.txt", "file:/hpjavant/bgee/foobar.txt", "", "/hpjavant/bgee/foobar.txt"}, {"file://hpjavant/bgee/foobar.txt", "file://hpjavant/bgee/foobar.txt", "hpjavant", "/bgee/foobar.txt"}, {"file:/hpjavant/bgee/foobar.txt", "file:/hpjavant/bgee/foobar.txt", "", "/hpjavant/bgee/foobar.txt"}, {"file://hpjavaux//hpjavant/bgee/foobar.txt", "file://hpjavaux//hpjavant/bgee/foobar.txt", "hpjavaux", "//hpjavant/bgee/foobar.txt"}, {"file://hpjavaux/bgee/foobar.txt", "file://hpjavaux/bgee/foobar.txt", "hpjavaux", "/bgee/foobar.txt"}, {"file://hpjavaux/c:/pubs/files/foobar.txt", "file://hpjavaux/c:/pubs/files/foobar.txt", "hpjavaux", "/c:/pubs/files/foobar.txt"}, {"file://bg710571//hpjavant/bgee/foobar.txt", "file://bg710571//hpjavant/bgee/foobar.txt", "bg710571", "//hpjavant/bgee/foobar.txt"}, {"file://bg710571/bgee/foobar.txt", "file://bg710571/bgee/foobar.txt", "bg710571", "/bgee/foobar.txt"}, {"file://bg710571/c:/pubs/files/foobar.txt", "file://bg710571/c:/pubs/files/foobar.txt", "bg710571", "/c:/pubs/files/foobar.txt"}};
        harness.checkPoint("new URL(string)");
        int i = 0;
        while (i < s.length) {
            try {
                URL url = new URL(s[i][0]);
                harness.check(url.toExternalForm(), (Object)s[i][1]);
                harness.check(url.getHost(), (Object)s[i][2]);
                harness.check(url.getFile(), (Object)s[i][3]);
            }
            catch (Throwable e) {
                harness.fail("Should not have thrown exception");
                e.printStackTrace(System.out);
            }
            ++i;
        }
    }

    public void test_cr601b() {
        String[][] stringArrayArray = new String[17][];
        stringArrayArray[0] = new String[]{"////", "c:/pub/files/foobar.txt", "file://////c:/pub/files/foobar.txt", "////", "c:/pub/files/foobar.txt"};
        stringArrayArray[1] = new String[]{"///", "c:/pub/files/foobar.txt", "file://///c:/pub/files/foobar.txt", "///", "c:/pub/files/foobar.txt"};
        stringArrayArray[2] = new String[]{"//", "c:/pub/files/foobar.txt", "file:////c:/pub/files/foobar.txt", "//", "c:/pub/files/foobar.txt"};
        stringArrayArray[3] = new String[]{"/", "c:/pub/files/foobar.txt", "file:///c:/pub/files/foobar.txt", "/", "c:/pub/files/foobar.txt"};
        stringArrayArray[4] = new String[]{"", "c:/pub/files/foobar.txt", "file:c:/pub/files/foobar.txt", "", "c:/pub/files/foobar.txt"};
        stringArrayArray[5] = new String[]{"hpjavaux", "c:/pub/files/foobar.txt", "file://hpjavauxc:/pub/files/foobar.txt", "hpjavaux", "c:/pub/files/foobar.txt"};
        String[] stringArray = new String[5];
        stringArray[1] = "c:/pub/files/foobar.txt";
        stringArray[2] = "file:c:/pub/files/foobar.txt";
        stringArray[3] = "null";
        stringArray[4] = "c:/pub/files/foobar.txt";
        stringArrayArray[6] = stringArray;
        stringArrayArray[7] = new String[]{"////", "//hpjavant/bgee/foobar.txt", "file:////////hpjavant/bgee/foobar.txt", "////", "//hpjavant/bgee/foobar.txt"};
        stringArrayArray[8] = new String[]{"///", "//hpjavant/bgee/foobar.txt", "file:///////hpjavant/bgee/foobar.txt", "///", "//hpjavant/bgee/foobar.txt"};
        stringArrayArray[9] = new String[]{"//", "//hpjavant/bgee/foobar.txt", "file://////hpjavant/bgee/foobar.txt", "//", "//hpjavant/bgee/foobar.txt"};
        stringArrayArray[10] = new String[]{"/", "//hpjavant/bgee/foobar.txt", "file://///hpjavant/bgee/foobar.txt", "/", "//hpjavant/bgee/foobar.txt"};
        stringArrayArray[11] = new String[]{"", "//hpjavant/bgee/foobar.txt", "file://hpjavant/bgee/foobar.txt", "", "//hpjavant/bgee/foobar.txt"};
        stringArrayArray[12] = new String[]{"hpjavaux", "//hpjavant/bgee/foobar.txt", "file://hpjavaux//hpjavant/bgee/foobar.txt", "hpjavaux", "//hpjavant/bgee/foobar.txt"};
        String[] stringArray2 = new String[5];
        stringArray2[1] = "//hpjavant/bgee/foobar.txt";
        stringArray2[2] = "file://hpjavant/bgee/foobar.txt";
        stringArray2[3] = "null";
        stringArray2[4] = "//hpjavant/bgee/foobar.txt";
        stringArrayArray[13] = stringArray2;
        stringArrayArray[14] = new String[]{"hpjavant", "/bgee/foobar.txt", "file://hpjavant/bgee/foobar.txt", "hpjavant", "/bgee/foobar.txt"};
        stringArrayArray[15] = new String[]{"hpjavant", "/home/bgee/foobar.txt", "file://hpjavant/home/bgee/foobar.txt", "hpjavant", "/home/bgee/foobar.txt"};
        stringArrayArray[16] = new String[]{"hpjavaux", "/home/bgee/foobar.txt", "file://hpjavaux/home/bgee/foobar.txt", "hpjavaux", "/home/bgee/foobar.txt"};
        String[][] s = stringArrayArray;
        harness.checkPoint("new URL(protocol, host, file)");
        int i = 0;
        while (i < s.length) {
            try {
                URL url = new URL("file", s[i][0], s[i][1]);
                harness.check(url.toExternalForm(), (Object)s[i][2]);
                harness.check(url.getHost(), (Object)s[i][3]);
                harness.check(url.getFile(), (Object)s[i][4]);
                harness.check(true);
            }
            catch (NullPointerException e) {
                if (i != 6 && i != 13) {
                    harness.fail("Should not have thrown NullPointerException");
                    e.printStackTrace(System.out);
                }
            }
            catch (Throwable e) {
                harness.fail("Should not have thrown exception");
                e.printStackTrace(System.out);
            }
            ++i;
        }
    }

    public void testall() {
        this.test_Basics();
        this.test_openConnection();
        this.test_openStream();
        this.test_sameFile();
        this.test_toString();
        this.test_URLStreamHandler();
        this.test_cr601a();
        this.test_cr601b();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }
}

