/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.MulticastSocket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.net.MulticastSocket.MulticastClient;
import gnu.testlet.wonka.net.MulticastSocket.MulticastServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MulticastSocketTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        InetAddress address;
        MulticastSocket socket;
        int nPort = 12345;
        try {
            socket = new MulticastSocket(4441);
            address = InetAddress.getByName("15.0.0.1");
            socket.joinGroup(address);
            harness.fail("Wrong ipaddress arg. - 1");
        }
        catch (IOException e) {
            harness.check(true);
        }
        try {
            socket = new MulticastSocket(-1);
            harness.fail("Wrong port arg. - 2");
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
        }
        catch (Exception e) {
            harness.check(true);
        }
        try {
            socket = new MulticastSocket(0);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            socket.leaveGroup(address);
            socket.close();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("Correct args. - 3");
            e.printStackTrace();
        }
        try {
            socket = new MulticastSocket();
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            socket.leaveGroup(address);
            socket.close();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("Correct args. different constructor. - 4");
            e.printStackTrace();
        }
        try {
            socket = new MulticastSocket(++nPort);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(null);
            harness.fail("joinGroup() with incorrect params. - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("joinGroup() with incorrect params. should have thrown a NullPointerException - 5a");
            e.printStackTrace();
        }
        try {
            socket = new MulticastSocket(++nPort);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            socket.leaveGroup(address);
            harness.check(true);
            socket.leaveGroup(address);
            harness.fail("leaveGroup() twice. - 6");
            socket.close();
        }
        catch (Exception e) {
            harness.check(true);
        }
        try {
            socket = new MulticastSocket(++nPort);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            socket.leaveGroup(null);
            harness.fail("leaveGroup() with incorrect params - 7");
            socket.close();
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("leaveGroup() with incorrect params. should have thrown a NullPointerException - 7a");
            e.printStackTrace();
        }
        try {
            socket = new MulticastSocket(++nPort);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            socket.leaveGroup(address);
            socket.close();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("Correct args. - 8");
            e.printStackTrace();
        }
        try {
            socket = new MulticastSocket(++nPort);
            address = InetAddress.getByName("230.0.0.1");
            socket.joinGroup(address);
            byte bTTL = socket.getTTL();
            boolean bl = false;
            if (bTTL != 0) {
                bl = true;
            }
            harness.check(bl, "getTTL() should never return zero - 9");
            byte newbTTL = 127;
            socket.setTTL(newbTTL);
            bTTL = socket.getTTL();
            harness.check(bTTL, newbTTL, "getTTL() should return same value (127) used for setTTL() - 10");
            bTTL = -56;
            socket.setTTL(bTTL);
            bTTL = socket.getTTL();
            socket.setTTL((byte)1);
            socket.leaveGroup(address);
            socket.close();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("Should not have thrown any exception - 11");
            e.printStackTrace();
        }
    }

    public void test_Comm() {
        try {
            MulticastClient client = new MulticastClient();
            client.start();
            MulticastServer server = new MulticastServer(4446);
            server.start();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("test_Comm failed");
            e.printStackTrace();
        }
    }

    public void testall() {
        this.test_Basics();
        this.test_Comm();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        harness.setclass("java.net.MulticastSocket");
        this.testall();
    }
}

