/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.math.BigInteger;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.math.BigInteger;

public class AcuniaBigIntegerTest
implements Testlet {
    protected TestHarness th;

    public static String string(long i) {
        if (i < 0L) {
            return "-" + Long.toHexString(-i);
        }
        return Long.toHexString(i);
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.math.BigInteger");
        this.test_BigInteger();
        this.test_abs();
        this.test_add();
        this.test_divide();
        this.test_divideAndRemainder();
        this.test_gcd();
        this.test_isProbablePrime();
        this.test_max();
        this.test_min();
        this.test_mod();
        this.test_modInverse();
        this.test_modPow();
        this.test_multiply();
        this.test_negate();
        this.test_pow();
        this.test_remainder();
        this.test_signum();
        this.test_subtract();
        this.test_and();
        this.test_andNot();
        this.test_bitCount();
        this.test_bitLength();
        this.test_clearBit();
        this.test_flipBit();
        this.test_getLowestSetBit();
        this.test_not();
        this.test_or();
        this.test_setBit();
        this.test_shiftLeft();
        this.test_shiftRight();
        this.test_testBit();
        this.test_xor();
        this.test_doubleValue();
        this.test_floatValue();
        this.test_intValue();
        this.test_longValue();
        this.test_toByteArray();
        this.test_valueOf();
        this.test_compareTo();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
    }

    public void test_mod() {
        this.th.checkPoint("mod(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.mod(new BigInteger("-1"));
            this.th.fail("should throw a ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            big.mod(new BigInteger("0"));
            this.th.fail("should throw a ArithmeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            big.mod(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.mod(5, 3, 2);
        this.mod(-5L, 3, 1L);
        this.mod(97125L, 3, 0L);
        this.mod(-5L, 364L, 359L);
        this.mod(5, 367L, 5);
        this.mod(12345565L, 3123343L, 2975536L);
        this.mod(89912334565L, 66526576858L, 23385757707L);
        this.mod(-223484583885L, 309879709809L, 86395125924L);
        this.mod("12345678912345678998765432198765432112348579835", "49849247825673457836783952785", "26676731909214354525437952490");
        this.mod("-2345678912342987998765432198765432112348579835", "49849247825673457836783952785", "11087801140580011135649879880");
        this.mod("1234567891234567899876543219876543218234982345789247829412348579835", "979697674643549849247825673457836783952785", "790925574855982590643417942974388632756275");
        this.mod("49247284972849679567567886567276278257876678768612345678912345678998765432198765432112348579835", "988988908098090804984924782567345872972137987836783952785", "573526136119471212993887594038030919565414271460411480300");
        this.mod("-908989080789687955950050508770609970780070780781234567891234567899876543219876543211234857983509900", "247825673457836783952785", "37062322574424925400690");
        this.mod("90989348094820347823898323489252456827598927592578925672748825789257898298482912345678912345678998765432198765432112348579835", "7834784782489249274274874782579425783456739538534949849247825673457836783952785", "5546643523640844048863099802162939135974441874753845385280281062922452880173410");
    }

    public void mod(long a, long b, long result) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigB = new BigInteger("" + b);
        BigInteger bigR = bigA.mod(bigB);
        this.th.check(bigR.toString(), String.valueOf(result), "calculating '" + a + "'.mod(" + b + ')');
    }

    public void mod(String a, String b, String result) {
        BigInteger bigA = new BigInteger(a);
        BigInteger bigB = new BigInteger(b);
        BigInteger bigR = bigA.mod(bigB);
        this.th.check(bigR.toString(), result, "calculating '" + a + "'.mod(" + b + ')');
    }

    public void test_pow() {
        this.th.checkPoint("pow(int)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.pow(-1);
            this.th.fail("should throw a ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        this.pow(3, 2, 9L);
        this.pow(3, 3, 27L);
        this.pow(-3L, 3, -27L);
        this.pow(3, 4, 81L);
        this.pow(3, 0, 1L);
        this.pow(13L, 7, 62748517L);
        this.pow(13L, 8, 815730721L);
        this.pow(13L, 9, 10604499373L);
        this.pow(10L, 9, 1000000000L);
        this.pow(10L, 10, 10000000000L);
        this.pow(10L, 11, 100000000000L);
        this.pow(-13L, 7, -62748517L);
        this.pow(-13L, 8, 815730721L);
        this.pow(-13L, 9, -10604499373L);
        this.pow(-10L, 9, -1000000000L);
        this.pow(-10L, 10, 10000000000L);
        this.pow(-10L, 11, -100000000000L);
        this.pow(2, 62, 0x4000000000000000L);
        this.pow(-2L, 63, Long.MIN_VALUE);
        this.pow("12345465787976254133563567488754", 0, "1");
        this.pow("12345465787976254133563567488754", 1, "12345465787976254133563567488754");
        this.pow("-12345465787976254133563567488754", 0, "1");
        this.pow("-12345465787976254133563567488754", 1, "-12345465787976254133563567488754");
        this.pow("12347488754", 13, "155068044660698865176210532230580025248543531379621741900724457136870656316148982583442128258673696684158584590588118214760479268864");
        this.pow("-12347488754", 13, "-155068044660698865176210532230580025248543531379621741900724457136870656316148982583442128258673696684158584590588118214760479268864");
        this.pow("12345465787976254", 8, "539584967814122950020074892817791857631912354200438188908235060725598962020201059241364920125512432870577507923419187675323105536");
        this.pow("-12345465787976254", 8, "539584967814122950020074892817791857631912354200438188908235060725598962020201059241364920125512432870577507923419187675323105536");
    }

    public void pow(long a, int b, long result) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigR = bigA.pow(b);
        this.th.check(bigR.toString(), String.valueOf(result), "calculating '" + a + "'.pow(" + b + ')');
    }

    public void pow(String a, int b, String result) {
        BigInteger bigA = new BigInteger(a);
        BigInteger bigR = bigA.pow(b);
        this.th.check(bigR.toString(), result, "calculating '" + a + "'.pow(" + b + ')');
    }

    public void test_modPow() {
        this.th.checkPoint("modPow(java.math.BigInteger,java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.modPow(new BigInteger("-1"), new BigInteger("35"));
            this.th.fail("should throw a ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            big.modPow(BigInteger.ONE, new BigInteger("-1"));
            this.th.fail("should throw a ArithmeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            big.modPow(big, null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            big.modPow(null, big);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.check(big.modPow(new BigInteger("-1"), new BigInteger("34")).toString(10), "23", "modInverse should be calculated");
        this.modPow(3, 2, 2, 1L);
        this.modPow(3, 3, 2, 1L);
        this.modPow(3, 3, 4, 3);
        this.modPow(3, 4, 4, 1L);
        this.modPow(13L, 7L, 25L, 17L);
        this.modPow(13L, 8L, 17L, 1L);
        this.modPow(13L, 9L, 13L, 0L);
        this.modPow(10L, 9L, 987654L, 494152L);
        this.modPow(10L, 10L, 7654L, 3076L);
        this.modPow(10L, 11L, 2345L, 565L);
        this.modPow("12345678998786532212235467776", "6533301", "9977562414123435667567", "2984929374493681814177");
        this.modPow("12345678998786", "65", "9977562414", "86997848");
        this.modPow("-12345678998786532212235467776", "6533301", "9977562414123435667567", "6992633039629753853390");
        this.modPow("9988998967776", "123354545301", "995667567", "323137518");
        this.modPow("12345678998786532212235467776", "123456777776533301", "567", "523");
    }

    public void modPow(long a, long b, long c, long result) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigB = new BigInteger("" + b);
        BigInteger bigC = new BigInteger("" + c);
        BigInteger bigR = bigA.modPow(bigB, bigC);
        this.th.check(bigR.toString(), String.valueOf(result), "calculating '" + a + "'.modPow(" + b + ',' + c + ')');
    }

    public void modPow(String a, String b, String c, String result) {
        BigInteger bigA = new BigInteger(a);
        BigInteger bigB = new BigInteger(b);
        BigInteger bigC = new BigInteger(c);
        BigInteger bigR = bigA.modPow(bigB, bigC);
        this.th.check(bigR.toString(), result, "calculating '" + a + "'.modPow(" + b + ',' + c + ')');
    }

    public void test_multiply() {
        this.th.checkPoint("multiply(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.multiply(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.multiply(2141965807L, 2882400018L);
        this.multiply(2141965807L, 13496082L);
        this.multiply(11259375L, 2882400018L);
        this.multiply(5, 7L);
        this.multiply(2, 256L);
        this.multiply(1024L, 7L);
        this.multiply(1024L, 1024L);
        this.multiply(7L, 1025L);
        this.multiply(7L, 1L);
        this.multiply(0L, 1025L);
        this.multiply(15L, 0L);
        this.multiply(12345L, 1234567L);
        this.multiply(123456789L, 123456789L);
        this.multiply("123456789987654321", "987654321123456789", "121932632103337905662094193112635269");
        this.multiply("123456789123456789098654323456643211234567865432", "1234567895856746258569137014789257913679146781367", "152415788377376085417465147944675539635643256078436354258399545659453653659773023673270381005544");
        this.multiply("1234567891234567890986543234598765432123456786643211234567865432", "12345678958567462585691370147892579112345678908765432123456765432345673679146781367", "15241578837737608541746514794866730719025488223410498849498842809533813499156607835178840677868043724081007266894620111101470529335993270381005544");
        this.multiply("123456789123456789098765432123456789098654323456643211234567865432", "123456789585674625812345678569137014789257913679112345678654346781367", "15241578837737608536258006907744318645569311694076239003338399512714379912778165050445760106981204278751782203252401380090556781005544");
        this.multiply("123456789123456733489098765432123456789098654323456643211234567865432", "12345678958567462581234567833569137014789257913679112345678654346781367", "1524157883773760167086709027970788502396411374567067872191869825760865756663070083706495794806066981204278751782203252401380090556781005544");
        this.multiply("123456789123456789098334455765432123456789098654323456643211234567865432", "1234567895856746258123456785691370167678847892057913679112345678654346781367", "152415788377376085362047999501952673696808644225634769588546036085996639934119194755977732728699401197872461397701161382203252401380090556781005544");
        this.multiply("12345678912345678909876543212345688990789098654323456643211234567865432", "123456789585674625812345678569137014789257913670765439112345678654346781367", "1524157883773760853625800690774433109115403070020311546883423329059412948778604664370387034837705031377735431662402826563572401380090556781005544");
    }

    public void multiply(long a, long b) {
        BigInteger bigi = new BigInteger("" + a);
        BigInteger big2 = new BigInteger("" + b);
        this.th.check(bigi.multiply(big2).toString(10), "" + a * b, "multiplying '" + a + "' * '" + b + '\'');
        this.th.check(bigi.negate().multiply(big2).toString(10), "" + -a * b, "multiplying '-" + a + "' * '" + b + '\'');
        this.th.check(bigi.multiply(big2.negate()).toString(10), "" + -a * b, "multiplying '" + a + "' * '-" + b + '\'');
        this.th.check(bigi.negate().multiply(big2.negate()).toString(10), "" + a * b, "multiplying '-" + a + "' * '-" + b + '\'');
    }

    public void multiply(String a, String b, String result) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        this.th.check(bigi.multiply(big2).toString(), result, "multiplying '" + a + "' * '" + b + '\'');
        this.th.check(bigi.multiply(big2.negate()).toString(), "-" + result, "multiplying '" + a + "' * '-" + b + '\'');
        this.th.check(bigi.negate().multiply(big2).toString(), "-" + result, "multiplying '-" + a + "' * '" + b + '\'');
        this.th.check(bigi.negate().multiply(big2.negate()).toString(), result, "multiplying '-" + a + "' * '-" + b + '\'');
    }

    public void test_divide() {
        this.th.checkPoint("divide(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.divide(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.divide("12345678912345678998765432198765432112348579835", "49849247825673457836783952785", "247660284775398017");
        this.divide("90989348094820347823898323489252456827598927592578925672748825789257898298482912345678912345678998765432198765432112348579835", "7834784782489249274274874782579425783456739538534949849247825673457836783952785", "11613509575678660510806770219390185177513850505");
        this.divide("12345678998765432456789", "1000000", "12345678998765432");
        this.divide("1234", "123", "10");
        this.divide("123123123", "123", "1001001");
        this.divide("12341234598", "123", "100335240");
        this.divide("12341234567888998765432221124566", "123", "100335240389341453377497732720");
        this.divide("123123123947294782347924783248792482824", "123432423", "997494183090732832393031636823");
        this.divide("123456789012345678922109840947294523456789123234445", "12345678989592729420987654321", "9999999928429889029787");
        this.divide("987654421123456789012345678922109840947294523456789123234445", "98812345678989592729420987654321", "9995253268574729634797919952");
        this.divide("1987654421123456789012345678922109840947294523456789123234445", "181", "10981516138803628668576495463658065419598312284291652614554");
        this.divide("19876544211234567890123456789221098409472945234567891232344456", "481", "41323376738533405176971843636634300227594480737147383019427");
        this.divide("19876544211234567890123456789221098409472945234567891232344456", "19876544211234567890123456789221098409472945234567891232344456", "1");
    }

    public void divide(String a, String b, String result) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        this.th.check(bigi.divide(big2).toString(), result, "testing '" + a + "' / '" + b + '\'');
        this.th.check(bigi.divide(big2.negate()).toString(), "-" + result, "testing '" + a + "' / '-" + b + '\'');
        this.th.check(bigi.negate().divide(big2).toString(), "-" + result, "testing '-" + a + "' / '" + b + '\'');
        this.th.check(bigi.negate().divide(big2.negate()).toString(), result, "testing '-" + a + "' / '-" + b + '\'');
    }

    public void test_divideAndRemainder() {
        this.th.checkPoint("divideAndRemainder(java.math.BigInteger)java.math.BigInteger");
        try {
            this.divideAndRemainder(1L, 0L);
            this.th.fail("didn't throw Exception");
        }
        catch (ArithmeticException ae) {
            this.th.check(true, "caught correct Exception");
        }
        BigInteger big = new BigInteger("12345");
        try {
            big.divideAndRemainder(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.divideAndRemainder(221L, 0x1331313L);
        this.divideAndRemainder(221L, 1L);
        this.divideAndRemainder(221L, 20L);
        this.divideAndRemainder(21L, 200L);
        this.divideAndRemainder(61985L, 8192L);
        this.divideAndRemainder(Long.MAX_VALUE, 0x2AAAAAAAAAAAAAAAL);
        this.divideAndRemainder(61985L, 20L);
        this.divideAndRemainder(2146545583L, 70608928L);
        this.divideAndRemainder(Integer.MAX_VALUE, 1135335456L);
        this.divideAndRemainder(2127671215L, 0xFFFFFFFL);
        this.divideAndRemainder(1914810287L, 305419896L);
        this.divideAndRemainder(1914810287L, 2271560481L);
        this.divideAndRemainder(1914810287L, 2146282751L);
        this.divideAndRemainder(1914810287L, 4413048L);
        this.divideAndRemainder(1914810287L, 5666848L);
        this.divideAndRemainder(268362273L, 230L);
        this.divideAndRemainder(61985L, 20L);
        this.divideAndRemainder(61985L, 200L);
        this.divideAndRemainder(29217L, 231L);
        this.divideAndRemainder(Long.MAX_VALUE, 111L);
        this.divideAndRemainder(Long.MAX_VALUE, 231L);
        this.divideAndRemainder(61985L, -20L);
        this.divideAndRemainder(22112344545L, 201232354L);
        this.divideAndRemainder(221232345365647L, 90887896786L);
        this.divideAndRemainder(221098409472945L, 79592729420L);
        this.divideAndRemainder(221232345365647L, 90887896786L);
        this.divideAndRemainder(221098409472945L, 89592729420L);
        this.divideAndRemainder(Long.MAX_VALUE, 895L);
        this.divideAndRemainder("123456789098765432101", "1234567890987654321", "100", "1");
        this.divideAndRemainder("1234567890987654321123456789098765432191", "1234567890987654321", "1000000000000000000100", "91");
        this.divideAndRemainder("12345678909876548674236723468743211234567890987654321919867946738461347618467124671894814761894781478194791479", "12345678909876543217914678247782349823478987896147682137612369", "1000000000000000441962089331183170935361892503913", "6715597036491976622262763579503321650514768988002025385091582");
        this.divideAndRemainder("1234567976542454676543454675643245656489098765432101", "1234567890987654321", "1000000069299388863175125850931579", "809699412890729242");
        this.divideAndRemainder("123456785784578457645677676878978879098765432101", "123468677876567890987654321", "999903683329294884717", "54781761811183194823519944");
        this.divideAndRemainder("1234567890986876876786786786788765432101", "12345678976867870987654321", "99999999457307", "3339014710196691851858554");
        this.divideAndRemainder("12345678909877834768423645267865432101", "12", "1028806575823152897368637105655452675", "1");
        this.divideAndRemainder("1987654421123456789012345678922109840947294523456789123234445", "181", "10981516138803628668576495463658065419598312284291652614554", "171");
        this.divideAndRemainder("19876544211234567890123456789221098409472945234567891232344456", "481", "41323376738533405176971843636634300227594480737147383019427", "69");
        this.divideAndRemainder("12345678909765445675676543458765432101", "123456787678687890987654321", "100000001149", "44807534098724613950617272");
        this.divideAndRemainder("1234567890987654365546453243564545675544567565456776546788765434567652101", "91234567890987654321", "13531799618569877847450903862313109613935372513897557", "1689025149845258304");
        this.divideAndRemainder("12345678909174561456246285625892659259536539536578959249469498765432101", "781234567890987654321", "15802781157652588279342366959355276738471005685664", "609366041877148077957");
        this.divideAndRemainder("12345672864284724786472846285268562527847648768763476234867789098765432101", "168234567890988767654321", "73383686950023082859905370324735874795318968354252", "61088368877718958909209");
    }

    public void divideAndRemainder(long a, long b) {
        BigInteger bigi = new BigInteger("" + a);
        BigInteger big2 = new BigInteger("" + b);
        BigInteger div = bigi.divide(big2);
        BigInteger rem = bigi.remainder(big2);
        BigInteger[] big = bigi.divideAndRemainder(big2);
        this.th.check(div.toString(10), "" + a / b, "division  '" + a + "' / '" + b + '\'');
        this.th.check(rem.toString(10), "" + a % b, "remainder '" + a + "' % '" + b + '\'');
        this.th.check(big[0].toString(10), "" + a / b, "divideAndRemainder[0] '" + a + "' / '" + b + '\'');
        this.th.check(big[1].toString(10), "" + a % b, "divideAndRemainder[0] '" + a + "' % '" + b + '\'');
        div = bigi.divide(big2.negate());
        rem = bigi.remainder(big2.negate());
        big = bigi.divideAndRemainder(big2.negate());
        this.th.check(div.toString(10), "" + a / -b, "division  '" + a + "' / '-" + b + '\'');
        this.th.check(rem.toString(10), "" + a % -b, "remainder '" + a + "' % '-" + b + '\'');
        this.th.check(big[0].toString(10), "" + a / -b, "divideAndRemainder[0] '" + a + "' / '-" + b + '\'');
        this.th.check(big[1].toString(10), "" + a % -b, "divideAndRemainder[0] '" + a + "' % '-" + b + '\'');
        div = bigi.negate().divide(big2);
        rem = bigi.negate().remainder(big2);
        big = bigi.negate().divideAndRemainder(big2);
        this.th.check(div.toString(10), "" + -a / b, "division  '-" + a + "' / '" + b + '\'');
        this.th.check(rem.toString(10), "" + -a % b, "remainder '-" + a + "' % '" + b + '\'');
        this.th.check(big[0].toString(10), "" + -a / b, "divideAndRemainder[0] '-" + a + "' / '" + b + '\'');
        this.th.check(big[1].toString(10), "" + -a % b, "divideAndRemainder[0] '-" + a + "' % '" + b + '\'');
        div = bigi.negate().divide(big2.negate());
        rem = bigi.negate().remainder(big2.negate());
        big = bigi.negate().divideAndRemainder(big2.negate());
        this.th.check(div.toString(10), "" + -a / -b, "division  '-" + a + "' / '-" + b + '\'');
        this.th.check(rem.toString(10), "" + -a % -b, "remainder '-" + a + "' % '-" + b + '\'');
        this.th.check(big[0].toString(10), "" + -a / -b, "divideAndRemainder[0] '-" + a + "' / '-" + b + '\'');
        this.th.check(big[1].toString(10), "" + -a % -b, "divideAndRemainder[0] '-" + a + "' % '-" + b + '\'');
    }

    public void divideAndRemainder(String a, String b, String q, String r) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        BigInteger div = bigi.divide(big2);
        BigInteger rem = bigi.remainder(big2);
        BigInteger[] big = bigi.divideAndRemainder(big2);
        this.th.check(div.toString(10), q, "division  '" + a + "' / '" + b + '\'');
        this.th.check(rem.toString(10), r, "remainder '" + a + "' % '" + b + '\'');
        this.th.check(big[0].toString(10), q, "divideAndRemainder[0] '" + a + "' / '" + b + '\'');
        this.th.check(big[1].toString(10), r, "divideAndRemainder[0] '" + a + "' % '" + b + '\'');
        div = bigi.divide(big2.negate());
        rem = bigi.remainder(big2.negate());
        big = bigi.divideAndRemainder(big2.negate());
        this.th.check(div.toString(10), "-" + q, "division  '" + a + "' / '-" + b + '\'');
        this.th.check(rem.toString(10), r, "remainder '" + a + "' % '-" + b + '\'');
        this.th.check(big[0].toString(10), "-" + q, "divideAndRemainder[0] '" + a + "' / '-" + b + '\'');
        this.th.check(big[1].toString(10), r, "divideAndRemainder[0] '" + a + "' % '-" + b + '\'');
        div = bigi.negate().divide(big2);
        rem = bigi.negate().remainder(big2);
        big = bigi.negate().divideAndRemainder(big2);
        this.th.check(div.toString(10), "-" + q, "division  '-" + a + "' / '" + b + '\'');
        this.th.check(rem.toString(10), "-" + r, "remainder '-" + a + "' % '" + b + '\'');
        this.th.check(big[0].toString(10), "-" + q, "divideAndRemainder[0] '-" + a + "' / '" + b + '\'');
        this.th.check(big[1].toString(10), "-" + r, "divideAndRemainder[0] '-" + a + "' % '" + b + '\'');
        div = bigi.negate().divide(big2.negate());
        rem = bigi.negate().remainder(big2.negate());
        big = bigi.negate().divideAndRemainder(big2.negate());
        this.th.check(div.toString(10), q, "division  '-" + a + "' / '-" + b + '\'');
        this.th.check(rem.toString(10), "-" + r, "remainder '-" + a + "' % '-" + b + '\'');
        this.th.check(big[0].toString(10), q, "divideAndRemainder[0] '-" + a + "' / '-" + b + '\'');
        this.th.check(big[1].toString(10), "-" + r, "divideAndRemainder[0] '-" + a + "' % '-" + b + '\'');
    }

    public void test_BigInteger() {
        this.th.checkPoint("BigInteger(java.lang.String)");
        BigInteger bigi = new BigInteger("00");
        this.th.check(bigi.toString(), (Object)"0");
        bigi = new BigInteger("-00");
        this.th.check(bigi.toString(10), (Object)"0");
        bigi = new BigInteger("12345678901234567890");
        this.th.check(bigi.toString(10), (Object)"12345678901234567890");
        bigi = new BigInteger("123456789012345678901");
        this.th.check(bigi.toString(10), (Object)"123456789012345678901");
        bigi = new BigInteger("1234567890123456789012");
        this.th.check(bigi.toString(10), (Object)"1234567890123456789012");
        bigi = new BigInteger("12345678901234567890123");
        this.th.check(bigi.toString(10), (Object)"12345678901234567890123");
        bigi = new BigInteger("123456789012345678901234");
        this.th.check(bigi.toString(10), (Object)"123456789012345678901234");
        bigi = new BigInteger("987654321123456789012345678901234");
        this.th.check(bigi.toString(10), (Object)"987654321123456789012345678901234");
        bigi = new BigInteger("9998889998889991234567890123456789012345678901234567890");
        this.th.check(bigi.toString(10), (Object)"9998889998889991234567890123456789012345678901234567890");
        this.th.checkPoint("BigInteger(java.lang.String,int)");
        bigi = new BigInteger("00", 10);
        this.th.check(bigi.toString(10), (Object)"0");
        bigi = new BigInteger("-00", 10);
        this.th.check(bigi.toString(10), (Object)"0");
        bigi = new BigInteger("ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890", 16);
        this.th.check(bigi.toString(16), (Object)"ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890".toLowerCase());
        bigi = new BigInteger("12345678901234567890", 10);
        this.th.check(bigi.toString(10), (Object)"12345678901234567890");
        bigi = new BigInteger("123456789012345678901", 10);
        this.th.check(bigi.toString(10), (Object)"123456789012345678901");
        bigi = new BigInteger("1234567890123456789012", 10);
        this.th.check(bigi.toString(10), (Object)"1234567890123456789012");
        bigi = new BigInteger("12345678901234567890123", 10);
        this.th.check(bigi.toString(10), (Object)"12345678901234567890123");
        bigi = new BigInteger("123456789012345678901234", 10);
        this.th.check(bigi.toString(10), (Object)"123456789012345678901234");
        bigi = new BigInteger("987654321123456789012345678901234", 10);
        this.th.check(bigi.toString(10), (Object)"987654321123456789012345678901234");
        bigi = new BigInteger("9998889998889991234567890123456789012345678901234567890", 10);
        this.th.check(bigi.toString(10), (Object)"9998889998889991234567890123456789012345678901234567890");
        this.th.checkPoint("BigInteger(byte[])");
        this.th.checkPoint("BigInteger(int,byte[])");
        this.th.checkPoint("BigInteger(int,java.util.Random)");
        this.th.checkPoint("BigInteger(int,int,java.util.Random");
    }

    public void test_abs() {
        this.th.checkPoint("abs()java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        BigInteger bigi = new BigInteger("0");
        this.th.check(bigi.abs(), bigi);
        bigi = new BigInteger("12345");
        this.th.check(bigi.abs(), bigi);
        bigi = new BigInteger("-987654");
        this.th.check(bigi.abs(), bigi.negate());
    }

    public void test_add() {
        this.th.checkPoint("add(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.add(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.checkAdd(12345L, 0L);
        this.checkAdd(0L, 123445L);
        this.checkAdd(12345L, 97887978897L);
        this.checkAdd(123876543356523455L, 87328947988738994L);
        this.checkAdd("123000789000456000123000789000456000", "456000123000789000456000123000789", "123456789123456789123456789123456789");
        this.checkAdd("9832367467284628657256256234863741685483467851362486146123672641784378776837613762396194714149146384716234761234314", "-9832367467284628657256256234863741685483467851362486146123672641784378776837613762396194714149146384716234761234313", "1");
    }

    private final void checkAdd(long a, long b) {
        BigInteger bigi = new BigInteger("" + a);
        BigInteger big2 = new BigInteger("" + b);
        this.th.check(bigi.add(big2).toString(), "" + (a + b), "adding '" + a + "' + '" + b + '\'');
        this.th.check(bigi.add(big2.negate()).toString(), "" + (a - b), "adding '" + a + "' + '-" + b + '\'');
        this.th.check(bigi.negate().add(big2).toString(), "" + (-a + b), "adding '-" + a + "' + '" + b + '\'');
        this.th.check(bigi.negate().add(big2.negate()).toString(), "" + (-a - b), "adding '-" + a + "' + '-" + b + '\'');
    }

    private final void checkAdd(String a, String b, String result) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        this.th.check(bigi.add(big2).toString(), result, "adding '" + a + "' + '" + b + '\'');
        this.th.check(bigi.negate().add(big2.negate()).toString(), "-" + result, "adding '-" + a + "' + '-" + b + '\'');
    }

    public void test_gcd() {
        this.th.checkPoint("gcd(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.gcd(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.check(BigInteger.ZERO.gcd(BigInteger.ZERO), BigInteger.ZERO, "checking gcd(0,0) = 0");
        this.th.check(BigInteger.ZERO.gcd(BigInteger.ONE), BigInteger.ONE, "checking gcd(0,1) = 1");
        this.th.check(BigInteger.ONE.gcd(BigInteger.ZERO), BigInteger.ONE, "checking gcd(1,0) = 1");
        this.checkGcd("1234567", "567", "1");
        this.checkGcd("1", "567", "1");
        this.checkGcd("2", "4", "2");
        this.checkGcd("121", "11", "11");
        this.checkGcd("121", "88", "11");
        this.checkGcd("144", "96", "48");
        this.checkGcd("1234567952834824285972578257825782578475978562456972787948778257823578925782957844982357692423478234789234992", "567874979859578257823048402580925840840894204835720580582502852095820589258028052809589258290892953487923478", "22");
        this.checkGcd("12398776545432568654123415654643546576876545678969857624124148793578278178788876567622228242848484248", "56736365245647564789874235345476587351243245343444848448747848719873448848484948348918484848484848", "8");
        this.checkGcd("9498409480148719471238231052058009143459820685534654676473452547535151234567986762565768309389192182", "90809110371032398123478924748913748794769147613613681283375534657576768658468356231312335657689886663434567", "1");
    }

    private final void checkGcd(String a, String b, String result) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        this.th.check(bigi.gcd(big2).toString(), result, "gcd '" + a + "' and '" + b + '\'');
        this.th.check(bigi.gcd(big2.negate()).toString(), result, "gcd '" + a + "' and '-" + b + '\'');
        this.th.check(bigi.negate().gcd(big2).toString(), result, "gcd '-" + a + "' and '" + b + '\'');
        this.th.check(bigi.negate().gcd(big2.negate()).toString(), result, "gcd '-" + a + "' and '-" + b + '\'');
    }

    public void test_isProbablePrime() {
        this.th.checkPoint("isProbablePrime(int)boolean");
        this.checkIsProbablePrime("0", 5, false);
        this.checkIsProbablePrime("1", 5, false);
        this.checkIsProbablePrime("2", 500000, true);
        this.checkIsProbablePrime("3", 500000, true);
        this.checkIsProbablePrime("5", 500000, true);
        this.checkIsProbablePrime("7", 500000, true);
        this.checkIsProbablePrime("15", 8, false);
        this.checkIsProbablePrime("13", 10, true);
        this.checkIsProbablePrime("31", 10, true);
        this.checkIsProbablePrime("97", 5, true);
        this.checkIsProbablePrime("138787878978778978", 12, false);
        this.checkIsProbablePrime("121231", 10, false);
        this.checkIsProbablePrime("137591", 10, false);
        this.checkIsProbablePrime("139991", 30, true);
        this.checkIsProbablePrime("319473174637471487194761496173364164781496714827645824783784894841931783994784", 10, false);
        this.checkIsProbablePrime("8238473497847819397837878997828178297829827819232434322443423423423423423423491", 30, false);
    }

    private final void checkIsProbablePrime(String value, int k, boolean prime) {
        BigInteger bigi = new BigInteger(value);
        this.th.check(prime ^ bigi.isProbablePrime(k) ^ true, "checking prime " + value);
        this.th.check(prime ^ bigi.negate().isProbablePrime(k) ^ true, "checking prime -" + value);
    }

    public void test_max() {
        this.th.checkPoint("max(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.max(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        BigInteger bigi = new BigInteger("123456");
        BigInteger equal = new BigInteger("123456");
        boolean bl = false;
        if (bigi.max(equal) == equal) {
            bl = true;
        }
        this.th.check(bl);
        BigInteger less = new BigInteger("12356");
        boolean bl2 = false;
        if (bigi.max(less) == bigi) {
            bl2 = true;
        }
        this.th.check(bl2);
        BigInteger more = new BigInteger("1234567");
        boolean bl3 = false;
        if (bigi.max(more) == more) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_min() {
        this.th.checkPoint("min(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.min(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        BigInteger bigi = new BigInteger("123456");
        BigInteger equal = new BigInteger("123456");
        boolean bl = false;
        if (bigi.min(equal) == equal) {
            bl = true;
        }
        this.th.check(bl);
        BigInteger less = new BigInteger("12356");
        boolean bl2 = false;
        if (bigi.min(less) == less) {
            bl2 = true;
        }
        this.th.check(bl2);
        BigInteger more = new BigInteger("1234567");
        boolean bl3 = false;
        if (bigi.min(more) == bigi) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_modInverse() {
        this.th.checkPoint("modInverse(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.modInverse(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.checkModInverse(1L, 2, 1L);
        this.checkModInverse(3, 2, 1L);
        this.checkModInverse(4, 3, 1L);
        this.checkModInverse(3, 4, 3);
        this.checkModInverse(4, 5, 4);
        this.checkModInverse(5, 6L, 5);
        this.checkModInverse(4, 5, 4);
        this.checkModInverse(5, 6L, 5);
        this.checkModInverse(17L, 9L, 8L);
        this.checkModInverse(-5L, 6L, 1L);
        this.checkModInverse(-5L, 4, 3);
        this.checkModInverse(-6L, 5, 4);
        this.checkModInverse(9L, 5, 4);
        this.checkModInverse(6L, 7L, 6L);
        this.checkModInverse(12345L, 34L, 23L);
        this.checkModInverse(123456789123456789L, 987654321987654322L, 76304088771625089L);
        this.checkModInverseFail(12L, -1);
        this.checkModInverseFail(13L, -17L);
        this.checkModInverseFail(13L, 0L);
        this.checkModInverseFail(13L, 26L);
        this.checkModInverseFail(13131313L, 1313L);
        this.checkModInverseFail(123456789123456789L, 98765432198765431L);
        this.checkModInverseFail(1943734598389458956L, 1294784387578919234L);
    }

    private final void checkModInverse(long a, long b, long result) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigB = new BigInteger("" + b);
        BigInteger res = new BigInteger("" + result);
        try {
            this.th.check(bigA.modInverse(bigB), res, "verifying modInverse of " + a + " and " + b);
        }
        catch (ArithmeticException ae) {
            this.th.fail("verifying modInverse of " + a + " and " + b + " --> " + ae);
        }
    }

    private final void checkModInverseFail(long a, long b) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigB = new BigInteger("" + b);
        try {
            bigA.modInverse(bigB);
            this.th.fail("modInverse of " + a + " and " + b + " should have thrown a ArithmeticException");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
    }

    public void test_negate() {
        this.th.checkPoint("negate()java.math.BigInteger");
        BigInteger bigi = new BigInteger("0");
        this.th.check(bigi.negate(), bigi);
        this.checkNegate("1");
        this.checkNegate("1123443");
        this.checkNegate("129427849785879502857025872058259857285943534654636345");
        this.checkNegate("1852758927942957252957829472549024792085295082350285902");
        this.checkNegate("990830918303307104814804852589148845838054582905749534592570257820598340538520409248021");
        this.checkNegate("795873490268036584205896832892508285952057805725712572507525725257995561895282959156729515215671925626951269562159151");
    }

    private final void checkNegate(String value) {
        BigInteger bigA = new BigInteger(value);
        BigInteger bigB = new BigInteger("-" + value);
        this.th.check(bigA.negate(), bigB, "negating " + value);
        this.th.check(bigB.negate(), bigA, "negating -" + value);
    }

    public void test_remainder() {
        this.th.checkPoint("remainder(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.remainder(new BigInteger("0"));
            this.th.fail("should throw a ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            big.remainder(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.remainder(5, 3, 2);
        this.remainder(-5L, 3, -2L);
        this.remainder(97125L, 3, 0L);
        this.remainder(-5L, 364L, -5L);
        this.remainder(5, 367L, 5);
        this.remainder(12345565L, 3123343L, 2975536L);
        this.remainder(89912334565L, 66526576858L, 23385757707L);
        this.remainder("12345678912345678998765432198765432112348579835", "49849247825673457836783952785", "26676731909214354525437952490");
        this.remainder("1234567891234567899876543219876543218234982345789247829412348579835", "979697674643549849247825673457836783952785", "790925574855982590643417942974388632756275");
        this.remainder("49247284972849679567567886567276278257876678768612345678912345678998765432198765432112348579835", "988988908098090804984924782567345872972137987836783952785", "573526136119471212993887594038030919565414271460411480300");
        this.remainder("90989348094820347823898323489252456827598927592578925672748825789257898298482912345678912345678998765432198765432112348579835", "7834784782489249274274874782579425783456739538534949849247825673457836783952785", "5546643523640844048863099802162939135974441874753845385280281062922452880173410");
    }

    public void remainder(long a, long b, long result) {
        BigInteger bigA = new BigInteger("" + a);
        BigInteger bigB = new BigInteger("" + b);
        BigInteger bigR = bigA.remainder(bigB);
        this.th.check(bigR.toString(), String.valueOf(result), "calculating '" + a + "'.remainder(" + b + ')');
    }

    public void remainder(String a, String b, String result) {
        BigInteger bigA = new BigInteger(a);
        BigInteger bigB = new BigInteger(b);
        BigInteger bigR = bigA.remainder(bigB);
        this.th.check(bigR.toString(), result, "calculating '" + a + "'.remainder(" + b + ')');
    }

    public void test_signum() {
        this.th.checkPoint("signum()int");
        BigInteger bigi = new BigInteger("123456");
        this.th.check(bigi.signum(), 1);
        bigi = new BigInteger("-123456");
        this.th.check(bigi.signum(), -1);
        bigi = new BigInteger("0000");
        this.th.check(bigi.signum(), 0);
    }

    public void test_subtract() {
        this.th.checkPoint("subtract(java.math.BigInteger)java.math.BigInteger");
        BigInteger big = new BigInteger("12345");
        try {
            big.subtract(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.checkSubtract(12345L, 0L);
        this.checkSubtract(0L, 123445L);
        this.checkSubtract(12345L, 97887978897L);
        this.checkSubtract(123876543356523455L, 87328947988738994L);
        this.checkSubtract("123456789123456789123456789123456789", "456789123456789123456789123456789", "123000000000000000000000000000000000");
        this.checkSubtract("9832367467284628657256256234863741685483467851362486146123672641784378776837613762396194714149146384716234761234314", "9832367467284628657256256234863741685483467851362486146123672641784378776837613762396194714149146384716234761234313", "1");
    }

    private final void checkSubtract(long a, long b) {
        BigInteger bigi = new BigInteger("" + a);
        BigInteger big2 = new BigInteger("" + b);
        this.th.check(bigi.subtract(big2).toString(), "" + (a - b), "subtracting '" + a + "' - '" + b + '\'');
        this.th.check(bigi.subtract(big2.negate()).toString(), "" + (a + b), "subtracting '" + a + "' - '-" + b + '\'');
        this.th.check(bigi.negate().subtract(big2).toString(), "" + (-a - b), "subtracting '-" + a + "' - '" + b + '\'');
        this.th.check(bigi.negate().subtract(big2.negate()).toString(), "" + (-a + b), "subtracting '-" + a + "' - '-" + b + '\'');
    }

    private final void checkSubtract(String a, String b, String result) {
        BigInteger bigi = new BigInteger(a);
        BigInteger big2 = new BigInteger(b);
        this.th.check(bigi.subtract(big2).toString(), result, "subtracting '" + a + "' - '" + b + '\'');
        this.th.check(bigi.negate().subtract(big2.negate()).toString(), "-" + result, "subtracting '-" + a + "' - '-" + b + '\'');
    }

    public void test_and() {
        this.th.checkPoint("()");
    }

    public void test_andNot() {
        this.th.checkPoint("()");
    }

    public void test_bitCount() {
        this.th.checkPoint("()");
    }

    public void test_bitLength() {
        this.th.checkPoint("()");
    }

    public void test_clearBit() {
        this.th.checkPoint("()");
    }

    public void test_flipBit() {
        this.th.checkPoint("()");
    }

    public void test_getLowestSetBit() {
        this.th.checkPoint("()");
    }

    public void test_not() {
        this.th.checkPoint("()");
    }

    public void test_or() {
        this.th.checkPoint("()");
    }

    public void test_setBit() {
        this.th.checkPoint("()");
    }

    public void test_shiftLeft() {
        this.th.checkPoint("()");
    }

    public void test_shiftRight() {
        this.th.checkPoint("()");
    }

    public void test_testBit() {
        this.th.checkPoint("()");
    }

    public void test_xor() {
        this.th.checkPoint("()");
    }

    public void test_doubleValue() {
        this.th.checkPoint("doubleValue()double");
        this.check_doubleValue("4");
        this.check_doubleValue("40");
        this.check_doubleValue("400");
        this.check_doubleValue("412");
        this.check_doubleValue("4345");
        this.check_doubleValue("98765432198765433");
        this.check_doubleValue("9876543219876543000111000", 9.876543219876543E24);
        this.check_doubleValue("129876543219876543000111000", 1.2987654321987654E26);
        BigInteger tobig = new BigInteger("10").pow(309);
        this.th.check(tobig.doubleValue(), Double.POSITIVE_INFINITY, "checking large numbers");
        this.th.check(tobig.negate().doubleValue(), Double.NEGATIVE_INFINITY, "checking large numbers");
    }

    private final void check_doubleValue(String value) {
        this.th.check(new BigInteger(value).doubleValue(), Double.parseDouble(value), "checking parseDouble of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigInteger(value).doubleValue(), Double.parseDouble(value), "checking parseDouble of '" + value + '\'');
    }

    private final void check_doubleValue(String value, double result) {
        this.th.check(new BigInteger(value).doubleValue(), result, "checking parseDouble of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigInteger(value).doubleValue(), -result, "checking parseDouble of '" + value + '\'');
    }

    public void test_floatValue() {
        this.th.checkPoint("()");
    }

    public void test_intValue() {
        this.th.checkPoint("()");
    }

    public void test_longValue() {
        this.th.checkPoint("()");
    }

    public void test_toByteArray() {
        this.th.checkPoint("()");
    }

    public void test_valueOf() {
        this.th.checkPoint("()");
    }

    public void test_compareTo() {
        this.th.checkPoint("()");
    }

    public void test_equals() {
        this.th.checkPoint("()");
    }

    public void test_hashCode() {
        this.th.checkPoint("()");
    }

    public void test_toString() {
        this.th.checkPoint("()");
    }
}

