/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.Modifier;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.reflect.Modifier;

public class SMModifierTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.reflect.Modifier");
        this.test_constants();
        this.test_isAbstract();
        this.test_isFinal();
        this.test_isInterface();
        this.test_isNative();
        this.test_isPrivate();
        this.test_isProtected();
        this.test_isPublic();
        this.test_isStatic();
        this.test_isStrict();
        this.test_isSynchronized();
        this.test_isTransient();
        this.test_isVolatile();
        this.test_toString();
    }

    protected void test_constants() {
        this.th.checkPoint("checking modifier constants");
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
        this.th.check(true);
    }

    protected void test_isAbstract() {
        this.th.checkPoint("isAbstract(int)boolean");
        this.th.check(Modifier.isAbstract(1024), "its number");
        this.th.check(Modifier.isAbstract(1096), "its number is included");
        this.th.check(Modifier.isAbstract(24) ^ true, "not abstract -- 1");
        this.th.check(Modifier.isAbstract(1023) ^ true, "not abstract -- 2");
    }

    protected void test_isFinal() {
        this.th.checkPoint("isFinal(int)boolean");
        this.th.check(Modifier.isFinal(16), "its number");
        this.th.check(Modifier.isFinal(48), "its number is included -- 1");
        this.th.check(Modifier.isFinal(57), "its number is included -- 2");
        this.th.check(Modifier.isFinal(64) ^ true, "not final -- 1");
        this.th.check(Modifier.isFinal(15) ^ true, "not final -- 2");
    }

    protected void test_isInterface() {
        this.th.checkPoint("isInterface(int)boolean");
        this.th.check(Modifier.isInterface(512), "its number");
        this.th.check(Modifier.isInterface(540), "its number is included -- 1");
        this.th.check(Modifier.isInterface(1600), "its number is included -- 2");
        this.th.check(Modifier.isInterface(511) ^ true, "not an Interface -- 1");
        this.th.check(Modifier.isInterface(1024) ^ true, "not an Interface -- 2");
    }

    protected void test_isNative() {
        this.th.checkPoint("isNative(int)boolean");
        this.th.check(Modifier.isNative(256), "its number");
        this.th.check(Modifier.isNative(435), "its number is included -- 1");
        this.th.check(Modifier.isNative(780), "its number is included -- 2");
        this.th.check(Modifier.isNative(513) ^ true, "not native -- 1");
        this.th.check(Modifier.isNative(255) ^ true, "not native -- 2");
    }

    protected void test_isPrivate() {
        this.th.checkPoint("isPrivate(int)boolean");
        this.th.check(Modifier.isPrivate(2), "its number");
        this.th.check(Modifier.isPrivate(6), "its number is included -- 1");
        this.th.check(Modifier.isPrivate(66), "its number is included -- 2");
        this.th.check(Modifier.isPrivate(1) ^ true, "not private -- 1");
        this.th.check(Modifier.isPrivate(5) ^ true, "not private -- 2");
    }

    protected void test_isProtected() {
        this.th.checkPoint("isProtected(int)boolean");
        this.th.check(Modifier.isProtected(4), "its number");
        this.th.check(Modifier.isProtected(6), "its number is included -- 1");
        this.th.check(Modifier.isProtected(68), "its number is included -- 2");
        this.th.check(Modifier.isProtected(64) ^ true, "not protected -- 1");
        this.th.check(Modifier.isProtected(3) ^ true, "not protected -- 2");
    }

    protected void test_isPublic() {
        this.th.checkPoint("isPublic(int)boolean");
        this.th.check(Modifier.isPublic(1), "its number");
        this.th.check(Modifier.isPublic(3), "its number is included -- 1");
        this.th.check(Modifier.isPublic(77), "its number is included -- 2");
        this.th.check(Modifier.isPublic(2) ^ true, "not public -- 1");
        this.th.check(Modifier.isPublic(888456) ^ true, "not public --2 ");
    }

    protected void test_isStatic() {
        this.th.checkPoint("isStatic(int)boolean");
        this.th.check(Modifier.isStatic(8), "its number");
        this.th.check(Modifier.isStatic(14), "its number is included -- 1");
        this.th.check(Modifier.isStatic(25), "its number is included -- 2");
        this.th.check(Modifier.isStatic(7) ^ true, "not static -- 1");
        this.th.check(Modifier.isStatic(17) ^ true, "not static -- 2");
    }

    protected void test_isStrict() {
        this.th.checkPoint("isStrict(int)boolean");
        this.th.check(Modifier.isStrict(2048), "its number");
        this.th.check(Modifier.isStrict(3111), "its number is included -- 1");
        this.th.check(Modifier.isStrict(6234), "its number is included -- 2");
        this.th.check(Modifier.isStrict(2047) ^ true, "not strict -- 1");
        this.th.check(Modifier.isStrict(5000) ^ true, "not strict -- 2");
    }

    protected void test_isSynchronized() {
        this.th.checkPoint("isSynchronized(int)boolean");
        this.th.check(Modifier.isSynchronized(32), "its number");
        this.th.check(Modifier.isSynchronized(35), "its number is included -- 1");
        this.th.check(Modifier.isSynchronized(99), "its number is included -- 2");
        this.th.check(Modifier.isSynchronized(65) ^ true, "not synchronized -- 1");
        this.th.check(Modifier.isSynchronized(31) ^ true, "not synchronized -- 2");
    }

    protected void test_isTransient() {
        this.th.checkPoint("isTransient(int)boolean");
        this.th.check(Modifier.isTransient(128), "its number");
        this.th.check(Modifier.isTransient(231), "its number is included -- 1");
        this.th.check(Modifier.isTransient(1157), "its number is included -- 2");
        this.th.check(Modifier.isTransient(127) ^ true, "not transient -- 1");
        this.th.check(Modifier.isTransient(311) ^ true, "not transient -- 2");
    }

    protected void test_isVolatile() {
        this.th.checkPoint("isVolatile(int)boolean");
        this.th.check(Modifier.isVolatile(64), "its number");
        this.th.check(Modifier.isVolatile(127), "its number is included -- 1");
        this.th.check(Modifier.isVolatile(320), "its number is included -- 2");
        this.th.check(Modifier.isVolatile(319) ^ true, "not volatile -- 1");
        this.th.check(Modifier.isVolatile(63) ^ true, "not volatile -- 2");
    }

    protected void test_toString() {
        this.th.checkPoint("toString(int)java.lang.String");
        this.th.check(Modifier.toString(2047).equals("public protected private abstract static final transient volatile native synchronized interface"), "checking toString order");
        this.th.check(Modifier.toString(4095).equals("public protected private abstract static final transient volatile native synchronized interface strict"), "checking toString order");
        System.out.println(Modifier.toString(4095));
    }
}

