/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.Array;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.reflect.Array;

public class SMArrayTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.reflect.Array");
        this.test_newInstance();
        this.test_getLength();
        this.test_get();
        this.test_getBoolean();
        this.test_getByte();
        this.test_getChar();
        this.test_getDouble();
        this.test_getFloat();
        this.test_getInt();
        this.test_getLong();
        this.test_getShort();
        this.test_set();
        this.test_setBoolean();
        this.test_setByte();
        this.test_setChar();
        this.test_setDouble();
        this.test_setFloat();
        this.test_setInt();
        this.test_setLong();
        this.test_setShort();
    }

    protected void test_newInstance() {
        this.th.checkPoint("newInstance(java.lang.Class,int)java.lang.Object");
        Object oa = Array.newInstance(Integer.TYPE, 10);
        this.th.check(oa.getClass().isArray(), "oa should be an Array");
        int[] ia = (int[])Array.newInstance(Integer.TYPE, 10);
        boolean bl = false;
        if (ia.length == 10) {
            bl = true;
        }
        this.th.check(bl, "ia.length = " + ia.length + ", should be 10");
        try {
            ia[9] = 10;
            this.th.check(true);
            boolean bl2 = false;
            if (ia[9] == 10) {
                bl2 = true;
            }
            this.th.check(bl2, "array is not correctly implemented");
        }
        catch (Exception e) {
            this.th.fail("no exception expected");
        }
        try {
            ia[10] = 10;
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (Exception e) {
            this.th.check(true);
        }
        try {
            oa = Array.newInstance(Float.TYPE, -1);
            this.th.fail("should throw an NegativeArraySizeException");
        }
        catch (NegativeArraySizeException ne) {
            this.th.check(true);
        }
        try {
            oa = Array.newInstance(Float.TYPE, 0);
            this.th.check(true);
            boolean bl3 = false;
            if (oa != null) {
                bl3 = true;
            }
            this.th.check(bl3);
        }
        catch (NegativeArraySizeException ne) {
            this.th.fail("should throw not NegativeArraySizeException");
        }
        this.th.checkPoint("newInstance(java.lang.Class,int[])java.lang.Object");
        ia = new int[10];
        oa = Array.newInstance(Integer.TYPE, ia);
        this.th.check(oa.getClass().isArray(), "oa should be an Array");
        ia = (int[])Array.newInstance(Integer.TYPE, 256);
        int i = 0;
        while (i < 256) {
            ia[i] = 10;
            ++i;
        }
        try {
            oa = Array.newInstance(Integer.TYPE, ia);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        ia = new int[]{};
        try {
            oa = Array.newInstance(Integer.TYPE, ia);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
    }

    protected void test_getLength() {
        this.th.checkPoint("getLength(java.lang.Object)int");
        int[] ia = null;
        try {
            Array.getLength(ia);
            this.th.fail("should throw an NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Object oa = Array.newInstance(Integer.TYPE, 2);
        try {
            this.th.check(Array.getLength(oa), 2, "length should be 2");
            this.th.check(true);
        }
        catch (IllegalArgumentException ie) {
            this.th.fail("should not throw IllegalArgumentException, got:" + ie);
        }
        oa = new Object();
        try {
            Array.getLength(oa);
            this.th.fail("should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
        ia = (int[])Array.newInstance(Integer.TYPE, 25);
        int i = 0;
        while (i < 25) {
            ia[i] = 10;
            ++i;
        }
        boolean bl = false;
        if (Array.getLength(ia) == 25) {
            bl = true;
        }
        this.th.check(bl, "length is the number of dimensions");
        boolean bl2 = false;
        if (ia.length == 25) {
            bl2 = true;
        }
        this.th.check(bl2, "test covers also newIstance()");
    }

    protected void test_get() {
        this.th.checkPoint("get(java.lang.Object,int)java.lang.Object");
        boolean[] ba = new boolean[2];
        ba[1] = true;
        ba[0] = false;
        Object ro = Array.get(ba, 1);
        this.th.check(ro instanceof Boolean, "get() failed  -- 1 ");
        this.th.check((Boolean)ro, "wrong boolean value returned -- 2");
        byte[] bta = new byte[2];
        bta[1] = 13;
        bta[0] = 23;
        ro = Array.get(bta, 1);
        this.th.check(ro instanceof Byte, "get() failed  -- 3 ");
        boolean bl = false;
        if ((Byte)ro == 13) {
            bl = true;
        }
        this.th.check(bl, "wrong byte value returned -- 4 ,got:" + ro);
        char[] ca = new char[2];
        ca[1] = 116;
        ca[0] = 102;
        ro = Array.get(ca, 0);
        this.th.check(ro instanceof Character, "get() failed  -- 5 ");
        boolean bl2 = false;
        if (((Character)ro).charValue() == 'f') {
            bl2 = true;
        }
        this.th.check(bl2, "wrong char value returned -- 6 ,got:" + ro);
        double[] da = new double[2];
        da[1] = 3;
        da[0] = 2;
        ro = Array.get(da, 1);
        this.th.check(ro instanceof Double, "get() failed  -- 7 ");
        boolean bl3 = false;
        if ((Double)ro == (double)3) {
            bl3 = true;
        }
        this.th.check(bl3, "wrong double value returned -- 8  ,got:" + ro);
        boolean bl4 = false;
        if (da[1] == (double)3) {
            bl4 = true;
        }
        this.th.check(bl4, "basic check");
        float[] fa = new float[2];
        fa[1] = 3.6f;
        fa[0] = 2.5f;
        ro = Array.get(fa, 0);
        this.th.check(ro instanceof Float, "get() failed  -- 9 ");
        boolean bl5 = false;
        if (((Float)ro).floatValue() == 2.5f) {
            bl5 = true;
        }
        this.th.check(bl5, "wrong float value returned -- 10  ,got:" + ro);
        int[] ia = new int[2];
        ia[1] = 23;
        ia[0] = 45;
        ro = Array.get(ia, 1);
        this.th.check(ro instanceof Integer, "get() failed  -- 11 ");
        boolean bl6 = false;
        if ((Integer)ro == 23) {
            bl6 = true;
        }
        this.th.check(bl6, "wrong int value returned -- 12  ,got:" + ro);
        long[] la = new long[2];
        la[1] = 123L;
        la[0] = 213L;
        ro = Array.get(la, 1);
        this.th.check(ro instanceof Long, "get() failed  -- 13 ");
        boolean bl7 = false;
        if ((Long)ro == 123L) {
            bl7 = true;
        }
        this.th.check(bl7, "wrong long value returned -- 14  ,got:" + ro);
        short[] sa = new short[2];
        sa[1] = 12;
        sa[0] = 21;
        ro = Array.get(sa, 1);
        this.th.check(ro instanceof Short, "get() failed  -- 15 ");
        boolean bl8 = false;
        if ((Short)ro == 12) {
            bl8 = true;
        }
        this.th.check(bl8, "wrong short value returned --16 ,got:" + ro);
        Object[] oa = new Object[]{this, null};
        ro = Array.get(oa, 0);
        this.th.check(ro.equals(this), "get returned wrong Object");
        ro = Array.get(oa, 1);
        boolean bl9 = false;
        if (ro == null) {
            bl9 = true;
        }
        this.th.check(bl9, "null objects are allowed!");
        try {
            Array.get(oa, -1);
            this.th.fail("ArrayIndexOutOfBoundsException should be thrown");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.get(oa, 10);
            this.th.fail("ArrayIndexOutOfBoundsException should be thrown");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        oa = null;
        try {
            Array.get(oa, 0);
            this.th.fail("NullPointerException should be thrown");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    protected void test_getBoolean() {
        this.th.checkPoint("getBoolean(java.lang.Object,int)boolean");
        boolean[] ba = new boolean[10];
        int i = 0;
        while (i < 10) {
            ba[i] = true;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            this.th.check(Array.getBoolean(ba, j), "retrieved wrong value -- " + j);
            ++j;
        }
        ba[0] = false;
        this.th.check(Array.getBoolean(ba, 0) ^ true, "retrieved wrong value -- 11");
        try {
            Array.getBoolean(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getBoolean(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getBoolean(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getBoolean(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        short[] sa = new short[2];
        sa[1] = 12;
        sa[0] = 21;
        try {
            Array.getBoolean(sa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        Object[] ob = (Object[])Array.newInstance(new Boolean(false).getClass(), 2);
        ob[1] = ob[0] = new Boolean(false);
        try {
            Array.getBoolean(ob, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
    }

    protected void test_getByte() {
        this.th.checkPoint("getByte(java.lang.Object,int)byte");
        byte[] ba = new byte[10];
        int i = 0;
        while (i < 10) {
            ba[i] = (byte)i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getByte(ba, j) == (byte)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getByte(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getByte(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getByte(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getByte(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        short[] sa = new short[2];
        sa[1] = 12;
        sa[0] = 21;
        try {
            Array.getByte(sa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
    }

    protected void test_getChar() {
        this.th.checkPoint("getChar(java.lang.Object,int)char");
        char[] ba = new char[10];
        int i = 0;
        while (i < 10) {
            ba[i] = (char)i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getChar(ba, j) == (char)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getChar(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getChar(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getChar(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getChar(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        short[] sa = new short[2];
        sa[1] = 12;
        sa[0] = 21;
        try {
            Array.getChar(sa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        byte[] bta = new byte[2];
        bta[1] = 12;
        bta[0] = 21;
        try {
            Array.getChar(bta, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
    }

    protected void test_getDouble() {
        double d;
        this.th.checkPoint("getDouble(java.lang.Object,int)double");
        double[] ba = new double[10];
        int i = 0;
        while (i < 10) {
            ba[i] = i;
            ++i;
        }
        Array.get(ba, 1);
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if ((Double)Array.get(ba, j) == (double)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- a " + j);
            boolean bl2 = false;
            if (Array.getDouble(ba, j) == (double)j) {
                bl2 = true;
            }
            this.th.check(bl2, "retrieved wrong value -- b " + j);
            ++j;
        }
        try {
            Array.getDouble(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getDouble(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getDouble(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getDouble(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException --  1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        boolean[] wa = new boolean[2];
        wa[1] = false;
        wa[0] = true;
        try {
            Array.getDouble(wa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        float[] fa = new float[2];
        fa[1] = 1.2f;
        fa[0] = 2.3f;
        try {
            d = Array.getDouble(fa, 1);
            boolean bl = false;
            if (d == (double)1.2f) {
                bl = true;
            }
            this.th.check(bl, "checking value of float");
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 1");
        }
        long[] la = new long[2];
        la[1] = 1L;
        la[0] = 2;
        try {
            d = Array.getDouble(la, 1);
            boolean bl = false;
            if (d == 1.0) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 2");
        }
        int[] ia = new int[2];
        ia[1] = 1;
        ia[0] = 2;
        try {
            Array.getDouble(ia, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 3");
        }
        char[] ca = new char[2];
        ca[1] = 102;
        ca[0] = 97;
        try {
            Array.getDouble(ca, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 4");
        }
        byte[] bta = new byte[2];
        bta[1] = 1;
        bta[0] = 1;
        try {
            Array.getDouble(bta, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 5");
        }
        short[] sa = new short[2];
        sa[1] = 1;
        sa[0] = 1;
        try {
            Array.getDouble(sa, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 6");
        }
    }

    protected void test_getFloat() {
        this.th.checkPoint("getFloat(java.lang.Object,int)float");
        float[] ba = new float[10];
        int i = 0;
        while (i < 10) {
            ba[i] = i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getFloat(ba, j) == (float)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getFloat(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getFloat(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getFloat(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getFloat(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        boolean[] wa = new boolean[2];
        wa[1] = false;
        wa[0] = true;
        try {
            Array.getFloat(wa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        double[] da = new double[2];
        da[1] = 1.2;
        da[0] = 2.3;
        try {
            Array.getFloat(da, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        long[] la = new long[2];
        la[1] = 1L;
        la[0] = 2;
        try {
            Array.getFloat(la, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 1");
        }
        int[] ia = new int[2];
        ia[1] = 1;
        ia[0] = 2;
        try {
            Array.getFloat(ia, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 2");
        }
        char[] ca = new char[2];
        ca[1] = 102;
        ca[0] = 97;
        try {
            Array.getFloat(ca, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 3");
        }
        byte[] bta = new byte[2];
        bta[1] = 1;
        bta[0] = 1;
        try {
            Array.getFloat(bta, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 4");
        }
        short[] sa = new short[2];
        sa[1] = 1;
        sa[0] = 1;
        try {
            Array.getFloat(sa, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 5");
        }
    }

    protected void test_getInt() {
        this.th.checkPoint("getInt(java.lang.Object,int)int");
        int[] ba = new int[10];
        int i = 0;
        while (i < 10) {
            ba[i] = i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getInt(ba, j) == j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getInt(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getInt(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getInt(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getInt(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        boolean[] wa = new boolean[2];
        wa[1] = false;
        wa[0] = true;
        try {
            Array.getInt(wa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        double[] da = new double[2];
        da[1] = 1.2;
        da[0] = 2.3;
        try {
            Array.getInt(da, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        float[] fa = new float[2];
        fa[1] = 1.2f;
        fa[0] = 2.3f;
        try {
            Array.getInt(fa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        long[] la = new long[2];
        la[1] = 12L;
        la[0] = 343443L;
        try {
            Array.getInt(la, 1);
            this.th.fail("should throw an IllegalArgumentException -- 5");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        char[] ca = new char[2];
        ca[1] = 102;
        ca[0] = 97;
        try {
            Array.getInt(ca, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 1");
        }
        byte[] bta = new byte[2];
        bta[1] = 1;
        bta[0] = 1;
        try {
            Array.getInt(bta, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 2");
        }
        short[] sa = new short[2];
        sa[1] = 1;
        sa[0] = 1;
        try {
            Array.getInt(sa, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 3");
        }
    }

    protected void test_getLong() {
        this.th.checkPoint("getLong(java.lang.Object,int)long");
        long[] ba = new long[10];
        int i = 0;
        while (i < 10) {
            ba[i] = i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getLong(ba, j) == (long)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getLong(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getLong(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getLong(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getLong(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        boolean[] wa = new boolean[2];
        wa[1] = false;
        wa[0] = true;
        try {
            Array.getLong(wa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        double[] da = new double[2];
        da[1] = 1.2;
        da[0] = 2.3;
        try {
            Array.getLong(da, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        float[] fa = new float[2];
        fa[1] = 1.2f;
        fa[0] = 2.3f;
        try {
            Array.getLong(fa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        int[] ia = new int[2];
        ia[1] = 1;
        ia[0] = 2;
        try {
            Array.getLong(ia, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 1");
        }
        char[] ca = new char[2];
        ca[1] = 102;
        ca[0] = 97;
        try {
            Array.getLong(ca, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 2");
        }
        byte[] bta = new byte[2];
        bta[1] = 1;
        bta[0] = 1;
        try {
            Array.getLong(bta, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 3");
        }
        short[] sa = new short[2];
        sa[1] = 1;
        sa[0] = 1;
        try {
            Array.getLong(sa, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException -- 4");
        }
    }

    protected void test_getShort() {
        this.th.checkPoint("getShort(java.lang.Object,int)short");
        short[] ba = new short[10];
        int i = 0;
        while (i < 10) {
            ba[i] = (short)i;
            ++i;
        }
        int j = 0;
        while (j < 10) {
            boolean bl = false;
            if (Array.getShort(ba, j) == (short)j) {
                bl = true;
            }
            this.th.check(bl, "retrieved wrong value -- " + j);
            ++j;
        }
        try {
            Array.getShort(ba, -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            Array.getShort(ba, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        ba = null;
        try {
            Array.getShort(ba, 1);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            Array.getShort(new Object(), 1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        boolean[] wa = new boolean[2];
        wa[1] = false;
        wa[0] = true;
        try {
            Array.getShort(wa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        double[] da = new double[2];
        da[1] = 1.2;
        da[0] = 2.3;
        try {
            Array.getShort(da, 1);
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        float[] fa = new float[2];
        fa[1] = 1.2f;
        fa[0] = 2.3f;
        try {
            Array.getShort(fa, 1);
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        long[] la = new long[2];
        la[1] = 12L;
        la[0] = 343443L;
        try {
            Array.getShort(la, 1);
            this.th.fail("should throw an IllegalArgumentException -- 5");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        char[] ca = new char[2];
        ca[1] = 76;
        ca[0] = 76;
        try {
            Array.getShort(ca, 1);
            this.th.fail("should throw an IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        int[] ia = new int[2];
        ia[1] = 12;
        ia[0] = 343;
        try {
            Array.getShort(ia, 1);
            this.th.fail("should throw an IllegalArgumentException -- 7");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        byte[] bta = new byte[2];
        bta[1] = 1;
        bta[0] = 1;
        try {
            Array.getShort(bta, 1);
            this.th.check(true);
        }
        catch (IllegalArgumentException ne) {
            this.th.fail("shouldn't throw an IllegalArgumentException");
        }
    }

    protected void test_set() {
    }

    protected void test_setBoolean() {
    }

    protected void test_setByte() {
    }

    protected void test_setChar() {
    }

    protected void test_setDouble() {
    }

    protected void test_setFloat() {
    }

    protected void test_setInt() {
    }

    protected void test_setLong() {
    }

    protected void test_setShort() {
    }
}

