/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.AccessibleObject;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.lang.reflect.AccessibleObject.help.hlpclass1;
import gnu.testlet.wonka.lang.reflect.AccessibleObject.help.hlpclass2;
import gnu.testlet.wonka.lang.reflect.AccessibleObject.hlpclass;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SMAccessibleObject
extends hlpclass2
implements Testlet {
    protected static TestHarness th;
    protected static Field[] flds;
    protected static Field[] flds1;
    protected static Field[] flds2;
    protected static Field[] fldsthis;
    protected static Method[] mtds;
    protected static Method[] mtds1;
    protected static Method[] mtds2;
    protected static Method[] mtdsthis;
    protected static Constructor[] cons;
    protected static Constructor[] cons1;
    protected static Constructor[] cons2;
    protected static Constructor[] consthis;
    private int thisipr = 4;
    public int thisipu = 1;
    protected int thisipt = 2;
    int thisidef = 3;
    static /* synthetic */ Class class$java$lang$Object;

    public void test(TestHarness testharness) {
        th = testharness;
        th.setclass("java.lang.reflect.AccessibleObject");
        th.checkPoint("isAccessible()boolean");
        this.test_isAccessible();
        this.test_setAccessible();
        if (this.setupReflection()) {
            th.checkPoint("access on fields");
            this.test_fieldAccess();
            th.checkPoint("access on methods");
            this.test_MethodAccess();
            th.checkPoint("access on constructors");
            this.test_ConstructorAccess();
        }
        if (this.setupReflection()) {
            th.checkPoint("Static access on fields");
            SMAccessibleObject.test_staticFieldAccess(this);
            RefTest.main(null);
            th.checkPoint("Static access on methods");
            SMAccessibleObject.test_staticMethodAccess(this);
            th.checkPoint("Static access on constructors");
            this.test_staticConstructorAccess(this);
        }
    }

    public void test_isAccessible() {
        Field f = null;
        hlpclass hc = new hlpclass();
        try {
            f = hc.getClass().getDeclaredField("ipu");
            th.check(!f.isAccessible(), "should be Accessible");
            th.check(f.getInt(hc) == 3, "access granted");
        }
        catch (Exception e) {
            th.fail("no Exceptions expected");
        }
        try {
            f = hc.getClass().getDeclaredField("ipt");
            th.check(!f.isAccessible(), "shouldn't  be Accessible");
        }
        catch (Exception e) {
            th.fail("no Exceptions expected");
        }
        try {
            th.check(f.getInt(hc) == 3, "access granted");
        }
        catch (Exception e) {
            th.fail("no Exceptions expected");
        }
        try {
            f = hc.getClass().getDeclaredField("ipr");
            th.check(!f.isAccessible(), "shouldn't  be Accessible");
        }
        catch (Exception e) {
            th.fail("no Exceptions expected");
        }
        try {
            f.getInt(hc);
            th.fail("Exception expected");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            f.setAccessible(true);
            th.check(f.getInt(hc) == 3, "access granted");
        }
        catch (Exception e) {
            th.fail("no Exceptions expected");
        }
    }

    public void test_setAccessible() {
        th.checkPoint("setAccessible(boolean)void");
        hlpclass hc = new hlpclass();
        Field f = null;
        try {
            f = hc.getClass().getDeclaredField("ipr");
            f.setAccessible(true);
            th.check(f.isAccessible(), "should be set to true");
            f.setAccessible(true);
            th.check(f.isAccessible(), "should still be true");
            f.setAccessible(false);
            th.check(!f.isAccessible(), "should be set to false now");
            f.setAccessible(false);
            th.check(!f.isAccessible(), "should still be false");
        }
        catch (Exception e) {
            th.fail("no Exception expected");
        }
        th.checkPoint("setAccessible(java.lang.reflect.AccessibleObject[],boolean)void");
        Field f1 = null;
        Field f2 = null;
        try {
            f1 = hc.getClass().getDeclaredField("ipt");
            f2 = hc.getClass().getDeclaredField("ipu");
            AccessibleObject[] aoa = new AccessibleObject[]{f, f1, f2};
            Field.setAccessible(aoa, true);
            th.check(f.isAccessible(), "should be set to true 1");
            th.check(f1.isAccessible(), "should be set to true 2");
            th.check(f2.isAccessible(), "should be set to true 3");
            Field.setAccessible(aoa, false);
            th.check(!f.isAccessible(), "should be set to false 1");
            th.check(!f1.isAccessible(), "should be set to false 2");
            th.check(!f2.isAccessible(), "should be set to false 3");
        }
        catch (Exception e) {
            th.fail("no Exception expected");
        }
    }

    public SMAccessibleObject() {
    }

    protected SMAccessibleObject(int i) {
    }

    SMAccessibleObject(float f) {
    }

    private SMAccessibleObject(Object o) {
    }

    public void publicThisMethod() {
    }

    protected void protectedThisMethod() {
    }

    void defaultThisMethod() {
    }

    private void privateThisMethod() {
    }

    public boolean setupReflection() {
        try {
            Class[] o = new Class[]{};
            Class[] i = new Class[]{Integer.TYPE};
            Class[] f = new Class[]{Float.TYPE};
            Class[] b = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SMAccessibleObject.class$("java.lang.Object")) : class$java$lang$Object};
            Class<?> c = new hlpclass().getClass();
            flds = new Field[4];
            SMAccessibleObject.flds[0] = c.getDeclaredField("ipu");
            SMAccessibleObject.flds[1] = c.getDeclaredField("ipt");
            SMAccessibleObject.flds[2] = c.getDeclaredField("idef");
            SMAccessibleObject.flds[3] = c.getDeclaredField("ipr");
            mtds = new Method[4];
            SMAccessibleObject.mtds[0] = c.getDeclaredMethod("publicMethod", o);
            SMAccessibleObject.mtds[1] = c.getDeclaredMethod("protectedMethod", o);
            SMAccessibleObject.mtds[2] = c.getDeclaredMethod("defaultMethod", o);
            SMAccessibleObject.mtds[3] = c.getDeclaredMethod("privateMethod", o);
            cons = new Constructor[4];
            SMAccessibleObject.cons[0] = c.getDeclaredConstructor(o);
            SMAccessibleObject.cons[1] = c.getDeclaredConstructor(i);
            SMAccessibleObject.cons[2] = c.getDeclaredConstructor(f);
            SMAccessibleObject.cons[3] = c.getDeclaredConstructor(b);
            c = new hlpclass1().getClass();
            flds1 = new Field[4];
            SMAccessibleObject.flds1[0] = c.getDeclaredField("ipu");
            SMAccessibleObject.flds1[1] = c.getDeclaredField("ipt");
            SMAccessibleObject.flds1[2] = c.getDeclaredField("idef");
            SMAccessibleObject.flds1[3] = c.getDeclaredField("ipr");
            mtds1 = new Method[4];
            SMAccessibleObject.mtds1[0] = c.getDeclaredMethod("publicMethod", o);
            SMAccessibleObject.mtds1[1] = c.getDeclaredMethod("protectedMethod", o);
            SMAccessibleObject.mtds1[2] = c.getDeclaredMethod("defaultMethod", o);
            SMAccessibleObject.mtds1[3] = c.getDeclaredMethod("privateMethod", o);
            cons1 = new Constructor[4];
            SMAccessibleObject.cons1[0] = c.getDeclaredConstructor(o);
            SMAccessibleObject.cons1[1] = c.getDeclaredConstructor(i);
            SMAccessibleObject.cons1[2] = c.getDeclaredConstructor(f);
            SMAccessibleObject.cons1[3] = c.getDeclaredConstructor(b);
            c = new hlpclass2().getClass();
            flds2 = new Field[5];
            SMAccessibleObject.flds2[0] = c.getDeclaredField("ipu");
            SMAccessibleObject.flds2[1] = c.getDeclaredField("ipt");
            SMAccessibleObject.flds2[2] = c.getDeclaredField("idef");
            SMAccessibleObject.flds2[3] = c.getDeclaredField("ipr");
            SMAccessibleObject.flds2[4] = c.getDeclaredField("ispt");
            mtds2 = new Method[5];
            SMAccessibleObject.mtds2[0] = c.getDeclaredMethod("publicMethod", o);
            SMAccessibleObject.mtds2[1] = c.getDeclaredMethod("protectedMethod", o);
            SMAccessibleObject.mtds2[2] = c.getDeclaredMethod("defaultMethod", o);
            SMAccessibleObject.mtds2[3] = c.getDeclaredMethod("privateMethod", o);
            SMAccessibleObject.mtds2[4] = c.getDeclaredMethod("protectedStaticMethod", o);
            cons2 = new Constructor[4];
            SMAccessibleObject.cons2[0] = c.getDeclaredConstructor(o);
            SMAccessibleObject.cons2[1] = c.getDeclaredConstructor(i);
            SMAccessibleObject.cons2[2] = c.getDeclaredConstructor(f);
            SMAccessibleObject.cons2[3] = c.getDeclaredConstructor(b);
            c = this.getClass();
            fldsthis = new Field[4];
            SMAccessibleObject.fldsthis[0] = c.getDeclaredField("thisipu");
            SMAccessibleObject.fldsthis[1] = c.getDeclaredField("thisipt");
            SMAccessibleObject.fldsthis[2] = c.getDeclaredField("thisidef");
            SMAccessibleObject.fldsthis[3] = c.getDeclaredField("thisipr");
            mtdsthis = new Method[4];
            SMAccessibleObject.mtdsthis[0] = c.getDeclaredMethod("publicThisMethod", o);
            SMAccessibleObject.mtdsthis[1] = c.getDeclaredMethod("protectedThisMethod", o);
            SMAccessibleObject.mtdsthis[2] = c.getDeclaredMethod("defaultThisMethod", o);
            SMAccessibleObject.mtdsthis[3] = c.getDeclaredMethod("privateThisMethod", o);
            consthis = new Constructor[4];
            SMAccessibleObject.consthis[0] = c.getDeclaredConstructor(o);
            SMAccessibleObject.consthis[1] = c.getDeclaredConstructor(i);
            SMAccessibleObject.consthis[2] = c.getDeclaredConstructor(f);
            SMAccessibleObject.consthis[3] = c.getDeclaredConstructor(b);
            return true;
        }
        catch (Exception e) {
            th.fail("failed to setup reflecftion");
            e.printStackTrace();
            return false;
        }
    }

    public void test_fieldAccess() {
        try {
            th.check(fldsthis[0].getInt(this), 1, "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[1].getInt(this), 2, "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[2].getInt(this), 3, "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[3].getInt(this), 4, "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            fldsthis[0].setAccessible(false);
            th.check(fldsthis[0].getInt(this), 1, "access on same class -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        hlpclass hc = new hlpclass();
        try {
            th.check(flds[0].getInt(hc), 3, "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(flds[1].getInt(hc), 3, "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(flds[2].getInt(hc), 4, "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds[3].getInt(hc);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds[3].setAccessible(true);
            th.check(flds[3].getInt(hc), 3, "access on class in same package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        hlpclass2 hc2 = new hlpclass2();
        try {
            th.check(flds2[0].getInt(hc2), 1, "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[1].getInt(hc2);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            th.check(flds2[1].getInt(this), 2, "access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false, "no exception wanted");
        }
        try {
            flds2[2].getInt(hc2);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds2[3].getInt(hc2);
            th.fail("access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds2[1].setAccessible(true);
            th.check(flds2[1].getInt(hc2), 2, "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[2].setAccessible(true);
            th.check(flds2[2].getInt(hc2), 3, "access on superclass in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[3].setAccessible(true);
            th.check(flds2[3].getInt(hc2), 4, "access on superclass in other package -- 8");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[4].getInt(this);
            th.fail("access on superclass in other package -- 9");
        }
        catch (IllegalAccessException e) {
            th.check(true, "IllegalAccessException was wanted");
        }
        try {
            flds2[4].getInt(hc2);
            th.fail("access on superclass in other package -- 10");
        }
        catch (IllegalAccessException e) {
            th.check(true, "IllegalAccessException was wanted");
        }
        try {
            flds2[4].setAccessible(true);
            th.check(flds2[4].getInt(this), 5, "access on superclass in other package -- 11");
        }
        catch (IllegalAccessException e) {
            th.check(false, "IllegalAccessException was not wanted");
        }
        hlpclass1 hc1 = new hlpclass1();
        try {
            th.check(flds1[0].getInt(hc1), 1, "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[1].getInt(hc1);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[2].getInt(hc1);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[3].getInt(hc1);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[1].setAccessible(true);
            th.check(flds1[1].getInt(hc1), 2, "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[2].setAccessible(true);
            th.check(flds1[2].getInt(hc1), 3, "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[3].setAccessible(true);
            th.check(flds1[3].getInt(hc1), 4, "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
    }

    public void test_MethodAccess() {
        Object[] o = new Object[]{};
        try {
            th.check(mtdsthis[0].invoke((Object)this, o), null, "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[1].invoke((Object)this, o), null, "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[2].invoke((Object)this, o), null, "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[3].invoke((Object)this, o), null, "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtdsthis[3].setAccessible(false);
            th.check(mtdsthis[3].invoke((Object)this, o), null, "access on same class -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on same class -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass hc = new hlpclass();
        try {
            th.check(mtds[0].invoke((Object)hc, o), null, "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtds[1].invoke((Object)hc, o), null, "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtds[2].invoke((Object)hc, o), null, "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds[3].invoke((Object)hc, o);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds[3].setAccessible(true);
            th.check(mtds[3].invoke((Object)hc, o), null, "access on class in same package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass2 hc2 = new hlpclass2();
        try {
            th.check(mtds2[0].invoke((Object)hc2, o), null, "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[1].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtds2[1].invoke((Object)this, o), null, "access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[2].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[3].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[1].setAccessible(true);
            th.check(mtds2[1].invoke((Object)hc2, o), null, "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 6 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[2].setAccessible(true);
            th.check(mtds2[2].invoke((Object)hc2, o), null, "access on class in same package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 7 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[3].setAccessible(true);
            th.check(mtds2[3].invoke((Object)hc2, o), null, "access on class in same package -- 8");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 8 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[4].invoke(null, o);
            th.fail("access on superclass in other package -- 9");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[4].setAccessible(true);
            th.check(mtds2[4].invoke(null, o), null, "access on class in same package -- 10");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 10 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass1 hc1 = new hlpclass1();
        try {
            th.check(mtds1[0].invoke((Object)hc1, o), null, "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[1].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[2].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[3].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[1].setAccessible(true);
            th.check(mtds1[1].invoke((Object)hc1, o), null, "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[2].setAccessible(true);
            th.check(mtds1[2].invoke((Object)hc1, o), null, "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 6 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[3].setAccessible(true);
            th.check(mtds1[3].invoke((Object)hc1, o), null, "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 7 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
    }

    public void test_ConstructorAccess() {
        Object[] o = new Object[]{};
        Object[] i = new Object[]{new Integer(5)};
        Object[] f = new Object[]{new Float(5.0f)};
        Object[] b = new Object[]{new Object()};
        try {
            th.check(consthis[0].newInstance(o).getClass(), this.getClass(), "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[1].newInstance(i).getClass(), this.getClass(), "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[2].newInstance(f).getClass(), this.getClass(), "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[3].newInstance(b).getClass(), this.getClass(), "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        Object c = new hlpclass();
        try {
            th.check(cons[0].newInstance(o).getClass(), c.getClass(), "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(cons[1].newInstance(i).getClass(), c.getClass(), "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(cons[2].newInstance(f).getClass(), c.getClass(), "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons[3].newInstance(b);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons[3].setAccessible(true);
            th.check(cons[3].newInstance(b).getClass(), c.getClass(), "access on class in same package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        c = new hlpclass2();
        try {
            th.check(cons2[0].newInstance(o).getClass(), c.getClass(), "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[1].newInstance(i);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[2].newInstance(f);
            th.fail("access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[3].newInstance(b);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[1].setAccessible(true);
            th.check(cons2[1].newInstance(i).getClass(), c.getClass(), "access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[2].setAccessible(true);
            th.check(cons2[2].newInstance(f).getClass(), c.getClass(), "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 6 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[3].setAccessible(true);
            th.check(cons2[3].newInstance(b).getClass(), c.getClass(), "access on superclass in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 7 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        c = new hlpclass1();
        try {
            th.check(cons1[0].newInstance(o).getClass(), c.getClass(), "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[1].newInstance(i);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[2].newInstance(f);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[3].newInstance(b);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[1].setAccessible(true);
            th.check(cons1[1].newInstance(i).getClass(), c.getClass(), "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[2].setAccessible(true);
            th.check(cons1[2].newInstance(f).getClass(), c.getClass(), "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 6 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[3].setAccessible(true);
            th.check(cons1[3].newInstance(b).getClass(), c.getClass(), "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 7 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
    }

    public static void test_staticFieldAccess(SMAccessibleObject object) {
        try {
            th.check(fldsthis[0].getInt(object), 1, "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[1].getInt(object), 2, "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[2].getInt(object), 3, "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(fldsthis[3].getInt(object), 4, "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            fldsthis[0].setAccessible(false);
            th.check(fldsthis[0].getInt(object), 1, "access on same class -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        hlpclass hc = new hlpclass();
        try {
            th.check(flds[0].getInt(hc), 3, "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(flds[1].getInt(hc), 3, "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            th.check(flds[2].getInt(hc), 4, "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds[3].getInt(hc);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        hlpclass2 hc2 = new hlpclass2();
        try {
            th.check(flds2[0].getInt(hc2), 1, "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[1].getInt(hc2);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true, "exception wanted");
        }
        try {
            th.check(flds2[1].getInt(object), object.ipt, "access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false, "no exception wanted -- 3");
        }
        try {
            flds2[2].getInt(hc2);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds2[3].getInt(hc2);
            th.fail("access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds2[1].setAccessible(true);
            th.check(flds2[1].getInt(hc2), 2, "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[2].setAccessible(true);
            th.check(flds2[2].getInt(hc2), 3, "access on superclass in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[3].setAccessible(true);
            th.check(flds2[3].getInt(hc2), 4, "access on superclass in other package -- 8");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds2[4].getInt(object);
            th.fail("access on superclass in other package -- 9");
        }
        catch (IllegalAccessException e) {
            th.check(true, "IllegalAccessException was wanted");
        }
        try {
            flds2[4].getInt(hc2);
            th.fail("access on superclass in other package -- 10");
        }
        catch (IllegalAccessException e) {
            th.check(true, "IllegalAccessException was wanted");
        }
        try {
            flds2[4].setAccessible(true);
            th.check(flds2[4].getInt(object), 5, "access on superclass in other package -- 11");
        }
        catch (IllegalAccessException e) {
            th.check(false, "IllegalAccessException was not wanted");
        }
        hlpclass1 hc1 = new hlpclass1();
        try {
            th.check(flds1[0].getInt(hc1), 1, "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[1].getInt(hc1);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[2].getInt(hc1);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[3].getInt(hc1);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        try {
            flds1[1].setAccessible(true);
            th.check(flds1[1].getInt(hc1), 2, "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[2].setAccessible(true);
            th.check(flds1[2].getInt(hc1), 3, "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        try {
            flds1[3].setAccessible(true);
            th.check(flds1[3].getInt(hc1), 4, "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
    }

    public static void test_staticMethodAccess(SMAccessibleObject object) {
        Object[] o = new Object[]{};
        try {
            th.check(mtdsthis[0].invoke((Object)object, o), null, "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[1].invoke((Object)object, o), null, "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[2].invoke((Object)object, o), null, "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtdsthis[3].invoke((Object)object, o), null, "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtdsthis[3].setAccessible(false);
            th.check(mtdsthis[3].invoke((Object)object, o), null, "access on same class -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on same class -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass hc = new hlpclass();
        try {
            th.check(mtds[0].invoke((Object)hc, o), null, "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtds[1].invoke((Object)hc, o), null, "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            th.check(mtds[2].invoke((Object)hc, o), null, "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds[3].invoke((Object)hc, o);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds[3].setAccessible(true);
            th.check(mtds[3].invoke((Object)hc, o), null, "access on class in same package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass2 hc2 = new hlpclass2();
        try {
            th.check(mtds2[0].invoke((Object)hc2, o), null, "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[1].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[1].setAccessible(false);
            th.check(mtds2[1].invoke((Object)object, o), null, "access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false, "unwanted IllegalAccessException -- 3");
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException -- 3");
        }
        try {
            mtds2[2].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[3].invoke((Object)hc2, o);
            th.fail("access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[1].setAccessible(true);
            th.check(mtds2[1].invoke((Object)hc2, o), null, "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 6 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[2].setAccessible(true);
            th.check(mtds2[2].invoke((Object)hc2, o), null, "access on class in same package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 7 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[3].setAccessible(true);
            th.check(mtds2[3].invoke((Object)hc2, o), null, "access on class in same package -- 8");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 8 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[4].invoke(null, o);
            th.fail("access on superclass in other package -- 9");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds2[4].setAccessible(true);
            th.check(mtds2[4].invoke(null, o), null, "access on class in same package -- 10");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 10 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        hlpclass1 hc1 = new hlpclass1();
        try {
            th.check(mtds1[0].invoke((Object)hc1, o), null, "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[1].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[2].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[3].invoke((Object)hc1, o);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[1].setAccessible(true);
            th.check(mtds1[1].invoke((Object)hc1, o), null, "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 5 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[2].setAccessible(true);
            th.check(mtds1[2].invoke((Object)hc1, o), null, "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 6 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
        try {
            mtds1[3].setAccessible(true);
            th.check(mtds1[3].invoke((Object)hc1, o), null, "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 7 " + e);
        }
        catch (InvocationTargetException i) {
            th.check(false, "unwanted InvocationTargetException");
        }
    }

    public void test_staticConstructorAccess(SMAccessibleObject object) {
        Object[] o = new Object[]{};
        Object[] i = new Object[]{new Integer(5)};
        Object[] f = new Object[]{new Float(5.0f)};
        Object[] b = new Object[]{new Object()};
        try {
            th.check(consthis[0].newInstance(o).getClass(), object.getClass(), "access on same class -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[1].newInstance(i).getClass(), object.getClass(), "access on same class -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[2].newInstance(f).getClass(), object.getClass(), "access on same class -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(consthis[3].newInstance(b).getClass(), object.getClass(), "access on same class -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        Object c = new hlpclass();
        try {
            th.check(cons[0].newInstance(o).getClass(), c.getClass(), "access on class in same package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(cons[1].newInstance(i).getClass(), c.getClass(), "access on class in same package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            th.check(cons[2].newInstance(f).getClass(), c.getClass(), "access on class in same package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons[3].newInstance(b);
            th.fail("access on class in same package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons[3].setAccessible(true);
            th.check(cons[3].newInstance(b).getClass(), c.getClass(), "access on class in same package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in same package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        c = new hlpclass2();
        try {
            th.check(cons2[0].newInstance(o).getClass(), c.getClass(), "access on superclass in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[1].newInstance(i);
            th.fail("access on superclass in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[2].newInstance(f);
            th.fail("access on superclass in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[3].newInstance(b);
            th.fail("access on superclass in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[1].setAccessible(true);
            th.check(cons2[1].newInstance(i).getClass(), c.getClass(), "access on superclass in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[2].setAccessible(true);
            th.check(cons2[2].newInstance(f).getClass(), c.getClass(), "access on superclass in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 6 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons2[3].setAccessible(true);
            th.check(cons2[3].newInstance(b).getClass(), c.getClass(), "access on superclass in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on superclass in other package -- 7 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        c = new hlpclass1();
        try {
            th.check(cons1[0].newInstance(o).getClass(), c.getClass(), "access on class in other package -- 1");
        }
        catch (IllegalAccessException e) {
            th.check(false);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[1].newInstance(i);
            th.fail("access on class in other package -- 2");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[2].newInstance(f);
            th.fail("access on class in other package -- 3");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[3].newInstance(b);
            th.fail("access on class in other package -- 4");
        }
        catch (IllegalAccessException e) {
            th.check(true);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[1].setAccessible(true);
            th.check(cons1[1].newInstance(i).getClass(), c.getClass(), "access on class in other package -- 5");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 5 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[2].setAccessible(true);
            th.check(cons1[2].newInstance(f).getClass(), c.getClass(), "access on class in other package -- 6");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 6 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
        try {
            cons1[3].setAccessible(true);
            th.check(cons1[3].newInstance(b).getClass(), c.getClass(), "access on class in other package -- 7");
        }
        catch (IllegalAccessException e) {
            th.fail("access on class in other package -- 7 " + e);
        }
        catch (Exception t) {
            th.check(false, "unwanted Exception: " + t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RefTest {
        private static final long MyValue = -2767605614048989439L;
        private long value = -2123605614048989439L;

        public static void main(String[] args) {
            try {
                th.checkPoint("extra tests");
                RefTest rf = new RefTest();
                Class<?> cl = rf.getClass();
                Field myVal = cl.getDeclaredField("MyValue");
                th.check(myVal.getLong(null), -2767605614048989439L, "checking static field");
                myVal = cl.getDeclaredField("value");
                th.check(myVal.getLong(rf), rf.value, "checking instance field");
            }
            catch (Exception e) {
                th.fail("extra test failed due to " + e);
            }
        }
    }
}

