/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Byte;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class ByteTest
implements Testlet {
    protected static TestHarness harness;

    public void testConstructors() {
        harness.checkPoint("Byte(byte)");
        Byte a = new Byte(0);
        Byte b = new Byte(1);
        Byte c = new Byte(0);
        Byte d = a;
        Byte e = new Byte(14);
        byte fbyte = 102;
        Byte f = new Byte(fbyte);
        Byte g = new Byte(97);
        Integer i = new Integer(0);
        harness.checkPoint("equals(java.lang.Object)boolean");
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        harness.check(bl);
        harness.check(a.equals(null) ^ true);
        boolean bl2 = false;
        if (a != b) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.check(a.equals(b) ^ true);
        boolean bl3 = false;
        if (a != c) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(a.equals(c));
        boolean bl4 = false;
        if (a == d) {
            bl4 = true;
        }
        harness.check(bl4);
        harness.check(a.equals(d));
        boolean bl5 = false;
        if (a == a) {
            bl5 = true;
        }
        harness.check(bl5);
        harness.check(a.equals(i) ^ true);
        harness.checkPoint("byteValue()byte");
        harness.check(a.byteValue(), 0);
        harness.check(a.byteValue(), a.byteValue());
        harness.check(a.byteValue(), c.byteValue());
        harness.check(a.byteValue(), d.byteValue());
        harness.check(a.byteValue(), i);
        harness.check(b.byteValue(), 1);
        harness.check(e.byteValue(), 14);
        harness.check(f.byteValue(), fbyte);
        harness.check(g.byteValue(), 97);
        harness.check(g.byteValue(), 97);
        harness.check(g.byteValue(), 97);
        harness.checkPoint("MAX_VALUE(public)byte");
        harness.check(127, 127);
        harness.checkPoint("MIN_VALUE(public)byte");
        harness.check(-128, -128);
        harness.checkPoint("Byte(java.lang.String)");
        this.constructMustSucceed("1", 1);
        this.constructMustSucceed("127", 127);
        this.constructMustSucceed("-128", -128);
        this.constructMustFail("128");
        this.constructMustFail("-129");
        this.constructMustFail("0x77");
        this.constructMustFail("#77");
        this.constructMustFail("4f");
        this.constructMustFail("0x4f");
        this.constructMustFail(" ");
        this.constructMustFail("");
        this.constructMustFail(null);
    }

    private final void constructMustSucceed(String line, int expected) {
        try {
            Byte constructed = new Byte(line);
            harness.check(constructed.byteValue(), (byte)expected);
        }
        catch (NumberFormatException e8) {
            harness.fail("Could not construct desired value <" + line + "> ");
        }
    }

    private final void constructMustFail(String line) {
        try {
            new Byte(line);
            harness.fail("Attempt to construct out-of-range byte < " + line + " > ");
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testCompare() {
        Comparable<Character> cha2;
        Byte cha1;
        harness.checkPoint("compareTo(java.lang.Object)int");
        this.checkCompare(100, 101);
        this.checkCompare(0, 101);
        this.checkCompare(-101, -100);
        this.checkCompare(-100, 0);
        this.checkCompare(-101, 100);
        this.checkCompare(55, 127);
        this.checkCompare(-128, -55);
        try {
            cha1 = new Byte(97);
            boolean bl = false;
            if (cha1.compareTo(new Byte(97)) == 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (ClassCastException e) {
            harness.fail("Exception comparing two instances of class Byte ");
        }
        try {
            cha1 = new Byte(97);
            cha2 = new Character('a');
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
        try {
            cha1 = new Byte(97);
            cha2 = new Integer(97);
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
    }

    private final void checkCompare(int smallvalue, int bigvalue) {
        try {
            Byte smallbyte = new Byte((byte)smallvalue);
            Byte bigbyte = new Byte((byte)bigvalue);
            if (smallbyte.compareTo(bigbyte) > 0) {
                harness.fail("compareTo detected <" + smallvalue + "> bigger then <" + bigvalue + '>');
            } else if (smallbyte.compareTo(bigbyte) == 0) {
                harness.fail("compareTo detected <" + smallvalue + "> equal to <" + bigvalue + '>');
            } else {
                harness.check(true);
            }
            if (bigbyte.compareTo(smallbyte) < 0) {
                harness.fail("compareTo detected <" + bigvalue + "> smaller then <" + smallvalue + '>');
            } else if (bigbyte.compareTo(smallbyte) == 0) {
                harness.fail("compareTo detected <" + bigvalue + "> equal to <" + smallvalue + '>');
            } else {
                harness.check(true);
            }
            if (smallbyte.compareTo(smallbyte) != 0) {
                harness.fail("compareTo detected <" + smallvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
            if (bigbyte.compareTo(bigbyte) != 0) {
                harness.fail("compareTo detected <" + bigvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Exception while comparing <" + smallvalue + "> and <" + bigvalue + '>');
        }
    }

    public void testStringConversion() {
        harness.checkPoint("toString(byte)java.lang.String");
        byte abyte = 97;
        byte zerobyte = 0;
        byte negbyte = -97;
        Byte a = new Byte(abyte);
        Byte zero = new Byte(0);
        Byte negative = new Byte(negbyte);
        String astring = "97";
        String negstring = "-97";
        harness.check(zero.toString(), (Object)"0");
        harness.check(Byte.toString(zerobyte), (Object)"0");
        harness.check(a.toString(), (Object)astring);
        harness.check(a.toString(), (Object)Byte.toString(abyte));
        harness.check(negative.toString(), (Object)"-97");
        harness.check(negative.toString(), (Object)Byte.toString(negbyte));
        harness.checkPoint("decode(java.lang.String)java.lang.Byte");
        this.decodeMustPass("11", 11);
        this.decodeMustPass("011", 9);
        this.decodeMustPass("#11", 17);
        this.decodeMustPass("0x11", 17);
        this.decodeMustPass("0x1F", 31);
        this.decodeMustPass("0x1f", 31);
        this.decodeMustPass("-11", -11);
        this.decodeMustPass("-011", -9);
        this.decodeMustFail("0-11");
        this.decodeMustPass("-#11", -17);
        this.decodeMustFail("#-11");
        this.decodeMustPass("-0x11", -17);
        this.decodeMustFail("0x-11");
        this.decodeMustPass("0x7f", 127);
        this.decodeMustPass("0x7F", 127);
        this.decodeMustFail("  11");
        this.decodeMustFail("128");
        this.decodeMustFail("-129");
        this.decodeMustFail("019");
        this.decodeMustFail("122.5");
        this.decodeMustFail("4F");
        this.decodeMustFail("#4G");
        this.decodeMustFail("0x4G");
        this.decodeMustFail(" ");
        this.decodeMustFail("");
        this.decodeMustFail(null);
    }

    private final void decodeMustPass(String line, int checkvalue) {
        try {
            Byte decoded = Byte.decode(line);
            harness.check(decoded.intValue(), checkvalue);
        }
        catch (Exception e) {
            harness.fail("Exception while trying to decode string <" + line + '>');
        }
    }

    private final void decodeMustFail(String line) {
        try {
            Byte.decode(line);
            harness.fail("Attempt to decode illegal string format <" + line + "> got: " + Byte.decode(line));
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testStringValueParsing() {
        String astring = new String("100");
        Byte target = new Byte(100);
        harness.checkPoint("valueOf(java.lang.String)java.lang.Byte");
        harness.check(Byte.parseByte(astring), 100);
        harness.check(Byte.valueOf(astring).equals(target));
        harness.check(Byte.parseByte("-34"), -34);
        harness.check(Byte.valueOf("-56").equals(new Byte(-56)));
        harness.check(Byte.parseByte("127"), 127);
        harness.check(Byte.valueOf("127").equals(new Byte(127)));
        harness.check(Byte.parseByte("-128"), -128);
        harness.check(Byte.valueOf("-128").equals(new Byte(-128)));
        harness.checkPoint("parseByte(java.lang.String)byte");
        this.parseCheckMustFail(" 87  ", 10);
        this.valueCheckMustFail("  87", 10);
        this.parseCheckMustFail("128", 10);
        this.valueCheckMustFail("128", 10);
        this.parseCheckMustFail("0x60", 10);
        this.valueCheckMustFail("0x60", 10);
        harness.check(Byte.parseByte("12", 10), Byte.parseByte("12"));
        harness.check(Byte.parseByte("-34", 10), Byte.parseByte("-34"));
        harness.check(Byte.valueOf("56", 10), Byte.valueOf("56"));
        harness.check(Byte.valueOf("-78", 10), Byte.valueOf("-78"));
        harness.check(Byte.parseByte("11", 2), Byte.parseByte("3"), "parseByte binary ");
        harness.check(Byte.parseByte("-11", 2), Byte.parseByte("-3"), "parseByte binary negative");
        harness.check(Byte.valueOf("11", 2), Byte.valueOf("3"), "valueOf binary ");
        harness.check(Byte.valueOf("-11", 2), Byte.valueOf("-3"), "valueOf binary negative");
        harness.check(Byte.parseByte("11", 3), Byte.parseByte("4"), "parseByte 3-based ");
        harness.check(Byte.parseByte("-11", 3), Byte.parseByte("-4"), "parseByte 3-based negative");
        harness.check(Byte.valueOf("11", 3), Byte.valueOf("4"), "valueOf 3-based ");
        harness.check(Byte.valueOf("-11", 3), Byte.valueOf("-4"), "valueOf 3-based negative");
        harness.check(Byte.parseByte("11", 8), Byte.parseByte("9"), "parseByte octal ");
        harness.check(Byte.parseByte("-11", 8), Byte.parseByte("-9"), "parseByte octal negative");
        harness.check(Byte.valueOf("11", 8), Byte.valueOf("9"), "valueOf octal ");
        harness.check(Byte.valueOf("-11", 8), Byte.valueOf("-9"), "valueOf octal negative");
        harness.check(Byte.parseByte("11", 16), Byte.parseByte("17"), "parseByte hex ");
        harness.check(Byte.parseByte("-11", 16), Byte.parseByte("-17"), "parseByte hex negative");
        harness.check(Byte.valueOf("11", 16), Byte.valueOf("17"), "valueOf hex ");
        harness.check(Byte.valueOf("-11", 16), Byte.valueOf("-17"), "valueOf hex negative");
        harness.check(Byte.parseByte("f", 16), Byte.parseByte("15"), "parseByte hex ");
        harness.check(Byte.parseByte("-f", 16), Byte.parseByte("-15"), "parseByte hex negative");
        harness.check(Byte.parseByte("F", 16), Byte.parseByte("15"), "parseByte hex capital");
        harness.check(Byte.valueOf("f", 16), Byte.valueOf("15"), "valueOf hex ");
        harness.check(Byte.valueOf("-f", 16), Byte.valueOf("-15"), "valueOf hex negative");
        harness.check(Byte.valueOf("F", 16), Byte.valueOf("15"), "valueOf hex capital");
        harness.check(Byte.parseByte("11", 25), Byte.parseByte("26"), "parseByte 25-based ");
        harness.check(Byte.parseByte("-11", 25), Byte.parseByte("-26"), "parseByte 25-based negative");
        harness.check(Byte.valueOf("11", 25), Byte.valueOf("26"), "valueOf 25-based ");
        harness.check(Byte.valueOf("-11", 25), Byte.valueOf("-26"), "valueOf 25-based negative");
        harness.check(Byte.parseByte("o", 25), Byte.parseByte("24"), "parseByte 25-based ");
        harness.check(Byte.parseByte("O", 25), Byte.parseByte("24"), "parseByte 25-based capital");
        harness.check(Byte.parseByte("-o", 25), Byte.parseByte("-24"), "parseByte 25-based negative");
        harness.check(Byte.valueOf("o", 25), Byte.valueOf("24"), "valueOf 25-based ");
        harness.check(Byte.valueOf("O", 25), Byte.valueOf("24"), "valueOf 25-based capital");
        harness.check(Byte.valueOf("-o", 25), Byte.valueOf("-24"), "valueOf 25-based negative");
        harness.check(Byte.parseByte("11", 36), Byte.parseByte("37"), "parseByte 36-based ");
        harness.check(Byte.parseByte("-11", 36), Byte.parseByte("-37"), "parseByte 36-based negative");
        harness.check(Byte.valueOf("11", 36), Byte.valueOf("37"), "valueOf 36-based ");
        harness.check(Byte.valueOf("-11", 36), Byte.valueOf("-37"), "valueOf 36-based negative");
        harness.check(Byte.parseByte("z", 36), Byte.parseByte("35"), "parseByte 36-based ");
        harness.check(Byte.parseByte("Z", 36), Byte.parseByte("35"), "parseByte 36-based capital");
        harness.check(Byte.parseByte("-z", 36), Byte.parseByte("-35"), "parseByte 36-based negative");
        harness.check(Byte.valueOf("z", 36), Byte.valueOf("35"), "valueOf 36-based ");
        harness.check(Byte.valueOf("Z", 36), Byte.valueOf("35"), "valueOf 36-based capital");
        harness.check(Byte.valueOf("-z", 36), Byte.valueOf("-35"), "valueOf 36-based negative");
        this.parseCheckMustFail("11", 1);
        this.valueCheckMustFail("11", 1);
        this.parseCheckMustFail("11", 37);
        this.valueCheckMustFail("11", 37);
        this.parseCheckMustFail("3", 2);
        this.valueCheckMustFail("3", 2);
        this.parseCheckMustFail("5", 4);
        this.valueCheckMustFail("5", 4);
        this.parseCheckMustFail("9", 8);
        this.valueCheckMustFail("9", 8);
        this.parseCheckMustFail("g", 16);
        this.valueCheckMustFail("g", 16);
        this.parseCheckMustFail("z", 35);
        this.valueCheckMustFail("z", 35);
        this.parseCheckMustFail("10000000", 2);
        this.valueCheckMustFail("10000000", 2);
        this.parseCheckMustFail("200", 8);
        this.valueCheckMustFail("200", 8);
        this.parseCheckMustFail("80", 16);
        this.valueCheckMustFail("80", 16);
        this.parseCheckMustFail("40", 32);
        this.valueCheckMustFail("40", 32);
        this.parseCheckMustFail("-10000001", 2);
        this.valueCheckMustFail("-10000001", 2);
        this.parseCheckMustFail("-201", 8);
        this.valueCheckMustFail("-201", 8);
        this.parseCheckMustFail("-81", 16);
        this.valueCheckMustFail("-81", 16);
        this.parseCheckMustFail("-41", 32);
        this.valueCheckMustFail("-41", 32);
    }

    private final void parseCheckMustFail(String line, int radix) {
        try {
            Byte.parseByte(line, radix);
            harness.fail("Attempt to parse illegal byte string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    private final void valueCheckMustFail(String line, int radix) {
        try {
            Byte.valueOf(line, radix);
            harness.fail("Attempt to get value from illegal byte string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    public void testValueConversion() {
        Byte zero = new Byte(0);
        Byte abyte = new Byte(97);
        Byte min = new Byte(-128);
        Byte max = new Byte(127);
        harness.checkPoint("Value conversins");
        boolean bl = false;
        if (zero == 0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (abyte == 97) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (max == 127) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (min == -128) {
            bl4 = true;
        }
        harness.check(bl4);
        boolean bl5 = false;
        if (zero.shortValue() == 0) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (abyte.shortValue() == 97) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (abyte.shortValue() == abyte.byteValue()) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (max.shortValue() == 127) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (min.shortValue() == -128) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (zero.intValue() == 0) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (abyte.intValue() == 97) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (abyte.intValue() == abyte.byteValue()) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (max.intValue() == 127) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (min.intValue() == -128) {
            bl14 = true;
        }
        harness.check(bl14);
        boolean bl15 = false;
        if (zero.longValue() == 0L) {
            bl15 = true;
        }
        harness.check(bl15);
        boolean bl16 = false;
        if (abyte.longValue() == 97L) {
            bl16 = true;
        }
        harness.check(bl16);
        boolean bl17 = false;
        if (abyte.longValue() == (long)abyte.byteValue()) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (max.longValue() == 127L) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (min.longValue() == -128L) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (zero.floatValue() == 0.0f) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (abyte.floatValue() == 97.0f) {
            bl21 = true;
        }
        harness.check(bl21);
        boolean bl22 = false;
        if (abyte.floatValue() == (float)abyte.byteValue()) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (max.floatValue() == 127.0f) {
            bl23 = true;
        }
        harness.check(bl23);
        boolean bl24 = false;
        if (min.floatValue() == -128.0f) {
            bl24 = true;
        }
        harness.check(bl24);
        boolean bl25 = false;
        if (zero.doubleValue() == 0.0) {
            bl25 = true;
        }
        harness.check(bl25);
        boolean bl26 = false;
        if (abyte.doubleValue() == 97.0) {
            bl26 = true;
        }
        harness.check(bl26);
        boolean bl27 = false;
        if (abyte.doubleValue() == (double)abyte.byteValue()) {
            bl27 = true;
        }
        harness.check(bl27);
        boolean bl28 = false;
        if (max.doubleValue() == 127.0) {
            bl28 = true;
        }
        harness.check(bl28);
        boolean bl29 = false;
        if (min.doubleValue() == -128.0) {
            bl29 = true;
        }
        harness.check(bl29);
    }

    public void testHashCode() {
        Byte a = new Byte(97);
        Byte b = new Byte(98);
        Byte zero = new Byte(0);
        Byte newa = new Byte(97);
        harness.checkPoint("hashCode()int");
        harness.check(a.hashCode(), newa.hashCode());
        harness.check(a.hashCode(), 97);
        harness.check(zero.hashCode(), 0);
        boolean bl = false;
        if (a.hashCode() != b.hashCode()) {
            bl = true;
        }
        harness.check(bl);
    }

    public void testGetClass() {
        Byte a = new Byte(97);
        Byte b = new Byte(0);
        Integer i = new Integer(0);
        harness.checkPoint("TYPE(public)java.lang.Class");
        try {
            harness.check(a instanceof Byte);
            harness.check(b instanceof Byte);
            harness.check(a.getClass().getName(), (Object)"java.lang.Byte");
            harness.check(b.getClass().getName(), (Object)"java.lang.Byte");
            harness.check(a.getClass(), Class.forName("java.lang.Byte"));
            harness.check(b.getClass(), Class.forName("java.lang.Byte"));
            boolean bl = false;
            if (i.getClass() != Class.forName("java.lang.Byte")) {
                bl = true;
            }
            harness.check(bl);
            harness.check(a.getClass(), b.getClass());
            boolean bl2 = false;
            if (a.getClass() != i.getClass()) {
                bl2 = true;
            }
            harness.check(bl2);
            harness.check(Byte.TYPE.getName(), (Object)"byte");
        }
        catch (ClassNotFoundException e) {
            harness.fail("error finding class name");
            harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Byte");
        this.testConstructors();
        this.testStringConversion();
        this.testStringValueParsing();
        this.testValueConversion();
        this.testHashCode();
        this.testGetClass();
    }
}

