/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class JNIPrimitiveTest
implements Testlet {
    protected static TestHarness harness;

    public void testPrimitiveCalls() {
        harness.checkPoint("function Boolean = inverse Boolean");
        harness.check(this.nativeInverse(true) ^ true);
        harness.check(this.nativeInverse(false));
        harness.checkPoint("function byte = 1/2 byte");
        harness.check(Byte.toString(this.nativeHalve((byte)127)), (Object)Byte.toString((byte)63));
        harness.check(Byte.toString(this.nativeHalve((byte)-128)), (Object)Byte.toString((byte)-64));
        harness.checkPoint("function short = 1/2 short");
        harness.check(Short.toString(this.nativeHalve((short)Short.MAX_VALUE)), (Object)Short.toString((short)16383));
        harness.check(Short.toString(this.nativeHalve((short)Short.MIN_VALUE)), (Object)Short.toString((short)-16384));
        harness.checkPoint("function int = 1/2 int");
        harness.check(Integer.toString(this.nativeHalve(Integer.MAX_VALUE)), (Object)Integer.toString(0x3FFFFFFF));
        harness.check(Integer.toString(this.nativeHalve(Integer.MIN_VALUE)), (Object)Integer.toString(-1073741824));
        harness.checkPoint("function long = 1/2 long");
        harness.check(Long.toString(this.nativeHalve(Long.MAX_VALUE)), (Object)Long.toString(0x3FFFFFFFFFFFFFFFL));
        harness.check(Long.toString(this.nativeHalve(Long.MIN_VALUE)), (Object)Long.toString(-4611686018427387904L));
        harness.checkPoint("function decimal = 1/decimal");
        harness.check(Float.toString(this.nativePart(3)), (Object)Float.toString(0.33333334f));
        harness.check(Double.toString(this.nativePart((double)3)), (Object)Double.toString(0.3333333333333333));
    }

    protected native boolean nativeInverse(boolean var1);

    protected native byte nativeHalve(byte var1);

    protected native short nativeHalve(short var1);

    protected native int nativeHalve(int var1);

    protected native long nativeHalve(long var1);

    protected native float nativePart(float var1);

    protected native double nativePart(double var1);

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI calls (primitive)primitive");
        this.testPrimitiveCalls();
    }

    static {
        System.loadLibrary("JNIPrimitiveTest");
    }
}

