/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.StreamTokenizer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMStreamTokenizerTest
implements Testlet {
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    protected TestHarness th;
    protected char[] buffer;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.StreamTokenizer");
        this.test_StreamTokenizer();
        this.test_nextToken();
    }

    public void test_StreamTokenizer() {
        this.th.checkPoint("StreamTokenizer(java.io.Reader)");
        try {
            new StreamTokenizer(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught exception ...");
        }
    }

    public void test_nextToken() {
        this.th.checkPoint("nextToken()int");
        CharArrayReader car = new CharArrayReader(this.buffer);
        StreamTokenizer st = new StreamTokenizer(car);
        try {
            this.th.check(st.nextToken(), -2, "checking return value ... -- 1");
            this.th.check(st.nval, -1.22, "parsing numbers -- 1");
            this.th.check(st.nextToken(), -2, "checking return value ... -- 2");
            this.th.check(st.nval, 0.45, "parsing numbers -- 2");
            this.th.check(st.nextToken(), -2, "checking return value ... -- 3");
            this.th.check(st.nval, -234.44, "parsing numbers -- 3");
            this.th.check(st.nextToken(), 34, "checking return value ... -- 4");
            this.th.check(st.sval, "this is ", "parsing quote -- 1");
            this.th.check(st.nextToken(), 39, "checking return value ... -- 5");
            this.th.check(st.sval, "a test \"", "parsing quote -- 2");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 6");
            this.th.check(st.sval, "\u0256", "parsing words -- 1");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 7");
            this.th.check(st.sval, "buffer", "parsing words -- 1");
            st.eolIsSignificant(true);
            this.th.check(st.nextToken(), 10, "checking return value ... -- 8");
            st.pushBack();
            this.th.check(st.nextToken(), 10, "checking return value ... -- 9");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 10");
            this.th.check(st.sval, "a1N.D-", "parsing words -- 2");
            st.lowerCaseMode(true);
            this.th.check(st.nextToken(), -3, "checking return value ... -- 11");
            this.th.check(st.sval, "contains", "parsing words -- 3");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 12");
            this.th.check(st.sval, "secrets", "parsing words -- 4");
            this.th.check(st.nextToken(), 10, "checking return value ... -- 13");
            this.th.check(st.sval, null, "checking sval ... -- 13");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 14");
            this.th.check(st.sval, "tell", "parsing words -- 5");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 15");
            this.th.check(st.sval, "them", "parsing words -- 6");
            this.th.check(st.nextToken(), -1, "checking return value ... -- 16");
            st.pushBack();
            this.th.check(st.nextToken(), -1, "checking return value ... -- 17");
            this.th.check(st.nextToken(), -1, "checking return value ... -- 18");
            this.th.check(st.nextToken(), -1, "checking return value ... -- 19");
        }
        catch (IOException ioe) {
            this.th.fail("got unwanted IOException -- 1");
        }
        car = new CharArrayReader(this.buffer);
        st = new StreamTokenizer(car);
        st.wordChars(48, 52);
        st.ordinaryChar(47);
        this.buffer = "abcd //asdd\n //\n /*sdsd*d/sdsf\nffdfdf\r dgfg\n */ ff/* ddffgg*/\nd".toCharArray();
        car = new CharArrayReader(this.buffer);
        try {
            this.th.check(st.nextToken(), -2, "checking return value ... -- 20");
            this.th.check(st.nval, -1.22, "parsing words -- 7");
            this.th.check(st.nextToken(), -2, "checking return value ... -- 21");
            this.th.check(st.nval, 0.45, "parsing words -- 7");
            st = new StreamTokenizer(car);
            st.ordinaryChar(47);
            st.slashSlashComments(true);
            st.slashStarComments(true);
            this.th.check(st.nextToken(), -3, "checking return value ... -- 22");
            this.th.check(st.sval, "abcd", "parsing words -- 8");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 23");
            this.th.check(st.sval, "ff", "parsing words -- 9");
            this.th.check(st.nextToken(), -3, "checking return value ... -- 24");
            this.th.check(st.sval, "d", "parsing words -- 10");
        }
        catch (IOException ioe) {
            this.th.fail("got unwanted IOException -- 2");
        }
    }

    private final /* synthetic */ void this() {
        this.buffer = " -1.22.45-234.44 \"this is \n'a test \"'\u0256  \r \n   buffer\n a1N.D- CONTAINS sEcrEts/: don't\n tell them".toCharArray();
    }

    public SMStreamTokenizerTest() {
        this.this();
    }
}

