/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.Reader;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.Reader.SMExReader;
import gnu.testlet.wonka.io.Reader.SMlockTC;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMReaderTest
implements Testlet {
    protected TestHarness th;
    protected int accesed;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.Reader");
        this.test_Reader();
        this.test_read();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_close();
        this.test_ready();
    }

    public void test_Reader() {
        this.th.checkPoint("Reader()");
        SMExReader xr = new SMExReader();
        boolean bl = false;
        if (xr.getLock() == xr) {
            bl = true;
        }
        this.th.check(bl, "if lock is not specified Reader uses itself");
        this.th.checkPoint("Reader(java.lang.Object)");
        xr = new SMExReader(this);
        boolean bl2 = false;
        if (xr.getLock() == this) {
            bl2 = true;
        }
        this.th.check(bl2, "if lock is specified Reader uses it");
        try {
            new SMExReader(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_read() {
        this.th.checkPoint("read()int");
        SMExReader xr = new SMExReader();
        try {
            int i = xr.read();
            boolean bl = false;
            if (i == 97) {
                bl = true;
            }
            this.th.check(bl, "SMExReader always returns 'a' -- 1, got:" + i);
            i = xr.read();
            boolean bl2 = false;
            if (i == 97) {
                bl2 = true;
            }
            this.th.check(bl2, "SMExReader always returns 'a' -- 2, got:" + i);
            i = xr.read();
            boolean bl3 = false;
            if (i == 97) {
                bl3 = true;
            }
            this.th.check(bl3, "SMExReader always returns 'a' -- 3, got:" + i);
            i = xr.read();
            boolean bl4 = false;
            if (i == -1) {
                bl4 = true;
            }
            this.th.check(bl4, "SMExReader always returns -1 at EOF, got:" + i);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption, got:" + e);
        }
        this.th.checkPoint("read(char[])int");
        char[] buf = new char[6];
        int j = 0;
        while (j < 6) {
            buf[j] = 99;
            ++j;
        }
        try {
            int i = xr.read(buf);
            boolean bl = false;
            if (i == -1) {
                bl = true;
            }
            this.th.check(bl, "SMExReader returns -1 if no chars read, got:" + i);
            xr = new SMExReader(10);
            i = xr.read(buf);
            boolean bl5 = false;
            if (i == 6) {
                bl5 = true;
            }
            this.th.check(bl5, "SMExReader returns nr chars read, got:" + i);
            this.th.check("aaaaaa".equals(new String(buf)), "make sure all chars are placed");
            int k = 0;
            while (k < 6) {
                buf[k] = 99;
                ++k;
            }
            i = xr.read(buf);
            boolean bl6 = false;
            if (i == 4) {
                bl6 = true;
            }
            this.th.check(bl6, "SMExReader returns nr chars read, got:" + i);
            this.th.check("aaaacc".equals(new String(buf)), "make no chars are overwritten");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption, got:" + e);
        }
        this.th.checkPoint("read(char[],int,int)int");
    }

    public void test_skip() {
        long l;
        this.th.checkPoint("skip(long)long");
        SMExReader xr = new SMExReader(30);
        try {
            l = xr.skip(-5L);
            this.th.fail("should throw an illegalArgumentException, but got:" + l);
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption, got:" + e);
        }
        try {
            l = xr.skip(20L);
            boolean bl = false;
            if (l == 20L) {
                bl = true;
            }
            this.th.check(bl, "skipped 20 chars");
            l = xr.skip(0L);
            boolean bl2 = false;
            if (l == 0L) {
                bl2 = true;
            }
            this.th.check(bl2, "skipped no chars");
            l = xr.skip(20L);
            boolean bl3 = false;
            if (l == 10L) {
                bl3 = true;
            }
            this.th.check(bl3, "skipped 10 chars");
            l = xr.skip(10L);
            boolean bl4 = false;
            if (l == 0L) {
                bl4 = true;
            }
            this.th.check(bl4, "skipped no chars, EOF reached");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption, got:" + e);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        SMExReader xr = new SMExReader();
        try {
            xr.mark(-3);
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 1, got:" + e);
        }
        try {
            xr.mark(3);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 2, got:" + e);
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        SMExReader xr = new SMExReader();
        try {
            this.th.check(xr.markSupported() ^ true, "always returns false -- 1");
            this.th.check(xr.markSupported() ^ true, "always returns false -- 2");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 1, got:" + e);
        }
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMExReader xr = new SMExReader();
        try {
            xr.reset();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 1, got:" + e);
        }
        try {
            xr.reset();
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 2, got:" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
    }

    public void test_ready() {
        this.th.checkPoint("ready()boolean");
        SMExReader xr = new SMExReader();
        try {
            this.th.check(xr.ready() ^ true, "always returns false -- 1");
            this.th.check(xr.ready() ^ true, "always returns false -- 2");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exeption -- 1, got:" + e);
        }
    }

    public void test_lock() {
        this.th.checkPoint("behauvior_of_lock()member");
        SMExReader xr = new SMExReader(new Object());
        SMlockTC lt = new SMlockTC();
        int i = this.setupLockThread(lt, xr);
        try {
            xr.mark(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- mark");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockTC();
        i = this.setupLockThread(lt, xr);
        try {
            xr.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- reset");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockTC();
        i = this.setupLockThread(lt, xr);
        try {
            xr.read();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- read()");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockTC();
        i = this.setupLockThread(lt, xr);
        try {
            xr.read(new char[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- read(char[])");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockTC();
        i = this.setupLockThread(lt, xr);
        try {
            xr.skip(3);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- skip");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int setupLockThread(SMlockTC lt, SMExReader xr) {
        this.f1 = false;
        lt.setXReader(xr);
        lt.setTestHarness(this.th);
        lt.setRT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    public void inc() {
        ++this.accesed;
    }

    public void set1() {
        this.f1 = true;
    }

    private final /* synthetic */ void this() {
        this.accesed = 0;
        this.t = null;
        this.f1 = false;
    }

    public SMReaderTest() {
        this.this();
    }
}

