/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.PipedStreams;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.PipedStreams.AcuniaPipedStreamThread;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaPipedStreamTest
implements Testlet {
    protected TestHarness th;
    private boolean go;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.PipedOutputStream");
        this.test_PipedOutputStream();
        this.th.setclass("java.io.PipedInputStream");
        this.test_PipedInputStream();
        this.test_connect();
        this.test_close();
        this.test_available();
        this.test_thread();
        this.test_read_write();
    }

    public void test_PipedInputStream() {
        this.th.checkPoint("PipedInputStream(java.io.PipedOutputStream)");
        try {
            new PipedOutputStream(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught exception ...");
        }
        catch (IOException ieo) {
            this.th.fail("Constructor should not throw an IOException here");
        }
    }

    public void test_PipedOutputStream() {
        this.th.checkPoint("PipedOutputStream(java.io.PipedInputStream)");
        try {
            new PipedOutputStream(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught exception ...");
        }
        catch (IOException ieo) {
            this.th.fail("Constructor should not throw an IOException here");
        }
        this.th.checkPoint("flush()void");
        try {
            new PipedOutputStream().flush();
            this.th.check(true, "unconnected stream be flushed");
        }
        catch (IOException ieo) {
            this.th.fail("unconnected stream be flushed, but got Exception");
        }
    }

    public void test_connect() {
        this.th.checkPoint("connect()void");
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = null;
        try {
            String test = "The quick brown ferret slunk through the twisty pipe.";
            pos = new PipedOutputStream(pis);
            pos.write(test.getBytes());
            byte[] buf = new byte[test.length()];
            pis.read(buf);
            this.th.check(new String(buf), test, test);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.th.fail("no IOException expected -- 1");
        }
        try {
            new PipedOutputStream(pis);
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            new PipedInputStream(pos);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            pis.connect(new PipedOutputStream());
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 3");
        }
        try {
            pos.connect(new PipedInputStream());
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
        pis = new PipedInputStream();
        pos = new PipedOutputStream();
        try {
            pis.connect(null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 1");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 3");
        }
        try {
            pos.connect(null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 2");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 4");
        }
    }

    public void test_available() {
        this.th.checkPoint("available()int");
        try {
            PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pis);
            boolean bl = false;
            if (pis.available() == 0) {
                bl = true;
            }
            this.th.check(bl, "nothing available -- 1");
            pos.write("testing".getBytes(), 0, 7);
            int avail = pis.available();
            boolean bl2 = false;
            if (avail > 0) {
                bl2 = true;
            }
            this.th.check(bl2, avail + " bytes available");
            byte[] buf = new byte[4];
            pis.read(buf, 0, 4);
            avail = pis.available();
            if (avail != 3) {
                this.th.fail("pis.available() returned " + avail + ", expected 3");
            } else {
                this.th.check(true, "three bytes available");
            }
            pis.read();
            pis.read();
            pis.read();
            boolean bl3 = false;
            if (pis.available() == 0) {
                bl3 = true;
            }
            this.th.check(bl3, "nothing available -- 2");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
    }

    public void test_thread() {
        this.th.checkPoint("read()int");
        PipedInputStream pis = new PipedInputStream();
        AcuniaPipedStreamThread pt = new AcuniaPipedStreamThread(pis, this.th);
        Thread t = new Thread(pt);
        try {
            pis.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            this.th.check(pis.read(), 1, "checking first read");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        try {
            pis.read();
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        this.th.checkPoint("read(byte[],int,int)int");
        pis = new PipedInputStream();
        pt = new AcuniaPipedStreamThread(pis, this.th);
        t = new Thread(pt);
        try {
            pis.read(new byte[3], 1, 2);
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 3");
        }
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            this.th.check(pis.read(new byte[1], 0, 1), 1, "checking first read");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 2");
        }
        try {
            pis.read(new byte[3], 1, 2);
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
        this.th.checkPoint("write(byte[],int,int)void");
        PipedOutputStream pos = new PipedOutputStream();
        pt = new AcuniaPipedStreamThread(pos, this.th);
        t = new Thread(pt);
        t.start();
        while (!pt.connected) {
            Thread.yield();
        }
        try {
            byte[] b = new byte[]{1};
            pos.write(b, 0, 1);
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 3 " + ioe);
        }
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pos.write(new byte[3], 1, 2);
            this.th.fail("should throw an IOException -- 5");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 5");
        }
        this.th.checkPoint("write(int)void");
        pos = new PipedOutputStream();
        pt = new AcuniaPipedStreamThread(pos, this.th);
        t = new Thread(pt);
        t.start();
        while (!pt.connected) {
            Thread.yield();
        }
        try {
            pos.write(1);
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 4");
        }
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pos.write(2);
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = null;
        try {
            pos = new PipedOutputStream(pis);
            pos.close();
            pos.close();
            pis.close();
            pis.close();
            pos.close();
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        try {
            pis.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            pis.read(new byte[2], 0, 1);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            this.th.check(pis.available(), 0);
        }
        catch (IOException ioe) {
            this.th.fail("caught IOException -- 3");
        }
        try {
            pos.write(1);
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
        try {
            pos.write(new byte[2], 0, 1);
            this.th.fail("should throw an IOException -- 5");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 5");
        }
        try {
            pos.flush();
            this.th.check(true, "should throw not IOException -- 6");
        }
        catch (IOException ioe) {
            this.th.fail("caught IOException -- 6");
        }
    }

    public void test_read_write() {
        this.th.checkPoint("read/write");
        PipedOutputStream pos = new PipedOutputStream();
        AcuniaPipedStreamThread pt = new AcuniaPipedStreamThread(pos, this.th);
        pt.setAlive(false);
        pt.setPRT(this);
        Thread t = new Thread(pt);
        t.start();
        String s = this.buildString();
        try {
            while (!this.go) {
                Thread.yield();
            }
            pos.write(s.getBytes());
            pt.stop();
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        while (t.isAlive()) {
            Thread.yield();
        }
        String readedS = pt.getBuffer();
        this.th.check(readedS, s, "reading is OK ... -- 1");
        this.th.check(readedS.length(), s.length(), "reading is OK ... -- 2");
        pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream();
        try {
            pis.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            pis.read(new byte[2], 0, 1);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            pos.write(1);
            this.th.fail("should throw an NullPointerException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException");
        }
        try {
            pos.write(new byte[2], 0, 1);
            this.th.fail("should throw an NullPointerException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException");
        }
        try {
            pis.connect(pos);
            byte[] buf = new byte[4];
            pos.write(buf, 0, 4);
            try {
                pis.read(buf, -1, 0);
                this.th.fail("should throw IndexOutOfBoundsException -- 1");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pis.read(buf, 1, -1);
                this.th.fail("should throw IndexOutOfBoundsException -- 2");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pis.read(buf, 2, 3);
                this.th.fail("should throw IndexOutOfBoundsException -- 3");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pos.write(buf, -1, 2);
                this.th.fail("should throw IndexOutOfBoundsException -- 4");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pos.write(buf, 1, -2);
                this.th.fail("should throw IndexOutOfBoundsException -- 5");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pos.write(buf, 3, 2);
                this.th.fail("should throw IndexOutOfBoundsException -- 6");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pos.write(null, 3, 2);
                this.th.fail("should throw NullPointerException -- 1");
            }
            catch (NullPointerException npe) {
                this.th.check(true);
            }
            try {
                pis.read(null, 2, 3);
                this.th.fail("should throw NullPointerException -- 2");
            }
            catch (NullPointerException npe) {
                this.th.check(true);
            }
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 4");
        }
    }

    private final String buildString() {
        StringBuffer b = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < 288) {
            b.append("ACUNIA" + j + ' ');
            if (j == 9) {
                b.setCharAt(b.length() - 1, '\n');
            }
            j = (j + 1) % 10;
            ++i;
        }
        b.setCharAt(b.length() - 1, '\n');
        b.setCharAt(0, '\n');
        return new String(b);
    }

    public void go() {
        this.go = true;
    }

    private final /* synthetic */ void this() {
        this.go = false;
    }

    public AcuniaPipedStreamTest() {
        this.this();
    }
}

