/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.FilterInputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.FilterInputStream.SMExFilterInputStream;
import gnu.testlet.wonka.io.FilterInputStream.SMInfoInputStream;
import java.io.ByteArrayInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMFilterInputStreamTest
implements Testlet {
    protected TestHarness th;
    protected byte[] ba;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.FilterInputStream");
        this.test_FilterInputStream();
        this.test_read();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_available();
        this.test_close();
    }

    public void test_FilterInputStream() {
        this.th.checkPoint("FilterInputStream(java.io.InputStream)");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.ba);
        SMExFilterInputStream xfin = new SMExFilterInputStream(bin);
        boolean bl = false;
        if (xfin.getIn() == bin) {
            bl = true;
        }
        this.th.check(bl, "checking in-stream field");
    }

    public void test_read() {
        this.th.checkPoint("read()int");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.ba);
        SMExFilterInputStream fin = new SMExFilterInputStream(bin);
        try {
            char c = (char)fin.read();
            boolean bl = false;
            if (c == 's') {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 1");
            c = (char)fin.read();
            boolean bl2 = false;
            if (c == 'm') {
                bl2 = true;
            }
            this.th.check(bl2, "checking return value -- 2");
            c = (char)fin.read();
            boolean bl3 = false;
            if (c == 'a') {
                bl3 = true;
            }
            this.th.check(bl3, "checking return value -- 3");
            c = (char)fin.read();
            boolean bl4 = false;
            if (c == 'r') {
                bl4 = true;
            }
            this.th.check(bl4, "checking return value -- 4");
            fin.skip(100L);
            int i = fin.read();
            boolean bl5 = false;
            if (i == -1) {
                bl5 = true;
            }
            this.th.check(bl5, "checking return value -- 5");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
        this.th.checkPoint("read(byte[])int");
        bin = new ByteArrayInputStream(this.ba);
        byte[] buffer = new byte[10];
        SMExFilterInputStream is = new SMExFilterInputStream(bin);
        try {
            int i = is.read(buffer);
            this.th.check("smartmove ".equals(new String(buffer)), "checking read -- 1");
            boolean bl = false;
            if (i == 10) {
                bl = true;
            }
            this.th.check(bl, "check return value -- 1");
            i = is.read(buffer);
            this.th.check("rules!\ntes".equals(new String(buffer)), "checking read -- 2");
            boolean bl6 = false;
            if (i == 10) {
                bl6 = true;
            }
            this.th.check(bl6, "check return value -- 2");
            i = is.read(buffer);
            this.th.check("ting Filte".equals(new String(buffer)), "checking read -- 3");
            boolean bl7 = false;
            if (i == 10) {
                bl7 = true;
            }
            this.th.check(bl7, "check return value -- 3");
            i = is.read(buffer);
            this.th.check("rInputStre".equals(new String(buffer)), "checking read -- 4");
            boolean bl8 = false;
            if (i == 10) {
                bl8 = true;
            }
            this.th.check(bl8, "check return value -- 4");
            i = is.read(buffer);
            this.th.check("amnputStre".equals(new String(buffer)), "checking read -- 5");
            boolean bl9 = false;
            if (i == 2) {
                bl9 = true;
            }
            this.th.check(bl9, "check return value -- 5");
            i = is.read(buffer);
            this.th.check("amnputStre".equals(new String(buffer)), "checking read -- 6");
            boolean bl10 = false;
            if (i == -1) {
                bl10 = true;
            }
            this.th.check(bl10, "check return value -- 6");
            i = is.read(buffer);
            this.th.check("amnputStre".equals(new String(buffer)), "checking read -- 7");
            boolean bl11 = false;
            if (i == -1) {
                bl11 = true;
            }
            this.th.check(bl11, "check return value -- 7");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception --1, got:" + e);
        }
        SMInfoInputStream iin = new SMInfoInputStream();
        fin = new SMExFilterInputStream(iin);
        try {
            iin.clean();
            fin.read(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 2, got:" + e);
        }
        this.th.check(iin.isMarked() ^ true, "checking marked after bad read -- 1");
        this.th.checkPoint("read(byte[],int,int)int");
        bin = new ByteArrayInputStream(this.ba);
        is = new SMExFilterInputStream(bin);
        try {
            int i = is.read(buffer, 0, 10);
            this.th.check("smartmove ".equals(new String(buffer)), "checking read -- 1");
            boolean bl = false;
            if (i == 10) {
                bl = true;
            }
            this.th.check(bl, "check return value -- 1");
            i = is.read(buffer, 1, 9);
            this.th.check("srules!\nte".equals(new String(buffer)), "checking read -- 2");
            boolean bl12 = false;
            if (i == 9) {
                bl12 = true;
            }
            this.th.check(bl12, "check return value -- 2");
            i = is.read(buffer, 1, 8);
            this.th.check("ssting Fie".equals(new String(buffer)), "checking read -- 3");
            boolean bl13 = false;
            if (i == 8) {
                bl13 = true;
            }
            this.th.check(bl13, "check return value -- 3");
            i = is.read(buffer, 3, 0);
            this.th.check("ssting Fie".equals(new String(buffer)), "checking read -- 4");
            boolean bl14 = false;
            if (i == 0) {
                bl14 = true;
            }
            this.th.check(bl14, "check return value -- 4");
            i = is.read(buffer, 0, 8);
            this.th.check("lterInpuie".equals(new String(buffer)), "checking read -- 5");
            boolean bl15 = false;
            if (i == 8) {
                bl15 = true;
            }
            this.th.check(bl15, "check return value -- 5");
            i = is.read(buffer, 0, 10);
            this.th.check("tStreamuie".equals(new String(buffer)), "checking read -- 6");
            boolean bl16 = false;
            if (i == 7) {
                bl16 = true;
            }
            this.th.check(bl16, "check return value -- 6");
            i = is.read(buffer);
            this.th.check("tStreamuie".equals(new String(buffer)), "checking read -- 7");
            boolean bl17 = false;
            if (i == -1) {
                bl17 = true;
            }
            this.th.check(bl17, "check return value -- 7");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception --1, got:" + e);
        }
        try {
            iin.clean();
            fin.read(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 2, got:" + e);
        }
        this.th.check(iin.isMarked() ^ true, "checking marked after bad read -- 1");
        try {
            iin.clean();
            this.th.check(fin.read(buffer, -3, 1), 1);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 3, got:" + e);
        }
        this.th.check(iin.isMarked(), "checking marked after bad read -- 2");
        try {
            iin.clean();
            this.th.check(fin.read(buffer, 3, 8), 8);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 4, got:" + e);
        }
        try {
            iin.clean();
            this.th.check(fin.read(buffer, 3, -1), -1);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- 5, got:" + e);
        }
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.ba);
        SMExFilterInputStream fin = new SMExFilterInputStream(bin);
        try {
            long l = fin.skip(5);
            char c = (char)fin.read();
            boolean bl = false;
            if (l == (long)5) {
                bl = true;
            }
            this.th.check(bl, "checking return value -- 1");
            boolean bl2 = false;
            if (c == 'm') {
                bl2 = true;
            }
            this.th.check(bl2, "checking if really skipped underlying stream");
            l = fin.skip(0L);
            c = (char)fin.read();
            boolean bl3 = false;
            if (l == 0L) {
                bl3 = true;
            }
            this.th.check(bl3, "checking return value -- 2");
            boolean bl4 = false;
            if (c == 'o') {
                bl4 = true;
            }
            this.th.check(bl4, "checking if nothing was skipped underlying stream -- 1");
            l = fin.skip(-5L);
            c = (char)fin.read();
            boolean bl5 = false;
            if (l == 0L) {
                bl5 = true;
            }
            this.th.check(bl5, "checking return value -- 3");
            boolean bl6 = false;
            if (c == 'v') {
                bl6 = true;
            }
            this.th.check(bl6, "checking if nothing was skipped underlying stream -- 2");
            l = fin.skip(15L);
            boolean bl7 = false;
            if (l == 15L) {
                bl7 = true;
            }
            this.th.check(bl7, "checking return value -- 4");
            l = fin.skip(150L);
            boolean bl8 = false;
            if (l == (long)this.ba.length - 23L) {
                bl8 = true;
            }
            this.th.check(bl8, "checking return value -- 5");
            l = fin.skip(150L);
            boolean bl9 = false;
            if (l == 0L) {
                bl9 = true;
            }
            this.th.check(bl9, "checking return value -- 5");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        SMInfoInputStream iin = new SMInfoInputStream();
        SMExFilterInputStream fin = new SMExFilterInputStream(iin);
        try {
            fin.mark(-10);
            this.th.check(iin.isMarked(), "checking if mark is called downstream");
            boolean bl = false;
            if (iin.getRAL() == -10) {
                bl = true;
            }
            this.th.check(bl, "checking if readAheadLimit is passed");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        SMInfoInputStream iin = new SMInfoInputStream();
        SMExFilterInputStream fin = new SMExFilterInputStream(iin);
        try {
            this.th.check(fin.markSupported() ^ true, "checking if markSupported is asked downstream -- 1");
            fin.mark(-10);
            this.th.check(fin.markSupported(), "checking if markSupported is asked downstream -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMInfoInputStream iin = new SMInfoInputStream();
        SMExFilterInputStream fin = new SMExFilterInputStream(iin);
        try {
            fin.reset();
            this.th.check(iin.isMarked(), "checking if reset is called downstream -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    public void test_available() {
        this.th.checkPoint("available()int");
        SMInfoInputStream iin = new SMInfoInputStream();
        SMExFilterInputStream fin = new SMExFilterInputStream(iin);
        try {
            boolean bl = false;
            if (fin.available() == 10) {
                bl = true;
            }
            this.th.check(bl, "checking if available is asked downstream -- 1");
            this.th.check(iin.isMarked(), "checking if available is asked downstream -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        this.th.checkPoint("available()int");
        SMInfoInputStream iin = new SMInfoInputStream();
        SMExFilterInputStream fin = new SMExFilterInputStream(iin);
        try {
            fin.close();
            this.th.check(iin.isMarked(), "checking if close is called downstream -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
    }

    private final /* synthetic */ void this() {
        this.ba = "smartmove rules!\ntesting FilterInputStream".getBytes();
    }

    public SMFilterInputStreamTest() {
        this.this();
    }
}

