/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.FilePermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.FilePermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AcuniaFilePermissionTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.FilePermission");
        this.test_FilePermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
        this.test_toString();
    }

    public void test_FilePermission() {
        this.th.checkPoint("FilePermission(java.lang.String,java.lang.String)");
        FilePermission bp = new FilePermission("", "read");
        this.th.check(bp.getName(), (Object)"");
        this.th.check(bp.getActions(), (Object)"read");
        bp = new FilePermission("currentdir", "write");
        this.th.check(bp.getName(), (Object)"currentdir");
        this.th.check(bp.getActions(), (Object)"write");
        try {
            new FilePermission(null, "write");
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            new FilePermission("write", null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
            this.th.debug("wanted a NullPointerException though");
        }
        try {
            new FilePermission("write", "read write");
            this.th.fail("should throw a IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new FilePermission("write", "ready");
            this.th.fail("should throw a IllegalArgumentException -- 7");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new FilePermission("write", "read, delete, , execute");
            this.th.fail("should throw a IllegalArgumentException -- 8");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        String s = "com.acunia";
        FilePermission bp = new FilePermission(s, "ReAd,  Write \n");
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new FilePermission(s, "Write ,Read \n\t ,Write")), "equal -- 1");
        this.th.check(bp.equals(new SecurityPermission(s, "read,write")) ^ true, "not equal -- 1");
        this.th.check(bp.equals(new FilePermission(s, "read")) ^ true, "not equal -- 2");
        bp = new FilePermission("", "ReAd,  Write \n, EXecutE");
        this.th.check(bp.equals(new FilePermission("./", "read,write,execute")), "equal -- 2");
        this.th.check(bp.equals(new FilePermission("./up/", "read,write,execute")) ^ true, "equal -- 3");
        this.th.check(new FilePermission("./ok", "write,reAd"), new FilePermission("ok", "write,reAd"), "equal -- 4");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "com.acunia";
        FilePermission bp = new FilePermission(s, "read");
        this.th.check(bp.hashCode(), bp.hashCode(), "cheking hashCode ... - 1");
        this.th.check(bp.hashCode(), new FilePermission(s, "Read").hashCode());
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "com.acunia";
        FilePermission bp = new FilePermission(s, "read \n \f");
        this.th.check(bp.getActions(), "read", "getActions returnvalue - 1");
        s = "com.*";
        bp = new FilePermission(s, "  \t \nwRiTe\f");
        this.th.check(bp.getActions(), "write", "getActions returnvalue - 2");
        s = "*";
        bp = new FilePermission(s, "WriTe \n ,\t REaD , ReAd ,Write");
        this.th.check(bp.getActions(), "read,write", "getActions returnvalue - 3");
        bp = new FilePermission(s, "Delete\n \t   \f, WRite,\t ExEcUtE\n, \f \nRead \n");
        this.th.check(bp.getActions(), "read,write,execute,delete", "getActions returnvalue - 4");
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        FilePermission bp1 = new FilePermission(".", "read");
        FilePermission bp2 = new FilePermission("", "read,delete");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 1");
        this.th.check(bp2.implies(null) ^ true, "not implied - 2");
        this.th.check(bp2.implies(bp1), "implied - 1");
        this.th.check(bp1.implies(new SecurityPermission("com.acunia", "read")) ^ true, "not implied -- 3");
        bp2 = new FilePermission("<<ALL FILES>>", "read,execute,write");
        bp1 = new FilePermission("./com.acunia/", "read,delete,write,execute");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 4");
        bp1 = new FilePermission("com.acunia", "read,write");
        this.th.check(bp2.implies(bp1), "implied - 2");
        bp1 = new FilePermission("./com.acunia", "read,delete");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 5");
        bp2 = new FilePermission("toppie/-", "read,execute,write");
        bp1 = new FilePermission("toppie/*", "read,write");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 6");
        this.th.check(bp2.implies(bp1), "implied - 3");
        bp1 = new FilePermission("toppie/", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 7");
        bp1 = new FilePermission("toppie.file", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 8");
        bp2 = new FilePermission("wr*te", "read,execute,write");
        bp1 = new FilePermission("write", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "implied - 4");
        bp2 = new FilePermission("toppie/*", "read,execute,write");
        bp1 = new FilePermission("toppie/", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 9");
        bp1 = new FilePermission("toppie/dir/", "read,write");
        this.th.check(bp2.implies(bp1), "implied - 5");
        bp1 = new FilePermission("toppie/dir/file.txt", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 10");
        bp1 = new FilePermission("toppie/file.txt", "read,write");
        this.th.check(bp2.implies(bp1), "implied - 6");
        bp1 = new FilePermission("toppie.file", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 11");
        bp1 = new FilePermission("toppie/dir/dir2", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 12");
        bp2 = new FilePermission("toppie/file*", "read,execute,write");
        bp1 = new FilePermission("toppie/file1/test.class", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 13");
        bp1 = new FilePermission("toppie/file1/", "read,write");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 14");
    }

    public void test_newPermissionCollection() {
        Enumeration<Permission> e;
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "com/acunia/*";
        FilePermission bp = new FilePermission(s, "read,write,execute");
        PermissionCollection pc = bp.newPermissionCollection();
        this.th.check(pc.isReadOnly() ^ true, "not readOnly");
        pc.setReadOnly();
        this.th.check(pc.isReadOnly(), "readOnly");
        try {
            pc.add(bp);
            e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true, "added element");
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new FilePermission("toppie/-", "read,write,execute"));
        pc.add(new FilePermission("toppie/", "read,delete"));
        pc.add(bp);
        pc.add(new FilePermission("vm/smartmove/", "write"));
        pc.add(bp);
        pc.add(new FilePermission("acunia/vm*", "read,write"));
        pc.add(new FilePermission("<<ALL FILES>>/javadir", "read,write"));
        pc.add(new FilePermission("<<ALL FILES>>/classdir", "read,write"));
        e = pc.elements();
        try {
            boolean f = false;
            while (e.hasMoreElements()) {
                boolean bl = false;
                if (bp == e.nextElement()) {
                    bl = true;
                }
                f |= bl;
            }
            this.th.check(f, "references should be kept");
        }
        catch (Exception ee) {
            this.th.fail("Enumeration elements() was bad");
        }
        try {
            e.nextElement();
            this.th.fail("Enumeration elements() was bad");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        this.th.check(pc.implies(bp), "implies -- 1 " + bp);
        this.th.check(pc.implies(new SecurityPermission("com/acunia/test", "read")) ^ true, "not implied -- 1");
        FilePermission bp1 = new FilePermission("com/acunia/", "read,write,execute");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 2");
        bp1 = new FilePermission("com.acunia/test.file", "read,write,delete");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 3");
        bp1 = new FilePermission("com/acunia/", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 4");
        bp1 = new FilePermission("com/acuniaCo/", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 5");
        bp1 = new FilePermission("com/acunia/dir/", "read");
        this.th.check(pc.implies(bp1), "implied - 1");
        bp1 = new FilePermission("com/acunia/file1", "read");
        this.th.check(pc.implies(bp1), "implied - 2");
        bp1 = new FilePermission("com/acunia/dir/file.txt", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 6");
        bp1 = new FilePermission("toppie/", "read,write");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 7");
        bp1 = new FilePermission("toppie/", "read,delete");
        this.th.check(pc.implies(bp1), "implied - 3a");
        bp1 = new FilePermission("toppie/*", "read,write");
        this.th.check(pc.implies(bp1), "implied - 3b");
        bp1 = new FilePermission("toppie.file", "read,write");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 9");
        bp1 = new FilePermission("toppie/dir/file.txt", "read,write");
        this.th.check(pc.implies(bp1), "implied - 4");
        bp1 = new FilePermission("toppie/dir/", "read,write");
        this.th.check(pc.implies(bp1), "implied - 5");
        bp1 = new FilePermission("toppie/file.txt", "read,write");
        this.th.check(pc.implies(bp1), "implied - 6");
        bp1 = new FilePermission("vm/smartmove/", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 10");
        bp1 = new FilePermission("vm/smartmove/", "delete");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 11");
        bp1 = new FilePermission("vm/smartmove/", "execute");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 12");
        bp1 = new FilePermission("vm/smartmove/", "write");
        this.th.check(pc.implies(bp1), "implied - 7");
        bp1 = new FilePermission("acunia/vm/", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 13");
        bp1 = new FilePermission("acunia/vm*", "read");
        this.th.check(pc.implies(bp1), "implied - 8");
        bp1 = new FilePermission("acunia/vmx/file1", "read");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 14");
        pc.add(new FilePermission("<<ALL FILES>>", "read,execute"));
        bp1 = new FilePermission("<<ALL FILES>>", "read");
        this.th.check(pc.implies(bp1), "implied - 9");
        bp1 = new FilePermission("<<ALL FILES>>/not", "read,write");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 15");
        bp1 = new FilePermission("<<ALL FILES>>/classdir", "read,write");
        this.th.check(pc.implies(bp1), "implied - 10");
        pc.add(new FilePermission("toppie/dir/file", "read,delete"));
        bp1 = new FilePermission("toppie/dir/file", "read,write,execute,delete");
        this.th.check(pc.implies(bp1), "implied - 11");
        pc.add(new FilePermission("toppieTo/-", "read,delete"));
        bp1 = new FilePermission("toppieTo/dir/", "read,write,execute,delete");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 16");
        bp1 = new FilePermission("toppieTo/dir/file", "read,delete");
        this.th.check(pc.implies(bp1), "implied - 12");
    }

    public void test_toString() {
        this.th.setclass("java.security.Permission");
        this.th.checkPoint("toString()java.lang.String");
        String s = "com.acunia";
        FilePermission bp = new FilePermission(s, "write,reAd");
        this.th.check(bp.toString(), (Object)("(\"" + bp.getClass().getName() + "\" \"" + s + "\" \"read,write\")"));
    }
}

