/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.File;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class FileTest
implements Testlet {
    protected static TestHarness harness;

    private final void testSeparators() {
        harness.checkPoint("Testing file separators");
        harness.verbose("File separator:" + File.separator);
        harness.check(File.separator, (Object)new String("" + File.separatorChar));
        harness.verbose("File path separator:" + File.pathSeparator);
        harness.check(File.pathSeparator, (Object)new String("" + File.pathSeparatorChar));
    }

    private final void testNullConstructors() {
        File testfile1;
        String testfilestring = "testfile.scr";
        harness.checkPoint("null constructors: File(null) =>exception");
        try {
            testfile1 = new File(null);
            harness.fail(" constructor < File(null) > should throw NullPointerException");
        }
        catch (NullPointerException e) {
            harness.check(true, " constructor < File(null) > threw NullPointer as defined : " + e.toString());
        }
        catch (Exception e) {
            harness.fail(" constructor < File(null) > should throw NullPointerException, threw : " + e.toString());
        }
        harness.checkPoint("null constructors: File(string null, filestring) =>allowed");
        try {
            String nullstring = null;
            harness.check(new File(nullstring, testfilestring), new File(testfilestring), "File(string null, string) definition");
        }
        catch (Exception e) {
            harness.fail(" constructor < File(string null, string) > should be allowed, threw : " + e.toString());
        }
        harness.checkPoint("null constructors: File(pathstring, null) =>exception");
        try {
            testfile1 = new File("", null);
            harness.fail(" constructor < File(pathstring, null) > should throw NullPointerException");
        }
        catch (NullPointerException e) {
            harness.check(true, " constructor < File(pathstring, null) > threw NullPointer as defined : " + e.toString());
        }
        catch (Exception e) {
            harness.fail(" constructor < File(pathstring, null) > should throw NullPointerException, threw : " + e.toString());
        }
        harness.checkPoint("null constructors: File(file null, filestring) =>allowed");
        try {
            File nullfile = null;
            harness.check(new File(nullfile, testfilestring), new File(testfilestring), "File(File, string) definition");
        }
        catch (Exception e) {
            harness.fail(" constructor < File(file null, string) > should be allowed, threw : " + e.toString());
        }
        harness.checkPoint("null constructors: File(pathfile, null) =>exception");
        try {
            File newfile = new File("");
            harness.check(true, "constructor < File(emptystring) > is allowed");
            File testfile12 = new File(newfile, null);
            harness.fail(" constructor < File(pathfile, null) > should throw NullPointerException");
        }
        catch (NullPointerException e) {
            harness.check(true, " constructor < File(pathfile, null) > threw NullPointer as defined : " + e.toString());
        }
        catch (Exception e) {
            harness.fail(" constructor < File(pathfile, null) > should throw NullPointerException, threw : " + e.toString());
        }
        try {
            harness.checkPoint("File('',string) = File(string) or file('/string') : One of the next tests WILL fail");
            harness.check(new File("", testfilestring), new File(testfilestring));
            harness.check(new File("", testfilestring), new File(File.separator + testfilestring));
            harness.checkPoint("File(File(''),string) = File(string) or file('/string') : One of the next tests WILL fail");
            harness.check(new File(new File(""), testfilestring), new File(testfilestring));
            harness.check(new File(new File(""), testfilestring), new File(File.separator + testfilestring));
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileEquals() {
        try {
            File currentdir = new File("");
            String currentdirstring = currentdir.getCanonicalPath();
            File canonicalcurrentdir = currentdir.getCanonicalFile();
            String testfilestring = "testfile.scr";
            String testfilepath = currentdirstring + File.separator + testfilestring;
            File testfile1 = new File(testfilestring);
            File testfile2 = new File(testfilestring);
            File relative1 = new File(null, testfilestring);
            File relative2 = new File(null, testfilestring);
            File absolute0 = new File(currentdirstring + File.separator + testfilestring);
            File absolute1 = new File(currentdirstring, testfilestring);
            File absolute2 = new File(canonicalcurrentdir, testfilestring);
            harness.checkPoint("<getCanonicalFile()> full dir file target");
            File canonical = testfile1.getCanonicalFile();
            harness.check(testfile1.getCanonicalFile(), canonical, "value invariant to self");
            harness.check(testfile2.getCanonicalFile(), canonical, "same constructor");
            harness.check(relative1.getCanonicalFile(), canonical, "relative1: same target");
            harness.check(relative2.getCanonicalFile(), canonical, "relative2: same target");
            harness.check(absolute0.getCanonicalFile(), canonical, "absolute0: same target");
            harness.check(absolute1.getCanonicalFile(), canonical, "absolute1: same target");
            harness.check(absolute2.getCanonicalFile(), canonical, "absolute2: same target");
            harness.checkPoint("object.equals()");
            harness.check(testfile1, testfile1, "reflection, equals to self");
            harness.check(testfile1, testfile2, "same constructor");
            harness.check(testfile2, testfile1, "symmetricity");
            harness.check(testfile1, relative1, "implicit equivalent constructor");
            harness.check(testfile1, relative2, "implicit equivalent constructor");
            harness.check(relative1, relative2, "transitivity");
            harness.check(absolute0, absolute1, "implicit equivalent constructor");
            harness.check(absolute1, absolute2, "implicit equivalent constructor");
            harness.check(absolute0, absolute2, "(symmetric)transitivity");
            harness.check(testfile1.equals(absolute0) ^ true, "same target, different constructor => different object");
            harness.check(testfile2.equals(absolute0) ^ true, "transitivity");
            harness.check(absolute0.equals(testfile1) ^ true, "symmetricity");
            harness.check(relative1.equals(absolute1) ^ true, "same target, different constructor => different object");
            harness.check(relative2.equals(absolute2) ^ true, "same target, different constructor => different object");
            harness.checkPoint("getPath equals definitions");
            harness.check(testfile1.getPath(), testfile1.getPath(), "value invariant to self");
            harness.check(testfile1.getPath(), testfile2.getPath(), "same constructor");
            harness.check(testfile1.getPath(), relative1.getPath(), "implicit equivalent constructor");
            harness.check(testfile1.getPath(), relative2.getPath(), "implicit equivalent constructor");
            harness.check(absolute0.getPath(), absolute1.getPath(), "same constructor");
            harness.check(absolute0.getPath(), absolute2.getPath(), "same constructor");
            String path = testfile1.getPath();
            harness.check(path.equals(absolute0.getPath()) ^ true, "different constructor");
            harness.check(path.equals(absolute1.getPath()) ^ true, "different constructor");
            harness.check(path.equals(absolute2.getPath()) ^ true, "different constructor");
            harness.checkPoint("toString definitions");
            harness.check(testfile1.toString(), testfile1.toString(), "value invariant to self");
            harness.check(testfile1.toString(), testfile2.toString(), "same constructor");
            harness.check(testfile1.toString(), relative1.toString(), "implicit equivalent constructor");
            harness.check(testfile1.toString(), relative2.toString(), "implicit equivalent constructor");
            harness.check(absolute0.toString(), absolute1.toString(), "same constructor");
            harness.check(absolute0.toString(), absolute2.toString(), "same constructor");
            String text = testfile1.toString();
            harness.check(text.equals(absolute0.toString()) ^ true, "different constructor");
            harness.check(text.equals(absolute1.toString()) ^ true, "different constructor");
            harness.check(text.equals(absolute2.toString()) ^ true, "different constructor");
            harness.checkPoint("hashcode equals");
            harness.check(testfile1.hashCode(), testfile1.hashCode(), "reflexive to self");
            harness.check(testfile1.hashCode(), testfile2.hashCode(), "same constructor");
            harness.check(testfile1.hashCode(), relative1.hashCode(), "equivalent constructor");
            harness.check(testfile1.hashCode(), relative2.hashCode(), "equivalent constructor");
            harness.check(absolute0.hashCode(), absolute1.hashCode(), "equivalent constructor");
            harness.check(absolute0.hashCode(), absolute2.hashCode(), "equivalent constructor");
            harness.checkPoint("hashcode definition");
            int hashrelative = testfilestring.hashCode() ^ 0x12D591;
            int hashabsolute = testfilepath.hashCode() ^ 0x12D591;
            harness.check(testfile1.hashCode(), hashrelative, "hashCode definition");
            harness.check(testfile2.hashCode(), hashrelative, "hashCode definition");
            harness.check(relative1.hashCode(), relative1.toString().hashCode() ^ 0x12D591, "hashCode definition");
            harness.check(relative2.hashCode(), relative1.toString().hashCode() ^ 0x12D591, "hashCode definition");
            harness.check(absolute0.hashCode(), hashabsolute, "hashCode definition");
            harness.check(absolute1.hashCode(), hashabsolute, "hashCode definition");
            harness.check(absolute2.hashCode(), hashabsolute, "hashCode definition");
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
        try {
            String testfilestring = "testfile.scr";
            File testfile1 = new File(testfilestring);
            testfile1.compareTo(testfilestring);
            harness.fail("compareTo different classes should throw ClassCastException");
        }
        catch (ClassCastException e) {
            harness.check(true, "compareTo different classes throws ClassCastException : " + e.toString());
        }
        catch (Exception e) {
            harness.fail("compareTo different classes should throw ClassCastException, threw : " + e.toString());
        }
    }

    private final void testFileConstructorsCurrentDir(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on current directory");
        try {
            File currentdir = new File("");
            String canonicalrootpath = currentdir.getCanonicalPath();
            int pos = canonicalrootpath.lastIndexOf(47);
            String superpath = canonicalrootpath.substring(0, pos);
            String currentdirname = canonicalrootpath.substring(pos + 1);
            harness.verbose("current canonicalpath = " + canonicalrootpath);
            harness.verbose("superpath = " + superpath);
            harness.verbose("currentdirname = " + currentdirname);
            harness.checkPoint("Testing current dir File('')");
            File testfile = new File(canonicalrootpath);
            harness.checkPoint("Testing File( full currentdir.getCanonicalPath() <" + canonicalrootpath + "> = )");
            this.testFileProperties(testfile, canonicalrootpath, currentdirname, superpath, canonicalrootpath, canonicalrootpath, do_tests, verbose);
            testfile = new File(canonicalrootpath + File.separator);
            harness.checkPoint("Testing File(full currentdir path + file separator ending<" + canonicalrootpath + File.separator + ">)");
            this.testFileProperties(testfile, canonicalrootpath, currentdirname, superpath, canonicalrootpath, canonicalrootpath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsCurrentFile(boolean do_tests, boolean verbose) {
        harness.checkPoint("files in current directory");
        try {
            String testfilestring = "testfile.scr";
            File currentdir = new File("");
            String canonicalrootpath = currentdir.getCanonicalPath();
            String testfilepath = canonicalrootpath + File.separator + testfilestring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.checkPoint("new File(" + testfilestring + ");");
            File testfile = new File(testfilestring);
            this.testFileProperties(testfile, testfilestring, testfilestring, null, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(String null, " + testfilestring + ");");
            String nullstring = null;
            testfile = new File(nullstring, testfilestring);
            this.testFileProperties(testfile, testfilestring, testfilestring, null, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(File null, " + testfilestring + ");");
            File nullfile = null;
            testfile = new File(nullfile, testfilestring);
            this.testFileProperties(testfile, testfilestring, testfilestring, null, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + testfilepath + ");");
            testfile = new File(testfilepath);
            this.testFileProperties(testfile, testfilepath, testfilestring, canonicalrootpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicalrootpath + ", " + testfilestring + ");");
            testfile = new File(canonicalrootpath, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, canonicalrootpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicalrootpath + File.separator + ", " + testfilestring + ");");
            testfile = new File(canonicalrootpath + File.separator, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, canonicalrootpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("current dir canonical form, " + testfilestring + ");");
            testfile = new File(new File(canonicalrootpath), testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, canonicalrootpath, testfilepath, testfilepath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsSubdirFile(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on current directory");
        try {
            String subdirstring = "subdir";
            String testfilestring = "testfile.scr";
            String testfilepath = subdirstring + File.separator + testfilestring;
            File subdirfile = new File(subdirstring);
            File currentdir = new File("");
            String canonicalrootpath = currentdir.getCanonicalPath();
            String canonicaldirpath = canonicalrootpath + File.separator + subdirstring;
            String canonicalfilepath = canonicaldirpath + File.separator + testfilestring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.verbose("canonicaldirpath = " + canonicaldirpath);
            harness.verbose("canonicalfilepath = " + canonicalfilepath);
            harness.checkPoint("new File(" + testfilepath + ");");
            File testfile = new File(testfilepath);
            this.testFileProperties(testfile, testfilepath, testfilestring, subdirstring, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + subdirstring + ", " + testfilestring + ");");
            testfile = new File(subdirstring, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, subdirstring, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( File<" + subdirstring + ">, " + testfilestring + ");");
            testfile = new File(new File(subdirstring), testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, subdirstring, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicalrootpath + ", " + testfilepath + ");");
            testfile = new File(canonicalrootpath, testfilepath);
            this.testFileProperties(testfile, canonicalfilepath, testfilestring, canonicaldirpath, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicaldirpath + ", " + testfilestring + ");");
            testfile = new File(canonicaldirpath, testfilestring);
            this.testFileProperties(testfile, canonicalfilepath, testfilestring, canonicaldirpath, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( File<" + canonicalrootpath + ">, " + testfilepath + ");");
            testfile = new File(new File(canonicalrootpath), testfilepath);
            this.testFileProperties(testfile, canonicalfilepath, testfilestring, canonicaldirpath, canonicalfilepath, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( File<" + canonicaldirpath + ">, " + testfilestring + ");");
            testfile = new File(new File(canonicaldirpath), testfilestring);
            this.testFileProperties(testfile, canonicalfilepath, testfilestring, canonicaldirpath, canonicalfilepath, canonicalfilepath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsSuperDir(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on super(../) directory");
        try {
            String superstring = "..";
            File currentdir = new File("");
            String subdirstring = "subdir";
            String canonicalrootpath = currentdir.getCanonicalPath();
            String canonicaldirpath = canonicalrootpath + File.separator + subdirstring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.verbose("canonicaldirpath = " + canonicaldirpath);
            int pos = canonicalrootpath.lastIndexOf(47);
            String superpath = canonicalrootpath.substring(0, pos);
            String currentdirname = canonicalrootpath.substring(pos + 1);
            harness.verbose("superpath = " + superpath);
            harness.verbose("currentdirname = " + currentdirname);
            String target = canonicalrootpath + File.separator + superstring;
            harness.checkPoint("new File(" + superstring + ");");
            File testfile = new File(superstring);
            this.testFileProperties(testfile, superstring, superstring, null, target, superpath, do_tests, verbose);
            harness.checkPoint("new File(" + superstring + File.separator + ");");
            testfile = new File(superstring + File.separator);
            this.testFileProperties(testfile, superstring, superstring, null, target, superpath, do_tests, verbose);
            target = canonicaldirpath + File.separator + superstring;
            harness.checkPoint("new File(" + target + ");");
            testfile = new File(target);
            this.testFileProperties(testfile, target, superstring, canonicaldirpath, target, canonicalrootpath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicalrootpath + ", " + superstring + ");");
            testfile = new File(canonicaldirpath, superstring);
            this.testFileProperties(testfile, target, superstring, canonicaldirpath, target, canonicalrootpath, do_tests, verbose);
            harness.checkPoint("new File( <new file(" + canonicaldirpath + ")>" + superstring + ");");
            testfile = new File(new File(canonicaldirpath), superstring);
            this.testFileProperties(testfile, target, superstring, canonicaldirpath, target, canonicalrootpath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsSuperdirFile(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on files in super(../) directory");
        try {
            String superstring = "..";
            String testfilestring = "testfile.scr";
            String testfilepath = superstring + File.separator + testfilestring;
            File currentdir = new File("");
            String subdirstring = "subdir";
            String canonicalrootpath = currentdir.getCanonicalPath();
            String canonicaldirpath = canonicalrootpath + File.separator + subdirstring;
            String canonicalfilepath = canonicalrootpath + File.separator + testfilestring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.verbose("canonicaldirpath = " + canonicaldirpath);
            harness.verbose("canonicalfilepath = " + canonicalfilepath);
            int pos = canonicalrootpath.lastIndexOf(47);
            String superpath = canonicalrootpath.substring(0, pos);
            String currentdirname = canonicalrootpath.substring(pos + 1);
            String superfilename = superpath + File.separator + testfilestring;
            harness.verbose("superpath = " + superpath);
            harness.verbose("currentdirname = " + currentdirname);
            harness.verbose("superfilename = " + superfilename);
            String absolute = canonicalrootpath + File.separator + testfilepath;
            harness.checkPoint("new File(" + testfilepath + ");");
            File testfile = new File(testfilepath);
            this.testFileProperties(testfile, testfilepath, testfilestring, superstring, absolute, superfilename, do_tests, verbose);
            harness.checkPoint("new File(" + superstring + ", " + testfilestring + ");");
            testfile = new File(superstring, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, superstring, absolute, superfilename, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + superstring + ") >, " + testfilestring + ");");
            testfile = new File(new File(superstring), testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, superstring, absolute, superfilename, do_tests, verbose);
            String target = subdirstring + File.separator + testfilepath;
            String parent = subdirstring + File.separator + superstring;
            absolute = canonicaldirpath + File.separator + testfilepath;
            harness.checkPoint("new File(" + target + ");");
            testfile = new File(target);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + parent + ", " + testfilestring + ");");
            testfile = new File(subdirstring, testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( <new File(" + parent + ")> , " + testfilepath + ");");
            testfile = new File(new File(subdirstring), testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + subdirstring + ", " + testfilepath + ");");
            testfile = new File(subdirstring, testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( <new File(" + subdirstring + ")> , " + testfilepath + ");");
            testfile = new File(new File(subdirstring), testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            target = canonicaldirpath + File.separator + testfilepath;
            parent = canonicaldirpath + File.separator + superstring;
            harness.checkPoint("new File(" + target + ");");
            testfile = new File(target);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + parent + ", " + testfilestring + ");");
            testfile = new File(parent, testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + parent + ") >, " + testfilestring + ");");
            testfile = new File(new File(parent), testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicaldirpath + ", " + testfilepath + ");");
            testfile = new File(canonicaldirpath, testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + canonicaldirpath + ") >, " + testfilepath + ");");
            testfile = new File(new File(canonicaldirpath), testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsParalleldirFile(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on paraallel(../parallel) directory");
        try {
            String superstring = "..";
            String parallelstring = "parallel";
            String parallelpath = superstring + File.separator + parallelstring;
            String testfilestring = "testfile.scr";
            String testfilepath = parallelpath + File.separator + testfilestring;
            harness.verbose("parallelpath = " + parallelpath);
            harness.verbose("testfilepath = " + testfilepath);
            File currentdir = new File("");
            String canonicalrootpath = currentdir.getCanonicalPath();
            int pos = canonicalrootpath.lastIndexOf(47);
            String superpath = canonicalrootpath.substring(0, pos);
            String canonicaldirpath = superpath + File.separator + parallelstring;
            String canonicalfilepath = canonicaldirpath + File.separator + testfilestring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.verbose("canonicaldirpath = " + canonicaldirpath);
            harness.verbose("canonicalfilepath = " + canonicalfilepath);
            String absolute = canonicalrootpath + File.separator + parallelpath;
            harness.checkPoint("new File(" + parallelpath + ");");
            File testfile = new File(parallelpath);
            this.testFileProperties(testfile, parallelpath, parallelstring, superstring, absolute, canonicaldirpath, do_tests, verbose);
            harness.checkPoint("new File(" + parallelpath + File.separator + ");");
            testfile = new File(parallelpath + File.separator);
            this.testFileProperties(testfile, parallelpath, parallelstring, superstring, absolute, canonicaldirpath, do_tests, verbose);
            absolute = canonicalrootpath + File.separator + testfilepath;
            String parent = parallelstring + File.separator + testfilestring;
            harness.checkPoint("new File(" + testfilepath + ");");
            testfile = new File(testfilepath);
            this.testFileProperties(testfile, testfilepath, testfilestring, parallelpath, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + parallelpath + ", " + testfilestring + ");");
            testfile = new File(parallelpath, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, parallelpath, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( <new File(" + parallelpath + ")> , " + testfilestring + ");");
            testfile = new File(new File(parallelpath), testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, parallelpath, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + superstring + ", " + parent + ");");
            testfile = new File(superstring, parent);
            this.testFileProperties(testfile, testfilepath, testfilestring, parallelpath, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File( <new File(" + superstring + ")> , " + parent + ");");
            testfile = new File(new File(superstring), parent);
            this.testFileProperties(testfile, testfilepath, testfilestring, parallelpath, absolute, canonicalfilepath, do_tests, verbose);
            String subdirstring = "subdir";
            String canonicalsubdirpath = canonicalrootpath + File.separator + subdirstring;
            String canonicalparalleldirpath = canonicalrootpath + File.separator + parallelstring;
            canonicalfilepath = canonicalparalleldirpath + File.separator + testfilestring;
            harness.verbose("canonicalrootpath = " + canonicalrootpath);
            harness.verbose("canonicalsubdirpath = " + canonicalsubdirpath);
            harness.verbose("canonicalparalleldirpath = " + canonicalparalleldirpath);
            harness.verbose("canonicalfilepath = " + canonicalfilepath);
            String target = subdirstring + File.separator + testfilepath;
            parent = subdirstring + File.separator + parallelpath;
            absolute = canonicalsubdirpath + File.separator + testfilepath;
            harness.checkPoint("new File(" + target + ");");
            testfile = new File(target);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + parent + ", " + testfilestring + ");");
            testfile = new File(parent, testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + parent + ")> ," + testfilestring + ");");
            testfile = new File(new File(parent), testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + subdirstring + ',' + testfilepath + ");");
            testfile = new File(subdirstring, testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + subdirstring + ")> ," + testfilepath + ");");
            testfile = new File(new File(subdirstring), testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, absolute, canonicalfilepath, do_tests, verbose);
            target = canonicalsubdirpath + File.separator + testfilepath;
            parent = canonicalsubdirpath + File.separator + parallelpath;
            absolute = canonicalsubdirpath + File.separator + testfilepath;
            harness.checkPoint("new File(" + target + ");");
            testfile = new File(target);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + parent + ", " + testfilestring + ");");
            testfile = new File(parent, testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + parent + ")> ," + testfilestring + ");");
            testfile = new File(new File(parent), testfilestring);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            String tempdirpath = canonicalsubdirpath + File.separator + superstring;
            String tempfilepath = parallelstring + File.separator + testfilestring;
            harness.checkPoint("new File(" + tempdirpath + ", " + tempfilepath + ");");
            testfile = new File(tempdirpath, tempfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + tempdirpath + ")> ," + tempfilepath + ");");
            testfile = new File(new File(tempdirpath), tempfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + canonicalsubdirpath + ", " + testfilepath + ");");
            testfile = new File(canonicalsubdirpath, testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + canonicalsubdirpath + ")> ," + testfilepath + ");");
            testfile = new File(new File(canonicalsubdirpath), testfilepath);
            this.testFileProperties(testfile, target, testfilestring, parent, target, canonicalfilepath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileConstructorsRootdirFile(boolean do_tests, boolean verbose) {
        harness.checkPoint("file constructors on a full root(home/rootdir) directory");
        try {
            String rootstring = File.separator + "home";
            String rootdirstring = "wonka";
            String rootdirpath = rootstring + File.separator + rootdirstring;
            String testfilestring = "testfile.scr";
            String testfilepath = rootdirpath + File.separator + testfilestring;
            String target = rootdirpath + File.separator;
            harness.checkPoint("new File(" + target + ");");
            File testfile = new File(target);
            this.testFileProperties(testfile, rootdirpath, rootdirstring, rootstring, rootdirpath, rootdirpath, do_tests, verbose);
            target = rootdirstring + File.separator;
            harness.checkPoint("new File(" + rootstring + ", " + target + ");");
            testfile = new File(rootstring, target);
            this.testFileProperties(testfile, rootdirpath, rootdirstring, rootstring, rootdirpath, rootdirpath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + rootstring + ")>, " + target + ");");
            testfile = new File(new File(rootstring), target);
            this.testFileProperties(testfile, rootdirpath, rootdirstring, rootstring, rootdirpath, rootdirpath, do_tests, verbose);
            harness.checkPoint("new File(" + testfilepath + ");");
            testfile = new File(testfilepath);
            this.testFileProperties(testfile, testfilepath, testfilestring, rootdirpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(" + rootdirpath + ',' + testfilestring + ");");
            testfile = new File(rootdirpath, testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, rootdirpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + rootdirpath + ")>," + testfilestring + ");");
            testfile = new File(new File(rootdirpath), testfilestring);
            this.testFileProperties(testfile, testfilepath, testfilestring, rootdirpath, testfilepath, testfilepath, do_tests, verbose);
            target = rootdirstring + File.separator + testfilestring;
            harness.checkPoint("new File(" + rootstring + ',' + target + ");");
            testfile = new File(rootstring, target);
            this.testFileProperties(testfile, testfilepath, testfilestring, rootdirpath, testfilepath, testfilepath, do_tests, verbose);
            harness.checkPoint("new File(<new File(" + rootstring + ")>," + target + ");");
            testfile = new File(new File(rootstring), target);
            this.testFileProperties(testfile, testfilepath, testfilestring, rootdirpath, testfilepath, testfilepath, do_tests, verbose);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testFileToURL() {
        try {
            File currentdir = new File("");
            File canonicalfile = currentdir.getCanonicalFile();
            String canonicalpath = currentdir.getCanonicalPath();
            String testfilestring = "testfile.scr";
            String testfilepath = canonicalpath + File.separator + "testfile.scr";
            harness.checkPoint("url tests for absolute file");
            URL target1 = this.doURLTests(new File(testfilepath));
            harness.checkPoint("comparing URL from same file");
            File mirrorfile = new File(testfilepath);
            URL mirror1 = mirrorfile.toURL();
            harness.check(target1, mirror1, "same files same url's");
            harness.check(target1.getFile(), mirror1.getFile(), "same files same url.getFile()");
            harness.check(target1.toString(), mirror1.toString(), "same files same url.toString()");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.checkPoint("url tests for absolute files constructed with absolute dir/dir string");
            URL target2 = this.doURLTests(new File(canonicalfile, testfilestring));
            URL target3 = this.doURLTests(new File(canonicalpath, testfilestring));
            harness.checkPoint("comparing URL from same file, different constructors");
            harness.check(target1, target2, "same files/different constructors, same url's");
            harness.check(target1.getFile(), target2.getFile(), "same files same url.getFile()");
            harness.check(target1.toString(), target2.toString(), "same files same url.toString()");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.check(target1, target3, "same files/different constructors, same url's");
            harness.check(target1.getFile(), target3.getFile(), "same files same url.getFile()");
            harness.check(target1.toString(), target3.toString(), "same files same url.toString()");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.checkPoint("url tests for relative file");
            URL target4 = this.doURLTests(new File(testfilestring));
            harness.checkPoint("comparing URL from absolute and relative file");
            harness.check(target1, target4, "absolute and relative files, same url's");
            harness.check(target1.getFile(), target4.getFile(), "same files same url.getFile()");
            harness.check(target1.toString(), target4.toString(), "same files same url.toString()");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.checkPoint("url tests for absolute and relative dirs");
            URL targetdir1 = this.doURLTests(new File(canonicalpath), true);
            URL targetdir2 = this.doURLTests(canonicalfile, true);
            harness.checkPoint("urls of directories should end with '/', indepent of operating system");
            harness.check(targetdir1.toString().endsWith("/"), "directory<" + targetdir1 + "> should end with '/')");
            harness.check(targetdir2.toString().endsWith("/"), "directory<" + targetdir2 + "> should end with '/')");
            harness.checkPoint("comparing URL from same dirs, different constructors");
            harness.check(targetdir1, targetdir2, "same files/different constructors, same url's");
            harness.check(targetdir1.getFile(), targetdir2.getFile(), "same files same url.getFile()");
            harness.check(targetdir1.toString(), targetdir2.toString(), "same files same url.toString()");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.checkPoint("Special case: URL(File['']) not recognised as dir");
            URL targetdir3 = this.doURLTests(currentdir, false);
            harness.check(targetdir3.toString().endsWith("/") ^ true, "directory<''> not recognised as dir: should not end with '/')");
            harness.check(targetdir1.equals(targetdir3) ^ true, "equivalent path but not regarded as dir");
            harness.check(targetdir1.getFile().equals(targetdir3.getFile()) ^ true, "File('').grtFile not regarded as dir");
            harness.check(targetdir1.toString(), targetdir3.toString() + '/', "File('').toString() not regarded as dir");
            harness.fail("URL.sameFile() not yet defined for Wonka");
            harness.checkPoint("Special case: file explicitly created as dir => URL explicitly recognised as dir");
            File explicit = new File("newdir");
            explicit.mkdir();
            URL targetdir4 = this.doURLTests(explicit, true);
            harness.check(explicit.isDirectory(), "File.isDir() => URL file regarded as dir");
            harness.check(targetdir4.toString().endsWith("/"), "File created as dir should end with '/')");
            explicit.delete();
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final URL doURLTests(File source) {
        return this.doURLTests(source, false);
    }

    private final URL doURLTests(File source, boolean isdir) {
        URL dest = null;
        try {
            dest = source.toURL();
            harness.verbose("file <" + source + "> to URL : URL <" + dest + '>');
            harness.verbose("URL <" + dest + "> to file :<" + dest.getFile() + '>');
            harness.check(dest.getProtocol(), "file", "(file.toURL()).Protocol = file");
            harness.check(dest.getPort(), -1, "(file.toURL()).port = not_set/-1 by definition");
            harness.check(dest.getHost(), "", "(file.toURL()).Host = empty string");
            if (isdir) {
                harness.check(dest.getFile(), source.getCanonicalPath() + '/', "(directory.toURL()).getFile() = complete path + ending slash");
            } else {
                harness.check(dest.getFile(), source.getCanonicalPath(), "(file.toURL()).getFile() = complete path of file");
            }
            harness.check(dest.getRef(), null, "(file.toURL()).Ref = empty string");
        }
        catch (Exception ex) {
            harness.fail(ex.toString());
        }
        return dest;
    }

    private final void throwExURLTests(File target, String reason) {
        Object dest = null;
        try {
            target.toURL();
            harness.fail("toURL()(" + reason + ")should throw  MalformedURLException");
        }
        catch (MalformedURLException mux) {
            harness.check(true, "toURL()(" + reason + ")threw desired MalformedURLException : " + mux);
        }
        catch (Exception ex) {
            harness.fail("toURL()(" + reason + ")should throw  MalformedURLException, threw : " + ex);
        }
    }

    private final void testHiddenFiles() {
        if (File.separatorChar == '/') {
            harness.checkPoint("Checking hidden files (Unix/Linux only)");
            try {
                File currentdir = new File("");
                String canonicalroot = currentdir.getCanonicalPath();
                String testfilename = "public.scr";
                File testfile = new File(testfilename);
                harness.check(testfile.isHidden() ^ true, "[" + testfilename + ".isHidden() ]must be false");
                testfilename = canonicalroot + File.separator + testfilename;
                testfile = new File(testfilename);
                harness.check(testfile.isHidden() ^ true, "[" + testfilename + ".isHidden() ]must be false");
                testfilename = ".hidden.scr";
                testfile = new File(testfilename);
                harness.check(testfile.isHidden(), "[(" + testfilename + ").isHidden() ]must be true");
                testfilename = canonicalroot + File.separator + testfilename;
                testfile = new File(testfilename);
                harness.check(testfile.isHidden(), "[(" + testfilename + ").isHidden() ]must be true");
                testfilename = ".hiddendir";
                testfile = new File(testfilename);
                harness.check(testfile.isHidden(), "[(" + testfilename + ").isHidden() ]must be true");
                testfilename = canonicalroot + File.separator + testfilename;
                testfile = new File(testfilename);
                harness.check(testfile.isHidden(), "[(" + testfilename + ").isHidden() ]must be true");
                testfilename = ".hiddendir/notpublic.scr";
                testfile = new File(testfilename);
                harness.check(testfile.isHidden() ^ true, "[" + testfilename + ".isHidden() ] public file in hidden dir is NOT hidden");
                testfilename = canonicalroot + File.separator + testfilename;
                testfile = new File(testfilename);
                harness.check(testfile.isHidden() ^ true, "[" + testfilename + ".isHidden() ] public file in hidden dir is NOT hidden");
            }
            catch (Exception e) {
                harness.fail(e.toString());
            }
        }
    }

    private final void verboseFileProperties(File targetfile) {
        harness.verbose("target file => getPath :          <" + targetfile.getPath() + '>');
        harness.verbose("target file => getName :          <" + targetfile.getName() + '>');
        harness.verbose("target file => getParent :        <" + targetfile.getParent() + '>');
        harness.verbose("target file => getAbsolutePath :  <" + targetfile.getAbsolutePath() + '>');
        try {
            harness.verbose("target file => getCanonicalPath : <" + targetfile.getCanonicalPath() + '>');
        }
        catch (IOException iox) {
            harness.fail("IO exception canonicalPath for <" + targetfile.toString() + "> : " + iox.toString());
        }
    }

    private final void testFileProperties(File targetfile, String path, String name, String parent, String absolute, String canonical) {
        harness.check(targetfile.getPath(), path, "getPath()");
        harness.check(targetfile.toString(), path, "toString() definition");
        harness.check(targetfile.getName(), name, "getName()");
        if (path.startsWith(File.separator)) {
            harness.check(targetfile.isAbsolute(), "isAbsolute() must be true for" + targetfile);
        } else {
            harness.check(targetfile.isAbsolute() ^ true, "isAbsolute() must be false for" + targetfile);
        }
        harness.check(targetfile.getParent(), parent, "getParent()");
        if (parent == null) {
            harness.check(targetfile.getParentFile(), null, "getParentFile() definition (parent = null)");
        } else {
            harness.check(targetfile.getParentFile(), new File(parent), "getParentFile() definition");
        }
        harness.check(targetfile.getAbsolutePath(), absolute, "getAbsolutePath()");
        if (absolute == null) {
            harness.check(targetfile.getAbsoluteFile(), null, "getAbsoluteFile() definition (absolute form == null)");
        } else {
            harness.check(targetfile.getAbsoluteFile(), new File(absolute), "getAbsoluteFile() definition");
            harness.check(targetfile.getAbsoluteFile().isAbsolute(), "isAbsolute() definition absolute file");
        }
        try {
            harness.check(targetfile.getCanonicalPath(), canonical, "getCanonicalPath()");
            if (canonical == null) {
                harness.check(targetfile.getCanonicalFile(), null, "getCannonicalFile() definition (canonical form == null)");
            } else {
                harness.check(targetfile.getCanonicalFile(), new File(canonical), "getCanonicalFile() definition");
                harness.check(targetfile.getAbsoluteFile().isAbsolute(), "isAbsolute() definition canonical file");
            }
        }
        catch (IOException iox) {
            harness.fail("IO exception canonicalPath for <" + targetfile.toString() + "> : " + iox.toString());
        }
    }

    private final void testFileProperties(File targetfile, String path, String name, String parent, String absolute, String canonical, boolean do_tests, boolean verbose) {
        if (verbose) {
            this.verboseFileProperties(targetfile);
        }
        if (do_tests) {
            this.testFileProperties(targetfile, path, name, parent, absolute, canonical);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.io.File");
        this.testSeparators();
        this.testNullConstructors();
        this.testFileEquals();
        this.testFileConstructorsCurrentDir(true, false);
        this.testFileConstructorsCurrentFile(true, false);
        this.testFileConstructorsSubdirFile(true, false);
        this.testFileConstructorsSuperdirFile(true, false);
        this.testFileConstructorsSuperDir(true, false);
        this.testFileConstructorsParalleldirFile(true, false);
        this.testFileConstructorsRootdirFile(true, false);
        this.testFileToURL();
        this.testHiddenFiles();
    }
}

