/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.ByteArrayInputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.ByteArrayInputStream.SMExByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMByteArrayInputStreamTest
implements Testlet {
    protected TestHarness th;
    protected byte[] buffer;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.ByteArrayInputStream");
        this.test_ByteArrayInputStream();
        this.test_read();
        this.test_skip();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_available();
        this.test_close();
        this.test_buf();
        this.test_count();
        this.test_fieldmark();
        this.test_pos();
    }

    public void test_ByteArrayInputStream() {
        this.th.checkPoint("ByteArrayInputStream(byte[])");
        SMExByteArrayInputStream xbin = new SMExByteArrayInputStream(this.buffer);
        boolean bl = false;
        if (xbin.get_buf() == this.buffer) {
            bl = true;
        }
        this.th.check(bl, "the stream doesn't use a copy");
        boolean bl2 = false;
        if (xbin.get_pos() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "position is at the begin of the array");
        boolean bl3 = false;
        if (xbin.get_count() == this.buffer.length) {
            bl3 = true;
        }
        this.th.check(bl3, "count points to the endindex of the array -- got:" + xbin.get_count() + "length" + this.buffer.length);
        boolean bl4 = false;
        if (xbin.get_mark() == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "mark is at the begin of the array");
        try {
            new ByteArrayInputStream(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.checkPoint("ByteArrayInputStream(byte[],int,int)");
        try {
            xbin = new SMExByteArrayInputStream(null, 5, 10);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            xbin = new SMExByteArrayInputStream(this.buffer, -10, 15);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        try {
            xbin = new SMExByteArrayInputStream(this.buffer, 60, 10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        try {
            xbin = new SMExByteArrayInputStream(this.buffer, 5, -10);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        xbin = new SMExByteArrayInputStream(this.buffer, 5, 50);
        boolean bl5 = false;
        if (xbin.get_buf() == this.buffer) {
            bl5 = true;
        }
        this.th.check(bl5, "the stream doesn't use a copy");
        boolean bl6 = false;
        if (xbin.get_pos() == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "position is at the begin of the array");
        boolean bl7 = false;
        if (xbin.get_count() == 55) {
            bl7 = true;
        }
        this.th.check(bl7, "count points to the endindex of the array -- got:" + xbin.get_count());
        boolean bl8 = false;
        if (xbin.get_mark() == 5) {
            bl8 = true;
        }
        this.th.check(bl8, "mark is at the begin of the array");
    }

    public void test_read() {
        this.th.checkPoint("read()int");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer, 0, 14);
        try {
            this.th.check(bin.read(), 116);
            this.th.check(bin.read(), 104);
            this.th.check(bin.read(), 105);
            this.th.check(bin.read(), 115);
            this.th.check(bin.read(), 32);
            this.th.check(bin.read(), 105);
            this.th.check(bin.read(), 115);
            this.th.check(bin.read(), 32);
            this.th.check(bin.read(), 97);
            this.th.check(bin.read(), 32);
            this.th.check(bin.read(), 116);
            this.th.check(bin.read(), 101);
            this.th.check(bin.read(), 115);
            this.th.check(bin.read(), 116);
            this.th.check(bin.read(), -1);
            bin.close();
        }
        catch (IOException e) {
            this.th.fail("shouldn't throw an IOException");
        }
        this.th.check(bin.read(), -1, "EOF reached");
        this.th.checkPoint("read(byte[],int,int)int");
        bin = new ByteArrayInputStream(this.buffer, 0, 9);
        byte[] buf = new byte[12];
        try {
            boolean bl = false;
            if (bin.read(buf, 0, 12) == 9) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).startsWith("this is a"), "checking contents of buf -- 1 got:" + new String(buf));
        boolean bl = false;
        if (buf[9] == 0 && buf[10] == 0 && buf[11] == 0) {
            bl = true;
        }
        this.th.check(bl, "checking if rest is untouched");
        bin = new ByteArrayInputStream(this.buffer, 0, 40);
        try {
            boolean bl2 = false;
            if (bin.read(buf, 0, 12) == 12) {
                bl2 = true;
            }
            this.th.check(bl2);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).equals("this is a te"), "checking contents of buf -- 2, got:" + new String(buf));
        try {
            boolean bl3 = false;
            if (bin.read(buf, 0, 12) == 12) {
                bl3 = true;
            }
            this.th.check(bl3);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).equals("st buffer an"), "checking contents of buf -- 3, got:" + new String(buf));
        try {
            boolean bl4 = false;
            if (bin.read(buf, 0, 12) == 12) {
                bl4 = true;
            }
            this.th.check(bl4);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).equals("d contains s"), "checking contents of buf -- 4, got:" + new String(buf));
        try {
            boolean bl5 = false;
            if (bin.read(buf, 0, 12) == 4) {
                bl5 = true;
            }
            this.th.check(bl5);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).equals("ecrentains s"), "checking contents of buf -- 5, got:" + new String(buf));
        try {
            boolean bl6 = false;
            if (bin.read(buf, 0, 12) == -1) {
                bl6 = true;
            }
            this.th.check(bl6, "checking returnvlaues");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception -- got:" + e);
        }
        this.th.check(new String(buf).equals("ecrentains s"), "checking contents of buf -- 6, got:" + new String(buf));
        bin = new ByteArrayInputStream(this.buffer, 0, 40);
        try {
            bin.read(buf, -1, 10);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("cought wrong exception -- got:" + e);
        }
        try {
            bin.read(buf, 13, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2b");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("cought wrong exception -- got:" + e);
        }
        try {
            bin.read(buf, 12, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2c");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("cought wrong exception -- got:" + e);
        }
        try {
            bin.read(buf, 2, 11);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("cought wrong exception -- got:" + e);
        }
        try {
            bin.read(buf, 10, -1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("cought wrong exception -- got:" + e);
        }
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer, 25, 30);
        boolean bl = false;
        if (bin.skip(-20L) == 0L) {
            bl = true;
        }
        this.th.check(bl);
        boolean bl2 = false;
        if (bin.skip(0L) == 0L) {
            bl2 = true;
        }
        this.th.check(bl2);
        boolean bl3 = false;
        if (bin.skip(20L) == 20L) {
            bl3 = true;
        }
        this.th.check(bl3);
        boolean bl4 = false;
        if (bin.skip(20L) == 10L) {
            bl4 = true;
        }
        this.th.check(bl4);
        boolean bl5 = false;
        if (bin.skip(20L) == 0L) {
            bl5 = true;
        }
        this.th.check(bl5);
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        SMExByteArrayInputStream xbin = new SMExByteArrayInputStream(this.buffer, 25, 30);
        try {
            xbin.skip(10L);
            xbin.mark(2132234);
            boolean bl = false;
            if (xbin.get_mark() == 35) {
                bl = true;
            }
            this.th.check(bl);
            xbin.read();
            xbin.mark(-2132234);
            xbin.read();
            boolean bl2 = false;
            if (xbin.get_mark() == 36) {
                bl2 = true;
            }
            this.th.check(bl2);
            xbin.mark(0);
            boolean bl3 = false;
            if (xbin.get_mark() == 37) {
                bl3 = true;
            }
            this.th.check(bl3);
            xbin.read();
            xbin.mark(657);
            boolean bl4 = false;
            if (xbin.get_mark() == 38) {
                bl4 = true;
            }
            this.th.check(bl4);
        }
        catch (Exception e) {
            this.th.fail("should't throw exceptions");
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer, 25, 30);
        this.th.check(bin.markSupported());
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMExByteArrayInputStream xbin = new SMExByteArrayInputStream(this.buffer, 25, 30);
        try {
            xbin.skip(10L);
            xbin.reset();
            boolean bl = false;
            if (xbin.get_mark() == xbin.get_pos()) {
                bl = true;
            }
            this.th.check(bl);
            xbin = new SMExByteArrayInputStream(this.buffer);
            xbin.skip(30L);
            xbin.reset();
            boolean bl2 = false;
            if (xbin.get_mark() == xbin.get_pos()) {
                bl2 = true;
            }
            this.th.check(bl2);
            xbin.skip(30L);
            xbin.mark(30);
            xbin.skip(30L);
            xbin.reset();
            boolean bl3 = false;
            if (xbin.get_mark() == xbin.get_pos()) {
                bl3 = true;
            }
            this.th.check(bl3);
            xbin.close();
            xbin.reset();
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw an exception");
        }
    }

    public void test_available() {
        this.th.checkPoint("available()int");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer, 25, 30);
        boolean bl = false;
        if (bin.available() == 30) {
            bl = true;
        }
        this.th.check(bl, "test -- 1 got:" + bin.available());
        bin.skip(25L);
        boolean bl2 = false;
        if (bin.available() == 5) {
            bl2 = true;
        }
        this.th.check(bl2, "test -- 2 got:" + bin.available());
        bin.skip(15L);
        boolean bl3 = false;
        if (bin.available() == 0) {
            bl3 = true;
        }
        this.th.check(bl3, "test -- 3 got:" + bin.available());
        bin = new ByteArrayInputStream(this.buffer);
        boolean bl4 = false;
        if (bin.available() == 59) {
            bl4 = true;
        }
        this.th.check(bl4, "test -- 4 got:" + bin.available());
    }

    public void test_buf() {
        this.th.checkPoint("()");
    }

    public void test_count() {
        this.th.checkPoint("()");
    }

    public void test_fieldmark() {
        this.th.checkPoint("()");
    }

    public void test_pos() {
        this.th.checkPoint("()");
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer, 25, 30);
        try {
            bin.close();
            this.th.check(bin.available(), 30, "nothing availbale anymore");
        }
        catch (IOException e) {
            this.th.check(true);
        }
        bin = new ByteArrayInputStream(this.buffer, 25, 30);
        try {
            bin.close();
            this.th.check(bin.skip(4), (long)4, "nothing skipped");
        }
        catch (IOException e) {
            this.th.check(true);
        }
        bin = new ByteArrayInputStream(this.buffer, 25, 30);
        try {
            bin.close();
            this.th.check(bin.read(), 32, "nothing read -- 1");
        }
        catch (IOException e) {
            this.th.check(true);
        }
        try {
            bin.close();
            this.th.check(bin.read(new byte[10], 1, 2), 2, "nothing read -- 2");
        }
        catch (IOException e) {
            this.th.check(true);
        }
    }

    private final /* synthetic */ void this() {
        this.buffer = "this is a test buffer and contains secrets: don't tell them".getBytes();
    }

    public SMByteArrayInputStreamTest() {
        this.this();
    }
}

