/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.awt.Font;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.awt.Font.FontTestHelper;
import java.awt.Font;
import java.util.Properties;

public class FontTest
implements Testlet {
    TestHarness harness;

    void testStaticConsts() {
        this.harness.checkPoint("PLAIN(public)int");
        this.harness.check(true, "Font.PLAIN");
        this.harness.checkPoint("BOLD(public)int");
        this.harness.check(true, "Font.BOLD");
        this.harness.checkPoint("ITALIC(public)int");
        this.harness.check(true, "Font.ITALIC");
    }

    void testConstructors() {
        this.harness.checkPoint("Font(java.lang.String,int,int)");
        Font fnt1 = new Font("helvR14", 0, 18);
        Font fnt2 = new Font("helvR14", 0, 18);
        Font fnt3 = new Font("courR14", 0, 14);
        Font fnt4 = new Font("helvB14", 1, 18);
        Font fnt5 = new Font("courR21", 0, 21);
        Font fnt6 = new Font("any", 0, 19);
        boolean bl = false;
        if (fnt1 != null) {
            bl = true;
        }
        this.harness.check(bl, "Font(java.awt.String, int, int)");
        this.harness.check(fnt1.equals(null) ^ true, "Font(java.awt.String, int, int)");
        this.harness.checkPoint("equals(java.lang.Object)boolean");
        this.harness.check(fnt1.equals(fnt2), "equals(java.awt.Font)boolean");
        this.harness.check(fnt1.equals(fnt3) ^ true, "equals(java.awt.Font)boolean");
        this.harness.check(fnt1.equals(fnt4) ^ true, "equals(java.awt.Font)boolean");
        this.harness.check(fnt1.equals(fnt5) ^ true, "equals(java.awt.Font)boolean");
        this.harness.check(fnt6.equals(new Font("any", 0, 18)), "Font(java.awt.String, int, int)");
        this.harness.check(new Font(null, 0, 17).equals(new Font("Default", 0, 17)), "Font(java.awt.String, int, int)");
    }

    void testProtectedAttributes() {
        this.harness.checkPoint("Protected attributes");
        FontTestHelper fnt = new FontTestHelper();
        this.harness.check(fnt.testIt());
    }

    void testAccessMethods() {
        String fn1 = new String("courR10");
        Font fnt1 = new Font(fn1, 0, 10);
        String fn2 = new String("BullShit");
        Font fnt2 = new Font(fn2, 0, 15);
        this.harness.checkPoint("getName()java.lang.String");
        this.harness.check(fnt1.getName().equals(fn1), "getName()java.lang.String");
        this.harness.check(fnt2.getName().equals(fn2), "getName()java.lang.String");
        this.harness.checkPoint("getFamily()java.lang.String");
        this.harness.check(fnt1.getFamily().equals("Courier"), "getFamily()java.lang.String");
        this.harness.check(fnt2.getFamily().equals("Helvetica"), "getFamily()java.lang.String");
        this.harness.checkPoint("getSize()int");
        boolean bl = false;
        if (fnt1.getSize() == 10) {
            bl = true;
        }
        this.harness.check(bl, "getSize()int");
        boolean bl2 = false;
        if (fnt2.getSize() == 14) {
            bl2 = true;
        }
        this.harness.check(bl2, "getSize()int");
        this.harness.checkPoint("getStyle()int");
        boolean bl3 = false;
        if (fnt1.getStyle() == 0) {
            bl3 = true;
        }
        this.harness.check(bl3, "getStyle()int");
        boolean bl4 = false;
        if (fnt2.getStyle() == 0) {
            bl4 = true;
        }
        this.harness.check(bl4, "getStyle()int");
    }

    void testStyleComparison() {
        this.harness.checkPoint("isPlain()boolean");
        String fn1 = new String("SansSerif");
        Font fnt1 = new Font(fn1, 0, 12);
        this.harness.check(fnt1.isPlain(), "isPlain()boolean");
        this.harness.checkPoint("isBold()boolean");
        this.harness.check(fnt1.isBold() ^ true, "isBold()boolean");
        this.harness.checkPoint("isItalic()boolean");
        this.harness.check(fnt1.isItalic() ^ true, "isItalic()boolean");
    }

    void testDecode() {
        this.harness.checkPoint("decode(java.lang.String)java.awt.Font");
        Font fnt1 = Font.decode("courR10-plain-10");
        this.harness.check(fnt1.equals(new Font("courR10", 0, 10)), "decode(java.lang.String)java.awt.Font");
        Font fnt2 = Font.decode("helvR08-plain-10");
        this.harness.check(fnt2.equals(new Font("helvR08", 0, 8)), "decode(java.lang.String)java.awt.Font");
        Font fnt3 = Font.decode("courR10-bold-10");
        this.harness.check(fnt3.equals(new Font("courR10", 1, 10)), "decode(java.lang.String)java.awt.Font");
        Font fnt4 = Font.decode("courR10-plain-14");
        this.harness.check(fnt4.equals(new Font("courR10", 0, 10)), "decode(java.lang.String)java.awt.Font");
        Font fnt5 = Font.decode("helvR19-plain-19");
        this.harness.check(fnt5.equals(new Font("helvR19", 0, 18)), "decode(java.lang.String)java.awt.Font");
        Font fnt6 = Font.decode("helvR08");
        this.harness.check(fnt6.equals(new Font("helvR08", 0, 8)), "decode(java.lang.String)java.awt.Font");
        String s = null;
        Font fnt7 = Font.decode(s);
        this.harness.check(fnt7.equals(new Font("dialog", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt8 = Font.decode("");
        this.harness.check(fnt8.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt9 = Font.decode("Roman");
        this.harness.check(fnt9.equals(new Font("Roman", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt10 = Font.decode("Roman-plain-18");
        this.harness.check(fnt10.equals(new Font("Roman", 0, 18)), "decode(java.lang.String)java.awt.Font");
        Font fnt11 = Font.decode("courR10-underline-10");
        this.harness.check(fnt11.equals(new Font("courR10", 0, 10)), "decode(java.lang.String)java.awt.Font");
        Font fnt12 = Font.decode("-");
        this.harness.check(fnt12.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt13 = Font.decode("--");
        this.harness.check(fnt13.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt14 = Font.decode("---");
        this.harness.check(fnt14.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt15 = Font.decode("--xxx");
        this.harness.check(fnt15.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
        Font fnt16 = Font.decode("-yyyy-");
        this.harness.check(fnt16.equals(new Font("", 0, 12)), "decode(java.lang.String)java.awt.Font");
    }

    void testGetFont() {
        this.harness.checkPoint("getFont(java.lang.String,java.awt.Font)java.awt.Font");
        Properties p = System.getProperties();
        p.put("myFont", "courR14-plain-14");
        Font fnt1 = Font.getFont("myFont", new Font("courR10", 0, 10));
        this.harness.check(fnt1.equals(new Font("courR14", 0, 14)), "getFont(java.lang.String, java.awt.Font)java.awt.Font");
        Font fnt2 = Font.getFont("yourFont", new Font("courR10", 0, 10));
        this.harness.check(fnt2.equals(new Font("courR10", 0, 10)), "getFont(java.lang.String, java.awt.Font)java.awt.Font");
        this.harness.checkPoint("getFont(java.lang.String)java.awt.Font");
        Font fnt3 = Font.getFont("myFont");
        this.harness.check(fnt3.equals(new Font("courR14", 0, 14)), "getFont(java.lang.String)java.awt.Font");
        Font fnt4 = Font.getFont("yourFont");
        boolean bl = false;
        if (fnt4 == null) {
            bl = true;
        }
        this.harness.check(bl, "getFont(java.lang.String)java.awt.Font");
    }

    void testToString() {
        this.harness.checkPoint("toString()java.lang.String");
        this.harness.check(new Font("courR10", 0, 10).toString().equals("java.awt.Font[family = Courier, name = courR10, style = plain, size = 10]"), "toString()java.lang.String");
        this.harness.check(new Font("BullShit", 0, 10).toString().equals("java.awt.Font[family = Courier, name = BullShit, style = plain, size = 10]"), "toString()java.lang.String");
        this.harness.check(new Font("helvB14", 1, 18).toString().equals("java.awt.Font[family = Helvetica, name = helvB14, style = bold, size = 14]"), "toString()java.lang.String");
        this.harness.check(new Font("helvR08", 0, 8).toString().equals("java.awt.Font[family = Helvetica, name = helvR08, style = plain, size = 8]"), "toString()java.lang.String");
    }

    void testHashCode() {
        this.harness.checkPoint("hashCode()int");
        Font fnt1 = new Font("DialogInput", 0, 12);
        Font fnt2 = new Font("SansSerif", 0, 12);
        int h1 = fnt1.hashCode();
        int h2 = new String("DialogInput012").hashCode();
        this.harness.check(fnt1.hashCode(), h1, "hashCode()int");
        boolean bl = false;
        if (fnt2.hashCode() != h1) {
            bl = true;
        }
        this.harness.check(bl, "hashCode()int");
        boolean bl2 = false;
        if (fnt1.hashCode() != fnt2.hashCode()) {
            bl2 = true;
        }
        this.harness.check(bl2, "hashCode()int");
        this.harness.check(h1, h2, "hashCode()int");
    }

    public void test(TestHarness newharness) {
        this.harness = newharness;
        this.harness.setclass("java.awt.Font");
        this.testStaticConsts();
        this.testConstructors();
        this.testProtectedAttributes();
        this.testAccessMethods();
        this.testStyleComparison();
        this.testDecode();
        this.testGetFont();
        this.testToString();
        this.testHashCode();
    }
}

