/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TEST_ObjectOutputStream_Values_B1_BAD
extends Mv_Assert {
    private SAMPLE_ObjectStream_B root;
    private SAMPLE_ObjectStream_B check;
    private SAMPLE_ObjectStream_B original;
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;
    private byte[] output;
    private static final double DELTA = 1.0E-6;

    public TEST_ObjectOutputStream_Values_B1_BAD() {
        this.original = this.root = SAMPLE_SerialObject.getRootObject();
    }

    public void setUp() {
        this.openOutputStream();
        try {
            this.oos.writeObject(this.original);
            this.oos.flush();
        }
        catch (IOException ioe) {
            this.closeOutputStream();
            TEST_ObjectOutputStream_Values_B1_BAD.fail(ioe.toString());
        }
        this.output = this.baos.toByteArray();
        this.closeOutputStream();
        this.openInputStream(this.output);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail(e.toString());
        }
        this.closeInputStream();
        this.check = (SAMPLE_ObjectStream_B)this.object;
    }

    public void tearDown() {
    }

    private void closeOutputStream() {
        try {
            this.baos.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail(ioe.toString());
        }
    }

    private void openOutputStream() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TEST_ObjectOutputStream_Values_B1_BAD.fail("unexpected io exception occurred while setting up");
        }
    }

    public void closeInputStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("IO Exception while closing input stream");
        }
    }

    private void openInputStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("openStream> " + ioe.toString());
            return;
        }
    }

    public void testValues_Byte() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestByte(), this.original.getTestByte());
    }

    public void testValues_Int() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestInt(), this.original.getTestInt());
    }

    public void testValues_Float() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestFloat(), this.original.getTestFloat(), 1.0E-6);
    }

    public void testValues_Char() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestChar(), 122L);
    }

    public void testValues_Short() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestShort(), this.original.getTestShort());
    }

    public void testValues_Long() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestLong(), this.original.getTestLong());
    }

    public void testValues_Double() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getTestDouble(), this.original.getTestDouble(), 1.0E-6);
    }

    public void testValues_Boolean() {
        TEST_ObjectOutputStream_Values_B1_BAD.assert("boolean values are not equal", this.check.getTestBoolean() == this.original.getTestBoolean());
    }

    public void testValues_TransientInt() {
        TEST_ObjectOutputStream_Values_B1_BAD.assert(this.check.getTransientInt() == 0);
    }

    public void testValues_VolatileInt() {
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getVolatileInt(), this.original.getVolatileInt());
    }

    public void testValues_ArrayString() {
        if (!Arrays.equals(this.check.getArrayString(), this.original.getArrayString())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("strings don't match in array");
        }
    }

    public void testValues_ArrayByte() {
        if (!Arrays.equals(this.check.getArrayByte(), this.original.getArrayByte())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in byte array");
        }
    }

    public void testValues_ArrayInt() {
        if (!Arrays.equals(this.check.getArrayInt(), this.original.getArrayInt())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in int array");
        }
    }

    protected void runTestt() {
        if (!Arrays.equals(this.check.getArrayFloat(), this.original.getArrayFloat())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in float array");
        }
        if (!Arrays.equals(this.check.getArrayShort(), this.original.getArrayShort())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in short array");
        }
        if (!Arrays.equals(this.check.getArrayChar(), this.original.getArrayChar())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in char array");
        }
        if (!Arrays.equals(this.check.getArrayLong(), this.original.getArrayLong())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in long array");
        }
        if (!Arrays.equals(this.check.getArrayDouble(), this.original.getArrayDouble())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in double array");
        }
        if (!Arrays.equals(this.check.getArrayBoolean(), this.original.getArrayBoolean())) {
            TEST_ObjectOutputStream_Values_B1_BAD.fail("values don't match in boolean array");
        }
        TEST_ObjectOutputStream_Values_B1_BAD.assertNull(this.check.getTransientArrayString());
        TEST_ObjectOutputStream_Values_B1_BAD.assertEquals(this.check.getD().toString(), this.original.getD().toString());
        TEST_ObjectOutputStream_Values_B1_BAD.assertNull(this.check.getTransientD());
    }
}

