/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_OuterClass;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TEST_ObjectOutputStream_InnerClass_Values_Public
extends Mv_Assert {
    private SAMPLE_ObjectStream_OuterClass outerClass = SAMPLE_SerialObject.getOuterClass();
    private SAMPLE_ObjectStream_OuterClass outerClassAfter;
    private SAMPLE_ObjectStream_B check;
    private SAMPLE_ObjectStream_B original;
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;
    private byte[] output;
    private static final double DELTA = 1.0E-6;

    public TEST_ObjectOutputStream_InnerClass_Values_Public() {
        this.original = this.outerClass.puic;
    }

    public void setUp() {
        this.openOutputStream();
        try {
            this.oos.writeObject(this.outerClass);
            this.oos.flush();
        }
        catch (IOException ioe) {
            this.closeOutputStream();
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail(ioe.toString());
        }
        this.output = this.baos.toByteArray();
        this.closeOutputStream();
        this.openInputStream(this.output);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail(e.toString());
        }
        this.outerClassAfter = (SAMPLE_ObjectStream_OuterClass)this.object;
        this.check = this.outerClassAfter.puic;
    }

    public void tearDown() {
        this.closeInputStream();
    }

    private void openOutputStream() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("unexpected io exception occurred while setting up");
        }
    }

    private void closeOutputStream() {
        try {
            this.baos.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail(ioe.toString());
        }
    }

    public void closeInputStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("IO Exception while closing input stream");
        }
    }

    private void openInputStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestByte(), this.original.getTestByte());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestInt(), this.original.getTestInt());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestFloat(), this.original.getTestFloat(), 1.0E-6);
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestChar(), this.original.getTestChar());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestShort(), this.original.getTestShort());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestLong(), this.original.getTestLong());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getTestDouble(), this.original.getTestDouble(), 1.0E-6);
        TEST_ObjectOutputStream_InnerClass_Values_Public.assert("boolean values are not equal", this.check.getTestBoolean() == this.original.getTestBoolean());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assert(this.check.getTransientInt() == 0);
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getVolatileInt(), this.original.getVolatileInt());
        if (!Arrays.equals(this.check.getArrayString(), this.original.getArrayString())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("strings don't match in array");
        }
        if (!Arrays.equals(this.check.getArrayByte(), this.original.getArrayByte())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in byte array");
        }
        if (!Arrays.equals(this.check.getArrayInt(), this.original.getArrayInt())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in int array");
        }
        if (!Arrays.equals(this.check.getArrayFloat(), this.original.getArrayFloat())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in float array");
        }
        if (!Arrays.equals(this.check.getArrayShort(), this.original.getArrayShort())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in short array");
        }
        if (!Arrays.equals(this.check.getArrayChar(), this.original.getArrayChar())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in char array");
        }
        if (!Arrays.equals(this.check.getArrayLong(), this.original.getArrayLong())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in long array");
        }
        if (!Arrays.equals(this.check.getArrayDouble(), this.original.getArrayDouble())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in double array");
        }
        if (!Arrays.equals(this.check.getArrayBoolean(), this.original.getArrayBoolean())) {
            TEST_ObjectOutputStream_InnerClass_Values_Public.fail("values don't match in boolean array");
        }
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertNull(this.check.getTransientArrayString());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertEquals(this.check.getD().toString(), this.original.getD().toString());
        TEST_ObjectOutputStream_InnerClass_Values_Public.assertNull(this.check.getTransientD());
    }
}

