/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_A;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_C;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TEST_ObjectInputStream_Instanceof
extends Mv_Assert {
    private SAMPLE_ObjectStream_B root;
    private SAMPLE_ObjectStream_B b;
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private byte[] data = new byte[SAMPLE_SerialObject.dataInt.length];

    public TEST_ObjectInputStream_Instanceof() {
        for (int i = 0; i < SAMPLE_SerialObject.dataInt.length; ++i) {
            this.data[i] = (byte)SAMPLE_SerialObject.dataInt[i];
        }
        this.root = SAMPLE_SerialObject.getRootObject();
    }

    public void setUp() {
        this.openStream(this.data);
        try {
            this.object = this.ois.readObject();
        }
        catch (IOException e) {
            TEST_ObjectInputStream_Instanceof.fail(e.toString());
        }
        catch (ClassNotFoundException cnfe) {
            TEST_ObjectInputStream_Instanceof.fail(cnfe.toString());
        }
        this.closeStream();
        this.b = (SAMPLE_ObjectStream_B)this.object;
    }

    public void tearDown() {
    }

    public void closeStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_Instanceof.fail("IO Exception while closing input stream");
        }
    }

    private void openStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_Instanceof.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectInputStream_Instanceof.assert("read object not an instance of original", this.object instanceof SAMPLE_ObjectStream_B);
        TEST_ObjectInputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_B", this.b.getLeft() instanceof SAMPLE_ObjectStream_B);
        TEST_ObjectInputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_C", this.b.getRight() instanceof SAMPLE_ObjectStream_C);
        TEST_ObjectInputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_A", this.b.getLeft().getLeft() instanceof SAMPLE_ObjectStream_A);
        TEST_ObjectInputStream_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_C", this.b.getLeft().getRight() instanceof SAMPLE_ObjectStream_C);
    }
}

