/*
 * Decompiled with CFR 0.152.
 */
package wonka.vm;

public class IntArrayList {
    private static final int defaultCapacity = 8;
    private int[] elements;
    private int size;

    public void ensureCapacity(int minCapacity) {
        if (this.elements.length < minCapacity) {
            int[] oldElements = this.elements;
            int oldlength = this.size;
            minCapacity = minCapacity > this.elements.length * 2 ? minCapacity : this.elements.length * 2;
            this.elements = new int[minCapacity];
            System.arraycopy(oldElements, 0, this.elements, 0, oldlength);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(int elem) {
        int i = 0;
        while (i < this.size) {
            if (this.elements[i] == elem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(int elem) {
        int i = 0;
        while (i < this.size) {
            if (this.elements[i] == elem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(int elem) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.elements[i] == elem) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int[] toArray() {
        int[] answer = new int[this.size];
        System.arraycopy(this.elements, 0, answer, 0, this.size);
        return answer;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    public int set(int index, int element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int answer = this.elements[index];
        this.elements[index] = element;
        return answer;
    }

    public boolean add(int o) {
        this.ensureCapacity(this.size + 1);
        int position = this.size++;
        this.elements[position] = o;
        return true;
    }

    public boolean add(int[] array) {
        this.ensureCapacity(this.size + array.length);
        System.arraycopy(array, 0, this.elements, this.size, array.length);
        this.size += array.length;
        return true;
    }

    public void add(int index, int element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Asked index " + index + " in array of size " + this.size);
        }
        int todo = this.size - index;
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, todo);
        this.elements[index] = element;
        ++this.size;
    }

    public int remove(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Asked index " + index + " in array of size " + this.size);
        }
        int answer = this.elements[index];
        int todo = this.size - index - 1;
        System.arraycopy(this.elements, index + 1, this.elements, index, todo);
        --this.size;
        return answer;
    }

    public void clear() {
        int oldsize = this.size;
        this.size = 0;
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ensureCapacity(newSize);
        this.size = newSize;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex != this.size) {
            System.arraycopy(this.elements, toIndex, this.elements, fromIndex, this.size - toIndex);
        }
        this.size -= toIndex - fromIndex;
    }

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int initialCapacity) {
        this.elements = new int[initialCapacity];
    }
}

