/*
 * Decompiled with CFR 0.152.
 */
package wonka.decoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import wonka.decoders.Latin1Decoder;

public abstract class Decoder {
    private static final String[] names;
    private static final Object[] decoders;
    public static final Decoder DEFAULT;

    public static char[] decode(byte[] bytes, String enc) throws UnsupportedEncodingException {
        return Decoder.get(enc).bToC(bytes, 0, bytes.length);
    }

    public static byte[] encode(char[] chars, String enc) throws UnsupportedEncodingException {
        return Decoder.get(enc).cToB(chars, 0, chars.length);
    }

    public static Decoder getDefault(String key) {
        try {
            return Decoder.get(key);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return DEFAULT;
        }
    }

    public static Decoder get(String key) throws UnsupportedEncodingException {
        String coding = key.toUpperCase();
        int hash = coding.hashCode() % 37;
        String[] k = names;
        while (true) {
            String k2;
            if (hash < 0) {
                hash += 37;
            }
            if ((k2 = k[hash]) == null) {
                throw new UnsupportedEncodingException(key);
            }
            if (coding.equals(k2)) {
                Object o = decoders[hash];
                try {
                    return ((Decoder)o).getInstance();
                }
                catch (ClassCastException cce) {
                    try {
                        Decoder d = (Decoder)Class.forName("wonka.decoders." + o).newInstance();
                        Decoder.decoders[hash] = d;
                        return d.getInstance();
                    }
                    catch (Exception e) {
                        throw new UnsupportedEncodingException("Unable to initiate encoder for " + key);
                    }
                }
            }
            --hash;
        }
    }

    private static final void put(String key, Object newvalue) throws NullPointerException {
        int hash = key.hashCode() % 37;
        String[] k = names;
        while (true) {
            String k2;
            if (hash < 0) {
                hash += 37;
            }
            if ((k2 = k[hash]) == null) {
                k[hash] = key;
                Decoder.decoders[hash] = newvalue;
                return;
            }
            --hash;
        }
    }

    public byte[] cToB(StringBuffer buffer) {
        int length = buffer.length();
        char[] chars = new char[length];
        buffer.getChars(0, length, chars, 0);
        return this.cToB(chars, 0, length);
    }

    public abstract char[] bToC(byte[] var1, int var2, int var3);

    public abstract int cFromStream(InputStream var1, char[] var2, int var3, int var4) throws IOException;

    public abstract byte[] cToB(char[] var1, int var2, int var3);

    public abstract int getChar(InputStream var1) throws IOException;

    public abstract String getEncoding();

    protected Decoder getInstance() {
        return this;
    }

    static {
        decoders = new Object[37];
        names = new String[37];
        String s = "ASCIIDecoder";
        Decoder.put("ASCII", s);
        Decoder.put("US-ASCII", s);
        Decoder.put("ISO646-US", s);
        s = "UTF8Decoder";
        Decoder.put("UTF8", s);
        Decoder.put("UTF-8", s);
        s = "UTF16Decoder";
        Decoder.put("UTF16", s);
        Decoder.put("UTF-16", s);
        Decoder.put("UTF-16BE", "UTF16BeDecoder");
        Decoder.put("UTF-16LE", "UTF16LeDecoder");
        Latin1Decoder d = new Latin1Decoder();
        DEFAULT = d;
        Decoder.put("ISO8859_1", d);
        Decoder.put("8859_1", d);
        Decoder.put("ISO8859-1", d);
        Decoder.put("ISO-8859-1", d);
        Decoder.put("ISO-8859-15", d);
        Decoder.put("ISO_8859-1", d);
        Decoder.put("ISO_8859-1:1978", d);
        Decoder.put("ISO_8859-1:1987", d);
        Decoder.put("ISO-IR-100", d);
        Decoder.put("LATIN1", d);
        Decoder.put("L1", d);
        Decoder.put("CSLSOLATIN1", d);
    }
}

