/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import javax.microedition.io.Datagram;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicDatagram
implements Datagram {
    private Input in;
    private Output out;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    int pointer;
    int offset;
    byte[] buffer;
    int maxSize;
    DatagramPacket dgram;

    void debug() {
        System.out.println("\nBasicDatagram: pointer " + this.pointer + ", offset " + this.offset + ", maxSize " + this.maxSize);
        System.out.println("Content '" + new String(this.buffer, this.offset, this.pointer - this.offset) + '\'');
        System.out.println("to " + this.dgram.getAddress() + ", port " + this.dgram.getPort());
        System.out.println("DatagramPacket: offset " + this.dgram.getOffset() + ", length " + this.dgram.getLength());
        System.out.println("Content '" + new String(this.dgram.getData(), this.dgram.getOffset(), this.dgram.getLength()) + "'\n");
    }

    public String getAddress() {
        InetAddress addr = this.dgram.getAddress();
        return "//" + (addr == null ? "" : addr.getHostName()) + ':' + this.dgram.getPort();
    }

    public byte[] getData() {
        return this.buffer;
    }

    public int getLength() {
        return this.maxSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public void reset() {
        this.maxSize = this.buffer.length;
        this.dgram.setData(this.buffer, 0, this.maxSize);
        this.offset = 0;
        this.pointer = 0;
    }

    public void setAddress(String name) throws IOException {
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        int index = name.lastIndexOf(58);
        try {
            int port = Integer.parseInt(name.substring(index + 1));
            this.dgram.setAddress(InetAddress.getByName(name.substring(index)));
            this.dgram.setPort(port);
        }
        catch (RuntimeException rt) {
            throw new IOException("invalid name");
        }
    }

    public void setAddress(Datagram d) {
        try {
            this.setAddress(d.getAddress());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setData(byte[] data, int offset, int length) {
        this.dgram.setData(data, offset, length);
        this.buffer = data;
        this.offset = offset;
        this.pointer = offset;
        this.maxSize = length;
    }

    public void setLength(int length) {
        this.dgram.setLength(length);
        this.maxSize = length;
    }

    public void readFully(byte[] b) throws IOException {
        this.dataIn.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataIn.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.dataIn.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.dataIn.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataIn.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataIn.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataIn.readChar();
    }

    public int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    public long readLong() throws IOException {
        return this.dataIn.readLong();
    }

    public float readFloat() throws IOException {
        return this.dataIn.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataIn.readDouble();
    }

    public String readLine() throws IOException {
        return this.dataIn.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataIn.readUTF();
    }

    public void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dataOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOut.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dataOut.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dataOut.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.dataOut.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.dataOut.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.dataOut.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dataOut.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dataOut.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.dataOut.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.dataOut.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.dataOut.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this.dataOut.writeUTF(s);
    }

    private final /* synthetic */ void this() {
        this.pointer = 0;
        this.offset = 0;
    }

    BasicDatagram(byte[] buf, int size) {
        this.this();
        this.dgram = new DatagramPacket(buf, size);
        this.in = new Input();
        this.dataIn = new DataInputStream(this.in);
        this.out = new Output();
        this.dataOut = new DataOutputStream(this.out);
        this.buffer = buf;
        this.maxSize = size;
    }

    BasicDatagram(byte[] buf, int size, String name) throws IOException {
        this.this();
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        int index = name.lastIndexOf(58);
        try {
            int port = Integer.parseInt(name.substring(index + 1));
            this.dgram = new DatagramPacket(buf, size, InetAddress.getByName(name.substring(index)), port);
        }
        catch (Exception e) {
            throw new IOException("invalid name");
        }
        this.in = new Input();
        this.dataIn = new DataInputStream(this.in);
        this.out = new Output();
        this.dataOut = new DataOutputStream(this.out);
        this.buffer = buf;
        this.maxSize = size;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Input
    extends InputStream {
        public int read() throws IOException {
            if (BasicDatagram.this.pointer >= BasicDatagram.this.maxSize) {
                return -1;
            }
            try {
                return (char)BasicDatagram.this.buffer[BasicDatagram.this.pointer++];
            }
            catch (Exception e) {
                throw new IOException();
            }
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > buf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (BasicDatagram.this.pointer >= BasicDatagram.this.maxSize) {
                return -1;
            }
            int length = BasicDatagram.this.maxSize - BasicDatagram.this.pointer;
            length = len > length ? length : len;
            System.arraycopy(BasicDatagram.this.buffer, BasicDatagram.this.pointer, buf, off, length);
            BasicDatagram.this.pointer += length;
            return length;
        }

        Input() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Output
    extends OutputStream {
        public void write(int b) throws IOException {
            if (BasicDatagram.this.pointer >= BasicDatagram.this.maxSize) {
                throw new IOException("Buffer is full");
            }
            try {
                BasicDatagram.this.buffer[BasicDatagram.this.pointer++] = (byte)b;
            }
            catch (Exception e) {
                throw new IOException();
            }
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > buf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (BasicDatagram.this.pointer >= BasicDatagram.this.maxSize) {
                throw new IOException("Buffer is full");
            }
            int length = BasicDatagram.this.maxSize - BasicDatagram.this.pointer;
            length = len > length ? length : len;
            System.arraycopy(buf, off, BasicDatagram.this.buffer, BasicDatagram.this.pointer, length);
            BasicDatagram.this.pointer += length;
            if (length != len) {
                throw new IOException("Buffer is full");
            }
        }

        Output() {
        }
    }
}

