/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private boolean closed;
    private CRC32 crc;
    private LinkedList entries;
    private ZipEntry currentEntry;
    private boolean entryOpen;
    private boolean preset;
    private boolean inflating;
    private boolean inCentDir;
    private boolean allowDataDescriptor;
    private long dataCount;
    private int used;

    protected ZipEntry createZipEntry(String zname) {
        return new ZipEntry(zname);
    }

    public int available() throws IOException {
        return 1 - this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.entryOpen) {
                this.closeEntry();
            }
            super.close();
            this.closed = true;
            this.currentEntry = null;
        }
    }

    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public ZipEntry getNextEntry() throws IOException {
        this.closeEntry();
        this.readLFHeader();
        if (this.inflating && this.entryOpen) {
            this.presetBuf();
        }
        return this.currentEntry;
    }

    public void closeEntry() throws IOException {
        if (this.entryOpen) {
            byte[] data = new byte[128];
            while (this.read(data, 0, 128) != -1) {
            }
            this.used = this.len - this.inf.getRemaining();
            if (this.preset) {
                if (this.inflating ? this.currentEntry.getCrc() != this.crc.getValue() || this.currentEntry.getSize() != (long)this.inf.getTotalOut() || this.currentEntry.getCompressedSize() == (long)(this.inf.getTotalIn() + this.skipTillNextHeader()) : this.currentEntry.getCrc() != this.crc.getValue() || this.dataCount != 0L) {
                    throw new ZipException("data was corrupted");
                }
            } else {
                this.skipTillNextHeader();
                if (this.getBytes(data, 0, 16) < 16) {
                    throw new ZipException("data was corrupted");
                }
                if (data[0] != dataDescS[0] || data[1] != dataDescS[1] || data[2] != dataDescS[2] || data[3] != dataDescS[3] || this.crc.getValue() != ZipFile.bytesToLong(data, 4)) {
                    throw new ZipException("corrupt dataDescriptor");
                }
                this.currentEntry.setCrc(this.crc.getValue());
                this.currentEntry.setCompressedSize(ZipFile.bytesToLong(data, 8));
                this.currentEntry.setSize(ZipFile.bytesToLong(data, 12));
            }
            this.entryOpen = false;
        }
    }

    public int read(byte[] buff, int offset, int len) throws IOException {
        int read = -1;
        if (this.entryOpen) {
            if (this.inflating) {
                read = super.read(buff, offset, len);
                if (this.inf.needsDictionary()) {
                    throw new ZipException();
                }
                this.dataCount -= (long)read;
            } else if (this.dataCount > 0L) {
                len = (long)len > this.dataCount ? (int)this.dataCount : len;
                read = this.getBytes(buff, offset, len);
                this.dataCount -= (long)read;
            }
            if (read != -1) {
                this.crc.update(buff, offset, read);
            }
        }
        return read;
    }

    private final void readLFHeader() throws IOException {
        block8: {
            byte[] header = new byte[22];
            int l = 0;
            while (true) {
                if ((l = this.getBytes(header, l, 22 - l)) == -1) {
                    this.currentEntry = null;
                    break block8;
                }
                if (header[0] != 80 || header[1] != 75) {
                    throw new ZipException("corrupt header found");
                }
                if (header[2] == 3 && header[3] == 4) {
                    this.parseLocalFileHeader(header);
                    break block8;
                }
                if (header[2] == 1 && header[3] == 2) {
                    this.parseFileHeader(header);
                    l = 0;
                    continue;
                }
                if (header[2] == 5 && header[3] == 6) {
                    this.parseEndCD(header);
                    l = 0;
                    continue;
                }
                if (!this.allowDataDescriptor || header[2] != 7 || header[3] != 8) break;
                this.allowDataDescriptor = false;
                int i = 4;
                while (i < 16) {
                    if (header[i] != 0) {
                        throw new ZipException("header data is wrong");
                    }
                    ++i;
                }
                l = 6;
                System.arraycopy(header, 16, header, 0, 6);
            }
            throw new ZipException("corrupt header found");
        }
    }

    private final void parseFileHeader(byte[] header) throws IOException {
        byte[] buff = new byte[46];
        System.arraycopy(header, 0, buff, 0, 22);
        if (this.getBytes(buff, 22, 24) < 24) {
            throw new ZipException("bytes missing --> corrupt header");
        }
        int mode = (0xFF & (char)buff[10]) + (0xFF & (char)buff[11]) * 256;
        long time = ZipFile.getDate(buff, 12);
        long crc32 = ZipFile.bytesToLong(buff, 16);
        long compSize = ZipFile.bytesToLong(buff, 20);
        long size = ZipFile.bytesToLong(buff, 24);
        int fnlen = (0xFF & (char)buff[28]) + (0xFF & (char)buff[29]) * 256;
        byte[] fname = new byte[fnlen];
        this.getBytes(fname, 0, fnlen);
        String name = new String(fname, 0, fnlen);
        ListIterator li = this.entries.listIterator(0);
        ZipEntry ze = null;
        while (li.hasNext()) {
            ze = (ZipEntry)li.next();
            if (name.equals(ze.getName())) break;
        }
        if (ze == null) {
            throw new ZipException("corrupt header");
        }
        if (time != ze.getTime() || crc32 != ze.getCrc() || size != ze.getSize() || compSize != ze.getCompressedSize()) {
            throw new ZipException("corrupt header");
        }
        fnlen = (0xFF & (char)buff[30]) + (0xFF & (char)buff[31]) * 256;
        fname = new byte[fnlen];
        if (fnlen == 0) {
            ze.setExtra(null);
        } else {
            this.getBytes(fname, 0, fnlen);
            ze.setExtra(fname);
        }
        fnlen = (0xFF & (char)buff[32]) + (0xFF & (char)buff[33]) * 256;
        fname = new byte[fnlen];
        if (fnlen == 0) {
            ze.setComment(null);
        } else {
            this.getBytes(fname, 0, fnlen);
            ze.setComment(new String(fname, 0, fnlen));
        }
        this.inCentDir = true;
    }

    private final void parseLocalFileHeader(byte[] header) throws IOException {
        ZipEntry ze;
        if (this.inCentDir) {
            throw new ZipException("stream is corrupted");
        }
        int mode = (0xFF & (char)header[4]) + (0xFF & (char)header[5]) * 256;
        if (mode > 20) {
            throw new ZipException("higher zip version needed");
        }
        mode = 8 & (0xFF & (char)header[6]);
        if (this.getBytes(header, 0, 8) < 8) {
            throw new ZipException("bytes missing --> corrupt header");
        }
        int fnlen = (0xFF & (char)header[4]) + (0xFF & (char)header[5]) * 256;
        byte[] fname = new byte[fnlen];
        this.getBytes(fname, 0, fnlen);
        String name = new String(fname, 0, fnlen);
        ListIterator li = this.entries.listIterator(0);
        while (li.hasNext()) {
            ze = (ZipEntry)li.next();
            if (!name.equals(ze.getName())) continue;
            throw new ZipException("file name already exist");
        }
        ze = this.createZipEntry(name);
        if (mode != 8) {
            this.preset = true;
            ze.setCrc(ZipFile.bytesToLong(header, 14));
            ze.setCompressedSize(ZipFile.bytesToLong(header, 18));
            ze.setSize(ZipFile.bytesToLong(header, 0));
        } else {
            this.preset = false;
        }
        mode = (0xFF & (char)header[8]) + (0xFF & (char)header[9]) * 256;
        if (mode != 8 && mode != 0) {
            throw new ZipException("stream is corrupted");
        }
        if (mode == 8) {
            this.inflating = true;
        } else {
            if (!this.preset) {
                throw new ZipException("stream is corrupted");
            }
            this.inflating = false;
            this.dataCount = ze.getSize();
        }
        this.inf.reset();
        ze.setMethod(mode);
        ze.setTime(ZipFile.getDate(header, 10));
        fnlen = (0xFF & (char)header[6]) + (0xFF & (char)header[7]) * 256;
        fname = new byte[fnlen];
        if (fnlen == 0) {
            ze.setExtra(null);
        } else {
            this.getBytes(fname, 0, fnlen);
            ze.setExtra(fname);
        }
        this.entries.addLast(ze);
        this.currentEntry = ze;
        this.crc.reset();
        if (this.preset && ze.getCompressedSize() == 0L) {
            this.entryOpen = false;
            this.allowDataDescriptor = true;
        } else {
            this.entryOpen = true;
        }
    }

    private final void parseEndCD(byte[] header) throws IOException {
        if ((0xFF & (char)header[10]) + (0xFF & (char)header[11]) * 256 != this.entries.size()) {
            throw new ZipException("corrupt header");
        }
        int commentSize = (0xFF & (char)header[20]) + (0xFF & (char)header[21]) * 256;
        this.getBytes(new byte[commentSize], 0, commentSize);
        this.entries.clear();
        this.inCentDir = false;
    }

    private final int getBytes(byte[] target, int offset, int length) throws IOException {
        int rd = 0;
        while (length > 0) {
            int get = this.len - this.used;
            int n = get = get > length ? length : get;
            if (get > 0) {
                System.arraycopy(this.buf, this.used, target, offset, get);
                this.used += get;
            } else {
                get = this.in.read(target, offset, length);
                if (get == -1) {
                    if (rd != 0) break;
                    --rd;
                    break;
                }
            }
            length -= get;
            rd += get;
            offset += get;
        }
        return rd;
    }

    private final void presetBuf() {
        this.len -= this.used;
        System.arraycopy(this.buf, this.used, this.buf, 0, this.len);
        this.inf.setInput(this.buf, 0, this.len);
    }

    private final int skipTillNextHeader() throws IOException {
        int skipped = 0;
        byte[] head = new byte[1];
        this.getBytes(head, 0, 1);
        while (head[0] != 80) {
            ++skipped;
            this.getBytes(head, 0, 1);
        }
        --this.used;
        this.buf[this.used] = head[0];
        return skipped;
    }

    private final /* synthetic */ void this() {
        this.closed = false;
        this.crc = new CRC32();
        this.entries = new LinkedList();
        this.currentEntry = null;
        this.entryOpen = false;
        this.preset = false;
        this.inCentDir = false;
    }

    public ZipInputStream(InputStream in) {
        super(in, new Inflater(true));
        this.this();
    }
}

