/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    private boolean closed;
    protected CRC32 crc;
    protected boolean eos;

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
            this.inf = null;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int ret = super.read(buffer, offset, length);
        if (ret != -1) {
            this.crc.update(buffer, offset, ret);
        }
        if (ret == 1 || this.inf.finished()) {
            long value;
            if (this.inf.needsDictionary()) {
                throw new IOException();
            }
            int rem = this.inf.getRemaining();
            byte[] trailer = new byte[8];
            int off = this.len - rem;
            int n = rem = rem > 8 ? 8 : rem;
            if (off >= 0 && off < this.buf.length - rem) {
                System.arraycopy(this.buf, this.len - rem, trailer, 0, rem);
            }
            if (rem < 8) {
                this.in.read(trailer, rem, 8 - rem);
            }
            if ((int)(value = (long)((0xFF & (char)trailer[0]) + ((0xFF & (char)trailer[1]) << 8) + ((0xFF & (char)trailer[2]) << 16) + ((0xFF & (char)trailer[3]) << 24))) != (int)this.crc.getValue()) {
                throw new IOException();
            }
            value = (0xFF & (char)trailer[4]) + ((0xFF & (char)trailer[5]) << 8) + ((0xFF & (char)trailer[6]) << 16) + ((0xFF & (char)trailer[7]) << 24);
            if ((int)value != this.inf.getTotalOut()) {
                throw new IOException();
            }
        }
        return ret;
    }

    private final void parseHeader() throws IOException {
        int i;
        byte[] header = new byte[10];
        this.in.read(header, 0, 10);
        int flags = 0xFF & (char)header[3];
        if (header[0] != 31 || header[1] != -117 || header[2] != 8 || (flags & 0xE0) != 0) {
            throw new IOException("corrupt stream detected");
        }
        if ((flags & 4) > 0) {
            this.in.read(header, 0, 2);
            int len = (0xFF & (char)header[0]) + (0xFF & (char)header[1]) * 256;
            this.in.skip(len);
        }
        if ((flags & 8) > 0) {
            i = this.in.read();
            while (i > 0) {
                i = this.in.read();
            }
        }
        if ((flags & 0x10) > 0) {
            i = this.in.read();
            while (i > 0) {
                i = this.in.read();
            }
        }
        if ((flags & 2) > 0) {
            this.in.skip(2);
        }
    }

    private final /* synthetic */ void this() {
        this.closed = false;
        this.crc = new CRC32();
        this.eos = false;
    }

    public GZIPInputStream(InputStream instr) throws IOException {
        super(instr, new Inflater(true));
        this.this();
        this.parseHeader();
    }

    public GZIPInputStream(InputStream instr, int readsize) throws IOException {
        super(instr, new Inflater(true), readsize);
        this.this();
        this.parseHeader();
    }
}

