/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Manifest theEmptyManifest = new Manifest();
    private Manifest manifest = theEmptyManifest;

    public JarFile(File file) throws IOException {
        this(file, false);
    }

    public JarFile(String fname) throws IOException {
        this(new File(fname), false);
    }

    public JarFile(String fname, boolean verify) throws IOException {
        this(new File(fname), verify);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file);
        ZipEntry ze = this.getEntry(MANIFEST_NAME);
        if (ze != null) {
            this.manifest = new Manifest(this.getInputStream(ze));
        }
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        ZipEntry ze = this.getEntry(MANIFEST_NAME);
        if (ze != null) {
            this.manifest = new Manifest(this.getInputStream(ze));
        }
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        return super.getInputStream(ze);
    }

    public JarEntry getJarEntry(String name) {
        JarEntry je = (JarEntry)super.getEntry(name);
        return je;
    }

    public Manifest getManifest() throws IOException {
        return this.manifest;
    }
}

