/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Attributes
implements Map,
Cloneable {
    protected Map map;

    public Attributes() {
        this.map = new HashMap();
    }

    public Attributes(int cap) {
        this.map = new HashMap(cap);
    }

    public Attributes(Attributes attr) {
        this.map = new HashMap(attr.map);
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        Attributes cloned = null;
        try {
            cloned = (Attributes)super.clone();
            cloned.map = (Map)((HashMap)this.map).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }

    public boolean containsKey(Object name) {
        return this.map.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attributes)) {
            return false;
        }
        return ((Object)this.map).equals(((Attributes)o).map);
    }

    public Object get(Object name) {
        return this.map.get(name);
    }

    public String getValue(String name) {
        Name attName = new Name(name);
        return (String)this.get(attName);
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        return this.map.put((Name)name, (String)value);
    }

    public String putValue(String aname, String val) {
        return (String)this.map.put(new Name(aname), val);
    }

    public void putAll(Map attr) {
        this.map.putAll(attr);
    }

    public Object remove(Object name) {
        return this.map.remove(name);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public static class Name {
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SEALED = new Name("Sealed");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-Vendor-URL");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        private String name;

        public Name(String name) throws IllegalArgumentException, NullPointerException {
            int length = name.length();
            if (length == 0) {
                throw new IllegalArgumentException("A name cannot have a length of '0'");
            }
            char[] str = name.toCharArray();
            for (int i = 0; i < length; ++i) {
                char ch = str[i];
                if (Character.digit(ch, 36) != -1 || ch == '-' || ch == '_') continue;
                throw new IllegalArgumentException("bad digit '" + ch + "'");
            }
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object o) {
            boolean answer = false;
            if (o instanceof Name) {
                Name n2 = (Name)o;
                if (n2.name.equalsIgnoreCase(this.name)) {
                    answer = true;
                }
            }
            return answer;
        }
    }
}

