/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashReference;

public class WeakHashMap
extends AbstractMap
implements Map {
    static final Object nullKey = new Object();
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 101;
    private WeakHashReference[] entries;
    private ReferenceQueue queue;
    private int threshold;
    private int capacity;
    private float loadFactor;
    int occupancy;
    int modCount = 0;

    public WeakHashMap() {
        this(101, 0.75f);
    }

    public WeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("HashMap needs positive numbers");
        }
        this.capacity = initialCapacity < 5 ? 5 : initialCapacity;
        this.entries = new WeakHashReference[this.capacity];
        this.loadFactor = loadFactor > 1.0f ? 0.75f : loadFactor;
        this.queue = new ReferenceQueue();
    }

    public WeakHashMap(Map map) {
        int initialCapacity;
        this.capacity = initialCapacity = map.size() * 4 / 3 + 5;
        this.entries = new WeakHashReference[this.capacity];
        this.loadFactor = 0.75f;
        this.queue = new ReferenceQueue();
        Iterator it = map.entrySet().iterator();
        try {
            while (true) {
                Map.Entry me = (Map.Entry)it.next();
                this.put(me.getKey(), me.getValue());
            }
        }
        catch (NoSuchElementException nsee) {
            return;
        }
    }

    public void clear() {
        if (this.occupancy > 0) {
            this.entries = new WeakHashReference[this.capacity];
            this.occupancy = 0;
            ++this.modCount;
        }
    }

    public boolean containsKey(Object key) {
        this.checkQueue();
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        while (true) {
            WeakHashReference entry;
            if (hash < 0) {
                hash += cap;
            }
            if ((entry = this.entries[hash]) == null) {
                return false;
            }
            if (key.equals(entry.get())) {
                return true;
            }
            --hash;
        }
    }

    public Set entrySet() {
        this.checkQueue();
        return new WeakHashMapSet();
    }

    public Object get(Object key) {
        this.checkQueue();
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        while (true) {
            WeakHashReference entry;
            if (hash < 0) {
                hash += cap;
            }
            if ((entry = this.entries[hash]) == null) {
                return null;
            }
            if (key.equals(entry.get())) {
                return entry.value;
            }
            --hash;
        }
    }

    public boolean isEmpty() {
        this.checkQueue();
        return this.occupancy == 0;
    }

    public Object put(Object key, Object newvalue) {
        if (key == null) {
            key = nullKey;
        }
        this.checkQueue();
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        while (true) {
            WeakHashReference entry;
            if (hash < 0) {
                hash += cap;
            }
            if ((entry = this.entries[hash]) == null) {
                this.entries[hash] = new WeakHashReference(key, newvalue, this.queue);
                int occ = this.occupancy;
                this.occupancy = ++occ;
                if (this.threshold <= occ) {
                    this.resize();
                }
                ++this.modCount;
                return null;
            }
            if (key.equals(entry.get())) {
                Object oldvalue = entry.value;
                entry.value = newvalue;
                ++this.modCount;
                return oldvalue;
            }
            --hash;
        }
    }

    public Object remove(Object key) {
        this.checkQueue();
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        while (true) {
            WeakHashReference entry;
            if (hash < 0) {
                hash += cap;
            }
            if ((entry = this.entries[hash]) == null) {
                return null;
            }
            if (key.equals(entry.get())) {
                Object oldvalue = entry.value;
                this.deleteSlot(hash);
                ++this.modCount;
                return oldvalue;
            }
            --hash;
        }
    }

    public int size() {
        this.checkQueue();
        return this.occupancy;
    }

    void checkQueue() {
        WeakHashReference ref = (WeakHashReference)this.queue.poll();
        int cap = this.capacity;
        while (ref != null) {
            int place = ref.hashValue % cap;
            if (place < 0) {
                place += cap;
            }
            while (ref != this.entries[place]) {
                if (--place >= 0) continue;
                place += cap;
            }
            this.deleteSlot(place);
            ref = (WeakHashReference)this.queue.poll();
        }
    }

    int firstBusySlot(int i) {
        if (i < 0 || i >= this.capacity) {
            return -1;
        }
        for (int j = i; j < this.capacity; ++j) {
            if (this.entries[j] == null) continue;
            return j;
        }
        return -1;
    }

    void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        while (true) {
            this.entries[current] = null;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? this.capacity - 1 : current - 1;
                if (this.entries[current] == null) {
                    return;
                }
                int home = this.entries[current].hashValue % this.capacity;
                if (home < 0) {
                    home += this.capacity;
                }
                int distance1 = current <= home ? home - current : this.capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : this.capacity + vacant - current;
                happy = distance1 < distance2;
            }
            this.entries[vacant] = this.entries[current];
        }
    }

    private void resize() {
        int oldsize = this.capacity;
        int newsize = oldsize * 2 + 1;
        WeakHashReference[] oldkeys = this.entries;
        WeakHashReference[] entries = new WeakHashReference[newsize];
        this.capacity = newsize;
        this.threshold = (int)((float)newsize * this.loadFactor);
        for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            WeakHashReference key = oldkeys[oldindex];
            if (key == null) continue;
            int place = key.hashValue % newsize;
            if (place < 0) {
                place += newsize;
            }
            while (entries[place] != null) {
                if (--place >= 0) continue;
                place += newsize;
            }
            entries[place] = key;
        }
        this.entries = entries;
    }

    protected class WeakHashMapIterator
    implements Iterator {
        int pos;
        int mc;
        Object refKey;

        protected WeakHashMapIterator() {
            this.pos = WeakHashMap.this.firstBusySlot(0);
            this.mc = WeakHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.pos != -1;
        }

        public Object next() {
            if (WeakHashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please (this.modCount == " + this.mc + ", outer.modCount == " + WeakHashMap.this.modCount + ")");
            }
            if (this.pos == -1) {
                throw new NoSuchElementException("no elements left");
            }
            WeakHashReference entry = WeakHashMap.this.entries[this.pos];
            this.refKey = entry.get();
            this.pos = WeakHashMap.this.firstBusySlot(this.pos + 1);
            return entry;
        }

        public void remove() {
            if (this.refKey == null) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            if (WeakHashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            WeakHashMap.this.remove(this.refKey);
            ++this.mc;
            this.refKey = null;
        }
    }

    protected class WeakHashMapSet
    extends AbstractSet {
        protected WeakHashMapSet() {
        }

        public Iterator iterator() {
            return new WeakHashMapIterator();
        }

        public int size() {
            return WeakHashMap.this.size();
        }
    }
}

