/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements Cloneable,
List,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private transient int initialCapacity;
    private static final long serialVersionUID = -2767605614048989439L;

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public Vector(int initCap, int capIncr) {
        this.initialCapacity = initCap;
        this.elementData = new Object[initCap];
        this.capacityIncrement = capIncr;
    }

    public Vector(int initCap) {
        this.initialCapacity = initCap;
        this.elementData = new Object[initCap];
    }

    public Vector() {
        this.initialCapacity = 10;
        this.elementData = new Object[10];
    }

    public Vector(Collection c) {
        this.initialCapacity = c.size();
        this.elementData = new Object[this.initialCapacity];
        this.elementCount = 0;
        this.capacityIncrement = 0;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.elementData[this.elementCount++] = it.next();
        }
    }

    public synchronized boolean addAll(Collection c) {
        super.addAll(c);
        return c.size() > 0;
    }

    public synchronized boolean addAll(int idx, Collection c) {
        super.addAll(idx, c);
        return c.size() > 0;
    }

    public synchronized Object[] toArray() {
        return this.toArray(new Object[this.elementCount]);
    }

    public synchronized Object[] toArray(Object[] arr) {
        Object[] array = arr;
        if (array.length < this.elementCount) {
            array = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.elementCount);
        }
        if (array.length > this.elementCount) {
            array[this.elementCount] = null;
        }
        System.arraycopy(this.elementData, 0, array, 0, this.elementCount);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result = "[";
        boolean exhausted = false;
        int i = 0;
        Vector vector = this;
        synchronized (vector) {
            while (!exhausted) {
                if (i == this.elementCount) {
                    exhausted = true;
                    continue;
                }
                Object element = this.elementData[i];
                if (result.length() > 1) {
                    result = result + ", ";
                }
                result = element == null ? result + "null" : result + element;
                ++i;
            }
        }
        result = result + "]";
        return result;
    }

    public synchronized Object clone() {
        Vector nieuw = null;
        try {
            nieuw = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nieuw.elementData = new Object[this.elementData.length];
        System.arraycopy(this.elementData, 0, nieuw.elementData, 0, this.elementCount);
        return nieuw;
    }

    public synchronized Object elementAt(int index) {
        if (index < this.elementCount) {
            return this.elementData[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized void setElementAt(Object obj, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[index] = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstElement() throws NoSuchElementException {
        Vector vector = this;
        synchronized (vector) {
            if (this.elementCount == 0) {
                throw new NoSuchElementException();
            }
            return this.elementData[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastElement() throws NoSuchElementException {
        Vector vector = this;
        synchronized (vector) {
            if (this.elementCount == 0) {
                throw new NoSuchElementException();
            }
            return this.elementData[this.elementCount - 1];
        }
    }

    public synchronized void addElement(Object obj) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = obj;
        ++this.modCount;
    }

    public synchronized void insertElementAt(Object obj, int index) throws ArrayIndexOutOfBoundsException {
        int elementCount = this.elementCount;
        Object[] elementData = this.elementData;
        if (index < 0 || index > elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elementCount >= elementData.length) {
            this.ensureCapacity(elementCount + 1);
            elementData = this.elementData;
        }
        if (index < elementCount) {
            System.arraycopy(elementData, index, elementData, index + 1, elementCount - index);
        }
        elementData[index] = obj;
        ++this.elementCount;
        ++this.modCount;
    }

    public synchronized boolean removeElement(Object obj) {
        int i = this.indexOf(obj, 0);
        if (i < 0) {
            return false;
        }
        this.removeElementAt(i);
        return true;
    }

    public synchronized void removeElementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index < this.elementCount - 1) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - index - 1);
        }
        ++this.modCount;
        this.elementData[--this.elementCount] = null;
    }

    public synchronized void removeAllElements() {
        if (this.elementCount > 0) {
            ++this.modCount;
        }
        while (this.elementCount > 0) {
            this.elementData[--this.elementCount] = null;
        }
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int size() {
        return this.elementCount;
    }

    public synchronized void setSize(int newSize) throws ArrayIndexOutOfBoundsException {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ensureCapacity(newSize);
        if (newSize != this.elementCount) {
            ++this.modCount;
        }
        if (this.capacity() >= newSize && this.elementData.length >= newSize) {
            while (this.elementCount < newSize) {
                this.elementData[this.elementCount++] = null;
            }
            while (this.elementCount > newSize) {
                this.elementData[--this.elementCount] = null;
            }
        }
        this.trimToSize();
    }

    public int capacity() {
        return this.elementData.length;
    }

    public synchronized void ensureCapacity(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int newCapacity = this.capacityIncrement > 0 ? this.elementData.length + this.capacityIncrement : this.elementData.length * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newArray = new Object[newCapacity];
            System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
            this.elementData = newArray;
        }
    }

    public synchronized void trimToSize() {
        if (this.elementData.length > this.elementCount) {
            int newCapacity = this.elementCount;
            if (newCapacity < this.initialCapacity && this.initialCapacity < this.elementData.length) {
                newCapacity = this.initialCapacity;
            }
            Object[] newArray = new Object[newCapacity];
            System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
            this.elementData = newArray;
        }
    }

    public synchronized void copyInto(Object[] anArray) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public Enumeration elements() {
        return new VectorEnum();
    }

    public synchronized boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public synchronized int indexOf(Object elem) {
        if (elem != null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized int indexOf(Object elem, int index) throws ArrayIndexOutOfBoundsException {
        if (elem != null) {
            for (int i = index; i < this.elementCount; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = index; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object elem) {
        if (elem != null) {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object elem, int index) throws ArrayIndexOutOfBoundsException {
        if (elem != null) {
            for (int i = index; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized boolean add(Object o) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = o;
        ++this.modCount;
        return true;
    }

    public synchronized void add(int index, Object o) {
        this.insertElementAt(o, index);
    }

    public synchronized boolean remove(Object o) {
        return this.removeElement(o);
    }

    public synchronized Object remove(int index) {
        Object returnObject = this.elementAt(index);
        this.removeElementAt(index);
        return returnObject;
    }

    public synchronized Object get(int index) {
        return this.elementAt(index);
    }

    public Iterator iterator() {
        return new VectorIterator();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.elementCount || fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.elementCount - toIndex);
        int j = this.elementCount;
        this.elementCount -= toIndex - fromIndex;
        for (int i = this.elementCount; i < j; ++i) {
            this.elementData[i] = null;
        }
        ++this.modCount;
    }

    public Object set(int index, Object element) {
        if (index < 0 || index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object old = this.elementData[index];
        this.elementData[index] = element;
        return old;
    }

    public List subList(int fromIndex, int toIndex) throws UnsupportedOperationException {
        return super.subList(fromIndex, toIndex);
    }

    public synchronized boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection c) throws UnsupportedOperationException {
        if (c.isEmpty()) {
            return false;
        }
        Object[] newElements = new Object[this.elementData.length];
        int newElementCount = 0;
        for (int i = 0; i < this.elementCount; ++i) {
            if (c.contains(this.elementData[i])) continue;
            newElements[newElementCount++] = this.elementData[i];
        }
        if (this.elementCount == newElementCount) {
            return false;
        }
        this.elementData = newElements;
        this.elementCount = newElementCount;
        ++this.modCount;
        return true;
    }

    public synchronized boolean retainAll(Collection c) throws UnsupportedOperationException {
        if (c.isEmpty()) {
            boolean returnboolean = this.elementCount > 0;
            this.clear();
            return returnboolean;
        }
        Object[] newElements = new Object[this.elementData.length];
        int newElementCount = 0;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!c.contains(this.elementData[i])) continue;
            newElements[newElementCount++] = this.elementData[i];
        }
        if (this.elementCount == newElementCount) {
            return false;
        }
        this.elementData = newElements;
        this.elementCount = newElementCount;
        ++this.modCount;
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        if (this.elementCount > 0) {
            ++this.modCount;
        }
        this.elementCount = 0;
    }

    public synchronized int hashCode() {
        int hashcode = 1;
        int count = this.elementCount;
        Object[] data = this.elementData;
        for (int i = 0; i < count; ++i) {
            hashcode = 31 * hashcode + (data[i] == null ? 0 : data[i].hashCode());
        }
        return hashcode;
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (list.size() != this.elementCount) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != null ? this.elementData[i].equals(list.get(i)) : list.get(i) == null) continue;
            return false;
        }
        return true;
    }

    private class VectorIterator
    implements Iterator {
        private int i = 0;
        private int Status = 0;
        private int localModCount;

        private VectorIterator() {
            this.localModCount = Vector.this.modCount;
        }

        public boolean hasNext() throws ConcurrentModificationException {
            return this.i < Vector.this.elementCount;
        }

        public Object next() throws ConcurrentModificationException, NoSuchElementException {
            if (this.localModCount != Vector.this.modCount) {
                throw new ConcurrentModificationException("in the Iterator from Vector method next");
            }
            if (this.i < Vector.this.elementCount) {
                this.Status = 1;
                return Vector.this.elementData[this.i++];
            }
            throw new NoSuchElementException();
        }

        public void remove() throws ConcurrentModificationException, IllegalStateException {
            if (this.localModCount != Vector.this.modCount) {
                throw new ConcurrentModificationException("in the Iterator from Vector method remove");
            }
            if (this.Status != 1) {
                throw new IllegalStateException("remove() must be called after next()");
            }
            Vector.this.removeElementAt(--this.i);
            this.Status = 0;
            ++this.localModCount;
        }
    }

    private class VectorEnum
    implements Enumeration {
        private int _i = 0;

        private VectorEnum() {
        }

        public boolean hasMoreElements() {
            return this._i < Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() throws NoSuchElementException {
            Vector vector = Vector.this;
            synchronized (vector) {
                if (this._i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                return Vector.this.elementData[this._i++];
            }
        }
    }
}

