/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static boolean RED = true;
    private static boolean BLACK = false;
    private static final long serialVersionUID = 919286545866124006L;
    transient Node leaf;
    transient Node root;
    transient Node lastFind;
    transient int modcount;
    transient int size;
    private Comparator comparator;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int count = s.readInt();
        for (int i = 0; i < count; ++i) {
            Object key = s.readObject();
            this.put(key, s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Iterator it = this.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry me = (Map.Entry)it.next();
            s.writeObject(me.getKey());
            s.writeObject(me.getValue());
        }
    }

    public TreeMap() {
        this.root = this.leaf = new Node();
    }

    public TreeMap(Map m) {
        this.root = this.leaf = new Node();
        this.putAll(m);
    }

    public TreeMap(SortedMap s) {
        this.root = this.leaf = new Node();
        this.comparator = s.comparator();
        this.putAll(s);
    }

    public TreeMap(Comparator comp) {
        this.root = this.leaf = new Node();
        this.comparator = comp;
    }

    private void rotateLeft(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.leaf) {
            y.left.parent = x;
        }
        if (y != this.leaf) {
            y.parent = x.parent;
        }
        if (x.parent != null) {
            if (x == x.parent.left) {
                x.parent.left = y;
            } else {
                x.parent.right = y;
            }
        } else {
            this.root = y;
        }
        y.left = x;
        if (x != this.leaf) {
            x.parent = y;
        }
    }

    private void rotateRight(Node n) {
        Node y = n.left;
        n.left = y.right;
        if (y.right != this.leaf) {
            y.right.parent = n;
        }
        if (y != this.leaf) {
            y.parent = n.parent;
        }
        if (n.parent != null) {
            if (n == n.parent.right) {
                n.parent.right = y;
            } else {
                n.parent.left = y;
            }
        } else {
            this.root = y;
        }
        y.right = n;
        if (n != this.leaf) {
            n.parent = y;
        }
    }

    private void insertFixup(Node n) {
        while (n != this.root && n.parent.color == RED) {
            Node y;
            if (n.parent == n.parent.parent.left) {
                y = n.parent.parent.right;
                if (y.color == RED) {
                    n.parent.color = BLACK;
                    y.color = BLACK;
                    n.parent.parent.color = RED;
                    n = n.parent.parent;
                    continue;
                }
                if (n == n.parent.right) {
                    n = n.parent;
                    this.rotateLeft(n);
                }
                n.parent.color = BLACK;
                n.parent.parent.color = RED;
                this.rotateRight(n.parent.parent);
                continue;
            }
            y = n.parent.parent.left;
            if (y.color == RED) {
                n.parent.color = BLACK;
                y.color = BLACK;
                n.parent.parent.color = RED;
                n = n.parent.parent;
                continue;
            }
            if (n == n.parent.left) {
                n = n.parent;
                this.rotateRight(n);
            }
            n.parent.color = BLACK;
            n.parent.parent.color = RED;
            this.rotateLeft(n.parent.parent);
        }
        this.root.color = BLACK;
    }

    public Object put(Object key, Object value) {
        Node current = this.root;
        Node parent = null;
        while (current != this.leaf) {
            int comp = this.compare(key, current.key);
            if (comp == 0) {
                key = current.value;
                current.value = value;
                return key;
            }
            parent = current;
            current = comp < 0 ? current.left : current.right;
        }
        Node n = new Node(parent, key, value, this.leaf);
        ++this.modcount;
        if (parent != null) {
            if (this.compare(key, parent.key) < 0) {
                parent.left = n;
            } else {
                parent.right = n;
            }
        } else {
            this.root = n;
        }
        this.insertFixup(n);
        this.lastFind = null;
        ++this.size;
        return null;
    }

    private void deleteFixup(Node n) {
        while (n != this.root && n.color == BLACK) {
            Node y;
            if (n == n.parent.left) {
                y = n.parent.right;
                if (y.color == RED) {
                    y.color = BLACK;
                    n.parent.color = RED;
                    this.rotateLeft(n.parent);
                    y = n.parent.right;
                }
                if (y.left.color == BLACK && y.right.color == BLACK) {
                    y.color = RED;
                    n = n.parent;
                    continue;
                }
                if (y.right.color == BLACK) {
                    y.left.color = BLACK;
                    y.color = RED;
                    this.rotateRight(y);
                    y = n.parent.right;
                }
                y.color = n.parent.color;
                n.parent.color = BLACK;
                y.right.color = BLACK;
                this.rotateLeft(n.parent);
                n = this.root;
                continue;
            }
            y = n.parent.left;
            if (y.color == RED) {
                y.color = BLACK;
                n.parent.color = RED;
                this.rotateRight(n.parent);
                y = n.parent.left;
            }
            if (y.left.color == BLACK && y.right.color == BLACK) {
                y.color = RED;
                n = n.parent;
                continue;
            }
            if (y.left.color == BLACK) {
                y.right.color = BLACK;
                y.color = RED;
                this.rotateLeft(y);
                y = n.parent.left;
            }
            y.color = n.parent.color;
            n.parent.color = BLACK;
            y.left.color = BLACK;
            this.rotateRight(n.parent);
            n = this.root;
        }
        n.color = BLACK;
    }

    public Object remove(Object key) {
        Node y;
        Node n;
        if (this.lastFind != null && this.compare(key, this.lastFind.key) == 0) {
            n = this.lastFind;
        } else {
            int comp;
            n = this.root;
            while (n != this.leaf && (comp = this.compare(key, n.key)) != 0) {
                n = comp < 0 ? n.left : n.right;
            }
            if (n == this.leaf) {
                return null;
            }
        }
        key = n.value;
        ++this.modcount;
        if (n.right == this.leaf || n.left == this.leaf) {
            y = n;
        } else {
            y = n.right;
            while (y.left != this.leaf) {
                y = y.left;
            }
        }
        Node x = y.left != this.leaf ? y.left : y.right;
        x.parent = y.parent;
        if (y.parent != null) {
            if (y == y.parent.left) {
                y.parent.left = x;
            } else {
                y.parent.right = x;
            }
        } else {
            this.root = x;
        }
        if (y != n) {
            n.key = y.key;
            n.value = y.value;
        }
        if (y.color == BLACK) {
            this.deleteFixup(x);
        }
        this.lastFind = null;
        --this.size;
        return key;
    }

    public Object get(Object key) {
        Node n = this.root;
        while (n != this.leaf) {
            int comp = this.compare(key, n.key);
            if (comp == 0) {
                this.lastFind = n;
                return n.value;
            }
            n = comp < 0 ? n.left : n.right;
        }
        return null;
    }

    Node getNode(Object key) {
        Node n = this.root;
        while (n != this.leaf) {
            int comp = this.compare(key, n.key);
            if (comp == 0) {
                this.lastFind = n;
                return n;
            }
            n = comp < 0 ? n.left : n.right;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        Node n = this.root;
        while (n != this.leaf) {
            int comp = this.compare(key, n.key);
            if (comp == 0) {
                this.lastFind = n;
                return true;
            }
            n = comp < 0 ? n.left : n.right;
        }
        return false;
    }

    public boolean containsValue(Object o) {
        block7: {
            if (this.size <= 0) break block7;
            Node n = this.root;
            while (n.right != this.leaf) {
                n = n.right;
            }
            if (o == null) {
                while (n != null) {
                    if (n.value == null) {
                        return true;
                    }
                    n = this.nextNode(n);
                }
            } else {
                while (n != null) {
                    if (o.equals(n.value)) {
                        return true;
                    }
                    n = this.nextNode(n);
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        return new SubTreeSet(this.leaf, this.leaf);
    }

    public Set keySet() {
        return new KeySubSet(this.leaf, this.leaf);
    }

    public Collection values() {
        return new ValueSubSet(this.leaf, this.leaf);
    }

    public void putAll(Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public void clear() {
        this.lastFind = null;
        this.leaf.parent = null;
        this.root = this.leaf;
        this.size = 0;
        ++this.modcount;
    }

    public Object clone() {
        TreeMap s = null;
        try {
            s = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        s.clear();
        s.putAll(this);
        return s;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Node n = this.root;
        while (n.left != this.leaf) {
            n = n.left;
        }
        this.lastFind = n;
        return n.key;
    }

    public Object lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Node n = this.root;
        while (n.right != this.leaf) {
            n = n.right;
        }
        this.lastFind = n;
        return n.key;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public SortedMap headMap(Object toV) {
        return new SubTree(this.leaf, toV);
    }

    public SortedMap tailMap(Object fromV) {
        return new SubTree(fromV, this.leaf);
    }

    public SortedMap subMap(Object fromV, Object toV) {
        if (this.compare(fromV, toV) > 0) {
            throw new IllegalArgumentException();
        }
        return new SubTree(fromV, toV);
    }

    int compare(Object nkey, Object key) {
        int ret = this.comparator != null ? this.comparator.compare(nkey, key) : (nkey == null ? (key == null ? 0 : -((Comparable)key).compareTo(nkey)) : ((Comparable)nkey).compareTo(key));
        return ret;
    }

    Node locateLowerNode(Object from) throws NoSuchElementException {
        Node next = this.root;
        if (next == this.leaf) {
            throw new NoSuchElementException("Map is Empty");
        }
        if (from == this.leaf) {
            while (next.left != this.leaf) {
                next = next.left;
            }
            return next;
        }
        if (this.compare(from, next.key) <= 0) {
            while (next.left != this.leaf) {
                next = next.left;
            }
        }
        while (next != null) {
            if (this.compare(from, next.key) <= 0) {
                return next;
            }
            next = this.nextNode(next);
        }
        throw new NoSuchElementException();
    }

    Node locateUpperNode(Object to) throws NoSuchElementException {
        Node next = this.root;
        if (next == this.leaf) {
            throw new NoSuchElementException("Map is Empty");
        }
        if (this.leaf == to) {
            while (next.right != this.leaf) {
                next = next.right;
            }
            return next;
        }
        if (this.compare(to, next.key) <= 0) {
            while (next.left != this.leaf) {
                next = next.left;
            }
        }
        if (this.compare(to, next.key) <= 0) {
            throw new NoSuchElementException();
        }
        Node prev = next;
        next = this.nextNode(next);
        while (next != null) {
            if (this.compare(to, next.key) <= 0) {
                return prev;
            }
            prev = next;
            next = this.nextNode(next);
        }
        return prev;
    }

    Node nextNode(Node next) {
        Object key = next.key;
        while (next != null) {
            if (this.compare(key, next.key) < 0) {
                return next;
            }
            if (next.right != this.leaf && this.compare(key, next.right.key) < 0) {
                next = next.right;
                while (next.left != this.leaf) {
                    next = next.left;
                }
                return next;
            }
            next = next.parent;
        }
        return next;
    }

    Object locateLowerKey(Object from, Object to) {
        Object key;
        Object object = key = from == this.leaf ? this.firstKey() : this.locateLowerNode((Object)from).key;
        if (to == this.leaf || this.compare(key, to) < 0) {
            return key;
        }
        throw new NoSuchElementException("Map is Empty");
    }

    Object locateUpperKey(Object from, Object to) {
        Object key;
        Object object = key = to == this.leaf ? this.lastKey() : this.locateUpperNode((Object)to).key;
        if (from == this.leaf || this.compare(key, from) >= 0) {
            return key;
        }
        throw new NoSuchElementException("Map is Empty");
    }

    int calculateSize(Object from, Object to) {
        int size = 1;
        try {
            Node next = this.locateLowerNode(from);
            Object key = next.key;
            if (to != this.leaf && this.compare(next.key, to) >= 0) {
                return 0;
            }
            while (next != null) {
                if (this.compare(key, next.key) < 0) {
                    if (to == this.leaf || this.compare(next.key, to) < 0) {
                        ++size;
                        key = next.key;
                        continue;
                    }
                    break;
                }
                if (next.right != this.leaf && this.compare(key, next.right.key) < 0) {
                    next = next.right;
                    while (next.left != this.leaf) {
                        next = next.left;
                    }
                    if (to == this.leaf || this.compare(next.key, to) < 0) {
                        ++size;
                        key = next.key;
                        continue;
                    }
                    break;
                }
                next = next.parent;
            }
        }
        catch (NoSuchElementException nse) {
            size = 0;
        }
        return size;
    }

    private class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Node n) {
            this.key = n.key;
            this.value = n.value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object nv) {
            Object old = this.value;
            TreeMap.this.put(this.key, nv);
            this.value = nv;
            return old;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            int kc = this.key == null ? 0 : this.key.hashCode();
            int vc = this.value == null ? 0 : this.value.hashCode();
            return kc ^ vc;
        }
    }

    private class SetIterator
    implements Iterator {
        private Node node;
        private int mc;
        private Object end;
        private Node prevKey;
        private int rType;

        public SetIterator(Node n, Object to, int returnType) {
            if (n == TreeMap.this.leaf) {
                n = null;
            }
            this.node = n;
            this.end = to;
            this.mc = TreeMap.this.modcount;
            this.prevKey = TreeMap.this.leaf;
            this.rType = returnType;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            if (this.mc != TreeMap.this.modcount) {
                throw new ConcurrentModificationException();
            }
            this.prevKey = this.node;
            Object ret = this.rType == 0 ? new MapEntry(this.node) : (this.rType == 1 ? this.node.key : this.node.value);
            this.node = TreeMap.this.nextNode(this.node);
            if (this.end != TreeMap.this.leaf && this.node != null && TreeMap.this.compare(this.node.key, this.end) >= 0) {
                this.node = null;
            }
            return ret;
        }

        public void remove() {
            if (this.prevKey == TreeMap.this.leaf) {
                throw new IllegalStateException();
            }
            if (this.mc != TreeMap.this.modcount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.lastFind = this.prevKey;
            if (this.node != null) {
                Object key = this.node.key;
                TreeMap.this.remove(this.prevKey.key);
                this.node = TreeMap.this.getNode(key);
            } else {
                TreeMap.this.remove(this.prevKey.key);
            }
            this.prevKey = TreeMap.this.leaf;
            ++this.mc;
        }
    }

    private class SubTreeSet
    extends AbstractSet {
        private Object from;
        private Object to;
        private int smc;
        private int size;

        public SubTreeSet(Object fr, Object t) {
            this.from = fr;
            this.to = t;
            this.smc = -1;
        }

        public synchronized int size() {
            if (this.smc != TreeMap.this.modcount) {
                this.size = TreeMap.this.calculateSize(this.from, this.to);
            }
            return this.size;
        }

        public Iterator iterator() {
            Node n = null;
            try {
                n = TreeMap.this.locateLowerNode(this.from);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return new SetIterator(n, this.to, 0);
        }
    }

    private class ValueSubSet
    extends AbstractCollection {
        private Object from;
        private Object to;
        private int smc;
        private int size;

        public ValueSubSet(Object fr, Object t) {
            this.from = fr;
            this.to = t;
            this.smc = -1;
        }

        public synchronized int size() {
            if (this.smc != TreeMap.this.modcount) {
                this.size = TreeMap.this.calculateSize(this.from, this.to);
            }
            return this.size;
        }

        public Iterator iterator() {
            Node n = null;
            try {
                n = TreeMap.this.locateLowerNode(this.from);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return new SetIterator(n, this.to, -1);
        }
    }

    private class KeySubSet
    extends AbstractSet {
        private Object from;
        private Object to;
        private int smc;
        private int size;

        public KeySubSet(Object fr, Object t) {
            this.from = fr;
            this.to = t;
            this.smc = -1;
        }

        public int size() {
            if (this.smc != TreeMap.this.modcount) {
                this.size = TreeMap.this.calculateSize(this.from, this.to);
            }
            return this.size;
        }

        public Iterator iterator() {
            Node n = null;
            try {
                n = TreeMap.this.locateLowerNode(this.from);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return new SetIterator(n, this.to, 1);
        }
    }

    private class SubTree
    extends AbstractMap
    implements SortedMap {
        private Object from;
        private Object to;

        private void checkRange(Object k) {
            if (this.from != TreeMap.this.leaf && TreeMap.this.compare(k, this.from) < 0 || this.to != TreeMap.this.leaf && TreeMap.this.compare(k, this.to) >= 0) {
                throw new IllegalArgumentException();
            }
        }

        public SubTree(Object f, Object t) {
            this.from = f;
            this.to = t;
        }

        public Object firstKey() {
            return TreeMap.this.locateLowerKey(this.from, this.to);
        }

        public Object lastKey() {
            return TreeMap.this.locateUpperKey(this.from, this.to);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public SortedMap headMap(Object toV) {
            this.checkRange(toV);
            return new SubTree(this.from, toV);
        }

        public SortedMap subMap(Object fr, Object t) {
            if (TreeMap.this.compare(fr, t) > 0) {
                throw new IllegalArgumentException();
            }
            this.checkRange(fr);
            this.checkRange(t);
            return new SubTree(fr, t);
        }

        public SortedMap tailMap(Object fr) {
            this.checkRange(fr);
            return new SubTree(fr, this.to);
        }

        public Set entrySet() {
            return new SubTreeSet(this.from, this.to);
        }

        public Set keySet() {
            return new KeySubSet(this.from, this.to);
        }

        public Collection values() {
            return new ValueSubSet(this.from, this.to);
        }

        public Object put(Object key, Object value) {
            this.checkRange(key);
            return TreeMap.this.put(key, value);
        }

        public Object remove(Object key) {
            if (this.from != TreeMap.this.leaf && TreeMap.this.compare(key, this.from) < 0 || this.to != TreeMap.this.leaf && TreeMap.this.compare(key, this.to) >= 0) {
                return null;
            }
            return TreeMap.this.remove(key);
        }
    }

    static final class Node {
        public Node parent;
        public Node left;
        public Node right;
        public boolean color;
        public Object key;
        public Object value;

        public Node() {
            this.parent = null;
            this.left = this;
            this.right = this;
            this.color = BLACK;
        }

        public Node(Node p, Object k, Object v, Node leaf) {
            this.key = k;
            this.value = v;
            this.parent = p;
            this.color = RED;
            this.left = leaf;
            this.right = leaf;
        }
    }
}

