/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private static final long serialVersionUID = -403250971215465050L;
    private int dstSavings;
    private int endDay;
    private int endDayOfWeek;
    private int endMode;
    private int endMonth;
    private int endTime;
    private int rawOffset;
    private int serialVersionOnStream;
    private int startDay;
    private int startDayOfWeek;
    private int startMode;
    private int startMonth;
    private int startTime;
    private int startYear = 0;
    private transient boolean hasEndRule;
    private transient boolean hasStartRule;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private boolean useDaylight;
    private static final byte[] monthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public SimpleTimeZone(int rawOffset, String ID) {
        this.setID(ID);
        this.rawOffset = rawOffset;
        this.useDaylight = false;
        this.hasStartRule = false;
        this.hasEndRule = false;
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime) {
        this(rawOffset, ID, startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime, endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime, 3600000);
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime, int dstSavings) {
        this.setID(ID);
        this.rawOffset = rawOffset;
        if (dstSavings < 0 || startTime < 0 || startTime >= 86400000 || endTime < 0 || endTime >= 86400000 || startMonth < 0 || startMonth > 11 || endMonth < 0 || endMonth > 11) {
            throw new IllegalArgumentException("1");
        }
        if (startDayOfWeekInMonth == 0 || startDayOfWeek > 7 || startDayOfWeek < -7 || startDayOfWeekInMonth > 31 || startDayOfWeekInMonth < -31 || (startDayOfWeekInMonth > 5 || startDayOfWeekInMonth < -5) && startDayOfWeek > 0) {
            throw new IllegalArgumentException("2 got stDoWiM" + startDayOfWeekInMonth + "and stDoW " + startDayOfWeek);
        }
        if (endDayOfWeekInMonth == 0 || endDayOfWeek > 7 || endDayOfWeek < -7 || endDayOfWeekInMonth > 31 || endDayOfWeekInMonth < -31 || (endDayOfWeekInMonth > 5 || endDayOfWeekInMonth < -5) && endDayOfWeek > 0) {
            throw new IllegalArgumentException("3 got endDoWiM" + endDayOfWeekInMonth + "and endDoW " + endDayOfWeek);
        }
        this.startMonth = startMonth;
        this.startTime = startTime;
        this.endMonth = endMonth;
        this.endTime = endTime;
        this.dstSavings = dstSavings;
        this.startMode = this.calculatedstSavMode(startDayOfWeek, startDayOfWeekInMonth);
        this.endMode = this.calculatedstSavMode(endDayOfWeek, endDayOfWeekInMonth);
        this.startDayOfWeek = Math.abs(startDayOfWeek);
        this.endDayOfWeek = Math.abs(endDayOfWeek);
        this.startDay = startDayOfWeekInMonth * (this.startMode == 4 ? -1 : 1);
        this.endDay = endDayOfWeekInMonth * (this.endMode == 4 ? -1 : 1);
        if (dstSavings != 0) {
            this.useDaylight = true;
        }
        this.hasStartRule = true;
        this.hasEndRule = true;
    }

    private int calculatedstSavMode(int dow, int dowim) {
        if (dow == 0) {
            return 1;
        }
        if (dow > 0) {
            return 2;
        }
        if (dowim > 0) {
            return 3;
        }
        return 4;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int offsetMillis) {
        this.rawOffset = offsetMillis;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public void setDSTSavings(int dst) {
        if (dst < 0) {
            throw new IllegalArgumentException();
        }
        this.dstSavings = dst;
    }

    public void setEndRule(int month, int dayOfWInM, int dayOfW, int time) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11 || dayOfW > 7 || dayOfW < 1 || dayOfWInM > 5 || dayOfWInM < -5) {
            throw new IllegalArgumentException();
        }
        if (dayOfWInM == 0) {
            this.useDaylight = false;
            this.hasEndRule = false;
        } else {
            this.hasEndRule = true;
            this.useDaylight |= this.hasEndRule && this.hasStartRule;
            this.endMonth = month;
            this.endMode = 2;
            this.endDayOfWeek = dayOfW;
            this.endDay = dayOfWInM;
            this.endTime = time;
        }
    }

    public void setEndRule(int month, int dayOfM, int time) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        if (dayOfM < 1 || dayOfM > monthLength[month]) {
            throw new IllegalArgumentException("end Day Of Month is wrong, got " + dayOfM);
        }
        this.hasEndRule = true;
        this.useDaylight |= this.hasEndRule && this.hasStartRule;
        this.endMonth = month;
        this.endMode = 1;
        this.endDay = dayOfM;
        this.endTime = time;
    }

    public void setEndRule(int month, int dayOfM, int dayOfW, int time, boolean after) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11 || dayOfW > 7 || dayOfW < 1) {
            throw new IllegalArgumentException();
        }
        if (dayOfM < 1 || dayOfM > monthLength[month]) {
            throw new IllegalArgumentException("end Day Of Month is wrong, got " + dayOfM);
        }
        this.hasEndRule = true;
        this.useDaylight |= this.hasEndRule && this.hasStartRule;
        this.endMonth = month;
        this.endMode = after ? 3 : 4;
        this.endDay = dayOfM;
        this.endDayOfWeek = dayOfW;
        this.endTime = time;
    }

    public void setStartRule(int month, int dayOfWInM, int dayOfW, int time) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11 || dayOfW > 7 || dayOfW < 1 || dayOfWInM > 5 || dayOfWInM < -5) {
            throw new IllegalArgumentException();
        }
        if (dayOfWInM == 0) {
            this.useDaylight = false;
            this.hasStartRule = false;
        } else {
            this.hasStartRule = true;
            this.useDaylight |= this.hasEndRule && this.hasStartRule;
            this.startMonth = month;
            this.startMode = 2;
            this.startDayOfWeek = dayOfW;
            this.startDay = dayOfWInM;
            this.startTime = time;
        }
    }

    public void setStartRule(int month, int dayOfM, int time) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        if (dayOfM < 1 || dayOfM > monthLength[month]) {
            throw new IllegalArgumentException("start Day Of Month is wrong, got " + dayOfM);
        }
        this.hasStartRule = true;
        this.useDaylight |= this.hasEndRule && this.hasStartRule;
        this.startMonth = month;
        this.startMode = 1;
        this.startDay = dayOfM;
        this.startTime = time;
    }

    public void setStartRule(int month, int dayOfM, int dayOfW, int time, boolean after) {
        if (time < 0 || time >= 86400000 || month < 0 || month > 11 || dayOfW > 7 || dayOfW < 1) {
            throw new IllegalArgumentException();
        }
        if (dayOfM < 1 || dayOfM > monthLength[month]) {
            throw new IllegalArgumentException("start Day Of Month is wrong, got " + dayOfM);
        }
        this.hasStartRule = true;
        this.useDaylight |= this.hasEndRule && this.hasStartRule;
        this.startMonth = month;
        this.startMode = after ? 3 : 4;
        this.startDay = dayOfM;
        this.startDayOfWeek = dayOfW;
        this.startTime = time;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(250);
        buf.append("java.util.SimpleTimeZone[id=");
        buf.append(this.getID());
        buf.append(",offset=");
        buf.append(this.rawOffset);
        buf.append(",dstSavings=");
        buf.append(this.dstSavings);
        buf.append(",useDaylight=");
        buf.append(this.useDaylight);
        buf.append(",startYear=");
        buf.append(this.startYear);
        buf.append(",startMode=");
        buf.append(this.startMode);
        buf.append(",startMonth=");
        buf.append(this.startMonth);
        buf.append(",startDay=");
        buf.append(this.startDay);
        buf.append(",startDayOfWeek=");
        buf.append(this.startDayOfWeek);
        buf.append(",startTime=");
        buf.append(this.startTime);
        buf.append(",endMode=");
        buf.append(this.endMode);
        buf.append(",endMonth=");
        buf.append(this.endMonth);
        buf.append(",endDay=");
        buf.append(this.endDay);
        buf.append(",endDayOfWeek=");
        buf.append(this.endDayOfWeek);
        buf.append(",endTime=");
        buf.append(this.endTime);
        buf.append(']');
        return new String(buf);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone other = (SimpleTimeZone)o;
        return other.getID() == this.getID() && this.hasSameRules(other);
    }

    public boolean hasSameRules(TimeZone other) {
        boolean b;
        if (!(other instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone ostz = (SimpleTimeZone)other;
        boolean bl = b = this.rawOffset == ostz.rawOffset && this.useDaylight == ostz.useDaylight;
        if (b && this.useDaylight) {
            return b;
        }
        b &= this.startMonth == ostz.startMonth;
        b &= this.endMonth == ostz.endMonth;
        b &= this.startMode == ostz.startMode;
        b &= this.endMode == ostz.endMode;
        b &= this.startTime == ostz.startTime;
        b &= this.startDay == ostz.startDay;
        b &= this.endTime == ostz.endTime;
        b &= this.endDay == ostz.endDay;
        if (this.startMode != 1) {
            b &= this.startDayOfWeek == ostz.startDayOfWeek;
        }
        if (this.endMode != 1) {
            b &= this.endDayOfWeek == ostz.endDayOfWeek;
        }
        return b;
    }

    private boolean inDaylightTime(int era, int year, int month, int day, int dayOffWeek, int millis) {
        int sDay;
        boolean b = this.startYear <= year && era == 1;
        if (month == this.startMonth && (b &= (month >= this.startMonth && month <= this.endMonth || this.endMonth <= this.startMonth) && (month >= this.startMonth || month <= this.endMonth || this.endMonth >= this.startMonth))) {
            switch (this.startMode) {
                case 1: {
                    b = day > this.startDay || day == this.startDay && millis >= this.startTime;
                    break;
                }
                case 2: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.startDayOfWeek, this.startDay, year);
                    b = day > sDay || day == sDay && millis >= this.startTime;
                    break;
                }
                case 3: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.startDayOfWeek, this.startDay, true);
                    b = day > sDay || day == sDay && millis >= this.startTime;
                    break;
                }
                case 4: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.startDayOfWeek, this.startDay, false);
                    boolean bl = b = day > sDay || day == sDay && millis >= this.startTime;
                }
            }
        }
        if (month == this.endMonth && b) {
            switch (this.endMode) {
                case 1: {
                    b = day < this.endDay || day == this.endDay && millis < this.endTime;
                    break;
                }
                case 2: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.endDayOfWeek, this.endDay, year);
                    b = day < sDay || day == sDay && millis < this.endTime;
                    break;
                }
                case 3: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.endDayOfWeek, this.endDay, true);
                    b = day < sDay || day == sDay && millis < this.endTime;
                    break;
                }
                case 4: {
                    sDay = this.calculateChangeDay(month, day, dayOffWeek, this.endDayOfWeek, this.endDay, false);
                    b = day < sDay || day == sDay && millis < this.endTime;
                }
            }
        }
        return b;
    }

    private int calculateChangeDay(int month, int day, int dayOffweek, int DOWinM, int chDOW, int year) {
        if (chDOW > 0) {
            day += (7 - dayOffweek + DOWinM) % 7;
            day -= day / 7 * 7;
            day += 7 * (chDOW - 1);
        } else {
            day += (DOWinM - dayOffweek - 7) % 7;
            int maxDay = monthLength[month];
            if (month == 1) {
                maxDay += new GregorianCalendar().isLeapYear(year) ? (byte)1 : 0;
            }
            day += (maxDay - day) / 7 * 7;
            if ((day += 7 * (chDOW + 1)) < 0) {
                day = 35;
            }
        }
        return day;
    }

    private int calculateChangeDay(int month, int day, int dayOffweek, int DOWinM, int chDOW, boolean after) {
        int help = day - chDOW;
        help = (dayOffweek - help + 55) % 7 + 1;
        help = after ? (7 - help + DOWinM) % 7 : -((DOWinM - help - 7) % 7);
        return help + day;
    }

    private native void getfields(int[] var1, long var2);

    public boolean inDaylightTime(Date date) {
        int[] array = new int[5];
        this.getfields(array, date.getTime() + (long)this.rawOffset);
        int era = 1;
        if (array[0] < 1) {
            era = 0;
            array[0] = -array[0] - 1;
        }
        return this.inDaylightTime(era, array[0], array[1], array[2], array[4], array[3]);
    }

    public int getOffset(int era, int year, int month, int day, int dayOffWeek, int milliseconds) {
        return this.rawOffset + (this.inDaylightTime(era, year, month, day, dayOffWeek, milliseconds) ? this.dstSavings : 0);
    }

    public int hashCode() {
        int hash = this.endDay * this.endDayOfWeek * this.endMode * this.endMonth + this.endTime;
        hash ^= this.startDay * this.startDayOfWeek * this.startMode * this.startMonth + this.startTime;
        return hash ^= this.getID().hashCode() ^ this.rawOffset;
    }
}

