/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    private static int defaultSize = 101;
    private static float defaultLoadFactor = 0.75f;
    static Object nullKey = new Object();
    transient int modCount;
    transient float loadFactor;
    transient int occupancy;
    transient int capacity;
    transient int threshold;
    transient Object[] key;

    public HashSet() {
        this(defaultSize, defaultLoadFactor);
    }

    public HashSet(Collection c) {
        this(1 + c.size() * 2, defaultLoadFactor);
        this.addAll(c);
    }

    public HashSet(int initCap) {
        this(initCap, defaultLoadFactor);
    }

    public HashSet(int initCap, float loadFactor) {
        if (initCap < 0 || loadFactor < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.capacity = initCap = initCap < 5 ? 5 : initCap;
        if (loadFactor > 1.0f) {
            loadFactor = defaultLoadFactor;
        }
        this.loadFactor = loadFactor;
        this.key = new Object[initCap];
        this.threshold = (int)(loadFactor * (float)initCap);
    }

    public boolean add(Object key) {
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hashcode = key.hashCode() % cap;
        Object[] k = this.key;
        while (true) {
            Object o;
            if (hashcode < 0) {
                hashcode += cap;
            }
            if ((o = k[hashcode]) == null) {
                ++this.modCount;
                k[hashcode] = key;
                if (++this.occupancy >= this.threshold) {
                    this.resize();
                }
                return true;
            }
            if (key.equals(o)) {
                return false;
            }
            --hashcode;
        }
    }

    public int size() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.occupancy == 0;
    }

    public boolean remove(Object key) {
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hashcode = key.hashCode() % cap;
        Object[] k = this.key;
        while (true) {
            Object o;
            if (hashcode < 0) {
                hashcode += cap;
            }
            if ((o = k[hashcode]) == null) {
                return false;
            }
            if (key.equals(o)) {
                ++this.modCount;
                this.deleteSlot(hashcode);
                return true;
            }
            --hashcode;
        }
    }

    public Iterator iterator() {
        return new HashSetIterator();
    }

    public void clear() {
        if (this.occupancy > 0) {
            ++this.modCount;
            this.occupancy = 0;
            this.key = new Object[this.capacity];
        }
    }

    public Object clone() {
        HashSet h = null;
        try {
            h = (HashSet)super.clone();
            h.key = (Object[])this.key.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return h;
    }

    public boolean contains(Object key) {
        int nextSlot = this.firstBusySlot(0);
        if (key == null) {
            key = nullKey;
        }
        Object[] k = this.key;
        while (nextSlot >= 0) {
            if (key.equals(k[nextSlot])) {
                return true;
            }
            nextSlot = this.firstBusySlot(nextSlot + 1);
        }
        return false;
    }

    private int firstBusySlot(int i) {
        Object[] key = this.key;
        int capacity = this.capacity;
        if (i < 0) {
            return -1;
        }
        while (i < capacity) {
            if (this.key[i] != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void resize() {
        int oldsize = this.capacity;
        int newsize = oldsize * 2 + 1;
        Object[] oldkeys = this.key;
        this.key = new Object[newsize];
        this.capacity = newsize;
        this.occupancy = 0;
        this.threshold = (int)(this.loadFactor * (float)newsize);
        for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            Object key = oldkeys[oldindex];
            if (key == null) continue;
            this.add(key);
        }
    }

    private void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        Object[] key = this.key;
        int capacity = this.capacity;
        while (true) {
            key[current] = null;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? capacity - 1 : current - 1;
                if (key[current] == null) {
                    return;
                }
                int home = key[current].hashCode() % capacity;
                if (home < 0) {
                    home += capacity;
                }
                int distance1 = current <= home ? home - current : capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : capacity + vacant - current;
                happy = distance1 < distance2;
            }
            key[vacant] = key[current];
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int cap;
        this.capacity = cap = s.readInt();
        this.threshold = (int)((float)cap * this.loadFactor);
        this.loadFactor = s.readFloat();
        int occ = s.readInt();
        this.key = new Object[cap];
        while (occ-- > 0) {
            this.add(s.readObject());
            --occ;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int occ;
        s.writeInt(this.capacity);
        s.writeFloat(this.loadFactor);
        s.writeInt(occ);
        int i = 0;
        Object[] k = this.key;
        for (occ = this.occupancy; occ > 0; --occ) {
            while (k[i] == null) {
                ++i;
            }
            s.writeObject(k[i++]);
        }
    }

    private class HashSetIterator
    implements Iterator {
        private int mc;
        private int pos;
        private int oldpos;

        public HashSetIterator() {
            this.mc = HashSet.this.modCount;
            this.oldpos = this.pos = HashSet.this.firstBusySlot(0);
        }

        public boolean hasNext() {
            if (this.mc != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.pos != -1;
        }

        public Object next() {
            if (this.pos == -1) {
                throw new NoSuchElementException();
            }
            if (this.mc != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object e = HashSet.this.key[this.pos];
            this.oldpos = this.pos;
            this.pos = HashSet.this.firstBusySlot(this.pos + 1);
            return nullKey == e ? null : e;
        }

        public void remove() {
            if (this.oldpos == this.pos) {
                throw new IllegalStateException();
            }
            if (this.mc != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            HashSet.this.deleteSlot(this.oldpos);
            this.oldpos = this.pos;
        }
    }
}

