/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 362498820763181265L;
    transient int capacity;
    transient int occupancy;
    private float loadFactor;
    private int threshold;
    static final Object nullKey = new Object();
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 101;
    transient Object[] key;
    transient Object[] value;
    transient int modCount;

    public HashMap() {
        this(101, 0.75f);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("HashMap needs positive numbers");
        }
        this.capacity = initialCapacity < 5 ? 5 : initialCapacity;
        this.key = new Object[this.capacity];
        this.value = new Object[this.capacity];
        this.loadFactor = loadFactor > 1.0f ? 0.75f : loadFactor;
    }

    public HashMap(Map t) {
        this(101, 0.75f);
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public int size() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.occupancy == 0;
    }

    public boolean containsValue(Object value) {
        int nextSlot = this.firstBusySlot(0);
        Object[] val = this.value;
        if (value == null) {
            while (nextSlot >= 0) {
                if (val[nextSlot] == null) {
                    return true;
                }
                nextSlot = this.firstBusySlot(nextSlot + 1);
            }
        } else {
            while (nextSlot >= 0) {
                if (value.equals(val[nextSlot])) {
                    return true;
                }
                nextSlot = this.firstBusySlot(nextSlot + 1);
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        int nextSlot = this.firstBusySlot(0);
        if (key == null) {
            key = nullKey;
        }
        Object[] k = this.key;
        while (nextSlot >= 0) {
            if (key.equals(k[nextSlot])) {
                return true;
            }
            nextSlot = this.firstBusySlot(nextSlot + 1);
        }
        return false;
    }

    public Object get(Object key) {
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        Object[] k = this.key;
        while (true) {
            Object o;
            if (hash < 0) {
                hash += cap;
            }
            if ((o = k[hash]) == null) {
                return null;
            }
            if (key.equals(o)) {
                return this.value[hash];
            }
            --hash;
        }
    }

    public Object put(Object key, Object newvalue) {
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        Object[] k = this.key;
        while (true) {
            Object o;
            if (hash < 0) {
                hash += cap;
            }
            if ((o = k[hash]) == null) {
                k[hash] = key;
                this.value[hash] = newvalue;
                ++this.occupancy;
                if (this.occupancy >= this.threshold) {
                    this.resize();
                }
                ++this.modCount;
                return null;
            }
            if (key.equals(o)) {
                Object[] value = this.value;
                Object oldvalue = value[hash];
                value[hash] = newvalue;
                return oldvalue;
            }
            --hash;
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            key = nullKey;
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        Object[] k = this.key;
        while (true) {
            Object o;
            if (hash < 0) {
                hash += cap;
            }
            if ((o = k[hash]) == null) {
                return null;
            }
            if (key.equals(o)) {
                Object oldvalue = this.value[hash];
                this.deleteSlot(hash);
                ++this.modCount;
                return oldvalue;
            }
            --hash;
        }
    }

    public void putAll(Map t) {
        super.putAll(t);
    }

    public void clear() {
        if (this.occupancy > 0) {
            this.key = new Object[this.capacity];
            this.value = new Object[this.capacity];
            this.occupancy = 0;
            ++this.modCount;
        }
    }

    public synchronized Object clone() {
        Object that = null;
        try {
            that = super.clone();
            HashMap that_hashmap = (HashMap)that;
            that_hashmap.key = (Object[])this.key.clone();
            that_hashmap.value = (Object[])this.value.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return that;
    }

    public Set keySet() {
        return new HashMapKeySet();
    }

    public Collection values() {
        return new HashMapCollection();
    }

    public Set entrySet() {
        return new HashMapSet();
    }

    private int firstBusySlot(int i) {
        int capacity = this.capacity;
        if (i < 0 || i >= capacity) {
            return -1;
        }
        Object[] key = this.key;
        for (int j = i; j < capacity; ++j) {
            if (key[j] == null) continue;
            return j;
        }
        return -1;
    }

    private void resize() {
        int oldsize = this.capacity;
        int newsize = oldsize * 2 + 1;
        Object[] oldkeys = this.key;
        Object[] oldvalues = this.value;
        Object[] keys = new Object[newsize];
        Object[] values = new Object[newsize];
        this.key = keys;
        this.value = values;
        this.capacity = newsize;
        this.threshold = (int)((float)newsize * this.loadFactor);
        block0: for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            Object k = oldkeys[oldindex];
            if (k == null) continue;
            int hash = k.hashCode() % newsize;
            while (true) {
                if (hash < 0) {
                    hash += newsize;
                }
                if (keys[hash] == null) {
                    keys[hash] = k;
                    values[hash] = oldvalues[oldindex];
                    continue block0;
                }
                --hash;
            }
        }
    }

    private void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        Object[] key = this.key;
        int capacity = this.capacity;
        while (true) {
            key[current] = null;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? capacity - 1 : current - 1;
                if (key[current] == null) {
                    return;
                }
                int home = key[current].hashCode() % capacity;
                if (home < 0) {
                    home += capacity;
                }
                int distance1 = current <= home ? home - current : capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : capacity + vacant - current;
                happy = distance1 < distance2;
            }
            key[vacant] = key[current];
            this.value[vacant] = this.value[current];
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.capacity = s.readInt();
        int local_oc = s.readInt();
        this.key = new Object[this.capacity];
        this.value = new Object[this.capacity];
        for (int i = 0; i < local_oc; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.capacity);
        s.writeInt(this.occupancy);
        int nextSlot = this.firstBusySlot(0);
        for (int i = 0; i < this.occupancy; ++i) {
            s.writeObject(this.key[nextSlot] == nullKey ? null : this.key[nextSlot]);
            s.writeObject(this.value[nextSlot]);
            nextSlot = this.firstBusySlot(nextSlot + 1);
        }
    }

    class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object o) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, NullPointerException {
            return HashMap.this.put(this.key, o);
        }

        public boolean equals(Object o) {
            boolean answer = false;
            if (o instanceof Entry) {
                Entry e2 = (Entry)o;
                answer = (this.key == null ? e2.getKey() == null : this.key.equals(e2.getKey())) && (this.value == null ? e2.getValue() == null : this.value.equals(e2.getValue()));
            }
            return answer;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            String answer = "HashMap Entry: " + this.key + "=" + this.value;
            return answer;
        }
    }

    protected class HashMapSet
    extends AbstractSet {
        protected HashMapSet() {
        }

        public Iterator iterator() {
            return new HashMapIterator();
        }

        public int size() {
            return HashMap.this.occupancy;
        }
    }

    protected class HashMapKeySet
    extends AbstractSet {
        protected HashMapKeySet() {
        }

        public Iterator iterator() {
            return new HashMapKeyIterator();
        }

        public int size() {
            return HashMap.this.occupancy;
        }
    }

    protected class HashMapCollection
    extends AbstractCollection {
        protected HashMapCollection() {
        }

        public Iterator iterator() {
            return new HashMapValueIterator();
        }

        public int size() {
            return HashMap.this.occupancy;
        }
    }

    protected class HashMapIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        protected HashMapIterator() {
            this.pos = HashMap.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = HashMap.this.modCount;
        }

        public boolean hasNext() {
            return HashMap.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (HashMap.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = HashMap.this.firstBusySlot(this.pos + 1);
            return new Entry(HashMap.this.key[this.oldpos] == nullKey ? null : HashMap.this.key[this.oldpos], HashMap.this.value[this.oldpos]);
        }

        public void remove() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            HashMap.this.remove(HashMap.this.key[this.oldpos]);
            ++this.mc;
            this.pos = HashMap.this.firstBusySlot(this.pos);
            this.status = -1;
        }
    }

    protected class HashMapValueIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        protected HashMapValueIterator() {
            this.pos = HashMap.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = HashMap.this.modCount;
        }

        public boolean hasNext() {
            return HashMap.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (HashMap.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = HashMap.this.firstBusySlot(this.pos + 1);
            return HashMap.this.value[this.oldpos];
        }

        public void remove() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            HashMap.this.remove(HashMap.this.key[this.oldpos]);
            ++this.mc;
            this.status = -1;
        }
    }

    protected class HashMapKeyIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        protected HashMapKeyIterator() {
            this.pos = HashMap.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = HashMap.this.modCount;
            this.status = 0;
        }

        public boolean hasNext() {
            return HashMap.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (HashMap.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = HashMap.this.firstBusySlot(this.pos + 1);
            return HashMap.this.key[this.oldpos] == nullKey ? null : HashMap.this.key[this.oldpos];
        }

        public void remove() {
            if (HashMap.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            HashMap.this.remove(HashMap.this.key[this.oldpos]);
            ++this.mc;
            this.status = -1;
        }
    }
}

