/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1807547505821590642L;
    public static final int MILLISECOND = 14;
    public static final int SECOND = 13;
    public static final int MINUTE = 12;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int AM_PM = 9;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_MONTH = 5;
    public static final int DATE = 5;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int DAY_OF_YEAR = 6;
    public static final int WEEK_OF_MONTH = 4;
    public static final int WEEK_OF_YEAR = 3;
    public static final int MONTH = 2;
    public static final int YEAR = 1;
    public static final int ERA = 0;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int AM = 0;
    public static final int PM = 1;
    protected long time;
    protected int[] fields = new int[17];
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    protected boolean[] isSet = new boolean[17];
    private int minimalDaysInFirstWeek = 1;
    private int firstDayOfWeek = 2;
    private boolean lenient = true;
    private TimeZone zone;
    private transient Locale loc;

    public abstract void add(int var1, int var2);

    public boolean after(Object cal) {
        this.complete();
        if (!(cal instanceof Calendar)) {
            return false;
        }
        return this.time > ((Calendar)cal).getTime().getTime();
    }

    public boolean before(Object cal) {
        this.complete();
        if (!(cal instanceof Calendar)) {
            return false;
        }
        return this.time < ((Calendar)cal).getTime().getTime();
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone tz, Locale loc) {
        if (tz == null || loc == null) {
            throw new NullPointerException();
        }
        this.zone = tz;
        this.loc = loc;
    }

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(TimeZone tz) {
        return new GregorianCalendar(tz);
    }

    public static synchronized Calendar getInstance(Locale loc) {
        return new GregorianCalendar(loc);
    }

    public static synchronized Calendar getInstance(TimeZone tz, Locale loc) {
        return new GregorianCalendar(tz, loc);
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public final void setTime(Date d) {
        this.time = d.getTime();
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
    }

    protected void setTimeInMillis(long Millis) {
        this.time = Millis;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
    }

    public final void set(int fld, int nv) {
        this.fields[fld] = nv;
        this.isSet[fld] = true;
        this.updateAreFieldsSet();
        this.isTimeSet = false;
    }

    public final void set(int year, int month, int date) {
        this.fields[1] = year;
        this.isSet[1] = true;
        this.fields[2] = month;
        this.isSet[2] = true;
        this.fields[5] = date;
        this.isSet[5] = true;
        this.updateAreFieldsSet();
        this.isTimeSet = false;
    }

    public final void set(int year, int month, int date, int hourOfDay, int minute) {
        this.fields[1] = year;
        this.isSet[1] = true;
        this.fields[2] = month;
        this.isSet[2] = true;
        this.fields[5] = date;
        this.isSet[5] = true;
        this.fields[11] = hourOfDay;
        this.isSet[11] = true;
        this.fields[12] = minute;
        this.isSet[12] = true;
        this.updateAreFieldsSet();
        this.isTimeSet = false;
    }

    public final void set(int year, int month, int date, int hourOfDay, int minute, int second) {
        this.fields[1] = year;
        this.isSet[1] = true;
        this.fields[2] = month;
        this.isSet[2] = true;
        this.fields[5] = date;
        this.isSet[5] = true;
        this.fields[11] = hourOfDay;
        this.isSet[11] = true;
        this.fields[12] = minute;
        this.isSet[12] = true;
        this.fields[13] = second;
        this.isSet[13] = true;
        this.updateAreFieldsSet();
        this.isTimeSet = false;
    }

    public final int get(int fld) {
        this.complete();
        return this.fields[fld];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    private void updateAreFieldsSet() {
        this.areFieldsSet = this.isSet[0];
        for (int i = 1; i < 17; ++i) {
            this.areFieldsSet &= this.isSet[i];
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setTimeZone(TimeZone tz) {
        if (tz == null) {
            throw new NullPointerException();
        }
        this.zone = tz;
    }

    public final void clear() {
        for (int i = 0; i < 17; ++i) {
            this.isSet[i] = false;
            this.fields[i] = 0;
            this.areFieldsSet = false;
        }
        this.isTimeSet = false;
    }

    public final void clear(int fld) {
        this.isSet[fld] = false;
        this.fields[fld] = 0;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    protected final int internalGet(int fld) {
        return this.fields[fld];
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int fld) {
        return this.isSet[fld];
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public Object clone() {
        try {
            Calendar cal = (Calendar)super.clone();
            cal.fields = this.fields;
            cal.isSet = this.isSet;
            cal.zone = (TimeZone)this.zone.clone();
            return cal;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)o;
        this.complete();
        cal.complete();
        return this.time == cal.time && this.zone.equals(cal.zone);
    }

    public int hashCode() {
        return (int)this.time ^ (int)this.time >> 32 ^ this.zone.hashCode();
    }

    public String toString() {
        return "";
    }

    public void setFirstDayOfWeek(int value) {
        if (value < 1 || value > 7) {
            throw new IllegalArgumentException();
        }
        this.firstDayOfWeek = value;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        if (value < 1 || value > 7) {
            throw new IllegalArgumentException();
        }
        this.minimalDaysInFirstWeek = value;
    }

    public abstract void roll(int var1, boolean var2);

    public void roll(int fld, int amt) {
        boolean up;
        boolean bl = up = amt >= 0;
        if (!up) {
            amt = -amt;
        }
        for (int i = 0; i < amt; ++i) {
            this.roll(fld, up);
        }
    }

    public int getActualMaximum(int fld) {
        this.complete();
        Calendar cal = (Calendar)this.clone();
        cal.setLenient(false);
        this.complete();
        int value = cal.fields[fld];
        while (true) {
            cal.roll(fld, true);
            cal.complete();
            if (value > cal.fields[fld]) {
                return value;
            }
            value = cal.fields[fld];
        }
    }

    public int getActualMinimum(int fld) {
        this.complete();
        Calendar cal = (Calendar)this.clone();
        cal.setLenient(false);
        this.complete();
        int value = cal.fields[fld];
        while (true) {
            cal.roll(fld, false);
            cal.complete();
            if (value < cal.fields[fld]) {
                return value;
            }
            value = cal.fields[fld];
        }
    }

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getMinimum(int var1);

    public static Locale[] getAvailableLocales() {
        Locale[] l = new Locale[]{Locale.getDefault()};
        return l;
    }
}

